"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtOpenGL import *
import enum


class QOpenGLShader(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qopenglshader.html

    **Detailed Description**

    This class supports shaders written in the OpenGL Shading Language (GLSL)
    and in the OpenGL/ES Shading Language (GLSL/ES).

    QOpenGLShader and **QOpenGLShaderProgram**  shelter the programmer from the
    details of compiling and linking vertex and fragment shaders.

    **See also** **QOpenGLShaderProgram** .
    """

    class ShaderTypeBit(enum.Flag):
        Vertex: QOpenGLShader = ...
        Fragment: QOpenGLShader = ...
        Geometry: QOpenGLShader = ...
        TessellationControl: QOpenGLShader = ...
        TessellationEvaluation: QOpenGLShader = ...
        Compute: QOpenGLShader = ...

    def __init__(
        self,
        type: "QOpenGLShader.ShaderTypeBit",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#QOpenGLShader

        **QOpenGLShader::QOpenGLShader(QOpenGLShader::ShaderType type , QObject
        * parent = nullptr)**

        Constructs a new QOpenGLShader object of the specified **type** and
        attaches it to **parent**. If shader programs are not supported,
        **QOpenGLShaderProgram::hasOpenGLShaderPrograms** () will return false.

        This constructor is normally followed by a call to **compileSourceCode**
        () or **compileSourceFile** ().

        The shader will be associated with the current **QOpenGLContext** .

        **See also** **compileSourceCode** () and **compileSourceFile** ().
        """
        ...

    @staticmethod
    def hasOpenGLShaders(
        type: "QOpenGLShader.ShaderTypeBit",
        context: typing.Optional[QtGui.QOpenGLContext] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#hasOpenGLShaders

        **[static] bool
        QOpenGLShader::hasOpenGLShaders(QOpenGLShader::ShaderType type ,
        QOpenGLContext * context = nullptr)**

        Returns `true` if shader programs of type **type** are supported on this
        system; false otherwise.

        The **context** is used to resolve the GLSL extensions. If **context**
        is `nullptr`, then **QOpenGLContext::currentContext** () is used.
        """
        ...

    def shaderId(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#shaderId

        **GLuint QOpenGLShader::shaderId() const**

        Returns the OpenGL identifier associated with this shader.

        **See also** **QOpenGLShaderProgram::programId** ().
        """
        ...

    def log(self) -> str:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#log

        **QString QOpenGLShader::log() const**

        Returns the errors and warnings that occurred during the last compile.

        **See also** **compileSourceCode** () and **compileSourceFile** ().
        """
        ...

    def isCompiled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#isCompiled

        **bool QOpenGLShader::isCompiled() const**

        Returns `true` if this shader has been compiled; false otherwise.

        **See also** **compileSourceCode** () and **compileSourceFile** ().
        """
        ...

    def sourceCode(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#sourceCode

        **QByteArray QOpenGLShader::sourceCode() const**

        Returns the source code for this shader.

        **See also** **compileSourceCode** ().
        """
        ...

    def compileSourceFile(self, fileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#compileSourceFile

        **bool QOpenGLShader::compileSourceFile(const QString & fileName )**

        Sets the source code for this shader to the contents of **fileName** and
        compiles it. Returns `true` if the file could be opened and the source
        compiled, false otherwise.

        **See also** **compileSourceCode** ().
        """
        ...

    @typing.overload
    def compileSourceCode(self, source: QtCore.QByteArray) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#compileSourceCode

        **bool QOpenGLShader::compileSourceCode(const char * source )**

        Sets the **source** code for this shader and compiles it. Returns `true`
        if the source was successfully compiled, false otherwise.

        **See also** **compileSourceFile** ().
        """
        ...

    @typing.overload
    def compileSourceCode(self, source: str) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#compileSourceCode-1

        **bool QOpenGLShader::compileSourceCode(const QByteArray & source )**

        This is an overloaded function.

        Sets the **source** code for this shader and compiles it. Returns `true`
        if the source was successfully compiled, false otherwise.

        **See also** **compileSourceFile** ().
        """
        ...

    def shaderType(self) -> "QOpenGLShader.ShaderTypeBit":
        """
        https://doc.qt.io/qt-6/qopenglshader.html#shaderType

        **QOpenGLShader::ShaderType QOpenGLShader::shaderType() const**

        Returns the type of this shader.
        """
        ...
