"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtOpenGL import *


class QOpenGLShaderProgram(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qopenglshaderprogram.html

    **Detailed Description**

    **Introduction**

    This class supports shader programs written in the OpenGL Shading Language
    (GLSL) and in the OpenGL/ES Shading Language (GLSL/ES).

    **QOpenGLShader**  and QOpenGLShaderProgram shelter the programmer from the
    details of compiling and linking vertex and fragment shaders.

    The following example creates a vertex shader program using the supplied
    source `code`. Once compiled and linked, the shader program is activated in
    the current **QOpenGLContext**  by calling **QOpenGLShaderProgram::bind**
    ():

    **QOpenGLShader**  shader(**QOpenGLShader** ::Vertex);
    shader.compileSourceCode(code);

        **QOpenGLShaderProgram**
    program(context);
        program.addShader(&shader);
        program.link();
    program.bind();

    **Writing Portable Shaders**

    Shader programs can be difficult to reuse across OpenGL implementations
    because of varying levels of support for standard vertex attributes and
    uniform variables. In particular, GLSL/ES lacks all of the standard
    variables that are present on desktop OpenGL systems: `gl_Vertex`,
    `gl_Normal`, `gl_Color`, and so on. Desktop OpenGL lacks the variable
    qualifiers `highp`, `mediump`, and `lowp`.

    The QOpenGLShaderProgram class makes the process of writing portable shaders
    easier by prefixing all shader programs with the following lines on desktop
    OpenGL:

    #define highp
        #define mediump
        #define lowp

    This makes it possible to run most GLSL/ES shader programs on desktop
    systems. The programmer should restrict themselves to just features that are
    present in GLSL/ES, and avoid standard variable names that only work on the
    desktop.

    **Simple Shader Example**

    program.addShaderFromSourceCode(**QOpenGLShader** ::Vertex,
    "attribute highp vec4 vertex;\\n"
            "uniform highp mat4 matrix;\\n"
    "void main(void)\\n"
            "{\\n"
            "   gl_Position = matrix *
    vertex;\\n"
            "}");
    program.addShaderFromSourceCode(**QOpenGLShader** ::Fragment,
    "uniform mediump vec4 color;\\n"
            "void main(void)\\n"
            "{\\n"
    "   gl_FragColor = color;\\n"
            "}");
        program.link();
    program.bind();

        int vertexLocation =
    program.attributeLocation("vertex");
        int matrixLocation =
    program.uniformLocation("matrix");
        int colorLocation =
    program.uniformLocation("color");

    With the above shader program active, we can draw a green triangle as
    follows:

    static GLfloat const triangleVertices[] = {
            60.0f,  10.0f,  0.0f,
    110.0f, 110.0f, 0.0f,
            10.0f,  110.0f, 0.0f
        };
    **QColor**  color(0, 255, 0, 255);

        QMatrix4x4 pmvMatrix;
    pmvMatrix.ortho(rect());
    program.enableAttributeArray(vertexLocation);
    program.setAttributeArray(vertexLocation, triangleVertices, 3);
    program.setUniformValue(matrixLocation, pmvMatrix);
    program.setUniformValue(colorLocation, color);
    glDrawArrays(GL_TRIANGLES, 0, 3);
    program.disableAttributeArray(vertexLocation);

    **Binary Shaders and Programs**

    Binary shaders may be specified using `glShaderBinary()` on the return value
    from **QOpenGLShader::shaderId** (). The **QOpenGLShader**  instance
    containing the binary can then be added to the shader program with
    **addShader** () and linked in the usual fashion with **link** ().

    Binary programs may be specified using `glProgramBinaryOES()` on the return
    value from **programId** (). Then the application should call **link** (),
    which will notice that the program has already been specified and linked,
    allowing other operations to be performed on the shader program. The shader
    program's id can be explicitly created using the **create** () function.

    **Caching Program Binaries**

    As of Qt 5.9, support for caching program binaries on disk is built in. To
    enable this, switch to using **addCacheableShaderFromSourceCode** () and
    **addCacheableShaderFromSourceFile** (). With an OpenGL ES 3.x context or
    support for `GL_ARB_get_program_binary`, this will transparently cache
    program binaries under **QStandardPaths::GenericCacheLocation**  or
    **QStandardPaths::CacheLocation** . When support is not available, calling
    the cacheable function variants is equivalent to the normal ones.

    **Note:** Some drivers do not have any binary formats available, even though
    they advertise the extension or offer OpenGL ES 3.0. In this case program
    binary support will be disabled.

    **See also** **QOpenGLShader** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#QOpenGLShaderProgram

        **QOpenGLShaderProgram::QOpenGLShaderProgram(QObject * parent =
        nullptr)**

        Constructs a new shader program and attaches it to **parent**. The
        program will be invalid until **addShader** () is called.

        The shader program will be associated with the current
        **QOpenGLContext** .

        **See also** **addShader** ().
        """
        ...

    def addCacheableShaderFromSourceFile(
        self, type: QOpenGLShader.ShaderTypeBit, fileName: str
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#addCacheableShaderFromS
        ourceFile

        **[since 5.9] bool QOpenGLShaderProgram::addCacheableShaderFromSourceFil
        e(QOpenGLShader::ShaderType type , const QString & fileName )**

        Registers the shader of the specified **type** and **fileName** to this
        program. Unlike **addShaderFromSourceFile** (), this function does not
        perform compilation. Compilation is deferred to **link** (), and may not
        happen at all, because **link** () may potentially use a program binary
        from Qt's shader disk cache. This will typically lead to a significant
        increase in performance.

        Returns true if the file has been read successfully, false if the file
        could not be opened or the normal, non-cached compilation of the shader
        has failed. The compilation error messages can be retrieved via **log**
        ().

        When the disk cache is disabled, via **Qt::AA_DisableShaderDiskCache**
        for example, or the OpenGL context has no support for context binaries,
        calling this function is equivalent to **addShaderFromSourceFile** ().

        This function was introduced in Qt 5.9.

        **See also** **addShaderFromSourceFile** () and
        **addCacheableShaderFromSourceCode** ().
        """
        ...

    @typing.overload
    def addCacheableShaderFromSourceCode(
        self, type: QOpenGLShader.ShaderTypeBit, source: QtCore.QByteArray
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#addCacheableShaderFromS
        ourceCode

        **[since 5.9] bool QOpenGLShaderProgram::addCacheableShaderFromSourceCod
        e(QOpenGLShader::ShaderType type , const char * source )**

        Registers the shader of the specified **type** and **source** to this
        program. Unlike **addShaderFromSourceCode** (), this function does not
        perform compilation. Compilation is deferred to **link** (), and may not
        happen at all, because **link** () may potentially use a program binary
        from Qt's shader disk cache. This will typically lead to a significant
        increase in performance.

        Returns true if the shader has been registered or, in the non-cached
        case, compiled successfully; false if there was an error. The
        compilation error messages can be retrieved via **log** ().

        When the disk cache is disabled, via **Qt::AA_DisableShaderDiskCache**
        for example, or the OpenGL context has no support for context binaries,
        calling this function is equivalent to **addShaderFromSourceCode** ().

        This function was introduced in Qt 5.9.

        **See also** **addShaderFromSourceCode** () and
        **addCacheableShaderFromSourceFile** ().
        """
        ...

    @typing.overload
    def addCacheableShaderFromSourceCode(
        self, type: QOpenGLShader.ShaderTypeBit, source: str
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#addCacheableShaderFromS
        ourceCode-1

        **[since 5.9] bool QOpenGLShaderProgram::addCacheableShaderFromSourceCod
        e(QOpenGLShader::ShaderType type , const QByteArray & source )**

        This is an overloaded function.

        Registers the shader of the specified **type** and **source** to this
        program. Unlike **addShaderFromSourceCode** (), this function does not
        perform compilation. Compilation is deferred to **link** (), and may not
        happen at all, because **link** () may potentially use a program binary
        from Qt's shader disk cache. This will typically lead to a significant
        increase in performance.

        Returns true if the shader has been registered or, in the non-cached
        case, compiled successfully; false if there was an error. The
        compilation error messages can be retrieved via **log** ().

        When the disk cache is disabled, via **Qt::AA_DisableShaderDiskCache**
        for example, or the OpenGL context has no support for context binaries,
        calling this function is equivalent to **addShaderFromSourceCode** ().

        This function was introduced in Qt 5.9.

        **See also** **addShaderFromSourceCode** () and
        **addCacheableShaderFromSourceFile** ().
        """
        ...

    def create(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#create

        **[since 5.3] bool QOpenGLShaderProgram::create()**

        Requests the shader program's id to be created immediately. Returns
        `true` if successful; `false` otherwise.

        This function is primarily useful when combining
        **QOpenGLShaderProgram**  with other OpenGL functions that operate
        directly on the shader program id, like `GL_OES_get_program_binary`.

        When the shader program is used normally, the shader program's id will
        be created on demand.

        This function was introduced in Qt 5.3.

        **See also** **programId** ().
        """
        ...

    def defaultInnerTessellationLevels(self) -> typing.List[float]:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#defaultInnerTessellatio
        nLevels

        **QList<float> QOpenGLShaderProgram::defaultInnerTessellationLevels()
        const**

        Returns the default inner tessellation levels to be used by the
        tessellation primitive generator in the event that the tessellation
        control shader does not output them. For more details on OpenGL and
        Tessellation shaders see **OpenGL Tessellation Shaders** .

        Returns a **QList**  of floats describing the inner tessellation levels.
        The vector will always have two elements but not all of them make sense
        for every mode of tessellation.

        **Note:** This returns the global OpenGL state value. It is not specific
        to this **QOpenGLShaderProgram**  instance.

        **Note:** This function is only supported with OpenGL >= 4.0 and will
        not return valid results with OpenGL ES 3.2.

        **See also** **setDefaultInnerTessellationLevels** () and
        **defaultOuterTessellationLevels** ().
        """
        ...

    def setDefaultInnerTessellationLevels(self, levels: typing.Iterable[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setDefaultInnerTessella
        tionLevels

        **void QOpenGLShaderProgram::setDefaultInnerTessellationLevels(const
        QList<float> & levels )**

        Sets the default outer tessellation levels to be used by the
        tessellation primitive generator in the event that the tessellation
        control shader does not output them to **levels**. For more details on
        OpenGL and Tessellation shaders see **OpenGL Tessellation Shaders** .

        The **levels** argument should be a **QList**  consisting of 2 floats.
        Not all of the values make sense for all tessellation modes. If you
        specify a vector with fewer than 2 elements, the remaining elements will
        be given a default value of 1.

        **Note:** This modifies global OpenGL state and is not specific to this
        **QOpenGLShaderProgram**  instance. You should call this in your render
        function when needed, as **QOpenGLShaderProgram**  will not apply this
        for you. This is purely a convenience function.

        **Note:** This function is only available with OpenGL >= 4.0 and is not
        supported with OpenGL ES 3.2.

        **See also** **defaultInnerTessellationLevels** () and
        **setDefaultOuterTessellationLevels** ().
        """
        ...

    def defaultOuterTessellationLevels(self) -> typing.List[float]:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#defaultOuterTessellatio
        nLevels

        **QList<float> QOpenGLShaderProgram::defaultOuterTessellationLevels()
        const**

        Returns the default outer tessellation levels to be used by the
        tessellation primitive generator in the event that the tessellation
        control shader does not output them. For more details on OpenGL and
        Tessellation shaders see **OpenGL Tessellation Shaders** .

        Returns a **QList**  of floats describing the outer tessellation levels.
        The vector will always have four elements but not all of them make sense
        for every mode of tessellation.

        **Note:** This returns the global OpenGL state value. It is not specific
        to this **QOpenGLShaderProgram**  instance.

        **Note:** This function is only supported with OpenGL >= 4.0 and will
        not return valid results with OpenGL ES 3.2.

        **See also** **setDefaultOuterTessellationLevels** () and
        **defaultInnerTessellationLevels** ().
        """
        ...

    def setDefaultOuterTessellationLevels(self, levels: typing.Iterable[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setDefaultOuterTessella
        tionLevels

        **void QOpenGLShaderProgram::setDefaultOuterTessellationLevels(const
        QList<float> & levels )**

        Sets the default outer tessellation levels to be used by the
        tessellation primitive generator in the event that the tessellation
        control shader does not output them to **levels**. For more details on
        OpenGL and Tessellation shaders see **OpenGL Tessellation Shaders** .

        The **levels** argument should be a **QList**  consisting of 4 floats.
        Not all of the values make sense for all tessellation modes. If you
        specify a vector with fewer than 4 elements, the remaining elements will
        be given a default value of 1.

        **Note:** This modifies global OpenGL state and is not specific to this
        **QOpenGLShaderProgram**  instance. You should call this in your render
        function when needed, as **QOpenGLShaderProgram**  will not apply this
        for you. This is purely a convenience function.

        **Note:** This function is only available with OpenGL >= 4.0 and is not
        supported with OpenGL ES 3.2.

        **See also** **defaultOuterTessellationLevels** () and
        **setDefaultInnerTessellationLevels** ().
        """
        ...

    def patchVertexCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#patchVertexCount

        **int QOpenGLShaderProgram::patchVertexCount() const**

        Returns the number of vertices per-patch to be used when rendering.

        **Note:** This returns the global OpenGL state value. It is not specific
        to this **QOpenGLShaderProgram**  instance.

        **See also** **setPatchVertexCount** ().
        """
        ...

    def setPatchVertexCount(self, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setPatchVertexCount

        **void QOpenGLShaderProgram::setPatchVertexCount(int count )**

        Use this function to specify to OpenGL the number of vertices in a patch
        to **count**. A patch is a custom OpenGL primitive whose interpretation
        is entirely defined by the tessellation shader stages. Therefore,
        calling this function only makes sense when using a
        **QOpenGLShaderProgram**  containing tessellation stage shaders. When
        using OpenGL tessellation, the only primitive that can be rendered with
        `glDraw*()` functions is `GL_PATCHES`.

        This is equivalent to calling glPatchParameteri(GL_PATCH_VERTICES,
        count).

        **Note:** This modifies global OpenGL state and is not specific to this
        **QOpenGLShaderProgram**  instance. You should call this in your render
        function when needed, as **QOpenGLShaderProgram**  will not apply this
        for you. This is purely a convenience function.

        **See also** **patchVertexCount** ().
        """
        ...

    def maxGeometryOutputVertices(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#maxGeometryOutputVertic
        es

        **int QOpenGLShaderProgram::maxGeometryOutputVertices() const**

        Returns the hardware limit for how many vertices a geometry shader can
        output.
        """
        ...

    @staticmethod
    def hasOpenGLShaderPrograms(
        context: typing.Optional[QtGui.QOpenGLContext] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#hasOpenGLShaderPrograms

        **[static] bool
        QOpenGLShaderProgram::hasOpenGLShaderPrograms(QOpenGLContext * context =
        nullptr)**

        Returns `true` if shader programs written in the OpenGL Shading Language
        (GLSL) are supported on this system; false otherwise.

        The **context** is used to resolve the GLSL extensions. If **context**
        is `nullptr`, then **QOpenGLContext::currentContext** () is used.
        """
        ...

    @typing.overload
    def setUniformValueArray(
        self, location: int, values: PYQT_SHADER_UNIFORM_VALUE_ARRAY
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValueArray

        **void QOpenGLShaderProgram::setUniformValueArray(int location , const
        GLfloat * values , int count , int tupleSize )**

        Sets the uniform variable array at **location** in the current context
        to the **count** elements of **values**. Each element has **tupleSize**
        components. The **tupleSize** must be 1, 2, 3, or 4.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValueArray(
        self, name: str, values: PYQT_SHADER_UNIFORM_VALUE_ARRAY
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValueArray-1

        **void QOpenGLShaderProgram::setUniformValueArray(int location , const
        GLint * values , int count )**

        Sets the uniform variable array at **location** in the current context
        to the **count** elements of **values**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-1

        **void QOpenGLShaderProgram::setUniformValue(int location , GLint value
        )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-2

        **void QOpenGLShaderProgram::setUniformValue(int location , GLuint value
        )**

        Sets the uniform variable at **location** in the current context to
        **value**. This function should be used when setting sampler values.

        **Note:** This function is not aware of unsigned int support in modern
        OpenGL versions and therefore treats **value** as a GLint and calls
        glUniform1i.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-3

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat x ,
        GLfloat y )**

        Sets the uniform variable at **location** in the current context to the
        2D vector ( **x** , **y** ).

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(
        self, location: int, x: float, y: float, z: float, w: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-4

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat x ,
        GLfloat y , GLfloat z )**

        Sets the uniform variable at **location** in the current context to the
        3D vector ( **x** , **y** , **z** ).

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QVector2D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-5

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat x ,
        GLfloat y , GLfloat z , GLfloat w )**

        Sets the uniform variable at **location** in the current context to the
        4D vector ( **x** , **y** , **z** , **w** ).

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-6

        **void QOpenGLShaderProgram::setUniformValue(int location , const
        QVector2D & value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QVector4D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-7

        **void QOpenGLShaderProgram::setUniformValue(int location , const
        QVector3D & value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(
        self,
        location: int,
        color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-8

        **void QOpenGLShaderProgram::setUniformValue(int location , const
        QVector4D & value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, point: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-9

        **void QOpenGLShaderProgram::setUniformValue(int location , const QColor
        & color )**

        Sets the uniform variable at **location** in the current context to the
        red, green, blue, and alpha components of **color**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, point: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue-10

        **void QOpenGLShaderProgram::setUniformValue(int location , const QPoint
        & point )**

        Sets the uniform variable at **location** in the current context to the
        x and y coordinates of **point**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix2x2) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix2x3) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix2x4) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix3x2) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix3x3) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix3x4) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix4x2) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix4x3) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix4x4) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QTransform) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(
        self, name: str, x: float, y: float, z: float, w: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QVector2D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QVector4D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(
        self, name: str, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, point: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, point: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix2x2) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix2x3) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix2x4) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix3x2) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix3x3) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix3x4) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix4x2) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix4x3) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QMatrix4x4) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def setUniformValue(self, name: str, value: QtGui.QTransform) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setUniformValue

        **void QOpenGLShaderProgram::setUniformValue(int location , GLfloat
        value )**

        Sets the uniform variable at **location** in the current context to
        **value**.

        **See also** **setAttributeValue** ().
        """
        ...

    @typing.overload
    def uniformLocation(self, name: QtCore.QByteArray) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#uniformLocation

        **int QOpenGLShaderProgram::uniformLocation(const char * name ) const**

        Returns the location of the uniform variable **name** within this shader
        program's parameter list. Returns -1 if **name** is not a valid uniform
        variable for this shader program.

        **See also** **attributeLocation** ().
        """
        ...

    @typing.overload
    def uniformLocation(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#uniformLocation-1

        **int QOpenGLShaderProgram::uniformLocation(const QByteArray & name )
        const**

        This is an overloaded function.

        Returns the location of the uniform variable **name** within this shader
        program's parameter list. Returns -1 if **name** is not a valid uniform
        variable for this shader program.

        **See also** **attributeLocation** ().
        """
        ...

    @typing.overload
    def disableAttributeArray(self, location: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#disableAttributeArray

        **void QOpenGLShaderProgram::disableAttributeArray(int location )**

        Disables the vertex array at **location** in this shader program that
        was enabled by a previous call to **enableAttributeArray** ().

        **See also** **enableAttributeArray** (), **setAttributeArray** (),
        **setAttributeValue** (), and **setUniformValue** ().
        """
        ...

    @typing.overload
    def disableAttributeArray(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#disableAttributeArray-1

        **void QOpenGLShaderProgram::disableAttributeArray(const char * name )**

        This is an overloaded function.

        Disables the vertex array called **name** in this shader program that
        was enabled by a previous call to **enableAttributeArray** ().

        **See also** **enableAttributeArray** (), **setAttributeArray** (),
        **setAttributeValue** (), and **setUniformValue** ().
        """
        ...

    @typing.overload
    def enableAttributeArray(self, location: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#enableAttributeArray

        **void QOpenGLShaderProgram::enableAttributeArray(int location )**

        Enables the vertex array at **location** in this shader program so that
        the value set by **setAttributeArray** () on **location** will be used
        by the shader program.

        **See also** **disableAttributeArray** (), **setAttributeArray** (),
        **setAttributeValue** (), and **setUniformValue** ().
        """
        ...

    @typing.overload
    def enableAttributeArray(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#enableAttributeArray-1

        **void QOpenGLShaderProgram::enableAttributeArray(const char * name )**

        This is an overloaded function.

        Enables the vertex array called **name** in this shader program so that
        the value set by **setAttributeArray** () on **name** will be used by
        the shader program.

        **See also** **disableAttributeArray** (), **setAttributeArray** (),
        **setAttributeValue** (), and **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeBuffer(
        self, location: int, type: int, offset: int, tupleSize: int, stride: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeBuffer

        **void QOpenGLShaderProgram::setAttributeBuffer(int location , GLenum
        type , int offset , int tupleSize , int stride = 0)**

        Sets an array of vertex values on the attribute at **location** in this
        shader program, starting at a specific **offset** in the currently bound
        vertex buffer. The **stride** indicates the number of bytes between
        vertices. A default **stride** value of zero indicates that the vertices
        are densely packed in the value array.

        The **type** indicates the type of elements in the vertex value array,
        usually `GL_FLOAT`, `GL_UNSIGNED_BYTE`, etc. The **tupleSize** indicates
        the number of components per vertex: 1, 2, 3, or 4.

        The array will become active when **enableAttributeArray** () is called
        on the **location**. Otherwise the value specified with
        **setAttributeValue** () for **location** will be used.

        **Note:** Normalization will be enabled. If this is not desired, call
        glVertexAttribPointer directly through **QOpenGLFunctions** .

        **See also** **setAttributeArray** ().
        """
        ...

    @typing.overload
    def setAttributeBuffer(
        self, name: str, type: int, offset: int, tupleSize: int, stride: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeBuffer-1

        **void QOpenGLShaderProgram::setAttributeBuffer(const char * name ,
        GLenum type , int offset , int tupleSize , int stride = 0)**

        This is an overloaded function.

        Sets an array of vertex values on the attribute called **name** in this
        shader program, starting at a specific **offset** in the currently bound
        vertex buffer. The **stride** indicates the number of bytes between
        vertices. A default **stride** value of zero indicates that the vertices
        are densely packed in the value array.

        The **type** indicates the type of elements in the vertex value array,
        usually `GL_FLOAT`, `GL_UNSIGNED_BYTE`, etc. The **tupleSize** indicates
        the number of components per vertex: 1, 2, 3, or 4.

        The array will become active when **enableAttributeArray** () is called
        on the **name**. Otherwise the value specified with
        **setAttributeValue** () for **name** will be used.

        **See also** **setAttributeArray** ().
        """
        ...

    @typing.overload
    def setAttributeArray(
        self, location: int, values: PYQT_SHADER_ATTRIBUTE_ARRAY
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeArray

        **void QOpenGLShaderProgram::setAttributeArray(int location , const
        GLfloat * values , int tupleSize , int stride = 0)**

        Sets an array of vertex **values** on the attribute at **location** in
        this shader program. The **tupleSize** indicates the number of
        components per vertex (1, 2, 3, or 4), and the **stride** indicates the
        number of bytes between vertices. A default **stride** value of zero
        indicates that the vertices are densely packed in **values**.

        The array will become active when **enableAttributeArray** () is called
        on the **location**. Otherwise the value specified with
        **setAttributeValue** () for **location** will be used.

        **See also** **setAttributeValue** (), **setUniformValue** (),
        **enableAttributeArray** (), and **disableAttributeArray** ().
        """
        ...

    @typing.overload
    def setAttributeArray(self, name: str, values: PYQT_SHADER_ATTRIBUTE_ARRAY) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeArray-1

        **void QOpenGLShaderProgram::setAttributeArray(int location , const
        QVector2D * values , int stride = 0)**

        Sets an array of 2D vertex **values** on the attribute at **location**
        in this shader program. The **stride** indicates the number of bytes
        between vertices. A default **stride** value of zero indicates that the
        vertices are densely packed in **values**.

        The array will become active when **enableAttributeArray** () is called
        on the **location**. Otherwise the value specified with
        **setAttributeValue** () for **location** will be used.

        **See also** **setAttributeValue** (), **setUniformValue** (),
        **enableAttributeArray** (), and **disableAttributeArray** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, location: int, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat
        value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-1

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat x
        , GLfloat y )**

        Sets the attribute at **location** in the current context to the 2D
        vector ( **x** , **y** ).

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-2

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat x
        , GLfloat y , GLfloat z )**

        Sets the attribute at **location** in the current context to the 3D
        vector ( **x** , **y** , **z** ).

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(
        self, location: int, x: float, y: float, z: float, w: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-3

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat x
        , GLfloat y , GLfloat z , GLfloat w )**

        Sets the attribute at **location** in the current context to the 4D
        vector ( **x** , **y** , **z** , **w** ).

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, location: int, value: QtGui.QVector2D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-4

        **void QOpenGLShaderProgram::setAttributeValue(int location , const
        QVector2D & value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, location: int, value: QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-5

        **void QOpenGLShaderProgram::setAttributeValue(int location , const
        QVector3D & value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, location: int, value: QtGui.QVector4D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-6

        **void QOpenGLShaderProgram::setAttributeValue(int location , const
        QVector4D & value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(
        self,
        location: int,
        value: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-7

        **void QOpenGLShaderProgram::setAttributeValue(int location , const
        QColor & value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, name: str, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-8

        **void QOpenGLShaderProgram::setAttributeValue(int location , const
        GLfloat * values , int columns , int rows )**

        Sets the attribute at **location** in the current context to the
        contents of **values** , which contains **columns** elements, each
        consisting of **rows** elements. The **rows** value should be 1, 2, 3,
        or 4. This function is typically used to set matrix values and column
        vectors.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, name: str, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-9

        **void QOpenGLShaderProgram::setAttributeValue(const char * name ,
        GLfloat value )**

        This is an overloaded function.

        Sets the attribute called **name** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, name: str, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue-10

        **void QOpenGLShaderProgram::setAttributeValue(const char * name ,
        GLfloat x , GLfloat y )**

        This is an overloaded function.

        Sets the attribute called **name** in the current context to the 2D
        vector ( **x** , **y** ).

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(
        self, name: str, x: float, y: float, z: float, w: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat
        value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, name: str, value: QtGui.QVector2D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat
        value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, name: str, value: QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat
        value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(self, name: str, value: QtGui.QVector4D) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat
        value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def setAttributeValue(
        self, name: str, value: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#setAttributeValue

        **void QOpenGLShaderProgram::setAttributeValue(int location , GLfloat
        value )**

        Sets the attribute at **location** in the current context to **value**.

        **See also** **setUniformValue** ().
        """
        ...

    @typing.overload
    def attributeLocation(self, name: QtCore.QByteArray) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#attributeLocation

        **int QOpenGLShaderProgram::attributeLocation(const char * name )
        const**

        Returns the location of the attribute **name** within this shader
        program's parameter list. Returns -1 if **name** is not a valid
        attribute for this shader program.

        **See also** **uniformLocation** () and **bindAttributeLocation** ().
        """
        ...

    @typing.overload
    def attributeLocation(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#attributeLocation-1

        **int QOpenGLShaderProgram::attributeLocation(const QByteArray & name )
        const**

        This is an overloaded function.

        Returns the location of the attribute **name** within this shader
        program's parameter list. Returns -1 if **name** is not a valid
        attribute for this shader program.

        **See also** **uniformLocation** () and **bindAttributeLocation** ().
        """
        ...

    @typing.overload
    def bindAttributeLocation(self, name: QtCore.QByteArray, location: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#bindAttributeLocation

        **void QOpenGLShaderProgram::bindAttributeLocation(const char * name ,
        int location )**

        Binds the attribute **name** to the specified **location**. This
        function can be called before or after the program has been linked. Any
        attributes that have not been explicitly bound when the program is
        linked will be assigned locations automatically.

        When this function is called after the program has been linked, the
        program will need to be relinked for the change to take effect.

        **See also** **attributeLocation** ().
        """
        ...

    @typing.overload
    def bindAttributeLocation(self, name: str, location: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#bindAttributeLocation-1

        **void QOpenGLShaderProgram::bindAttributeLocation(const QByteArray &
        name , int location )**

        This is an overloaded function.

        Binds the attribute **name** to the specified **location**. This
        function can be called before or after the program has been linked. Any
        attributes that have not been explicitly bound when the program is
        linked will be assigned locations automatically.

        When this function is called after the program has been linked, the
        program will need to be relinked for the change to take effect.

        **See also** **attributeLocation** ().
        """
        ...

    def programId(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#programId

        **GLuint QOpenGLShaderProgram::programId() const**

        Returns the OpenGL identifier associated with this shader program.

        **See also** **QOpenGLShader::shaderId** ().
        """
        ...

    def release(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#release

        **void QOpenGLShaderProgram::release()**

        Releases the active shader program from the current **QOpenGLContext** .
        This is equivalent to calling `glUseProgram(0)`.

        **See also** **bind** ().
        """
        ...

    def bind(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#bind

        **bool QOpenGLShaderProgram::bind()**

        Binds this shader program to the active **QOpenGLContext**  and makes it
        the current shader program. Any previously bound shader program is
        released. This is equivalent to calling `glUseProgram()` on
        **programId** (). Returns `true` if the program was successfully bound;
        false otherwise. If the shader program has not yet been linked, or it
        needs to be re-linked, this function will call **link** ().

        **See also** **link** () and **release** ().
        """
        ...

    def log(self) -> str:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#log

        **QString QOpenGLShaderProgram::log() const**

        Returns the errors and warnings that occurred during the last **link**
        () or **addShader** () with explicitly specified source code.

        **See also** **link** ().
        """
        ...

    def isLinked(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#isLinked

        **bool QOpenGLShaderProgram::isLinked() const**

        Returns `true` if this shader program has been linked; false otherwise.

        **See also** **link** ().
        """
        ...

    def link(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#link

        **[virtual] bool QOpenGLShaderProgram::link()**

        Links together the shaders that were added to this program with
        **addShader** (). Returns `true` if the link was successful or false
        otherwise. If the link failed, the error messages can be retrieved with
        **log** ().

        Subclasses can override this function to initialize attributes and
        uniform variables for use in specific shader programs.

        If the shader program was already linked, calling this function again
        will force it to be re-linked.

        When shaders were added to this program via
        **addCacheableShaderFromSourceCode** () or
        **addCacheableShaderFromSourceFile** (), program binaries are supported,
        and a cached binary is available on disk, actual compilation and linking
        are skipped. Instead, link() will initialize the program with the binary
        blob via glProgramBinary(). If there is no cached version of the program
        or it was generated with a different driver version, the shaders will be
        compiled from source and the program will get linked normally. This
        allows seamless upgrading of the graphics drivers, without having to
        worry about potentially incompatible binary formats.

        **See also** **addShader** () and **log** ().
        """
        ...

    def removeAllShaders(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#removeAllShaders

        **void QOpenGLShaderProgram::removeAllShaders()**

        Removes all of the shaders that were added to this program previously.
        The **QOpenGLShader**  objects for the shaders will not be deleted if
        they were constructed externally. **QOpenGLShader**  objects that are
        constructed internally by **QOpenGLShaderProgram**  will be deleted.

        **See also** **addShader** () and **removeShader** ().
        """
        ...

    def addShaderFromSourceFile(
        self, type: QOpenGLShader.ShaderTypeBit, fileName: str
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#addShaderFromSourceFile

        **bool
        QOpenGLShaderProgram::addShaderFromSourceFile(QOpenGLShader::ShaderType
        type , const QString & fileName )**

        Compiles the contents of **fileName** as a shader of the specified
        **type** and adds it to this shader program. Returns `true` if
        compilation was successful, false otherwise. The compilation errors and
        warnings will be made available via **log** ().

        This function is intended to be a short-cut for quickly adding vertex
        and fragment shaders to a shader program without creating an instance of
        **QOpenGLShader**  first.

        **See also** **addShader** () and **addShaderFromSourceCode** ().
        """
        ...

    @typing.overload
    def addShaderFromSourceCode(
        self, type: QOpenGLShader.ShaderTypeBit, source: QtCore.QByteArray
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#addShaderFromSourceCode

        **bool
        QOpenGLShaderProgram::addShaderFromSourceCode(QOpenGLShader::ShaderType
        type , const char * source )**

        Compiles **source** as a shader of the specified **type** and adds it to
        this shader program. Returns `true` if compilation was successful, false
        otherwise. The compilation errors and warnings will be made available
        via **log** ().

        This function is intended to be a short-cut for quickly adding vertex
        and fragment shaders to a shader program without creating an instance of
        **QOpenGLShader**  first.

        **See also** **addShader** (), **addShaderFromSourceFile** (),
        **removeShader** (), **link** (), **log** (), and **removeAllShaders**
        ().
        """
        ...

    @typing.overload
    def addShaderFromSourceCode(
        self, type: QOpenGLShader.ShaderTypeBit, source: str
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#addShaderFromSourceCode
        -1

        **bool
        QOpenGLShaderProgram::addShaderFromSourceCode(QOpenGLShader::ShaderType
        type , const QByteArray & source )**

        This is an overloaded function.

        Compiles **source** as a shader of the specified **type** and adds it to
        this shader program. Returns `true` if compilation was successful, false
        otherwise. The compilation errors and warnings will be made available
        via **log** ().

        This function is intended to be a short-cut for quickly adding vertex
        and fragment shaders to a shader program without creating an instance of
        **QOpenGLShader**  first.

        **See also** **addShader** (), **addShaderFromSourceFile** (),
        **removeShader** (), **link** (), **log** (), and **removeAllShaders**
        ().
        """
        ...

    def shaders(self) -> typing.List[QOpenGLShader]:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#shaders

        **QList<QOpenGLShader *> QOpenGLShaderProgram::shaders() const**

        Returns a list of all shaders that have been added to this shader
        program using **addShader** ().

        **See also** **addShader** () and **removeShader** ().
        """
        ...

    def removeShader(self, shader: QOpenGLShader) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#removeShader

        **void QOpenGLShaderProgram::removeShader(QOpenGLShader * shader )**

        Removes **shader** from this shader program. The object is not deleted.

        The shader program must be valid in the current **QOpenGLContext** .

        **See also** **addShader** (), **link** (), and **removeAllShaders** ().
        """
        ...

    def addShader(self, shader: QOpenGLShader) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshaderprogram.html#addShader

        **bool QOpenGLShaderProgram::addShader(QOpenGLShader * shader )**

        Adds a compiled **shader** to this shader program. Returns `true` if the
        shader could be added, or false otherwise.

        Ownership of the **shader** object remains with the caller. It will not
        be deleted when this **QOpenGLShaderProgram**  instance is deleted. This
        allows the caller to add the same shader to multiple shader programs.

        **See also** **addShaderFromSourceCode** (), **addShaderFromSourceFile**
        (), **removeShader** (), **link** (), and **removeAllShaders** ().
        """
        ...
