"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6.QtOpenGL import *
import enum


class QOpenGLWindow(QtGui.QPaintDeviceWindow):
    """
    https://doc.qt.io/qt-6/qopenglwindow.html

    **Detailed Description**

    QOpenGLWindow is an enhanced **QWindow**  that allows easily creating
    windows that perform OpenGL rendering using an API that is compatible with
    **QOpenGLWidget**  Unlike **QOpenGLWidget** , QOpenGLWindow has no
    dependency on the widgets module and offers better performance.

    A typical application will subclass QOpenGLWindow and reimplement the
    following virtual functions:

    * **initializeGL** () to perform OpenGL resource initialization
      *
    **resizeGL** () to set up the transformation matrices and other window size
    dependent resources
      * **paintGL** () to issue OpenGL commands or draw
    using **QPainter**

    To schedule a repaint, call the **update** () function. Note that this will
    not immediately result in a call to **paintGL** (). Calling **update** ()
    multiple times in a row will not change the behavior in any way.

    This is a slot so it can be connected to a **QTimer::timeout** () signal to
    perform animation. Note however that in the modern OpenGL world it is a much
    better choice to rely on synchronization to the vertical refresh rate of the
    display. See **setSwapInterval** () on a description of the swap interval.
    With a swap interval of `1`, which is the case on most systems by default,
    the **swapBuffers** () call, that is executed internally by QOpenGLWindow
    after each repaint, will block and wait for vsync. This means that whenever
    the swap is done, an update can be scheduled again by calling **update** (),
    without relying on timers.

    To request a specific configuration for the context, use **setFormat** ()
    like for any other **QWindow** . This allows, among others, requesting a
    given OpenGL version and profile, or enabling depth and stencil buffers.

    Unlike **QWindow** , QOpenGLWindow allows opening a painter on itself and
    perform **QPainter** -based drawing.

    QOpenGLWindow supports multiple update behaviors. The default,
    `NoPartialUpdate` is equivalent to a regular, OpenGL-based **QWindow** . In
    contrast, `PartialUpdateBlit` and `PartialUpdateBlend` are more in line with
    **QOpenGLWidget** 's way of working, where there is always an extra,
    dedicated framebuffer object present. These modes allow, by sacrificing some
    performance, redrawing only a smaller area on each paint and having the rest
    of the content preserved from of the previous frame. This is useful for
    applications than render incrementally using **QPainter** , because this way
    they do not have to redraw the entire window content on each **paintGL** ()
    call.

    Similarly to **QOpenGLWidget** , QOpenGLWindow supports the
    **Qt::AA_ShareOpenGLContexts**  attribute. When enabled, the OpenGL contexts
    of all QOpenGLWindow instances will share with each other. This allows
    accessing each other's shareable OpenGL resources.

    For more information on graphics in Qt, see **Graphics** .
    """

    class UpdateBehavior(enum.Enum):
        NoPartialUpdate: QOpenGLWindow = ...
        PartialUpdateBlit: QOpenGLWindow = ...
        PartialUpdateBlend: QOpenGLWindow = ...

    @typing.overload
    def __init__(
        self,
        updateBehavior: "QOpenGLWindow.UpdateBehavior" = ...,
        parent: typing.Optional[QtGui.QWindow] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#QOpenGLWindow

        **QOpenGLWindow::QOpenGLWindow(QOpenGLWindow::UpdateBehavior
        updateBehavior = NoPartialUpdate, QWindow * parent = nullptr)**

        Constructs a new QOpenGLWindow with the given **parent** and
        **updateBehavior**.

        **See also** **QOpenGLWindow::UpdateBehavior** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        shareContext: QtGui.QOpenGLContext,
        updateBehavior: "QOpenGLWindow.UpdateBehavior" = ...,
        parent: typing.Optional[QtGui.QWindow] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#QOpenGLWindow-1

        **QOpenGLWindow::QOpenGLWindow(QOpenGLContext * shareContext ,
        QOpenGLWindow::UpdateBehavior updateBehavior = NoPartialUpdate, QWindow
        * parent = nullptr)**

        Constructs a new QOpenGLWindow with the given **parent** and
        **updateBehavior**. The QOpenGLWindow's context will share with
        **shareContext**.

        **See also** **QOpenGLWindow::UpdateBehavior**  and **shareContext** .
        """
        ...

    def metric(self, metric: QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#resizeEvent

        **[override virtual protected] void
        QOpenGLWindow::resizeEvent(QResizeEvent * event )**

        Reimplements: **QWindow::resizeEvent** (QResizeEvent *ev).

        Resize **event** handler. Calls **resizeGL** ().

        **See also** **resizeGL** ().
        """
        ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#paintEvent

        **[override virtual protected] void
        QOpenGLWindow::paintEvent(QPaintEvent * event )**

        Reimplements: **QPaintDeviceWindow::paintEvent** (QPaintEvent *event).

        Paint **event** handler. Calls **paintGL** ().

        **See also** **paintGL** ().
        """
        ...

    def paintOverGL(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#paintOverGL

        **[virtual protected] void QOpenGLWindow::paintOverGL()**

        This virtual function is called after each invocation of **paintGL** ().

        When the update mode is set to **NoPartialUpdate** , there is no
        difference between this function and **paintGL** (), performing
        rendering in either of them leads to the same result.

        Like **paintUnderGL** (), rendering in this function targets the default
        framebuffer of the window, regardless of the update behavior. It gets
        called after **paintGL** () has returned and the blit
        (**PartialUpdateBlit** ) or quad drawing (**PartialUpdateBlend** ) has
        been done.

        **See also** **paintGL** (), **paintUnderGL** (), and **UpdateBehavior**
        .
        """
        ...

    def paintUnderGL(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#paintUnderGL

        **[virtual protected] void QOpenGLWindow::paintUnderGL()**

        The virtual function is called before each invocation of **paintGL** ().

        When the update mode is set to `NoPartialUpdate`, there is no difference
        between this function and **paintGL** (), performing rendering in either
        of them leads to the same result.

        The difference becomes significant when using `PartialUpdateBlend`,
        where an extra framebuffer object is used. There, **paintGL** () targets
        this additional framebuffer object, which preserves its contents, while
        paintUnderGL() and **paintOverGL** () target the default framebuffer,
        i.e. directly the window surface, the contents of which is lost after
        each displayed frame.

        **Note:** Avoid relying on this function when the update behavior is
        `PartialUpdateBlit`. This mode involves blitting the extra framebuffer
        used by **paintGL** () onto the default framebuffer after each
        invocation of **paintGL** (), thus overwriting all drawing generated in
        this function.

        **See also** **paintGL** (), **paintOverGL** (), and **UpdateBehavior**
        .
        """
        ...

    def paintGL(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#paintGL

        **[virtual protected] void QOpenGLWindow::paintGL()**

        This virtual function is called whenever the window contents needs to be
        painted. Reimplement it in a subclass.

        There is no need to call **makeCurrent** () because this has already
        been done when this function is called.

        Before invoking this function, the context and the framebuffer, if there
        is one, are bound, and the viewport is set up by a call to glViewport().
        No other state is set and no clearing or drawing is performed by the
        framework.

        **Note:** When using a partial update behavior, like
        `PartialUpdateBlend`, the output of the previous paintGL() call is
        preserved and, after the additional drawing perfomed in the current
        invocation of the function, the content is blitted or blended over the
        content drawn directly to the window in **paintUnderGL** ().

        **See also** **initializeGL** (), **resizeGL** (), **paintUnderGL** (),
        **paintOverGL** (), and **UpdateBehavior** .
        """
        ...

    def resizeGL(self, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#resizeGL

        **[virtual protected] void QOpenGLWindow::resizeGL(int w , int h )**

        This virtual function is called whenever the widget has been resized.
        Reimplement it in a subclass. The new size is passed in **w** and **h**.

        **Note:** This is merely a convenience function in order to provide an
        API that is compatible with **QOpenGLWidget** . Unlike with
        **QOpenGLWidget** , derived classes are free to choose to override
        **resizeEvent** () instead of this function.

        **Note:** Avoid issuing OpenGL commands from this function as there may
        not be a context current when it is invoked. If it cannot be avoided,
        call **makeCurrent** ().

        **Note:** Scheduling updates from here is not necessary. The windowing
        systems will send expose events that trigger an update automatically.

        **See also** **initializeGL** () and **paintGL** ().
        """
        ...

    def initializeGL(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#initializeGL

        **[virtual protected] void QOpenGLWindow::initializeGL()**

        This virtual function is called once before the first call to
        **paintGL** () or **resizeGL** (). Reimplement it in a subclass.

        This function should set up any required OpenGL resources and state.

        There is no need to call **makeCurrent** () because this has already
        been done when this function is called. Note however that the
        framebuffer, in case partial update mode is used, is not yet available
        at this stage, so avoid issuing draw calls from here. Defer such calls
        to **paintGL** () instead.

        **See also** **paintGL** () and **resizeGL** ().
        """
        ...

    def shareContext(self) -> QtGui.QOpenGLContext:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#shareContext

        **QOpenGLContext *QOpenGLWindow::shareContext() const**

        Returns The **QOpenGLContext**  requested to be shared with this
        window's **QOpenGLContext** .
        """
        ...

    def grabFramebuffer(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#grabFramebuffer

        **QImage QOpenGLWindow::grabFramebuffer()**

        Returns a copy of the framebuffer.

        **Note:** This is a potentially expensive operation because it relies on
        glReadPixels() to read back the pixels. This may be slow and can stall
        the GPU pipeline.

        **Note:** When used together with update behavior `NoPartialUpdate`, the
        returned image may not contain the desired content when called after the
        front and back buffers have been swapped (unless preserved swap is
        enabled in the underlying windowing system interface). In this mode the
        function reads from the back buffer and the contents of that may not
        match the content on the screen (the front buffer). In this case the
        only place where this function can safely be used is **paintGL** () or
        **paintOverGL** ().
        """
        ...

    def defaultFramebufferObject(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#defaultFramebufferObject

        **GLuint QOpenGLWindow::defaultFramebufferObject() const**

        The framebuffer object handle used by this window.

        When the update behavior is set to `NoPartialUpdate`, there is no
        separate framebuffer object. In this case the returned value is the ID
        of the default framebuffer.

        Otherwise the value of the ID of the framebuffer object or `0` if not
        yet initialized.
        """
        ...

    def context(self) -> QtGui.QOpenGLContext:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#context

        **QOpenGLContext *QOpenGLWindow::context() const**

        Returns The **QOpenGLContext**  used by this window or `0` if not yet
        initialized.
        """
        ...

    def doneCurrent(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#doneCurrent

        **void QOpenGLWindow::doneCurrent()**

        Releases the context.

        It is not necessary to call this function in most cases, since the
        widget will make sure the context is bound and released properly when
        invoking **paintGL** ().

        **See also** **makeCurrent** ().
        """
        ...

    def makeCurrent(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#makeCurrent

        **void QOpenGLWindow::makeCurrent()**

        Prepares for rendering OpenGL content for this window by making the
        corresponding context current and binding the framebuffer object, if
        there is one, in that context context.

        It is not necessary to call this function in most cases, because it is
        called automatically before invoking **paintGL** (). It is provided
        nonetheless to support advanced, multi-threaded scenarios where a thread
        different than the GUI or main thread may want to update the surface or
        framebuffer contents. See **QOpenGLContext**  for more information on
        threading related issues.

        This function is suitable for calling also when the underlying platform
        window is already destroyed. This means that it is safe to call this
        function from a **QOpenGLWindow**  subclass' destructor. If there is no
        native window anymore, an offscreen surface is used instead. This
        ensures that OpenGL resource cleanup operations in the destructor will
        always work, as long as this function is called first.

        **See also** **QOpenGLContext** , **context** (), **paintGL** (), and
        **doneCurrent** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#isValid

        **bool QOpenGLWindow::isValid() const**

        Returns `true` if the window's OpenGL resources, like the context, have
        been successfully initialized. Note that the return value is always
        `false` until the window becomes exposed (shown).
        """
        ...

    def updateBehavior(self) -> "QOpenGLWindow.UpdateBehavior":
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#updateBehavior

        **QOpenGLWindow::UpdateBehavior QOpenGLWindow::updateBehavior() const**

        Returns the update behavior for this **QOpenGLWindow** .
        """
        ...

    @property
    def frameSwapped(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qopenglwindow.html#frameSwapped

        **[signal] void QOpenGLWindow::frameSwapped()**

        This signal is emitted after the potentially blocking **buffer swap**
        has been done. Applications that wish to continuously repaint
        synchronized to the vertical refresh, should issue an **update** () upon
        this signal. This allows for a much smoother experience compared to the
        traditional usage of timers.
        """
        ...
