"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
import datetime
from PyQt6.QtPositioning import *


class QGeoAreaMonitorInfo(PyQt6.sip.wrapper):
    """
    https://doc.qt.io/qt-6/qgeoareamonitorinfo.html

    **Detailed Description**

    The purpose of area monitoring is to inform a user when he/she comes close
    to an area of interest. In general such an area is described by a
    **QGeoCircle** . The circle's center represents the place of interest and
    the area around it identifies the geographical region within which
    notifications are sent.

    A QGeoAreaMonitorInfo object is valid if it has a non-empty name and a valid
    **area** (). Such objects must be registered with a
    **QGeoAreaMonitorSource**  to start and stop the monitoring process. Note
    that extensive monitoring can be very resource consuming because the
    positioning engine must remain active and has to match the current position
    with each QGeoAreaMonitorInfo instance.

    To further reduce the burden on the system there are optional attributes
    which can set. Each monitored area can have an expiry date which
    automatically removes the to-be-monitored area from the monitoring source
    once the expiry date has been reached. Another option is to adjust the
    persistence of a monitored area. A QGeoAreaMonitorInfo that **isPersistent**
    () will remain active beyond the current applications lifetime. If an area
    is entered while the monitoring application is not running the application
    will be started. Note that this feature is not available on all platforms.
    Its availability can be checked via
    **QGeoAreaMonitorSource::supportedAreaMonitorFeatures** ().

    **See also** **QGeoAreaMonitorSource** .
    """

    @typing.overload
    def __init__(self, name: str = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#QGeoAreaMonitorInfo

        **QGeoAreaMonitorInfo::QGeoAreaMonitorInfo(const QString & name =
        QString())**

        Constructs a QGeoAreaMonitorInfo object with the specified **name**.

        **See also** **name** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoAreaMonitorInfo") -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#QGeoAreaMonitorInfo-1

        **QGeoAreaMonitorInfo::QGeoAreaMonitorInfo(const QGeoAreaMonitorInfo &
        other )**

        Constructs a QGeoAreaMonitorInfo object as a copy of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def swap(self, other: "QGeoAreaMonitorInfo") -> None:
        ...

    def setNotificationParameters(
        self, parameters: typing.Dict[str, typing.Any]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#setNotificationParameter
        s

        **void QGeoAreaMonitorInfo::setNotificationParameters(const QVariantMap
        & parameters )**

        Sets the set of platform specific **parameters** used by
        **QGeoAreaMonitorInfo** .

        **See also** **notificationParameters** ().
        """
        ...

    def notificationParameters(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#notificationParameters

        **QVariantMap QGeoAreaMonitorInfo::notificationParameters() const**

        Returns the set of platform specific parameters used by this
        **QGeoAreaMonitorInfo** .

        **See also** **setNotificationParameters** ().
        """
        ...

    def setPersistent(self, isPersistent: bool) -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#setPersistent

        **void QGeoAreaMonitorInfo::setPersistent(bool isPersistent )**

        Sets the **QGeoAreaMonitorInfo**  object's persistence to
        **isPersistent**.

        Note that setting this flag does not imply that
        **QGeoAreaMonitorSource**  supports persistent monitoring.
        **QGeoAreaMonitorSource::supportedAreaMonitorFeatures** () can be used
        to check for this feature's availability.

        **See also** **isPersistent** ().
        """
        ...

    def isPersistent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#isPersistent

        **bool QGeoAreaMonitorInfo::isPersistent() const**

        Returns true if the **QGeoAreaMonitorInfo**  is persistent. The default
        value for this property is false.

        A non-persistent **QGeoAreaMonitorInfo**  will be removed by the system
        once the application owning the monitor object stops. Persistent objects
        remain active and can be retrieved once the application restarts.

        If the system triggers an event associated to a persistent
        **QGeoAreaMonitorInfo**  the relevant application will be re-started and
        the appropriate signal emitted.

        **See also** **setPersistent** ().
        """
        ...

    def setExpiration(
        self, expiry: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#setExpiration

        **void QGeoAreaMonitorInfo::setExpiration(const QDateTime & expiry )**

        Sets the expiry date and time to **expiry**.

        **See also** **expiration** ().
        """
        ...

    def expiration(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#expiration

        **QDateTime QGeoAreaMonitorInfo::expiration() const**

        Returns the expiry date.

        After an active **QGeoAreaMonitorInfo**  has expired the region is no
        longer monitored and the **QGeoAreaMonitorInfo**  object is removed from
        the list of **active monitors** .

        If the expiry **QDateTime**  is invalid the **QGeoAreaMonitorInfo**
        object is treated as not having an expiry date. This implies an
        indefinite monitoring period if the object is persistent or until the
        current application closes if the object is non-persistent.

        **See also** **setExpiration** () and
        **QGeoAreaMonitorSource::activeMonitors** ().
        """
        ...

    def setArea(self, newShape: "QGeoShape") -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#setArea

        **void QGeoAreaMonitorInfo::setArea(const QGeoShape & newShape )**

        Sets the to-be-monitored area to **newShape**.

        **See also** **area** ().
        """
        ...

    def area(self) -> "QGeoShape":
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#area

        **QGeoShape QGeoAreaMonitorInfo::area() const**

        Returns the boundaries of the to-be-monitored area. This area must not
        be empty.

        **See also** **setArea** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#isValid

        **bool QGeoAreaMonitorInfo::isValid() const**

        Returns true, if the monitor is valid. A valid **QGeoAreaMonitorInfo**
        has a non-empty **name** () and the monitored area is not **empty** ().
        Otherwise this function returns false.
        """
        ...

    def identifier(self) -> str:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#identifier

        **QString QGeoAreaMonitorInfo::identifier() const**

        Returns the identifier of the **QGeoAreaMonitorInfo**  object. The
        identifier is automatically generated upon construction of a new
        **QGeoAreaMonitorInfo**  object.
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#setName

        **void QGeoAreaMonitorInfo::setName(const QString & name )**

        Sets the user visibile **name**.

        **See also** **name** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorinfo.html#name

        **QString QGeoAreaMonitorInfo::name() const**

        Returns the name of the **QGeoAreaMonitorInfo**  object. The name should
        be used for user-visibility purposes.

        **See also** **setName** ().
        """
        ...
