"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
import datetime
from PyQt6.QtPositioning import *
import enum


class QGeoPositionInfo(PyQt6.sip.wrapper):
    """
    https://doc.qt.io/qt-6/qgeopositioninfo.html

    **Detailed Description**

    A QGeoPositionInfo contains, at a minimum, a geographical coordinate and a
    timestamp. It may also have heading and speed measurements as well as
    estimates of the accuracy of the provided data.

    **See also** **QGeoPositionInfoSource** .
    """

    class Attribute(enum.Enum):
        Direction: QGeoPositionInfo = ...
        GroundSpeed: QGeoPositionInfo = ...
        VerticalSpeed: QGeoPositionInfo = ...
        MagneticVariation: QGeoPositionInfo = ...
        HorizontalAccuracy: QGeoPositionInfo = ...
        VerticalAccuracy: QGeoPositionInfo = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#QGeoPositionInfo

        **QGeoPositionInfo::QGeoPositionInfo()**

        Creates an invalid QGeoPositionInfo object.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        coordinate: QGeoCoordinate,
        updateTime: typing.Union[QtCore.QDateTime, datetime.datetime],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#QGeoPositionInfo-1

        **QGeoPositionInfo::QGeoPositionInfo(const QGeoCoordinate & coordinate ,
        const QDateTime & timestamp )**

        Creates a QGeoPositionInfo for the given **coordinate** and
        **timestamp**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoPositionInfo") -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#QGeoPositionInfo-2

        **QGeoPositionInfo::QGeoPositionInfo(const QGeoPositionInfo & other )**

        Creates a QGeoPositionInfo with the values of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def swap(self, other: "QGeoPositionInfo") -> None:
        ...

    def hasAttribute(self, attribute: "QGeoPositionInfo.Attribute") -> bool:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#hasAttribute

        **bool QGeoPositionInfo::hasAttribute(QGeoPositionInfo::Attribute
        attribute ) const**

        Returns true if the specified **attribute** is present for this
        **QGeoPositionInfo**  object.
        """
        ...

    def removeAttribute(self, attribute: "QGeoPositionInfo.Attribute") -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#removeAttribute

        **void QGeoPositionInfo::removeAttribute(QGeoPositionInfo::Attribute
        attribute )**

        Removes the specified **attribute** and its value.
        """
        ...

    def attribute(self, attribute: "QGeoPositionInfo.Attribute") -> float:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#attribute

        **qreal QGeoPositionInfo::attribute(QGeoPositionInfo::Attribute
        attribute ) const**

        Returns the value of the specified **attribute** as a qreal value.

        Returns NaN if the value has not been set.

        The function **hasAttribute** () should be used to determine whether or
        not a value has been set for an attribute.

        **See also** **hasAttribute** () and **setAttribute** ().
        """
        ...

    def setAttribute(
        self, attribute: "QGeoPositionInfo.Attribute", value: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#setAttribute

        **void QGeoPositionInfo::setAttribute(QGeoPositionInfo::Attribute
        attribute , qreal value )**

        Sets the value for **attribute** to **value**.

        **See also** **attribute** ().
        """
        ...

    def coordinate(self) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#coordinate

        **QGeoCoordinate QGeoPositionInfo::coordinate() const**

        Returns the coordinate for this position.

        Returns an invalid coordinate if no coordinate has been set.

        **See also** **setCoordinate** ().
        """
        ...

    def setCoordinate(self, coordinate: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#setCoordinate

        **void QGeoPositionInfo::setCoordinate(const QGeoCoordinate & coordinate
        )**

        Sets the coordinate for this position to **coordinate**.

        **See also** **coordinate** ().
        """
        ...

    def timestamp(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#timestamp

        **QDateTime QGeoPositionInfo::timestamp() const**

        Returns the date and time at which this position was reported, in UTC
        time.

        Returns an invalid **QDateTime**  if no date/time value has been set.

        **See also** **setTimestamp** ().
        """
        ...

    def setTimestamp(
        self, timestamp: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#setTimestamp

        **void QGeoPositionInfo::setTimestamp(const QDateTime & timestamp )**

        Sets the date and time at which this position was reported to
        **timestamp**.

        The **timestamp** must be in UTC time.

        **See also** **timestamp** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#isValid

        **bool QGeoPositionInfo::isValid() const**

        Returns true if the **timestamp** () and **coordinate** () values are
        both valid.

        **See also** **QGeoCoordinate::isValid** () and **QDateTime::isValid**
        ().
        """
        ...
