"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtPositioning import *
import enum


class QGeoPositionInfoSource(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qgeopositioninfosource.html

    **Detailed Description**

    The static function **QGeoPositionInfoSource::createDefaultSource** ()
    creates a default position source that is appropriate for the platform, if
    one is available. Otherwise, QGeoPositionInfoSource will check for available
    plugins that implement the **QGeoPositionInfoSourceFactory**  interface.

    Users of a QGeoPositionInfoSource subclass can request the current position
    using **requestUpdate** (), or start and stop regular position updates using
    **startUpdates** () and **stopUpdates** (). When an update is available,
    **positionUpdated** () is emitted. The last known position can be accessed
    with **lastKnownPosition** ().

    If regular position updates are required, **setUpdateInterval** () can be
    used to specify how often these updates should be emitted. If no interval is
    specified, updates are simply provided whenever they are available. For
    example:

    // Emit updates every 10 seconds if available
        **QGeoPositionInfoSource**
    *source = **QGeoPositionInfoSource** ::createDefaultSource(0);
        if
    (source)
            source->setUpdateInterval(10000);

    To remove an update interval that was previously set, call
    **setUpdateInterval** () with a value of 0.

    **Note:** The position source may have a minimum value requirement for
    update intervals, as returned by **minimumUpdateInterval** ().

    **Note:** To use this class from Android service, see **Qt Positioning on
    Android** .
    """

    class PositioningMethod(enum.Flag):
        NoPositioningMethods: QGeoPositionInfoSource = ...
        SatellitePositioningMethods: QGeoPositionInfoSource = ...
        NonSatellitePositioningMethods: QGeoPositionInfoSource = ...
        AllPositioningMethods: QGeoPositionInfoSource = ...

    class Error(enum.Enum):
        AccessError: QGeoPositionInfoSource = ...
        ClosedError: QGeoPositionInfoSource = ...
        UnknownSourceError: QGeoPositionInfoSource = ...
        UpdateTimeoutError: QGeoPositionInfoSource = ...
        NoError: QGeoPositionInfoSource = ...

    def __init__(self, parent: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#QGeoPositionInfoSourc
        e

        **QGeoPositionInfoSource::QGeoPositionInfoSource(QObject * parent )**

        Creates a position source with the specified **parent**.
        """
        ...

    def backendProperty(self, name: str) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#backendProperty

        **[virtual, since Qt 5.14] QVariant
        QGeoPositionInfoSource::backendProperty(const QString & name ) const**

        Returns the value of the backend-specific property named **name** , if
        present. Otherwise, the returned value will be invalid. Supported
        backend-specific properties are listed and described in **Qt Positioning
        plugins#Default plugins** .

        This function was introduced in Qt 5.14.

        **See also** **setBackendProperty** .
        """
        ...

    def setBackendProperty(self, name: str, value: typing.Any) -> bool:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#setBackendProperty

        **[virtual, since Qt 5.14] bool
        QGeoPositionInfoSource::setBackendProperty(const QString & name , const
        QVariant & value )**

        Sets the backend-specific property named **name** to **value**. Returns
        `true` on success, `false` otherwise. Backend-specific properties can be
        used to configure the positioning subsystem behavior at runtime.
        Supported backend-specific properties are listed and described in **Qt
        Positioning plugins#Default plugins** .

        This function was introduced in Qt 5.14.

        **See also** **backendProperty** .
        """
        ...

    def requestUpdate(self, timeout: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#requestUpdate

        **[pure virtual slot] void QGeoPositionInfoSource::requestUpdate(int
        timeout = 0)**

        Attempts to get the current position and emit **positionUpdated** ()
        with this information. If the current position cannot be found within
        the given **timeout** (in milliseconds) or if **timeout** is less than
        the value returned by **minimumUpdateInterval** (), an **errorOccurred**
        () signal with the **UpdateTimeoutError**  is emitted.

        If the timeout is zero, the timeout defaults to a reasonable timeout
        period as appropriate for the source.

        This does nothing if another update request is in progress. However it
        can be called even if **startUpdates** () has already been called and
        regular updates are in progress.

        If the source uses multiple positioning methods, it tries to get the
        current position from the most accurate positioning method within the
        given timeout.

        **Note:** Since Qt6 this method always resets the last error to
        **NoError**  before requesting the position.

        **Note:** To understand how to use this method from an Android service,
        see **Qt Positioning on Android** .
        """
        ...

    def stopUpdates(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#stopUpdates

        **[pure virtual slot] void QGeoPositionInfoSource::stopUpdates()**

        Stops emitting updates at regular intervals.
        """
        ...

    def startUpdates(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#startUpdates

        **[pure virtual slot] void QGeoPositionInfoSource::startUpdates()**

        Starts emitting updates at regular intervals as specified by
        **setUpdateInterval** ().

        If **setUpdateInterval** () has not been called, the source will emit
        updates as soon as they become available.

        An **errorOccurred** () signal with the **UpdateTimeoutError**  will be
        emitted if this **QGeoPositionInfoSource**  subclass determines that it
        will not be able to provide regular updates. This could happen if a
        satellite fix is lost or if a hardware error is detected. Position
        updates will recommence if the data becomes available later on. The
        **UpdateTimeoutError**  error will not be emitted again until after the
        periodic updates resume.

        **Note:** Since Qt6 this method always resets the last error to
        **NoError**  before starting the updates.

        **Note:** To understand how to use this method from an Android service,
        see **Qt Positioning on Android** .

        On iOS, starting from version 8, Core Location framework requires
        additional entries in the application's Info.plist with keys
        NSLocationAlwaysUsageDescription or NSLocationWhenInUseUsageDescription
        and a string to be displayed in the authorization prompt. The key
        NSLocationWhenInUseUsageDescription is used when requesting permission
        to use location services while the app is in the foreground. The key
        NSLocationAlwaysUsageDescription is used when requesting permission to
        use location services whenever the app is running (both the foreground
        and the background). If both entries are defined,
        NSLocationWhenInUseUsageDescription has a priority in the foreground
        mode.
        """
        ...

    def error(self) -> "QGeoPositionInfoSource.Error":
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#error

        **[pure virtual] QGeoPositionInfoSource::Error
        QGeoPositionInfoSource::error() const**

        Returns the type of error that last occurred.

        **Note:** Since Qt6 the last error is always reset when calling
        **startUpdates** () or **requestUpdate** ().
        """
        ...

    @staticmethod
    def availableSources() -> typing.List[str]:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#availableSources

        **[static] QStringList QGeoPositionInfoSource::availableSources()**

        Returns a list of available source plugins. This includes any default
        backend plugin for the current platform.
        """
        ...

    @typing.overload
    @staticmethod
    def createSource(
        sourceName: str, parent: QtCore.QObject
    ) -> "QGeoPositionInfoSource":
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#createSource

        **[static] QGeoPositionInfoSource
        *QGeoPositionInfoSource::createSource(const QString & sourceName ,
        QObject * parent )**

        Creates and returns a position source with the given **parent** , by
        loading the plugin named **sourceName**.

        Returns `nullptr` if the plugin cannot be found.
        """
        ...

    @typing.overload
    @staticmethod
    def createSource(
        sourceName: str,
        parameters: typing.Dict[str, typing.Any],
        parent: QtCore.QObject,
    ) -> "QGeoPositionInfoSource":
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#createSource-1

        **[static, since Qt 5.14] QGeoPositionInfoSource
        *QGeoPositionInfoSource::createSource(const QString & sourceName , const
        QVariantMap & parameters , QObject * parent )**

        Creates and returns a position source with the given **parent** , by
        loading the plugin named **sourceName**.

        Returns `nullptr` if the plugin cannot be found.

        This method passes **parameters** to the factory to configure the
        source.

        This function was introduced in Qt 5.14.
        """
        ...

    @typing.overload
    @staticmethod
    def createDefaultSource(parent: QtCore.QObject) -> "QGeoPositionInfoSource":
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#createDefaultSource

        **[static] QGeoPositionInfoSource
        *QGeoPositionInfoSource::createDefaultSource(QObject * parent )**

        Creates and returns a position source with the given **parent** that
        reads from the system's default sources of location data, or the plugin
        with the highest available priority.

        Returns `nullptr` if the system has no default position source, no valid
        plugins could be found or the user does not have the permission to
        access the current position.
        """
        ...

    @typing.overload
    @staticmethod
    def createDefaultSource(
        parameters: typing.Dict[str, typing.Any], parent: QtCore.QObject
    ) -> "QGeoPositionInfoSource":
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#createDefaultSource-1

        **[static, since Qt 5.14] QGeoPositionInfoSource
        *QGeoPositionInfoSource::createDefaultSource(const QVariantMap &
        parameters , QObject * parent )**

        Creates and returns a position source with the given **parent** that
        reads from the system's default sources of location data, or the plugin
        with the highest available priority.

        Returns `nullptr` if the system has no default position source, no valid
        plugins could be found or the user does not have the permission to
        access the current position.

        This method passes **parameters** to the factory to configure the
        source.

        This function was introduced in Qt 5.14.
        """
        ...

    def sourceName(self) -> str:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#sourceName-prop

        **[read-only] sourceName : const QString**

        This property holds the unique name of the position source
        implementation in use.

        This is the same name that can be passed to **createSource** () in order
        to create a new instance of a particular position source implementation.

        **Access functions:**

        QString **sourceName** () const
        """
        ...

    def minimumUpdateInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#minimumUpdateInterval
        -prop

        **[read-only] minimumUpdateInterval : const int**

        This property holds the minimum time (in milliseconds) required to
        retrieve a position update.

        This is the minimum value accepted by **setUpdateInterval** () and
        **requestUpdate** ().

        **Access functions:**

        virtual int **minimumUpdateInterval** () const = 0
        """
        ...

    def supportedPositioningMethods(self) -> "QGeoPositionInfoSource.PositioningMethod":
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#supportedPositioningM
        ethods

        **[pure virtual] QGeoPositionInfoSource::PositioningMethods
        QGeoPositionInfoSource::supportedPositioningMethods() const**

        Returns the positioning methods available to this source. Availability
        is defined as being usable at the time of calling this function.
        Therefore user settings like turned off location service or limitations
        to Satellite-based position providers are reflected by this function.
        Runtime notifications when the status changes can be obtained via
        **supportedPositioningMethodsChanged** ().

        Not all platforms distinguish the different positioning methods or
        communicate the current user configuration of the device. The following
        table provides an overview of the current platform situation:

        PlatformBrief Description
        AndroidIndividual provider status and
        general Location service state are known and communicated when location
        service is active.
        GeoClueHardcoced to always return
        **AllPositioningMethods** .
        GeoClue2Individual providers are not
        distinguishable but disabled Location services reflected.
        iOS/tvOSHardcoced to always return **AllPositioningMethods** .
        macOSHardcoced to always return **AllPositioningMethods** .
        Windows
        (UWP)Individual providers are not distinguishable but disabled Location
        services reflected.

        **See also** **supportedPositioningMethodsChanged** () and
        **setPreferredPositioningMethods** ().
        """
        ...

    def lastKnownPosition(
        self, fromSatellitePositioningMethodsOnly: bool = ...
    ) -> QGeoPositionInfo:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#lastKnownPosition

        **[pure virtual] QGeoPositionInfo
        QGeoPositionInfoSource::lastKnownPosition(bool
        fromSatellitePositioningMethodsOnly = false) const**

        Returns an update containing the last known position, or a null update
        if none is available.

        If **fromSatellitePositioningMethodsOnly** is true, this returns the
        last known position received from a satellite positioning method; if
        none is available, a null update is returned.
        """
        ...

    def preferredPositioningMethods(self) -> "QGeoPositionInfoSource.PositioningMethod":
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#preferredPositioningM
        ethods-prop

        **[bindable] preferredPositioningMethods : PositioningMethods**

        **Note:** This property supports **QProperty**  bindings.

        Sets the preferred positioning methods for this source.

        If new methods include a method that is not supported by the source, the
        unsupported method will be ignored.

        If new methods do not include a single method available/supported by the
        source, the preferred methods will be set to the set of methods which
        the source has available. If the source has no method availabe (e.g.
        because its Location service is turned off or it does not offer a
        Location service), the passed methods are accepted as they are.

        The default value for this property is **NoPositioningMethods** .

        **Note:** Subclass implementations must call the base implementation of
        `setPreferredPositioningMethods()` to ensure
        `preferredPositioningMethods()` returns the correct value.

        **See also** **supportedPositioningMethods** ().
        """
        ...

    def setPreferredPositioningMethods(
        self, methods: "QGeoPositionInfoSource.PositioningMethod"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#preferredPositioningM
        ethods-prop

        **[bindable] preferredPositioningMethods : PositioningMethods**

        **Note:** This property supports **QProperty**  bindings.

        Sets the preferred positioning methods for this source.

        If new methods include a method that is not supported by the source, the
        unsupported method will be ignored.

        If new methods do not include a single method available/supported by the
        source, the preferred methods will be set to the set of methods which
        the source has available. If the source has no method availabe (e.g.
        because its Location service is turned off or it does not offer a
        Location service), the passed methods are accepted as they are.

        The default value for this property is **NoPositioningMethods** .

        **Note:** Subclass implementations must call the base implementation of
        `setPreferredPositioningMethods()` to ensure
        `preferredPositioningMethods()` returns the correct value.

        **See also** **supportedPositioningMethods** ().
        """
        ...

    def updateInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#updateInterval-prop

        **[bindable] updateInterval : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the requested interval in milliseconds between each
        update.

        If the update interval is not set (or is set to 0) the source will
        provide updates as often as necessary.

        If the update interval is set, the source will provide updates at an
        interval as close to the requested interval as possible. If the
        requested interval is less than the **minimumUpdateInterval** (), the
        minimum interval is used instead.

        Changes to the update interval will happen as soon as is practical,
        however the time the change takes may vary between implementations.
        Whether or not the elapsed time from the previous interval is counted as
        part of the new interval is also implementation dependent.

        The default value for this property is 0.

        **Note:** Subclass implementations must call the base implementation of
        `setUpdateInterval()` so that `updateInterval()` returns the correct
        value.

        **Note:** This property can't be used to tune update frequency on iOS
        and macOS, because their APIs do not provide such possibility. On these
        systems this parameter is only used to set **UpdateTimeoutError**  and
        trigger an **errorOccurred**  signal if the update is not received
        within the desired interval.

        **Member Function Documentation**
        """
        ...

    def setUpdateInterval(self, msec: int) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#updateInterval-prop

        **[bindable] updateInterval : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the requested interval in milliseconds between each
        update.

        If the update interval is not set (or is set to 0) the source will
        provide updates as often as necessary.

        If the update interval is set, the source will provide updates at an
        interval as close to the requested interval as possible. If the
        requested interval is less than the **minimumUpdateInterval** (), the
        minimum interval is used instead.

        Changes to the update interval will happen as soon as is practical,
        however the time the change takes may vary between implementations.
        Whether or not the elapsed time from the previous interval is counted as
        part of the new interval is also implementation dependent.

        The default value for this property is 0.

        **Note:** Subclass implementations must call the base implementation of
        `setUpdateInterval()` so that `updateInterval()` returns the correct
        value.

        **Note:** This property can't be used to tune update frequency on iOS
        and macOS, because their APIs do not provide such possibility. On these
        systems this parameter is only used to set **UpdateTimeoutError**  and
        trigger an **errorOccurred**  signal if the update is not received
        within the desired interval.

        **Member Function Documentation**
        """
        ...

    @property
    def errorOccurred(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#errorOccurred

        **[signal] void
        QGeoPositionInfoSource::errorOccurred(QGeoPositionInfoSource::Error
        positioningError )**

        This signal is emitted after an error occurred. The **positioningError**
        parameter describes the type of error that occurred.
        """
        ...

    @property
    def positionUpdated(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#positionUpdated

        **[signal] void QGeoPositionInfoSource::positionUpdated(const
        QGeoPositionInfo & update )**

        If **startUpdates** () or **requestUpdate** () is called, this signal is
        emitted when an update becomes available.

        The **update** value holds the value of the new update.
        """
        ...

    @property
    def supportedPositioningMethodsChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qgeopositioninfosource.html#supportedPositioningM
        ethodsChanged

        **[signal, since Qt 5.12] void
        QGeoPositionInfoSource::supportedPositioningMethodsChanged()**

        This signal is emitted when the supported positioning methods changed.
        The cause for a change could be a user turning Location services on/off
        or restricting Location services to certain types (e.g. GPS only). Note
        that changes to the supported positioning methods cannot be detected on
        all platforms. **supportedPositioningMethods** () provides an overview
        of the current platform support.

        This function was introduced in Qt 5.12.
        """
        ...
