"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtPositioning import *
import enum


class QGeoSatelliteInfo(PyQt6.sip.wrapper):
    """
    https://doc.qt.io/qt-6/qgeosatelliteinfo.html

    **Detailed Description**

    **See also** **QGeoSatelliteInfoSource** .
    """

    class SatelliteSystem(enum.Enum):
        Undefined: QGeoSatelliteInfo = ...
        GPS: QGeoSatelliteInfo = ...
        GLONASS: QGeoSatelliteInfo = ...
        GALILEO: QGeoSatelliteInfo = ...
        BEIDOU: QGeoSatelliteInfo = ...
        QZSS: QGeoSatelliteInfo = ...
        Multiple: QGeoSatelliteInfo = ...
        CustomType: QGeoSatelliteInfo = ...

    class Attribute(enum.Enum):
        Elevation: QGeoSatelliteInfo = ...
        Azimuth: QGeoSatelliteInfo = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#QGeoSatelliteInfo

        **QGeoSatelliteInfo::QGeoSatelliteInfo()**

        Creates a satellite information object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoSatelliteInfo") -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#QGeoSatelliteInfo-1

        **QGeoSatelliteInfo::QGeoSatelliteInfo(const QGeoSatelliteInfo & other
        )**

        Creates a satellite information object with the values of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def swap(self, other: "QGeoSatelliteInfo") -> None:
        ...

    def hasAttribute(self, attribute: "QGeoSatelliteInfo.Attribute") -> bool:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#hasAttribute

        **bool QGeoSatelliteInfo::hasAttribute(QGeoSatelliteInfo::Attribute
        attribute ) const**

        Returns true if the specified **attribute** is present in this update.
        """
        ...

    def removeAttribute(self, attribute: "QGeoSatelliteInfo.Attribute") -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#removeAttribute

        **void QGeoSatelliteInfo::removeAttribute(QGeoSatelliteInfo::Attribute
        attribute )**

        Removes the specified **attribute** and its value.
        """
        ...

    def attribute(self, attribute: "QGeoSatelliteInfo.Attribute") -> float:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#attribute

        **qreal QGeoSatelliteInfo::attribute(QGeoSatelliteInfo::Attribute
        attribute ) const**

        Returns the value of the specified **attribute** as a qreal value.

        Returns -1 if the value has not been set.

        **See also** **hasAttribute** () and **setAttribute** ().
        """
        ...

    def setAttribute(
        self, attribute: "QGeoSatelliteInfo.Attribute", value: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setAttribute

        **void QGeoSatelliteInfo::setAttribute(QGeoSatelliteInfo::Attribute
        attribute , qreal value )**

        Sets the value for **attribute** to **value**.

        **See also** **attribute** ().
        """
        ...

    def signalStrength(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#signalStrength

        **int QGeoSatelliteInfo::signalStrength() const**

        Returns the signal strength, or -1 if the value has not been set.

        **See also** **setSignalStrength** ().
        """
        ...

    def setSignalStrength(self, signalStrength: int) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setSignalStrength

        **void QGeoSatelliteInfo::setSignalStrength(int signalStrength )**

        Sets the signal strength to **signalStrength** , in decibels.

        **See also** **signalStrength** ().
        """
        ...

    def satelliteIdentifier(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#satelliteIdentifier

        **int QGeoSatelliteInfo::satelliteIdentifier() const**

        Returns the satellite identifier number.

        The satellite identifier number can be used to identify a satellite
        within the satellite system.

        The actual value may vary, depending on the platform and the selected
        backend.

        For example, if **nmea** plugin is used, the satellite identifier for
        GPS satellite system represents the PRN (Pseudo-random noise) number,
        and the satellite identifier for GLONASS satellite system represents the
        slot number.

        For NMEA-based backends the satellite identifier can be used to
        determine the satellite system type if it is not available from other
        sources. You can refer to **satellite IDs list**  to check the ID ranges
        for different satellite systems.

        **Note:** Depending on the platform and the selected backend, the
        satellite identifier ranges for different satellite systems may
        intersect. To uniquely identify a satellite, a combination of
        satelliteIndetifier() and **satelliteSystem** () must be used.

        **See also** **setSatelliteIdentifier** () and **satelliteSystem** ().
        """
        ...

    def setSatelliteIdentifier(self, satId: int) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setSatelliteIdentifier

        **void QGeoSatelliteInfo::setSatelliteIdentifier(int satId )**

        Sets the satellite identifier number to **satId**.

        The satellite identifier number can be used to identify a satellite
        within the satellite system.

        The actual value may vary, depending on the platform and the selected
        backend.

        For example, if **nmea** plugin is used, the satellite identifier for
        GPS satellite system represents the PRN (Pseudo-random noise) number,
        and the satellite identifier for GLONASS satellite system represents the
        slot number.

        **See also** **satelliteIdentifier** ().
        """
        ...

    def satelliteSystem(self) -> "QGeoSatelliteInfo.SatelliteSystem":
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#satelliteSystem

        **QGeoSatelliteInfo::SatelliteSystem
        QGeoSatelliteInfo::satelliteSystem() const**

        Returns the Satellite System (GPS, GLONASS, ...)

        **Note:** This value can be used together with **satelliteIdentifier**
        () to uniquely identify a satellite.

        **See also** **setSatelliteSystem** () and **satelliteIdentifier** ().
        """
        ...

    def setSatelliteSystem(self, system: "QGeoSatelliteInfo.SatelliteSystem") -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setSatelliteSystem

        **void
        QGeoSatelliteInfo::setSatelliteSystem(QGeoSatelliteInfo::SatelliteSystem
        system )**

        Sets the Satellite System (GPS, GLONASS, ...) to **system**.

        **See also** **satelliteSystem** ().
        """
        ...
