"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtCore
from PyQt6.QtPositioning import *
import enum


class QNmeaSatelliteInfoSource(QGeoSatelliteInfoSource):
    """
    https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html

    **Detailed Description**

    NMEA is a commonly used protocol for the specification of one's global
    position at a certain point in time. The **QNmeaSatelliteInfoSource**  class
    reads NMEA data and uses it to provide information about satellites in view
    and satellites in use in form of lists of **QGeoSatelliteInfo**  objects.

    A **QNmeaSatelliteInfoSource**  instance operates in either **RealTimeMode**
    or **SimulationMode** . These modes allow NMEA data to be read from either a
    live source of data, or replayed for simulation purposes from previously
    recorded NMEA data.

    The source of NMEA data is set via **setDevice** ().

    Use **startUpdates** () to start receiving regular satellite information
    updates and **stopUpdates** () to stop these updates. If you only require
    updates occasionally, you can call **requestUpdate** () to request a single
    update of both satellites in view and satellites in use.

    The information about satellites in view is received via the
    **satellitesInViewUpdated** () signal.

    The information about satellites in use is received via the
    **satellitesInUseUpdated** () signal.
    """

    class SatelliteInfoParseStatus(enum.Enum):
        NotParsed: QNmeaSatelliteInfoSource = ...
        PartiallyParsed: QNmeaSatelliteInfoSource = ...
        FullyParsed: QNmeaSatelliteInfoSource = ...

    class UpdateMode(enum.Enum):
        RealTimeMode: QNmeaSatelliteInfoSource = ...
        SimulationMode: QNmeaSatelliteInfoSource = ...

    SimulationUpdateInterval: str = ...

    def __init__(
        self,
        mode: "QNmeaSatelliteInfoSource.UpdateMode",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#QNmeaSatelliteInfoS
        ource

        **QNmeaSatelliteInfoSource::QNmeaSatelliteInfoSource(QNmeaSatelliteInfoS
        ource::UpdateMode mode , QObject * parent = nullptr)**

        Constructs a **QNmeaSatelliteInfoSource**  instance with the given
        **parent** and **mode**.
        """
        ...

    def parseSatelliteInfoFromNmea(
        self, data: bytes, size: int, infos: typing.Iterable[QGeoSatelliteInfo]
    ) -> typing.Tuple[
        "QNmeaSatelliteInfoSource.SatelliteInfoParseStatus",
        QGeoSatelliteInfo.SatelliteSystem,
    ]:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#parseSatelliteInfoF
        romNmea

        **[virtual protected] QNmeaSatelliteInfoSource::SatelliteInfoParseStatus
        QNmeaSatelliteInfoSource::parseSatelliteInfoFromNmea(const char * data ,
        int size , QList<QGeoSatelliteInfo> & infos ,
        QGeoSatelliteInfo::SatelliteSystem & system )**

        Parses an NMEA sentence string to extract the information about
        satellites in view.

        The default implementation will parse standard NMEA $GPGSV sentences.
        This method should be reimplemented in a subclass whenever the need to
        deal with non-standard NMEA sentences arises.

        The parser reads **size** bytes from **data** and uses that information
        to fill **infos** list.

        Returns **SatelliteInfoParseStatus**  with parse result. Modifies
        **infos** list in case **PartiallyParsed**  or **FullyParsed**  is
        returned. Also sets the **system** to correct satellite system type.
        This is required to determine the system type in case there are no
        satellites in view.
        """
        ...

    def parseSatellitesInUseFromNmea(
        self, data: bytes, size: int, pnrsInUse: typing.Iterable[int]
    ) -> QGeoSatelliteInfo.SatelliteSystem:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#parseSatellitesInUs
        eFromNmea

        **[virtual protected] QGeoSatelliteInfo::SatelliteSystem
        QNmeaSatelliteInfoSource::parseSatellitesInUseFromNmea(const char * data
        , int size , QList<int> & pnrsInUse )**

        Parses an NMEA sentence string to extract the IDs of satelites in use.

        The default implementation will parse standard NMEA $GPGSA sentences.
        This method should be reimplemented in a subclass whenever the need to
        deal with non-standard NMEA sentences arises.

        The parser reads **size** bytes from **data** and uses that information
        to fill **pnrsInUse** list.

        Returns system type if the sentence was successfully parsed, otherwise
        returns **QGeoSatelliteInfo::Undefined**  and should not modifiy
        **pnrsInUse**.
        """
        ...

    def requestUpdate(self, timeout: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#requestUpdate

        **[override virtual slot] void
        QNmeaSatelliteInfoSource::requestUpdate(int msec = 0)**

        Reimplements: **QGeoSatelliteInfoSource::requestUpdate** (int timeout).
        """
        ...

    def stopUpdates(self) -> None:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#stopUpdates

        **[override virtual slot] void QNmeaSatelliteInfoSource::stopUpdates()**

        Reimplements: **QGeoSatelliteInfoSource::stopUpdates** ().
        """
        ...

    def startUpdates(self) -> None:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#startUpdates

        **[override virtual slot] void
        QNmeaSatelliteInfoSource::startUpdates()**

        Reimplements: **QGeoSatelliteInfoSource::startUpdates** ().
        """
        ...

    def backendProperty(self, name: str) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#backendProperty

        **[override virtual] QVariant
        QNmeaSatelliteInfoSource::backendProperty(const QString & name ) const**

        Reimplements: **QGeoSatelliteInfoSource::backendProperty(const QString
        &name) const** .

        **See also** **setBackendProperty** ().
        """
        ...

    def setBackendProperty(self, name: str, value: typing.Any) -> bool:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#setBackendProperty

        **[override virtual] bool
        QNmeaSatelliteInfoSource::setBackendProperty(const QString & name ,
        const QVariant & value )**

        Reimplements: **QGeoSatelliteInfoSource::setBackendProperty** (const
        QString &name, const QVariant &value).

        **See also** **backendProperty** ().
        """
        ...

    def error(self) -> QGeoSatelliteInfoSource.Error:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#error

        **[override virtual] QGeoSatelliteInfoSource::Error
        QNmeaSatelliteInfoSource::error() const**

        Reimplements: **QGeoSatelliteInfoSource::error() const** .
        """
        ...

    def minimumUpdateInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#minimumUpdateInterv
        al

        **[override virtual] int
        QNmeaSatelliteInfoSource::minimumUpdateInterval() const**

        Reimplements an access function for property:
        **QGeoSatelliteInfoSource::minimumUpdateInterval** .
        """
        ...

    def setUpdateInterval(self, msec: int) -> None:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#setUpdateInterval

        **[override virtual] void
        QNmeaSatelliteInfoSource::setUpdateInterval(int msec )**

        Reimplements an access function for property:
        **QGeoSatelliteInfoSource::updateInterval** .
        """
        ...

    def device(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#device

        **QIODevice *QNmeaSatelliteInfoSource::device() const**

        Returns the NMEA data source.

        **See also** **setDevice** ().
        """
        ...

    def setDevice(self, source: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#setDevice

        **void QNmeaSatelliteInfoSource::setDevice(QIODevice * device )**

        Sets the NMEA data source to **device**. If the device is not open, it
        will be opened in QIODevice::ReadOnly mode.

        The source device can only be set once and must be set before calling
        **startUpdates** () or **requestUpdate** ().

        **Note:** The **device** must emit **QIODevice::readyRead** () for the
        source to be notified when data is available for reading.
        **QNmeaSatelliteInfoSource**  does not assume the ownership of the
        device, and hence does not deallocate it upon destruction.

        **See also** **device** ().
        """
        ...

    def updateMode(self) -> "QNmeaSatelliteInfoSource.UpdateMode":
        """
        https://doc.qt.io/qt-6/qnmeasatelliteinfosource.html#updateMode

        **QNmeaSatelliteInfoSource::UpdateMode
        QNmeaSatelliteInfoSource::updateMode() const**

        Returns the update mode.
        """
        ...
