"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtWidgets
from PyQt6 import QtCore
from PyQt6.QtPrintSupport import *


class QPrintPreviewDialog(QtWidgets.QDialog):
    """
    https://doc.qt.io/qt-6/qprintpreviewdialog.html

    **Detailed Description**

    Using QPrintPreviewDialog in your existing application is straightforward:

    1. Create the QPrintPreviewDialog.

    You can construct a QPrintPreviewDialog
    with an existing **QPrinter**  object, or you can have QPrintPreviewDialog
    create one for you, which will be the system default printer.

      2. Connect
    the **paintRequested** () signal to a slot.

    When the dialog needs to
    generate a set of preview pages, the **paintRequested** () signal will be
    emitted. You can use the exact same code for the actual printing as for
    having the preview generated, including calling **QPrinter::newPage** () to
    start a new page in the preview. Connect a slot to the **paintRequested** ()
    signal, where you draw onto the **QPrinter**  object that is passed into the
    slot.

      3. Call **exec** ().

    Call **QPrintPreviewDialog::exec** () to show
    the preview dialog.

    **See also** **QPrinter** , **QPrintDialog** , **QPageSetupDialog** , and
    **QPrintPreviewWidget** .
    """

    @typing.overload
    def __init__(
        self,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        flags: QtCore.Qt.WindowType = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#QPrintPreviewDialog

        **QPrintPreviewDialog::QPrintPreviewDialog(QPrinter * printer , QWidget
        * parent = nullptr, Qt::WindowFlags flags = Qt::WindowFlags())**

        Constructs a QPrintPreviewDialog based on **printer** and with
        **parent** as the parent widget. The widget flags **flags** are passed
        on to the **QWidget**  constructor.

        **See also** **QWidget::setWindowFlags** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        printer: QPrinter,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        flags: QtCore.Qt.WindowType = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#QPrintPreviewDialog-1

        **QPrintPreviewDialog::QPrintPreviewDialog(QWidget * parent = nullptr,
        Qt::WindowFlags flags = Qt::WindowFlags())**

        This is an overloaded function.

        This will create an internal **QPrinter**  object, which will use the
        system default printer.
        """
        ...

    def done(self, result: int) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#done

        **[override virtual] void QPrintPreviewDialog::done(int result )**

        Reimplements: **QDialog::done** (int r).
        """
        ...

    def printer(self) -> QPrinter:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#printer

        **QPrinter *QPrintPreviewDialog::printer()**

        Returns a pointer to the **QPrinter**  object this dialog is currently
        operating on.
        """
        ...

    @typing.overload
    def open(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#open

        **void QPrintPreviewDialog::open(QObject * receiver , const char *
        member )**

        This is an overloaded function.

        Opens the dialog and connects its finished(int) signal to the slot
        specified by **receiver** and **member**.

        The signal will be disconnected from the slot when the dialog is closed.
        """
        ...

    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#open

        **void QPrintPreviewDialog::open(QObject * receiver , const char *
        member )**

        This is an overloaded function.

        Opens the dialog and connects its finished(int) signal to the slot
        specified by **receiver** and **member**.

        The signal will be disconnected from the slot when the dialog is closed.
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#setVisible

        **[override virtual] void QPrintPreviewDialog::setVisible(bool visible
        )**

        Reimplements: **QDialog::setVisible** (bool visible).
        """
        ...

    @property
    def paintRequested(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qprintpreviewdialog.html#paintRequested

        **[signal] void QPrintPreviewDialog::paintRequested(QPrinter * printer
        )**

        This signal is emitted when the **QPrintPreviewDialog**  needs to
        generate a set of preview pages.

        The **printer** instance supplied is the paint device onto which you
        should paint the contents of each page, using the **QPrinter**  instance
        in the same way as you would when printing directly.
        """
        ...
