"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtQml import *
import enum


class QJSValue(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qjsvalue.html

    **Detailed Description**

    QJSValue supports the types defined in the **ECMA-262**  standard: The
    primitive types, which are Undefined, Null, Boolean, Number, and String; and
    the Object and Array types. Additionally, built-in support is provided for
    Qt/C++ types such as **QVariant**  and **QObject** .

    For the object-based types (including Date and RegExp), use the newT()
    functions in **QJSEngine**  (e.g. **QJSEngine::newObject** ()) to create a
    QJSValue of the desired type. For the primitive types, use one of the
    QJSValue constructor overloads. For other types, e.g. registered gadget
    types such as **QPoint** , you can use **QJSEngine::toScriptValue** .

    The methods named isT() (e.g. **isBool** (), **isUndefined** ()) can be used
    to test if a value is of a certain type. The methods named toT() (e.g.
    **toBool** (), **toString** ()) can be used to convert a QJSValue to another
    type. You can also use the generic qjsvalue_cast() function.

    Object values have zero or more properties which are themselves QJSValues.
    Use **setProperty** () to set a property of an object, and call **property**
    () to retrieve the value of a property.

    **QJSEngine**  myEngine;
        **QJSValue**  myObject = myEngine.newObject();
    **QJSValue**  myOtherObject = myEngine.newObject();
    myObject.setProperty("myChild", myOtherObject);
    myObject.setProperty("name", "John Doe");

    If you want to iterate over the properties of a script object, use the
    **QJSValueIterator**  class.

    Object values have an internal `prototype` property, which can be accessed
    with **prototype** () and **setPrototype** ().

    Function objects (objects for which **isCallable** ()) returns true) can be
    invoked by calling **call** (). Constructor functions can be used to
    construct new objects by calling **callAsConstructor** ().

    Use **equals** () or **strictlyEquals** () to compare a QJSValue to another.

    Note that a QJSValue for which **isObject** () is true only carries a
    reference to an actual object; copying the QJSValue will only copy the
    object reference, not the object itself. If you want to clone an object
    (i.e. copy an object's properties to another object), you can do so with the
    help of a `for-in` statement in script code, or **QJSValueIterator**  in
    C++.

    **Working With Arrays**

    To create an array using QJSValue, use **QJSEngine::newArray** ():

    // Assumes that this class was declared in QML.
        **QJSValue**  jsArray =
    engine->newArray(3);

    To set individual elements in the array, use the **setProperty** (quint32
    arrayIndex, const QJSValue &value) overload. For example, to fill the array
    above with integers:

    for (int i = 0; i < 3; ++i) {
            jsArray.setProperty(i,
    **QRandomGenerator** ::global().generate());
        }

    To determine the length of the array, access the `"length"` property. To
    access array elements, use the **property** (quint32 arrayIndex) overload.
    The following code reads the array we created above back into a list:

    **QVector** <int> integers;
        const int length =
    jsArray.property("length").toInt();
        for (int i = 0; i < length; ++i) {
    integers.append(jsArray.property(i).toInt());
        }

    **See also** **QJSEngine**  and **QJSValueIterator** .
    """

    class ErrorType(enum.Enum):
        GenericError: QJSValue = ...
        EvalError: QJSValue = ...
        RangeError: QJSValue = ...
        ReferenceError: QJSValue = ...
        SyntaxError: QJSValue = ...
        TypeError: QJSValue = ...
        URIError: QJSValue = ...

    class ObjectConversionBehavior(enum.Enum):
        ConvertJSObjects: QJSValue = ...
        RetainJSObjects: QJSValue = ...

    class SpecialValue(enum.Enum):
        NullValue: QJSValue = ...
        UndefinedValue: QJSValue = ...

    @typing.overload
    def __init__(self, value: "QJSValue.SpecialValue" = ...) -> None:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#QJSValue

        **QJSValue::QJSValue(QJSValue::SpecialValue value = UndefinedValue)**

        Constructs a new QJSValue with a special **value**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        other: typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#QJSValue-1

        **QJSValue::QJSValue(const QJSValue & other )**

        Constructs a new QJSValue that is a copy of **other**.

        Note that if **other** is an object (i.e., **isObject** () would return
        true), then only a reference to the underlying object is copied into the
        new script value (i.e., the object itself is not copied).
        """
        ...

    def errorType(self) -> "QJSValue.ErrorType":
        """
        https://doc.qt.io/qt-6/qjsvalue.html#errorType

        **[since 5.12] QJSValue::ErrorType QJSValue::errorType() const**

        Returns the error type this **QJSValue**  represents if it is an Error
        object. Otherwise, returns `NoError."`

        This function was introduced in Qt 5.12.

        **See also** **isError** () and **QJSEngine - Script Exceptions** .
        """
        ...

    def callAsConstructor(
        self,
        args: typing.Iterable[
            typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str]
        ] = ...,
    ) -> "QJSValue":
        """
        https://doc.qt.io/qt-6/qjsvalue.html#callAsConstructor

        **QJSValue QJSValue::callAsConstructor(const QJSValueList & args =
        QJSValueList()) const**

        Creates a new `Object` and calls this **QJSValue**  as a constructor,
        using the created object as the `this' object and passing **args** as
        arguments. If the return value from the constructor call is an object,
        then that object is returned; otherwise the default constructed object
        is returned.

        If this **QJSValue**  is not a function, callAsConstructor() does
        nothing and returns an undefined **QJSValue** .

        Calling this function can cause an exception to occur in the script
        engine; in that case, the value that was thrown (typically an `Error`
        object) is returned. You can call **isError** () on the return value to
        determine whether an exception occurred.

        **See also** **call** () and **QJSEngine::newObject** ().
        """
        ...

    def callWithInstance(
        self,
        instance: typing.Union[
            "QJSValue", "QJSValue.SpecialValue", bool, int, float, str
        ],
        args: typing.Iterable[
            typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str]
        ] = ...,
    ) -> "QJSValue":
        """
        https://doc.qt.io/qt-6/qjsvalue.html#callWithInstance

        **QJSValue QJSValue::callWithInstance(const QJSValue & instance , const
        QJSValueList & args = QJSValueList()) const**

        Calls this **QJSValue**  as a function, using **instance** as the `this'
        object in the function call, and passing **args** as arguments to the
        function. Returns the value returned from the function.

        If this **QJSValue**  is not a function, **call** () does nothing and
        returns an undefined **QJSValue** .

        Note that if **instance** is not an object, the global object (see
        **QJSEngine::globalObject** ()) will be used as the `this' object.

        Calling **call** () can cause an exception to occur in the script
        engine; in that case, **call** () returns the value that was thrown
        (typically an `Error` object). You can call **isError** () on the return
        value to determine whether an exception occurred.

        **See also** **call** ().
        """
        ...

    def call(
        self,
        args: typing.Iterable[
            typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str]
        ] = ...,
    ) -> "QJSValue":
        """
        https://doc.qt.io/qt-6/qjsvalue.html#call

        **QJSValue QJSValue::call(const QJSValueList & args = QJSValueList())
        const**

        Calls this **QJSValue**  as a function, passing **args** as arguments to
        the function, and using the globalObject() as the "this"-object. Returns
        the value returned from the function.

        If this **QJSValue**  is not callable, call() does nothing and returns
        an undefined **QJSValue** .

        Calling call() can cause an exception to occur in the script engine; in
        that case, call() returns the value that was thrown (typically an
        `Error` object). You can call **isError** () on the return value to
        determine whether an exception occurred.

        **See also** **isCallable** (), **callWithInstance** (), and
        **callAsConstructor** ().
        """
        ...

    def isCallable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isCallable

        **bool QJSValue::isCallable() const**

        Returns true if this **QJSValue**  is a function, otherwise returns
        false.

        **See also** **call** ().
        """
        ...

    def deleteProperty(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#deleteProperty

        **bool QJSValue::deleteProperty(const QString & name )**

        Attempts to delete this object's property of the given **name**. Returns
        true if the property was deleted, otherwise returns false.

        The behavior of this function is consistent with the JavaScript delete
        operator. In particular:

        * Non-configurable properties cannot be deleted.
          * This function will
        return true even if this object doesn't have a property of the given
        **name** (i.e., non-existent properties are "trivially deletable").
          *
        If this object doesn't have an own property of the given **name** , but
        an object in the **prototype** () chain does, the prototype object's
        property is not deleted, and this function returns true.

        **See also** **setProperty** () and **hasOwnProperty** ().
        """
        ...

    def hasOwnProperty(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#hasOwnProperty

        **bool QJSValue::hasOwnProperty(const QString & name ) const**

        Returns true if this object has an own (not prototype-inherited)
        property of the given **name** , otherwise returns false.

        **See also** **property** () and **hasProperty** ().
        """
        ...

    def hasProperty(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#hasProperty

        **bool QJSValue::hasProperty(const QString & name ) const**

        Returns true if this object has a property of the given **name** ,
        otherwise returns false.

        **See also** **property** () and **hasOwnProperty** ().
        """
        ...

    @typing.overload
    def setProperty(
        self,
        name: str,
        value: typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#setProperty

        **void QJSValue::setProperty(const QString & name , const QJSValue &
        value )**

        Sets the value of this **QJSValue** 's property with the given **name**
        to the given **value**.

        If this **QJSValue**  is not an object, this function does nothing.

        If this **QJSValue**  does not already have a property with name
        **name** , a new property is created.

        To modify array elements, use the **setProperty** (quint32 arrayIndex,
        const QJSValue &value) overload instead.

        **See also** **property** () and **deleteProperty** ().
        """
        ...

    @typing.overload
    def setProperty(
        self,
        arrayIndex: int,
        value: typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#setProperty-1

        **void QJSValue::setProperty(quint32 arrayIndex , const QJSValue & value
        )**

        This is an overloaded function.

        Sets the property at the given **arrayIndex** to the given **value**.

        It is possible to modify elements in an array in two ways. The first is
        to use the array index as the property name:

        jsValueArray.setProperty(QLatin1String("4"), value);

        The second is to use the overload that takes an index:

        jsValueArray.setProperty(4, value);

        Both of these approaches achieve the same result, except that the
        latter:

        * Is easier to use (can use an integer directly)
          * Is faster (no
        conversion to integer)

        If this **QJSValue**  is not an Array object, this function behaves as
        if setProperty() was called with the string representation of
        **arrayIndex**.

        **See also** **property** (quint32 arrayIndex) and **Working With
        Arrays** .
        """
        ...

    @typing.overload
    def property(self, name: str) -> "QJSValue":
        """
        https://doc.qt.io/qt-6/qjsvalue.html#property

        **QJSValue QJSValue::property(const QString & name ) const**

        Returns the value of this **QJSValue** 's property with the given
        **name**. If no such property exists, an undefined **QJSValue**  is
        returned.

        If the property is implemented using a getter function (i.e. has the
        PropertyGetter flag set), calling property() has side-effects on the
        script engine, since the getter function will be called (possibly
        resulting in an uncaught script exception). If an exception occurred,
        property() returns the value that was thrown (typically an `Error`
        object).

        To access array elements, use the **setProperty** (quint32 arrayIndex,
        const QJSValue &value) overload instead.

        **See also** **setProperty** (), **hasProperty** (), and
        **QJSValueIterator** .
        """
        ...

    @typing.overload
    def property(self, arrayIndex: int) -> "QJSValue":
        """
        https://doc.qt.io/qt-6/qjsvalue.html#property-1

        **QJSValue QJSValue::property(quint32 arrayIndex ) const**

        This is an overloaded function.

        Returns the property at the given **arrayIndex**.

        It is possible to access elements in an array in two ways. The first is
        to use the array index as the property name:

        **qDebug** () << jsValueArray.property(QLatin1String("4")).toString();

        The second is to use the overload that takes an index:

        **qDebug** () << jsValueArray.property(4).toString();

        Both of these approaches achieve the same result, except that the
        latter:

        * Is easier to use (can use an integer directly)
          * Is faster (no
        conversion to integer)

        If this **QJSValue**  is not an Array object, this function behaves as
        if property() was called with the string representation of
        **arrayIndex**.
        """
        ...

    def setPrototype(
        self,
        prototype: typing.Union[
            "QJSValue", "QJSValue.SpecialValue", bool, int, float, str
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#setPrototype

        **void QJSValue::setPrototype(const QJSValue & prototype )**

        If this **QJSValue**  is an object, sets the internal prototype
        (`__proto__` property) of this object to be **prototype** ; if the
        **QJSValue**  is null, it sets the prototype to null; otherwise does
        nothing.

        The internal prototype should not be confused with the public property
        with name "prototype"; the public prototype is usually only set on
        functions that act as constructors.

        **See also** **prototype** () and **isObject** ().
        """
        ...

    def prototype(self) -> "QJSValue":
        """
        https://doc.qt.io/qt-6/qjsvalue.html#prototype

        **QJSValue QJSValue::prototype() const**

        If this **QJSValue**  is an object, returns the internal prototype
        (`__proto__` property) of this object; otherwise returns an undefined
        **QJSValue** .

        **See also** **setPrototype** () and **isObject** ().
        """
        ...

    def strictlyEquals(
        self,
        other: typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#strictlyEquals

        **bool QJSValue::strictlyEquals(const QJSValue & other ) const**

        Returns true if this **QJSValue**  is equal to **other** using strict
        comparison (no conversion), otherwise returns false. The comparison
        follows the behavior described in **ECMA-262**  section 11.9.6, "The
        Strict Equality Comparison Algorithm".

        If the type of this **QJSValue**  is different from the type of the
        **other** value, this function returns false. If the types are equal,
        the result depends on the type, as shown in the following table:

        TypeResult
        Undefinedtrue
        Nulltrue
        Booleantrue if both values are
        true, false otherwise
        Numberfalse if either value is NaN (Not-a-
        Number); true if values are equal, false otherwise
        Stringtrue if both
        values are exactly the same sequence of characters, false otherwise
        Objecttrue if both values refer to the same object, false otherwise

        **See also** **equals** ().
        """
        ...

    def equals(
        self,
        other: typing.Union["QJSValue", "QJSValue.SpecialValue", bool, int, float, str],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#equals

        **bool QJSValue::equals(const QJSValue & other ) const**

        Returns true if this **QJSValue**  is equal to **other** , otherwise
        returns false. The comparison follows the behavior described in
        **ECMA-262**  section 11.9.3, "The Abstract Equality Comparison
        Algorithm".

        This function can return true even if the type of this **QJSValue**  is
        different from the type of the **other** value; i.e. the comparison is
        not strict. For example, comparing the number 9 to the string "9"
        returns true; comparing an undefined value to a null value returns true;
        comparing a `Number` object whose primitive value is 6 to a `String`
        object whose primitive value is "6" returns true; and comparing the
        number 1 to the boolean value `true` returns true. If you want to
        perform a comparison without such implicit value conversion, use
        **strictlyEquals** ().

        Note that if this **QJSValue**  or the **other** value are objects,
        calling this function has side effects on the script engine, since the
        engine will call the object's valueOf() function (and possibly
        **toString** ()) in an attempt to convert the object to a primitive
        value (possibly resulting in an uncaught script exception).

        **See also** **strictlyEquals** ().
        """
        ...

    def toDateTime(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toDateTime

        **QDateTime QJSValue::toDateTime() const**

        Returns a **QDateTime**  representation of this value, in local time. If
        this **QJSValue**  is not a date, or the value of the date is NaN (Not-
        a-Number), an invalid **QDateTime**  is returned.

        **See also** **isDate** ().
        """
        ...

    def toQObject(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toQObject

        **QObject *QJSValue::toQObject() const**

        If this **QJSValue**  is a **QObject** , returns the **QObject**
        pointer that the **QJSValue**  represents; otherwise, returns `nullptr`.

        If the **QObject**  that this **QJSValue**  wraps has been deleted, this
        function returns `nullptr` (i.e. it is possible for toQObject() to
        return `nullptr` even when **isQObject** () returns true).

        **See also** **isQObject** ().
        """
        ...

    def toPrimitive(self) -> QJSPrimitiveValue:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toPrimitive

        **QJSPrimitiveValue QJSValue::toPrimitive() const**

        Converts the value to a **QJSPrimitiveValue** . If the value holds a
        type supported by **QJSPrimitiveValue** , the value is copied. Otherwise
        the value is converted to a string, and the string is stored in
        **QJSPrimitiveValue** .

        **Note:** Conversion of a managed value to a string can throw an
        exception. In particular, symbols cannot be coerced into strings, or a
        custom **toString** () method may throw. In this case the result is the
        undefined value and the engine carries an error after the conversion.
        """
        ...

    @typing.overload
    def toVariant(self) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toVariant

        **QVariant QJSValue::toVariant(QJSValue::ObjectConversionBehavior
        behavior ) const**

        Returns the **QVariant**  value of this **QJSValue** , if it can be
        converted to a **QVariant** ; otherwise returns an invalid **QVariant**
        . Some JavaScript types and objects have native expressions in Qt. Those
        are converted to their native expressions. For example:

        Input TypeResult
        UndefinedAn invalid **QVariant** .
        NullA
        **QVariant**  containing a null pointer (**QMetaType::Nullptr** ).
        BooleanA **QVariant**  containing the value of the boolean.
        NumberA
        **QVariant**  containing the value of the number.
        StringA **QVariant**
        containing the value of the string.
        **QVariant**  ObjectThe result is
        the **QVariant**  value of the object (no conversion).
        **QObject**
        ObjectA **QVariant**  containing a pointer to the **QObject** .
        Date
        ObjectA **QVariant**  containing the date value (**toDateTime** ()).
        **RegularExpression**  ObjectA **QVariant**  containing the regular
        expression value.

        For other types the **behavior** parameter is relevant. If
        `ConvertJSObjects` is given, a best effort but possibly lossy conversion
        is attempted. Generic JavaScript objects are converted to QVariantMap.
        JavaScript arrays are converted to QVariantList. Each property or
        element is converted to a **QVariant** , recursively; cyclic references
        are not followed. JavaScript function objects are dropped. If
        `RetainJSObjects` is given, the **QJSValue**  is wrapped into a
        **QVariant**  via **QVariant::fromValue** (). The resulting conversion
        is lossless but the internal structure of the objects is not immediately
        accessible.

        **See also** **isVariant** ().
        """
        ...

    @typing.overload
    def toVariant(self, behavior: "QJSValue.ObjectConversionBehavior") -> typing.Any:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toVariant-1

        **QVariant QJSValue::toVariant() const**

        This is an overloaded function.

        Returns toVariant(**ConvertJSObjects** ).

        **See also** **isVariant** ().
        """
        ...

    def toBool(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toBool

        **bool QJSValue::toBool() const**

        Returns the boolean value of this **QJSValue** , using the conversion
        rules described in **ECMA-262**  section 9.2, "ToBoolean".

        Note that if this **QJSValue**  is an object, calling this function has
        side effects on the script engine, since the engine will call the
        object's valueOf() function (and possibly **toString** ()) in an attempt
        to convert the object to a primitive value (possibly resulting in an
        uncaught script exception).

        **See also** **isBool** ().
        """
        ...

    def toUInt(self) -> int:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toUInt

        **quint32 QJSValue::toUInt() const**

        Returns the unsigned 32-bit integer value of this **QJSValue** , using
        the conversion rules described in **ECMA-262**  section 9.6, "ToUint32".

        Note that if this **QJSValue**  is an object, calling this function has
        side effects on the script engine, since the engine will call the
        object's valueOf() function (and possibly **toString** ()) in an attempt
        to convert the object to a primitive value (possibly resulting in an
        uncaught script exception).

        **See also** **toNumber** () and **toInt** ().
        """
        ...

    def toInt(self) -> int:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toInt

        **qint32 QJSValue::toInt() const**

        Returns the signed 32-bit integer value of this **QJSValue** , using the
        conversion rules described in **ECMA-262**  section 9.5, "ToInt32".

        Note that if this **QJSValue**  is an object, calling this function has
        side effects on the script engine, since the engine will call the
        object's valueOf() function (and possibly **toString** ()) in an attempt
        to convert the object to a primitive value (possibly resulting in an
        uncaught script exception).

        **See also** **toNumber** () and **toUInt** ().
        """
        ...

    def toNumber(self) -> float:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toNumber

        **double QJSValue::toNumber() const**

        Returns the number value of this **QJSValue** , as defined in
        **ECMA-262**  section 9.3, "ToNumber".

        Note that if this **QJSValue**  is an object, calling this function has
        side effects on the script engine, since the engine will call the
        object's valueOf() function (and possibly **toString** ()) in an attempt
        to convert the object to a primitive value (possibly resulting in an
        uncaught script exception).

        **See also** **isNumber** (), **toInt** (), and **toUInt** ().
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#toString

        **QString QJSValue::toString() const**

        Returns the string value of this **QJSValue** , as defined in
        **ECMA-262**  section 9.8, "ToString".

        Note that if this **QJSValue**  is an object, calling this function has
        side effects on the script engine, since the engine will call the
        object's toString() function (and possibly valueOf()) in an attempt to
        convert the object to a primitive value (possibly resulting in an
        uncaught script exception).

        **See also** **isString** ().
        """
        ...

    def isUrl(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isUrl

        **bool QJSValue::isUrl() const**

        Returns true if this **QJSValue**  is an object of the URL class;
        otherwise returns false.
        """
        ...

    def isError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isError

        **bool QJSValue::isError() const**

        Returns true if this **QJSValue**  is an object of the Error class;
        otherwise returns false.

        **See also** **errorType** () and **QJSEngine - Script Exceptions** .
        """
        ...

    def isArray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isArray

        **bool QJSValue::isArray() const**

        Returns true if this **QJSValue**  is an object of the Array class;
        otherwise returns false.

        **See also** **QJSEngine::newArray** ().
        """
        ...

    def isRegExp(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isRegExp

        **bool QJSValue::isRegExp() const**

        Returns true if this **QJSValue**  is an object of the RegExp class;
        otherwise returns false.
        """
        ...

    def isDate(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isDate

        **bool QJSValue::isDate() const**

        Returns true if this **QJSValue**  is an object of the Date class;
        otherwise returns false.
        """
        ...

    def isObject(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isObject

        **bool QJSValue::isObject() const**

        Returns true if this **QJSValue**  is of the Object type; otherwise
        returns false.

        Note that function values, variant values, and **QObject**  values are
        objects, so this function returns true for such values.

        **See also** **QJSEngine::newObject** ().
        """
        ...

    def isQObject(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isQObject

        **bool QJSValue::isQObject() const**

        Returns true if this **QJSValue**  is a **QObject** ; otherwise returns
        false.

        Note: This function returns true even if the **QObject**  that this
        **QJSValue**  wraps has been deleted.

        **See also** **toQObject** () and **QJSEngine::newQObject** ().
        """
        ...

    def isVariant(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isVariant

        **bool QJSValue::isVariant() const**

        Returns true if this **QJSValue**  is a variant value; otherwise returns
        false.

        **See also** **toVariant** ().
        """
        ...

    def isUndefined(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isUndefined

        **bool QJSValue::isUndefined() const**

        Returns true if this **QJSValue**  is of the primitive type Undefined or
        if the managed value has been cleared (by deleting the engine).
        Otherwise returns false.
        """
        ...

    def isString(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isString

        **bool QJSValue::isString() const**

        Returns true if this **QJSValue**  is of the primitive type String;
        otherwise returns false.

        **See also** **toString** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isNull

        **bool QJSValue::isNull() const**

        Returns true if this **QJSValue**  is of the primitive type Null;
        otherwise returns false.
        """
        ...

    def isNumber(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isNumber

        **bool QJSValue::isNumber() const**

        Returns true if this **QJSValue**  is of the primitive type Number;
        otherwise returns false.

        **See also** **toNumber** ().
        """
        ...

    def isBool(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsvalue.html#isBool

        **bool QJSValue::isBool() const**

        Returns true if this **QJSValue**  is of the primitive type Boolean;
        otherwise returns false.

        **See also** **toBool** ().
        """
        ...
