"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtQml import *


class QQmlListReference(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qqmllistreference.html

    **Detailed Description**

    QQmlListReference allows C++ programs to read from, and assign values to a
    QML list property in a simple and type-safe way. A QQmlListReference can be
    created by passing an object and property name or through a **QQmlProperty**
    instance. These two are equivalent:

    **QQmlListReference**  ref1(object, "children");

        **QQmlProperty**
    ref2(object, "children");
        **QQmlListReference**  ref2 =
    qvariant_cast<**QQmlListReference** >(ref2.read());

    Not all QML list properties support all operations. A set of methods,
    **canAppend** (), **canAt** (), **canClear** () and **canCount** () allow
    programs to query whether an operation is supported on a given property.

    QML list properties are type-safe. Only **QObject** 's that derive from the
    correct base class can be assigned to the list. The **listElementType** ()
    method can be used to query the **QMetaObject**  of the **QObject**  type
    supported. Attempting to add objects of the incorrect type to a list
    property will fail.

    Like with normal lists, when accessing a list element by index, it is the
    callers responsibility to ensure that it does not request an out of range
    element using the **count** () method before calling **at** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference

        **QQmlListReference::QQmlListReference()**

        Constructs an invalid instance.
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: QtCore.QObject,
        property: str,
        engine: typing.Optional[QQmlEngine] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference-1

        **[since 6.1] QQmlListReference::QQmlListReference(const QVariant &
        variant , QQmlEngine * engine = nullptr)**

        Constructs a QQmlListReference from a **QVariant**  **variant**
        containing a **QQmlListProperty** . If **variant** does not contain a
        list property, an invalid QQmlListReference is created. If the object
        owning the list property is destroyed after the reference is
        constructed, it will automatically become invalid. That is, it is safe
        to hold QQmlListReference instances even after the object is deleted.

        The **engine** is required to look up the element type, which may be a
        dynamically created QML type. If it's omitted, only pre-registered types
        are available. The element type is needed when inserting values into the
        list and when the value meta type is explicitly retrieved.

        This function was introduced in Qt 6.1.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QQmlListReference") -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference-2

        **QQmlListReference::QQmlListReference(QObject * object , const char *
        property , QQmlEngine * engine = nullptr)**

        Constructs a QQmlListReference for **object** 's **property**. If
        **property** is not a list property, an invalid QQmlListReference is
        created. If **object** is destroyed after the reference is constructed,
        it will automatically become invalid. That is, it is safe to hold
        QQmlListReference instances even after **object** is deleted.

        The **engine** is required to look up the element type, which may be a
        dynamically created QML type. If it's omitted, only pre-registered types
        are available. The element type is needed when inserting values into the
        list and when the value meta type is explicitly retrieved.
        """
        ...

    @typing.overload
    def __init__(
        self, variant: typing.Any, engine: typing.Optional[QQmlEngine] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference

        **QQmlListReference::QQmlListReference()**

        Constructs an invalid instance.
        """
        ...

    def removeLast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#removeLast

        **bool QQmlListReference::removeLast() const**

        Removes the last item in the list. Returns true if the operation
        succeeded, otherwise false.

        **See also** **canRemoveLast** ().
        """
        ...

    def replace(self, a0: int, a1: QtCore.QObject) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#replace

        **bool QQmlListReference::replace(qsizetype index , QObject * object )
        const**

        Replaces the item at **index** in the list with **object**. Returns true
        if the operation succeeded, otherwise false.

        **See also** **canReplace** ().
        """
        ...

    def canRemoveLast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canRemoveLast

        **bool QQmlListReference::canRemoveLast() const**

        Returns true if the last item can be removed from the list property,
        otherwise false. Returns false if the reference is invalid.

        **See also** **removeLast** ().
        """
        ...

    def canReplace(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canReplace

        **bool QQmlListReference::canReplace() const**

        Returns true if items in the list property can be replaced, otherwise
        false. Returns false if the reference is invalid.

        **See also** **replace** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#count

        **qsizetype QQmlListReference::count() const**

        Returns the number of objects in the list, or 0 if the operation failed.
        """
        ...

    def clear(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#clear

        **bool QQmlListReference::clear() const**

        Clears the list. Returns true if the operation succeeded, otherwise
        false.

        **See also** **canClear** ().
        """
        ...

    def at(self, a0: int) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#at

        **QObject *QQmlListReference::at(qsizetype index ) const**

        Returns the list element at **index** , or 0 if the operation failed.

        **See also** **canAt** ().
        """
        ...

    def append(self, a0: QtCore.QObject) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#append

        **bool QQmlListReference::append(QObject * object ) const**

        Appends **object** to the list. Returns true if the operation succeeded,
        otherwise false.

        **See also** **canAppend** ().
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#isReadable

        **bool QQmlListReference::isReadable() const**

        Return true if **at** () and **count** () are implemented, so you can
        access the elements.

        **See also** **isManipulable** (), **at** (), and **count** ().
        """
        ...

    def isManipulable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#isManipulable

        **bool QQmlListReference::isManipulable() const**

        Return true if **at** (), **count** (), **append** (), and either
        **clear** () or **removeLast** () are implemented, so you can manipulate
        the list.

        Mind that **replace** () and **removeLast** () can be emulated by
        stashing all items and rebuilding the list using **clear** () and
        **append** (). Therefore, they are not required for the list to be
        manipulable. Furthermore, **clear** () can be emulated using
        **removeLast** ().

        **See also** **isReadable** (), **at** (), **count** (), **append** (),
        **clear** (), **replace** (), and **removeLast** ().
        """
        ...

    def canCount(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canCount

        **bool QQmlListReference::canCount() const**

        Returns true if the list property can be queried for its element count,
        otherwise false. Returns false if the reference is invalid.

        **See also** **count** ().
        """
        ...

    def canClear(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canClear

        **bool QQmlListReference::canClear() const**

        Returns true if the list property can be cleared, otherwise false.
        Returns false if the reference is invalid.

        **See also** **clear** ().
        """
        ...

    def canAt(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canAt

        **bool QQmlListReference::canAt() const**

        Returns true if the list property can queried by index, otherwise false.
        Returns false if the reference is invalid.

        **See also** **at** ().
        """
        ...

    def canAppend(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canAppend

        **bool QQmlListReference::canAppend() const**

        Returns true if the list property can be appended to, otherwise false.
        Returns false if the reference is invalid.

        **See also** **append** ().
        """
        ...

    def listElementType(self) -> QtCore.QMetaObject:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#listElementType

        **const QMetaObject *QQmlListReference::listElementType() const**

        Returns the **QMetaObject**  for the elements stored in the list
        property, or `nullptr` if the reference is invalid.

        The **QMetaObject**  can be used ahead of time to determine whether a
        given instance can be added to a list. If you didn't pass an engine on
        construction this may return nullptr.
        """
        ...

    def object(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#object

        **QObject *QQmlListReference::object() const**

        Returns the list property's object. Returns `nullptr` if the reference
        is invalid.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#isValid

        **bool QQmlListReference::isValid() const**

        Returns true if the instance refers to a valid list property, otherwise
        false.
        """
        ...
