"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore


class QQmlPropertyMap(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qqmlpropertymap.html

    **Detailed Description**

    QQmlPropertyMap provides a convenient way to expose domain data to the UI
    layer. The following example shows how you might declare data in C++ and
    then access it in QML.

    In the C++ file:

    // create our data
        **QQmlPropertyMap**  ownerData;
    ownerData.insert("name", **QVariant** (**QString** ("John Smith")));
    ownerData.insert("phone", **QVariant** (**QString** ("555-5555")));
    // expose it to the UI layer
        **QQuickView**  view;
        **QQmlContext**
    *ctxt = view.rootContext();
        ctxt->setContextProperty("owner",
    &ownerData);

        view.setSource(**QUrl** ::fromLocalFile("main.qml"));
    view.show();

    Then, in `main.qml`:

    Text { text: owner.name + " " + owner.phone }

    The binding is dynamic - whenever a key's value is updated, anything bound
    to that key will be updated as well.

    To detect value changes made in the UI layer you can connect to the
    **valueChanged** () signal. However, note that **valueChanged** () is
    **NOT** emitted when changes are made by calling **insert** () or **clear**
    () - it is only emitted when a value is updated from QML.

    **Note:** It is not possible to remove keys from the map; once a key has
    been added, you can only modify or clear its associated value.

    **Note:** When deriving a class from QQmlPropertyMap, use the **protected
    two-argument constructor**  which ensures that the class is correctly
    registered with the Qt **Meta-Object System** .

    **Note:** The **QMetaObject**  of a QQmlPropertyMap is dynamically generated
    and modified. Operations on that meta object are not thread safe, so
    applications need to take care to explicitly synchronize access to the meta
    object.
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#QQmlPropertyMap

        **QQmlPropertyMap::QQmlPropertyMap(QObject * parent = nullptr)**

        Constructs a bindable map with parent object **parent**.
        """
        ...

    def updateValue(self, key: str, input: typing.Any) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#updateValue

        **[virtual protected] QVariant QQmlPropertyMap::updateValue(const
        QString & key , const QVariant & input )**

        Returns the new value to be stored for the key **key**. This function is
        provided to intercept updates to a property from QML, where the value
        provided from QML is **input**.

        Override this function to manipulate the property value as it is
        updated. Note that this function is only invoked when the value is
        updated from QML.
        """
        ...

    def __getitem__(self, key: str) -> typing.Any:
        ...

    def contains(self, key: str) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#contains

        **bool QQmlPropertyMap::contains(const QString & key ) const**

        Returns true if the map contains **key**.

        **See also** **size** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#isEmpty

        **bool QQmlPropertyMap::isEmpty() const**

        Returns true if the map contains no keys; otherwise returns false.

        **See also** **size** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#size

        **int QQmlPropertyMap::size() const**

        Returns the number of keys in the map.

        **See also** **isEmpty** () and **count** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#count

        **int QQmlPropertyMap::count() const**

        This is an overloaded function.

        Same as **size** ().
        """
        ...

    def keys(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#keys

        **[invokable] QStringList QQmlPropertyMap::keys() const**

        Returns the list of keys.

        Keys that have been cleared will still appear in this list, even though
        their associated values are invalid QVariants.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def clear(self, key: str) -> None:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#clear

        **void QQmlPropertyMap::clear(const QString & key )**

        Clears the value (if any) associated with **key**.
        """
        ...

    def freeze(self) -> None:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#freeze

        **[since 6.1] void QQmlPropertyMap::freeze()**

        Disallows any further properties to be added to this property map.
        Existing properties can be modified or cleared.

        In turn, an internal cache is turned on for the existing properties,
        which may result in faster access from QML.

        This function was introduced in Qt 6.1.
        """
        ...

    @typing.overload
    def insert(self, values: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#insert

        **void QQmlPropertyMap::insert(const QString & key , const QVariant &
        value )**

        Sets the value associated with **key** to **value**.

        If the key doesn't exist, it is automatically created.
        """
        ...

    @typing.overload
    def insert(self, key: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#insert-1

        **[since 6.1] void QQmlPropertyMap::insert(const QVariantHash & values
        )**

        Inserts the **values** into the **QQmlPropertyMap** .

        Keys that don't exist are automatically created.

        This method is substantially faster than calling `insert(key, value)`
        many times in a row.

        This function was introduced in Qt 6.1.
        """
        ...

    def value(self, key: str) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#value

        **QVariant QQmlPropertyMap::value(const QString & key ) const**

        Returns the value associated with **key**.

        If no value has been set for this key (or if the value has been
        cleared), an invalid **QVariant**  is returned.
        """
        ...

    @property
    def valueChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qqmlpropertymap.html#valueChanged

        **[signal] void QQmlPropertyMap::valueChanged(const QString & key ,
        const QVariant & value )**

        This signal is emitted whenever one of the values in the map is changed.
        **key** is the key corresponding to the **value** that was changed.

        **Note:** valueChanged() is **NOT** emitted when changes are made by
        calling **insert** () or **clear** () - it is only emitted when a value
        is updated from QML.
        """
        ...
