"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip


class QQmlScriptString(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qqmlscriptstring.html

    **Detailed Description**

    QQmlScriptString is used to create **QObject**  properties that accept a
    script "assignment" from QML.

    Normally, the following QML would result in a binding being established for
    the `script` property; i.e. `script` would be assigned the value obtained
    from running `myObj.value = Math.max(myValue, 100)`

    MyType {
            script: myObj.value = Math.max(myValue, 100)
        }

    If instead the property had a type of QQmlScriptString, the script itself --
    **myObj.value = Math.max(myValue, 100)** \\-- would be passed to the `script`
    property and the class could choose how to handle it. Typically, the class
    will evaluate the script at some later time using a **QQmlExpression** .

    **QQmlExpression**  expr(scriptString);
        expr.evaluate();

    **See also** **QQmlExpression** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#QQmlScriptString

        **QQmlScriptString::QQmlScriptString()**

        Constructs an empty instance.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QQmlScriptString") -> None:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#QQmlScriptString-1

        **QQmlScriptString::QQmlScriptString(const QQmlScriptString & other )**

        Copies **other**.
        """
        ...

    def booleanLiteral(self) -> typing.Tuple[bool, bool]:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#booleanLiteral

        **bool QQmlScriptString::booleanLiteral(bool * ok ) const**

        If the content of the **QQmlScriptString**  is a boolean literal,
        returns the boolean value and sets **ok** to true. Otherwise returns
        false and sets **ok** to false.
        """
        ...

    def numberLiteral(self) -> typing.Tuple[float, bool]:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#numberLiteral

        **qreal QQmlScriptString::numberLiteral(bool * ok ) const**

        If the content of the **QQmlScriptString**  is a number literal, returns
        that number and sets **ok** to true. Otherwise returns 0.0 and sets
        **ok** to false.
        """
        ...

    def stringLiteral(self) -> str:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#stringLiteral

        **QString QQmlScriptString::stringLiteral() const**

        If the content of the **QQmlScriptString**  is a string literal, returns
        that string. Otherwise returns a null **QString** .
        """
        ...

    def isNullLiteral(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#isNullLiteral

        **bool QQmlScriptString::isNullLiteral() const**

        Returns whether the content of the **QQmlScriptString**  is the `null`
        literal.
        """
        ...

    def isUndefinedLiteral(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#isUndefinedLiteral

        **bool QQmlScriptString::isUndefinedLiteral() const**

        Returns whether the content of the **QQmlScriptString**  is the
        `undefined` literal.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlscriptstring.html#isEmpty

        **bool QQmlScriptString::isEmpty() const**

        Returns whether the **QQmlScriptString**  is empty.
        """
        ...
