"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore


class QQuickItemGrabResult(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qquickitemgrabresult.html

    **Detailed Description**

    **See also** **QQuickItem::grabToImage** ().
    """

    def event(self, a0: QtCore.QEvent) -> bool:
        ...

    @typing.overload
    def saveToFile(self, fileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qquickitemgrabresult.html#saveToFile

        **[invokable] bool QQuickItemGrabResult::saveToFile(const QString &
        fileName ) const**

        Saves the grab result as an image to **fileName**. Returns `true` if
        successful; otherwise returns `false`.

        **Note:** In Qt versions prior to 5.9, this function is marked as
        non-`const`.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @typing.overload
    def saveToFile(self, fileName: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-6/qquickitemgrabresult.html#saveToFile-1

        **[invokable, since 6.2] bool QQuickItemGrabResult::saveToFile(const
        QUrl & filePath ) const**

        Saves the grab result as an image to **filePath** , which must refer to
        a **local file name**  with a **supported image format**  extension.
        Returns `true` if successful; otherwise returns `false`.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 6.2.
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qquickitemgrabresult.html#url-prop

        **[read-only] url : const QUrl**

        This property holds a URL which can be used in conjunction with URL
        based image consumers, such as the QtQuick::Image type.

        The URL is valid until the **QQuickItemGrabResult**  object is deleted.

        The URL does not represent a valid file or location to read it from, it
        is primarily a key to access images through Qt Quick's image-based
        types.

        **Access functions:**

        QUrl **url** () const

        **Member Function Documentation**
        """
        ...

    def image(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qquickitemgrabresult.html#image-prop

        **[read-only] image : const QImage**

        This property holds the pixel results from a grab.

        If the grab is not yet complete or if it failed, a null image is
        returned (`image.isNull()` will return `true`).

        **Access functions:**

        QImage **image** () const
        """
        ...

    @property
    def ready(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickitemgrabresult.html#ready

        **[signal] void QQuickItemGrabResult::ready()**

        This signal is emitted when the grab has completed.
        """
        ...
