"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtQuick import *


class QQuickRenderControl(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qquickrendercontrol.html

    **Detailed Description**

    **QQuickWindow**  and **QQuickView**  and their associated internal render
    loops render the Qt Quick scene onto a native window. In some cases, for
    example when integrating with 3rd party OpenGL, Vulkan, Metal, or Direct 3D
    renderers, it can be useful to get the scene into a texture that can then be
    used in arbitrary ways by the external rendering engine. Such a mechanism is
    also essential when integrating with a VR framework. QQuickRenderControl
    makes this possible in a hardware accelerated manner, unlike the
    performance-wise limited alternative of using **QQuickWindow::grabWindow**
    ()

    When using a QQuickRenderControl, the **QQuickWindow**  must not be
    **shown**  (it will not be visible on-screen) and there will not be an
    underlying native window for it. Instead, the **QQuickWindow**  instance is
    associated with the render control object, using the overload of the
    **QQuickWindow**  constructor, and a texture or image object specified via
    **QQuickWindow::setRenderTarget** (). The **QQuickWindow**  object is still
    essential, because it represents the Qt Quick scene and provides the bulk of
    the scene management and event delivery mechanisms. It does not however act
    as a real on-screen window from the windowing system's perspective.

    Management of the graphics devices, contexts, image and texture objects is
    up to the application. The device or context that will be used by Qt Quick
    must be created before calling **initialize** (). The creation of the the
    texture object can be deferred, see below. Qt 5.4 introduces the ability for
    **QOpenGLContext**  to adopt existing native contexts. Together with
    QQuickRenderControl this makes it possible to create a **QOpenGLContext**
    that shares with an external rendering engine's existing context. This new
    **QOpenGLContext**  can then be used to render the Qt Quick scene into a
    texture that is accessible by the other engine's context too. For Vulkan,
    Metal, and Direct 3D there are no Qt-provided wrappers for device objects,
    so existing ones can be passed as-is via **QQuickWindow::setGraphicsDevice**
    ().

    Loading and instantiation of the QML components happen by using a
    **QQmlEngine** . Once the root object is created, it will need to be
    parented to the **QQuickWindow** 's contentItem().

    Applications will usually have to connect to 4 important signals:

    * **QQuickWindow::sceneGraphInitialized** () Emitted at some point after
    calling **QQuickRenderControl::initialize** (). Upon this signal, the
    application is expected to create its framebuffer object and associate it
    with the **QQuickWindow** .
      * **QQuickWindow::sceneGraphInvalidated** ()
    When the scenegraph resources are released, the framebuffer object can be
    destroyed too.
      * **QQuickRenderControl::renderRequested** () Indicates
    that the scene has to be rendered by calling **render** (). After making the
    context current, applications are expected to call **render** ().
      *
    **QQuickRenderControl::sceneChanged** () Indicates that the scene has
    changed meaning that, before rendering, polishing and synchronizing is also
    necessary.

    To send events, for example mouse or keyboard events, to the scene, use
    **QCoreApplication::sendEvent** () with the **QQuickWindow**  instance as
    the receiver.

    For key events it may be also necessary to set the focus manually on the
    desired item. In practice this involves calling **forceActiveFocus** () on
    the desired item, for example the scene's root item, once it is associated
    with the scene (the **QQuickWindow** ).

    **Note:** In general QQuickRenderControl is supported in combination with
    all Qt Quick backends. However, some functionality, in particular grab(),
    may not be available in all cases.
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#QQuickRenderControl

        **QQuickRenderControl::QQuickRenderControl(QObject * parent = nullptr)**

        Constructs a QQuickRenderControl object, with parent object **parent**.
        """
        ...

    def window(self) -> "QQuickWindow":
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#window

        **[since 6.0] QQuickWindow *QQuickRenderControl::window() const**

        Returns the **QQuickWindow**  this **QQuickRenderControl**  is
        associated with.

        **Note:** A **QQuickRenderControl**  gets associated with a
        **QQuickWindow**  when constructing the **QQuickWindow** . The return
        value from this function is null before that point.

        This function was introduced in Qt 6.0.
        """
        ...

    def endFrame(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#endFrame

        **[since 6.0] void QQuickRenderControl::endFrame()**

        Specifies the end of a graphics frame. Calls to **sync** () or
        **render** () must be enclosed by calls to **beginFrame** () and
        endFrame().

        When this function is called, any graphics commands enqueued by the
        scenegraph are submitted to the context or command queue, whichever is
        applicable.

        This function was introduced in Qt 6.0.

        **See also** **beginFrame** (), **initialize** (), **sync** (),
        **render** (), **QQuickGraphicsDevice** , and **QQuickRenderTarget** .
        """
        ...

    def beginFrame(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#beginFrame

        **[since 6.0] void QQuickRenderControl::beginFrame()**

        Specifies the start of a graphics frame. Calls to **sync** () or
        **render** () must be enclosed by calls to beginFrame() and **endFrame**
        ().

        Unlike the earlier OpenGL-only world of Qt 5, rendering with other
        graphics APIs requires more well-defined points of starting and ending a
        frame. When manually driving the rendering loop via
        **QQuickRenderControl** , it now falls to the user of
        **QQuickRenderControl**  to specify these points.

        A typical update step, including initialization of rendering into an
        existing texture, could like like the following. The example snippet
        assumes Direct3D 11 but the same concepts apply other graphics APIs as
        well.

        if (!m_quickInitialized) {
                m_quickWindow->setGraphicsDevice(QQui
        ckGraphicsDevice::fromDeviceAndContext(m_engine->device(),
        m_engine->context()));

                if (!m_renderControl->initialize())
        qWarning("Failed to initialize redirected Qt Quick rendering");
        m_quickWindow->setRenderTarget(QQuickRenderTarget::fromNativeTexture({
        quint64(m_res.texture), 0 },
        QSize(QML_WIDTH, QML_HEIGHT),
        SAMPLE_COUNT));

                m_quickInitialized = true;
            }
        m_renderControl->polishItems();

            m_renderControl->beginFrame();
        m_renderControl->sync();
            m_renderControl->render();
        m_renderControl->endFrame(); // Qt Quick's rendering commands are
        submitted to the device context here

        This function was introduced in Qt 6.0.

        **See also** **endFrame** (), **initialize** (), **sync** (), **render**
        (), **QQuickGraphicsDevice** , and **QQuickRenderTarget** .
        """
        ...

    def samples(self) -> int:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#samples

        **[since 6.0] int QQuickRenderControl::samples() const**

        Returns the current sample count. 1 or 0 means no multisampling.

        This function was introduced in Qt 6.0.

        **See also** **setSamples** ().
        """
        ...

    def setSamples(self, sampleCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#setSamples

        **[since 6.0] void QQuickRenderControl::setSamples(int sampleCount )**

        Sets the number of samples to use for multisampling. When
        **sampleCount** is 0 or 1, multisampling is disabled.

        **Note:** This function is always used in combination with a multisample
        render target, which means **sampleCount** must match the sample count
        passed to QQuickRenderTarget::fromNativeTexture(), which in turn must
        match the sample count of the native texture.

        This function was introduced in Qt 6.0.

        **See also** **samples** (), **initialize** (), and
        **QQuickRenderTarget** .
        """
        ...

    def prepareThread(self, targetThread: QtCore.QThread) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#prepareThread

        **void QQuickRenderControl::prepareThread(QThread * targetThread )**

        Prepares rendering the Qt Quick scene outside the GUI thread.

        **targetThread** specifies the thread on which synchronization and
        rendering will happen. There is no need to call this function in a
        single threaded scenario.
        """
        ...

    def renderWindow(self, offset: QtCore.QPoint) -> QtGui.QWindow:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#renderWindow

        **[virtual] QWindow *QQuickRenderControl::renderWindow(QPoint * offset
        )**

        Reimplemented in subclasses to return the real window this render
        control is rendering into.

        If **offset** in non-null, it is set to the offset of the control inside
        the window.

        **Note:** While not mandatory, reimplementing this function becomes
        essential for supporting multiple screens with different device pixel
        ratios and properly positioning popup windows opened from QML. Therefore
        providing it in subclasses is highly recommended.
        """
        ...

    @staticmethod
    def renderWindowFor(
        win: "QQuickWindow", offset: typing.Optional[QtCore.QPoint] = ...
    ) -> QtGui.QWindow:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#renderWindowFor

        **[static] QWindow *QQuickRenderControl::renderWindowFor(QQuickWindow *
        win , QPoint * offset = nullptr)**

        Returns the real window that **win** is being rendered to, if any.

        If **offset** in non-null, it is set to the offset of the rendering
        inside its window.
        """
        ...

    def sync(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#sync

        **bool QQuickRenderControl::sync()**

        This function is used to synchronize the QML scene with the rendering
        scene graph.

        If a dedicated render thread is used, the GUI thread should be blocked
        for the duration of this call.

        Returns **true** if the synchronization changed the scene graph.
        """
        ...

    def render(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#render

        **void QQuickRenderControl::render()**

        Renders the scenegraph using the current context.
        """
        ...

    def polishItems(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#polishItems

        **void QQuickRenderControl::polishItems()**

        This function should be called as late as possible before **sync** ().
        In a threaded scenario, rendering can happen in parallel with this
        function.
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#invalidate

        **void QQuickRenderControl::invalidate()**

        Stop rendering and release resources.

        This is the equivalent of the cleanup operations that happen with a real
        **QQuickWindow**  when the window becomes hidden.

        This function is called from the destructor. Therefore there will
        typically be no need to call it directly.

        Once invalidate() has been called, it is possible to reuse the
        **QQuickRenderControl**  instance by calling **initialize** () again.

        **Note:** This function does not take
        QQuickWindow::persistentSceneGraph() or
        QQuickWindow::persistentGraphics() into account. This means that
        context-specific resources are always released.
        """
        ...

    def initialize(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#initialize

        **[since 6.0] bool QQuickRenderControl::initialize()**

        Initializes the scene graph resources. When using a graphics API, such
        as Vulkan, Metal, OpenGL, or Direct3D, for Qt Quick rendering,
        **QQuickRenderControl**  will set up an appropriate rendering engine
        when this function is called. This rendering infrastructure exists as
        long as the **QQuickRenderControl**  exists.

        To control what graphics API Qt Quick uses, call
        **QQuickWindow::setGraphicsApi** () with one of the
        **QSGRendererInterface** :GraphicsApi constants. That must be done
        before calling this function.

        To prevent the scenegraph from creating its own device and context
        objects, specify an appropriate **QQuickGraphicsDevice** , wrapping
        existing graphics objects, by calling
        **QQuickWindow::setGraphicsDevice** ().

        To configure which device extensions to enable (for example, for
        Vulkan), call **QQuickWindow::setGraphicsConfiguration** () before this
        function.

        **Note:** When using Vulkan, **QQuickRenderControl**  does not create a
        **QVulkanInstance**  automatically. Rather, it is the application's
        responsibility to create a suitable **QVulkanInstance**  and **associate
        it**  with the **QQuickWindow** . Before initializing the
        **QVulkanInstance** , it is strongly encouraged to query the list of Qt
        Quick's desired instance extensions by calling the static function
        **QQuickGraphicsConfiguration::preferredInstanceExtensions** () and to
        pass the returned list to **QVulkanInstance::setExtensions** ().

        Returns `true` on success, `false` otherwise.

        **Note:** This function does not need to be, and must not be, called
        when using the `software` adaptation of Qt Quick.

        This function was introduced in Qt 6.0.

        **See also** **QQuickRenderTarget** , **QQuickGraphicsDevice** , and
        **QQuickGraphicsConfiguration::preferredInstanceExtensions** ().
        """
        ...

    @property
    def renderRequested(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#renderRequested

        **[signal] void QQuickRenderControl::renderRequested()**

        This signal is emitted when the scene graph needs to be rendered. It is
        not necessary to call **sync** ().

        **Note:** Avoid triggering rendering directly when this signal is
        emitted. Instead, prefer deferring it by using a timer for example. This
        will lead to better performance.
        """
        ...

    @property
    def sceneChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickrendercontrol.html#sceneChanged

        **[signal] void QQuickRenderControl::sceneChanged()**

        This signal is emitted when the scene graph is updated, meaning that
        **polishItems** () and **sync** () needs to be called. If **sync** ()
        returns true, then **render** () needs to be called.

        **Note:** Avoid triggering polishing, synchronization and rendering
        directly when this signal is emitted. Instead, prefer deferring it by
        using a timer for example. This will lead to better performance.
        """
        ...
