"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtQml
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtQuick import *
import enum


class QQuickWindow(QtGui.QWindow):
    """
    https://doc.qt.io/qt-6/qquickwindow.html

    **Detailed Description**

    QQuickWindow provides the graphical scene management needed to interact with
    and display a scene of QQuickItems.

    A QQuickWindow always has a single invisible root item. To add items to this
    window, reparent the items to the root item or to an existing item in the
    scene.

    For easily displaying a scene from a QML file, see **QQuickView** .

    **Rendering**

    QQuickWindow uses a scene graph to represent what needs to be rendered. This
    scene graph is disconnected from the QML scene and potentially lives in
    another thread, depending on the platform implementation. Since the
    rendering scene graph lives independently from the QML scene, it can also be
    completely released without affecting the state of the QML scene.

    The **sceneGraphInitialized** () signal is emitted on the rendering thread
    before the QML scene is rendered to the screen for the first time. If the
    rendering scene graph has been released, the signal will be emitted again
    before the next frame is rendered. A visible, on-screen QQuickWindow is
    driven internally by a `render loop`, of which there are multiple
    implementations provided in the scene graph. For details on the scene graph
    rendering process, see **Qt Quick Scene Graph** .

    By default, a QQuickWindow renders using an accelerated 3D graphics API,
    such as OpenGL or Vulkan. See **Scene Graph Adaptations**  for a detailed
    overview of scene graph backends and the supported graphics APIs.

    **Warning:** It is crucial that graphics operations and interaction with the
    scene graph happens exclusively on the rendering thread, primarily during
    the updatePaintNode() phase.

    **Warning:** As many of the signals related to rendering are emitted from
    the rendering thread, connections should be made using
    **Qt::DirectConnection** .

    **Integration with Accelerated 3D Graphics APIs**

    It is possible to integrate OpenGL, Vulkan, Metal, or Direct3D 11 calls
    directly into the QQuickWindow, as long as the QQuickWindow and the
    underlying scene graph is rendering using the same API. To access native
    graphics objects, such as device or context object handles, use
    **QSGRendererInterface** . An instance of **QSGRendererInterface**  is
    queriable from QQuickWindow by calling **rendererInterface** (). The
    enablers for this integration are the **beforeRendering** (),
    **beforeRenderPassRecording** (), **afterRenderPassRecording** (), and
    related signals. These allow rendering underlays or overlays. Alternatively,
    **QNativeInterface::QSGOpenGLTexture** ,
    **QNativeInterface::QSGVulkanTexture** , and other similar classes allow
    wrapping an existing native texture or image object in a **QSGTexture**
    that can then be used with the scene graph.

    **Rendering without Acceleration**

    A limited, pure software based rendering path is available as well. With the
    `software` backend, a number of Qt Quick features are not available, QML
    items relying on these will not be rendered at all. At the same time, this
    allows QQuickWindow to be functional even on systems where there is no 3D
    graphics API available at all. See **Qt Quick Software Adaptation**  for
    more details.

    **Redirected Rendering**

    A QQuickWindow is not necessarily backed by a native window on screen. The
    rendering can be redirected to target a custom render target, such as a
    given native texture. This is achieved in combination with the
    **QQuickRenderControl**  class, and functions such as **setRenderTarget**
    (), **setGraphicsDevice** (), and **setGraphicsConfiguration** ().

    In this case, the QQuickWindow represents the scene, and provides the
    intrastructure for rendering a frame. It will not be backed by a render loop
    and a native window. Instead, in this case the application drives rendering,
    effectively substituting for the render loops. This allows generating image
    sequences, rendering into textures for use in external 3D engines, or
    rendering Qt Quick content within a VR environment.

    **Resource Management**

    QML will try to cache images and scene graph nodes to improve performance,
    but in some low-memory scenarios it might be required to aggressively
    release these resources. The **releaseResources** () function can be used to
    force the clean up of certain resources, especially resource that are cached
    and can be recreated later when needed again.

    Additionally, calling **releaseResources** () may result in releasing the
    entire scene graph and the associated graphics resources. The
    **sceneGraphInvalidated** () signal will be emitted when this happens. This
    behavior is controlled by the **setPersistentGraphics** () and
    **setPersistentSceneGraph** () functions.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **Exposure and Visibility**

    When a QQuickWindow instance is deliberately hidden with **hide** () or
    setVisible(false), it will stop rendering and its scene graph and graphics
    context might be released as well. This depends on the settings configured
    by **setPersistentGraphics** () and **setPersistentSceneGraph** (). The
    behavior in this respect is identical to explicitly calling the
    **releaseResources** () function. A window can become not exposed, in other
    words non-renderable, by other means as well. This depends on the platform
    and windowing system. For example, on Windows minimizing a window makes it
    stop rendering. On macOS fully obscuring a window by other windows on top
    triggers the same. On Linux/X11, the behavior is dependent on the window
    manager.

    **OpenGL Context and Surface Formats**

    While it is possible to specify a **QSurfaceFormat**  for every QQuickWindow
    by calling the member function **setFormat** (), windows may also be created
    from QML by using the Window and **ApplicationWindow**  elements. In this
    case there is no C++ code involved in the creation of the window instance,
    yet applications may still wish to set certain surface format values, for
    example to request a given OpenGL version or profile. Such applications can
    call the static function **QSurfaceFormat::setDefaultFormat** () at startup.
    The specified format will be used for all Quick windows created afterwards.

    **Vulkan Instance**

    When using Vulkan, a QQuickWindow is automatically associated with a
    **QVulkanInstance**  that is created and managed internally by the scene
    graph. This way most applications do not need to worry about having a
    `VkInstance` available since it all happens automatically. In advanced cases
    an application may wish to create its own **QVulkanInstance** , in order to
    configure it in a specific way. That is possible as well. Calling
    **setVulkanInstance** () on the QQuickWindow right after construction,
    before making it visible, leads to using the application-supplied
    **QVulkanInstance**  (and the underlying `VkInstance`). When redirecting via
    **QQuickRenderControl** , there is no **QVulkanInstance**  provided
    automatically, but rather the application is expected to provide its own and
    associate it with the QQuickWindow.

    **Graphics Contexts and Devices**

    When the scene graph is initialized, which typically happens when the window
    becomes exposed or, in case of redirected rendering, initialization is
    performed **via QQuickRenderControl** , the context or device objects
    necessary for rendering are created automatically. This includes OpenGL
    contexts, Direct3D devices and device contexts, Vulkan and Metal devices.
    These are also queriable by application code afterwards via
    **QSGRendererInterface** . When using the `basic` render loop, which
    performs all rendering on the GUI thread, the same context or device is used
    with all visible QQuickWindows. The `threaded` render loop uses a dedicated
    context or device object for each rendering thread, and so for each
    QQuickWindow. With some graphics APIs, there is a degree of customizability
    provided via **setGraphicsConfiguration** (). This makes it possible, for
    example, to specify the list of Vulkan extensions to enable on the
    `VkDevice`. Alternatively, it is also possible to provide a set of existing
    context or device objects for use by the QQuickWindow, instead of letting it
    construct its own. This is achieved through **setGraphicsDevice** ().

    **See also** **QQuickView** , **QQuickRenderControl** ,
    **QQuickRenderTarget** , **QQuickGraphicsDevice** ,
    **QQuickGraphicsConfiguration** , and **QSGRendererInterface** .
    """

    class TextRenderType(enum.Enum):
        QtTextRendering: QQuickWindow = ...
        NativeTextRendering: QQuickWindow = ...

    class RenderStage(enum.Enum):
        BeforeSynchronizingStage: QQuickWindow = ...
        AfterSynchronizingStage: QQuickWindow = ...
        BeforeRenderingStage: QQuickWindow = ...
        AfterRenderingStage: QQuickWindow = ...
        AfterSwapStage: QQuickWindow = ...
        NoStage: QQuickWindow = ...

    class SceneGraphError(enum.Enum):
        ContextNotAvailable: QQuickWindow = ...

    class CreateTextureOption(enum.Flag):
        TextureHasAlphaChannel: QQuickWindow = ...
        TextureHasMipmaps: QQuickWindow = ...
        TextureOwnsGLTexture: QQuickWindow = ...
        TextureCanUseAtlas: QQuickWindow = ...
        TextureIsOpaque: QQuickWindow = ...

    def __init__(self, parent: typing.Optional[QtGui.QWindow] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#QQuickWindow

        **QQuickWindow::QQuickWindow(QWindow * parent = nullptr)**

        Constructs a window for displaying a QML scene with parent window
        **parent**.
        """
        ...

    def graphicsConfiguration(self) -> QQuickGraphicsConfiguration:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#graphicsConfiguration

        **[since 6.0] QQuickGraphicsConfiguration
        QQuickWindow::graphicsConfiguration() const**

        Returns the **QQuickGraphicsDevice**  passed to **setGraphicsDevice**
        (), or a default constructed one otherwise

        This function was introduced in Qt 6.0.

        **See also** **setGraphicsConfiguration** ().
        """
        ...

    def setGraphicsConfiguration(self, config: QQuickGraphicsConfiguration) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setGraphicsConfiguration

        **[since 6.0] void QQuickWindow::setGraphicsConfiguration(const
        QQuickGraphicsConfiguration & config )**

        Sets the graphics configuration for this window. **config** contains
        various settings that may be taken into account by the scene graph when
        initializing the underlying graphics devices and contexts.

        Such additional configuration, specifying for example what device
        extensions to enable for Vulkan, becomes relevant and essential when
        integrating native graphics rendering code that relies on certain
        extensions. The same is true when integrating with an external 3D or VR
        engines, such as OpenXR.

        **Note:** The configuration is ignored when adopting existing graphics
        devices via **setGraphicsDevice** () since the scene graph is then not
        in control of the actual construction of those objects.

        **QQuickGraphicsConfiguration**  instances are implicitly shared,
        copyable, and can be passed by value.

        **Warning:** Setting a **QQuickGraphicsConfiguration**  on a
        **QQuickWindow**  must happen early enough, before the scene graph is
        initialized for the first time for that window. With on-screen windows
        this means the call must be done before invoking **show** () on the
        **QQuickWindow**  or **QQuickView** . With **QQuickRenderControl**  the
        configuration must be finalized before calling **initialize** ().

        This function was introduced in Qt 6.0.

        **See also** **graphicsConfiguration** ().
        """
        ...

    def graphicsDevice(self) -> QQuickGraphicsDevice:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#graphicsDevice

        **[since 6.0] QQuickGraphicsDevice QQuickWindow::graphicsDevice()
        const**

        Returns the **QQuickGraphicsDevice**  passed to **setGraphicsDevice**
        (), or a default constructed one otherwise

        This function was introduced in Qt 6.0.

        **See also** **setGraphicsDevice** ().
        """
        ...

    def setGraphicsDevice(self, device: QQuickGraphicsDevice) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setGraphicsDevice

        **[since 6.0] void QQuickWindow::setGraphicsDevice(const
        QQuickGraphicsDevice & device )**

        Sets the graphics device objects for this window. The scenegraph will
        use existing device, physical device, and other objects specified by
        **device** instead of creating new ones.

        This function is very often used in combination with
        **QQuickRenderControl**  and **setRenderTarget** (), in order to
        redirect Qt Quick rendering into a texture.

        A default constructed **QQuickGraphicsDevice**  does not change the
        default behavior in any way. Once a **device** created via one of the
        **QQuickGraphicsDevice**  factory functions, such as,
        **QQuickGraphicsDevice::fromDeviceObjects** (), is passed in, and the
        scenegraph uses a matching graphics API (with the example of
        fromDeviceObjects(), that would be Vulkan), the scenegraph will use the
        existing device objects (such as, the `VkPhysicalDevice`, `VkDevice`,
        and graphics queue family index, in case of Vulkan) encapsulated by the
        **QQuickGraphicsDevice** . This allows using the same device, and so
        sharing resources, such as buffers and textures, between Qt Quick and
        native rendering engines.

        **Warning:** This function can only be called before initializing the
        scenegraph and will have no effect if called afterwards. In practice
        this typically means calling it right before
        **QQuickRenderControl::initialize** ().

        As an example, this time with Direct3D, the typical usage is expected to
        be the following:

        // native graphics resources set up by a custom D3D rendering engine
        ID3D11Device *device;
            ID3D11DeviceContext *context;
        ID3D11Texture2D *texture;
            ...
            // now to redirect Qt Quick
        content into 'texture' we could do the following:
        QQuickRenderControl *renderControl = new QQuickRenderControl;
        QQuickWindow *window = new QQuickWindow(renderControl); // this window
        will never be shown on-screen
            ...
            window->setGraphicsDevice(QQui
        ckGraphicsDevice::fromDeviceAndContext(device, context));
        renderControl->initialize();
        window->setRenderTarget(QQuickRenderTarget::fromD3D11Texture(texture,
        textureSize);
            ...

        The key aspect of using this function is to ensure that resources or
        handles to resources, such as `texture` in the above example, are
        visible to and usable by both the external rendering engine and the
        scenegraph renderer. This requires using the same graphics device (or
        with OpenGL, OpenGL context).

        **QQuickGraphicsDevice**  instances are implicitly shared, copyable, and
        can be passed by value. They do not own the associated native objects
        (such as, the ID3D11Device in the example).

        **Note:** Using **QQuickRenderControl**  does not always imply having to
        call this function. When adopting an existing device or context is not
        needed, this function should not be called, and the scene graph will
        then initialize its own devices and contexts normally, just as it would
        with an on-screen **QQuickWindow** .

        This function was introduced in Qt 6.0.

        **See also** **graphicsDevice** (), **QQuickRenderControl** ,
        **setRenderTarget** (), and **setGraphicsApi** ().
        """
        ...

    @staticmethod
    def graphicsApi() -> "QSGRendererInterface.GraphicsApi":
        """
        https://doc.qt.io/qt-6/qquickwindow.html#graphicsApi

        **[static, since 6.0] QSGRendererInterface::GraphicsApi
        QQuickWindow::graphicsApi()**

        Returns the graphics API that would be used by the scene graph if it was
        initialized at this point in time.

        The standard way to query the API used by the scene graph is to use
        **QSGRendererInterface::graphicsApi** () once the scene graph has
        initialized, for example when or after the **sceneGraphInitialized** ()
        signal is emitted. In that case one gets the true, real result, because
        then it is known that everything was initialized correctly using that
        graphics API.

        This is not always convenient. If the application needs to set up
        external frameworks, or needs to work with **setGraphicsDevice** () in a
        manner that depends on the scene graph's built in API selection logic,
        it is not always feasiable to defer such operations until after the
        **QQuickWindow**  has been made visible or
        **QQuickRenderControl::initialize** () has been called.

        Therefore, this static function is provided as a counterpart to
        **setGraphicsApi** (): it can be called at any time, and the result
        reflects what API the scene graph would choose if it was initialized at
        the point of the call.

        **Note:** This static function is intended to be called on the main
        (GUI) thread only. For querying the API when rendering, use
        **QSGRendererInterface**  since that object lives on the render thread.

        **Note:** This function does not take scene graph backends into account.

        This function was introduced in Qt 6.0.

        **See also** **setGraphicsApi** ().
        """
        ...

    @staticmethod
    def setGraphicsApi(api: "QSGRendererInterface.GraphicsApi") -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setGraphicsApi

        **[static, since 5.8] void
        QQuickWindow::setGraphicsApi(QSGRendererInterface::GraphicsApi api )**

        Requests the specified graphics **api**.

        When the built-in, default graphics adaptation is used, **api**
        specifies which graphics API (OpenGL, Vulkan, Metal, or Direct3D) the
        scene graph should use to render. In addition, the `software` backend is
        built-in as well, and can be requested by setting **api** to
        **QSGRendererInterface::Software** .

        Unlike **setSceneGraphBackend** (), which can only be used to request a
        given backend (shipped either built-in or installed as dynamically
        loaded plugins), this function works with the higher level concept of
        graphics APIs. It covers the backends that ship with Qt Quick, and thus
        have corresponding values in the **QSGRendererInterface::GraphicsApi**
        enum.

        When this function is not called at all, and the equivalent environment
        variable `QSG_RHI_BACKEND` is not set either, the scene graph will
        choose the graphics API to use based on the platform.

        This function becomes important in applications that are only prepared
        for rendering with a given API. For example, if there is native OpenGL
        or Vulkan rendering done by the application, it will want to ensure Qt
        Quick is rendering using OpenGL or Vulkan too. Such applications are
        expected to call this function early in their main() function.

        **Note:** The call to the function must happen before constructing the
        first **QQuickWindow**  in the application. The graphics API cannot be
        changed afterwards.

        **Note:** When used in combination with **QQuickRenderControl** , this
        rule is relaxed: it is possible to change the graphics API, but only
        when all existing **QQuickRenderControl**  and **QQuickWindow**
        instances have been destroyed.

        To query what graphics API the scene graph is using to render,
        **QSGRendererInterface::graphicsApi** () after the scene graph **has
        initialized** , which typically happens either when the window becomes
        visible for the first time, or when **QQuickRenderControl::initialize**
        () is called.

        To switch back to the default behavior, where the scene graph chooses a
        graphics API based on the platform and other conditions, set **api** to
        **QSGRendererInterface::Unknown** .

        This function was introduced in Qt 5.8.

        **See also** **graphicsApi** ().
        """
        ...

    def isPersistentGraphics(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#isPersistentGraphics

        **bool QQuickWindow::isPersistentGraphics() const**

        Returns whether essential graphics resources can be released during the
        lifetime of the **QQuickWindow** .

        **Note:** This is a hint, and is not guaranteed that it is taken into
        account.

        **See also** **setPersistentGraphics** ().
        """
        ...

    def setPersistentGraphics(self, persistent: bool) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setPersistentGraphics

        **void QQuickWindow::setPersistentGraphics(bool persistent )**

        Sets whether the graphics resources (graphics device or context,
        swapchain, buffers, textures) should be preserved, and cannot be
        released until the last window is deleted, to **persistent**. The
        default value is true.

        When calling **releaseResources** (), or when the window gets hidden
        (more specifically, not renderable), some render loops have the
        possibility to release all, not just the cached, graphics resources.
        This can free up memory temporarily, but it also means the rendering
        engine will have to do a full, potentially costly reinitialization of
        the resources when the window needs to render again.

        **Note:** The rules for when a window is not renderable are platform and
        window manager specific.

        **Note:** All graphics resources are released when the last
        **QQuickWindow**  is deleted, regardless of this setting.

        **Note:** This is a hint, and is not guaranteed that it is taken into
        account.

        **Note:** This hint does not apply to cached resources, that are
        relatively cheap to drop and then recreate later. Therefore, calling
        **releaseResources** () will typically lead to releasing those
        regardless of the value of this hint.

        **See also** **isPersistentGraphics** (), **setPersistentSceneGraph**
        (), **sceneGraphInitialized** (), **sceneGraphInvalidated** (), and
        **releaseResources** ().
        """
        ...

    def endExternalCommands(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#endExternalCommands

        **[since 5.14] void QQuickWindow::endExternalCommands()**

        When mixing raw graphics (OpenGL, Vulkan, Metal, etc.) commands with
        scene graph rendering, it is necessary to call this function after
        recording commands to the command buffer used by the scene graph to
        render its main render pass. This is to avoid clobbering state.

        In practice this function is often called from a slot connected to the
        **beforeRenderPassRecording** () or **afterRenderPassRecording** ()
        signals.

        The function does not need to be called when recording commands to the
        application's own command buffer (such as, a VkCommandBuffer or
        MTLCommandBuffer + MTLRenderCommandEncoder created and managed by the
        application, not retrieved from the scene graph). With graphics APIs
        where no native command buffer concept is exposed (OpenGL, Direct 3D
        11), **beginExternalCommands** () and endExternalCommands() together
        provide a replacement for the Qt 5 resetOpenGLState() function.

        Calling this function and **beginExternalCommands** () is not necessary
        within the **render** () implementation of a **QSGRenderNode**  because
        the scene graph performs the necessary steps implicitly for render
        nodes.

        This function was introduced in Qt 5.14.

        **See also** **beginExternalCommands** () and
        **QQuickOpenGLUtils::resetOpenGLState** ().
        """
        ...

    def beginExternalCommands(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#beginExternalCommands

        **[since 5.14] void QQuickWindow::beginExternalCommands()**

        When mixing raw graphics (OpenGL, Vulkan, Metal, etc.) commands with
        scene graph rendering, it is necessary to call this function before
        recording commands to the command buffer used by the scene graph to
        render its main render pass. This is to avoid clobbering state.

        In practice this function is often called from a slot connected to the
        **beforeRenderPassRecording** () or **afterRenderPassRecording** ()
        signals.

        The function does not need to be called when recording commands to the
        application's own command buffer (such as, a VkCommandBuffer or
        MTLCommandBuffer + MTLRenderCommandEncoder created and managed by the
        application, not retrieved from the scene graph). With graphics APIs
        where no native command buffer concept is exposed (OpenGL, Direct 3D
        11), beginExternalCommands() and **endExternalCommands** () together
        provide a replacement for the Qt 5 resetOpenGLState() function.

        Calling this function and **endExternalCommands** () is not necessary
        within the **render** () implementation of a **QSGRenderNode**  because
        the scene graph performs the necessary steps implicitly for render
        nodes.

        Native graphics objects (such as, graphics device, command buffer or
        encoder) are accessible via **QSGRendererInterface::getResource** ().

        **Warning:** Watch out for the fact that
        **QSGRendererInterface::CommandListResource**  may return a different
        object between beginExternalCommands() - **endExternalCommands** ().
        This can happen when the underlying implementation provides a dedicated
        secondary command buffer for recording external graphics commands within
        a render pass. Therefore, always query CommandListResource after calling
        this function. Do not attempt to reuse an object from an earlier query.

        **Note:** When the scenegraph is using OpenGL, pay attention to the fact
        that the OpenGL state in the context can have arbitrary settings, and
        this function does not perform any resetting of the state back to
        defaults.

        This function was introduced in Qt 5.14.

        **See also** **endExternalCommands** () and
        **QQuickOpenGLUtils::resetOpenGLState** ().
        """
        ...

    @staticmethod
    def setTextRenderType(renderType: "QQuickWindow.TextRenderType") -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setTextRenderType

        **[static, since 5.10] void
        QQuickWindow::setTextRenderType(QQuickWindow::TextRenderType renderType
        )**

        Sets the default render type of text-like elements in Qt Quick to
        **renderType**.

        **Note:** setting the render type will only affect elements created
        afterwards; the render type of existing elements will not be modified.

        This function was introduced in Qt 5.10.

        **See also** **textRenderType** ().
        """
        ...

    @staticmethod
    def textRenderType() -> "QQuickWindow.TextRenderType":
        """
        https://doc.qt.io/qt-6/qquickwindow.html#textRenderType

        **[static, since 5.10] QQuickWindow::TextRenderType
        QQuickWindow::textRenderType()**

        Returns the render type of text-like elements in Qt Quick. The default
        is **QQuickWindow::QtTextRendering** .

        This function was introduced in Qt 5.10.

        **See also** **setTextRenderType** ().
        """
        ...

    @staticmethod
    def sceneGraphBackend() -> str:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#sceneGraphBackend

        **[static, since 5.9] QString QQuickWindow::sceneGraphBackend()**

        Returns the requested Qt Quick scenegraph backend.

        **Note:** The return value of this function may still be outdated by
        subsequent calls to **setSceneGraphBackend** () until the first
        **QQuickWindow**  in the application has been constructed.

        **Note:** The value only reflects the request in the `QT_QUICK_BACKEND`
        environment variable after a **QQuickWindow**  has been constructed.

        This function was introduced in Qt 5.9.

        **See also** **setSceneGraphBackend** ().
        """
        ...

    def createImageNode(self) -> "QSGImageNode":
        """
        https://doc.qt.io/qt-6/qquickwindow.html#createImageNode

        **[since 5.8] QSGImageNode *QQuickWindow::createImageNode() const**

        Creates a simple image node. When the scenegraph is not initialized, the
        return value is null.

        This is cross-backend alternative to constructing a
        **QSGSimpleTextureNode**  directly.

        This function was introduced in Qt 5.8.

        **See also** **QSGImageNode** .
        """
        ...

    def createRectangleNode(self) -> "QSGRectangleNode":
        """
        https://doc.qt.io/qt-6/qquickwindow.html#createRectangleNode

        **[since 5.8] QSGRectangleNode *QQuickWindow::createRectangleNode()
        const**

        Creates a simple rectangle node. When the scenegraph is not initialized,
        the return value is null.

        This is cross-backend alternative to constructing a
        **QSGSimpleRectNode**  directly.

        This function was introduced in Qt 5.8.

        **See also** **QSGRectangleNode** .
        """
        ...

    @staticmethod
    def setSceneGraphBackend(backend: str) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setSceneGraphBackend

        **[static, since 5.8] void QQuickWindow::setSceneGraphBackend(const
        QString & backend )**

        Requests a Qt Quick scenegraph **backend**. Backends can either be
        built-in or be installed in form of dynamically loaded plugins.

        This is an overloaded function.

        **Note:** The call to the function must happen before constructing the
        first **QQuickWindow**  in the application. It cannot be changed
        afterwards.

        See **Switch Between Adaptations in Your Application**  for more
        information about the list of backends. If **backend** is invalid or an
        error occurs, the request is ignored.

        **Note:** Calling this function is equivalent to setting the
        `QT_QUICK_BACKEND` or `QMLSCENE_DEVICE` environment variables. However,
        this API is safer to use in applications that spawn other processes as
        there is no need to worry about environment inheritance.

        This function was introduced in Qt 5.8.

        **See also** **sceneGraphBackend** ().
        """
        ...

    def rendererInterface(self) -> "QSGRendererInterface":
        """
        https://doc.qt.io/qt-6/qquickwindow.html#rendererInterface

        **[since 5.8] QSGRendererInterface *QQuickWindow::rendererInterface()
        const**

        Returns the current renderer interface. The value is always valid and is
        never null.

        **Note:** This function can be called at any time after constructing the
        **QQuickWindow** , even while **isSceneGraphInitialized** () is still
        false. However, some renderer interface functions, in particular
        **QSGRendererInterface::getResource** () will not be functional until
        the scenegraph is up and running. Backend queries, like
        **QSGRendererInterface::graphicsApi** () or
        **QSGRendererInterface::shaderType** (), will always be functional on
        the other hand.

        **Note:** The ownership of the returned pointer stays with Qt. The
        returned instance may or may not be shared between different
        **QQuickWindow**  instances, depending on the scenegraph backend in use.
        Therefore applications are expected to query the interface object for
        each **QQuickWindow**  instead of reusing the already queried pointer.

        This function was introduced in Qt 5.8.

        **See also** **QSGRenderNode**  and **QSGRendererInterface** .
        """
        ...

    def isSceneGraphInitialized(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#isSceneGraphInitialized

        **bool QQuickWindow::isSceneGraphInitialized() const**

        Returns true if the scene graph has been initialized; otherwise returns
        false.
        """
        ...

    def effectiveDevicePixelRatio(self) -> float:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#effectiveDevicePixelRatio

        **qreal QQuickWindow::effectiveDevicePixelRatio() const**

        Returns the device pixel ratio for this window.

        This is different from **QWindow::devicePixelRatio** () in that it
        supports redirected rendering via **QQuickRenderControl** . When using a
        **QQuickRenderControl** , the **QQuickWindow**  is often not created,
        meaning it is never shown and there is no underlying native window
        created in the windowing system. As a result, querying properties like
        the device pixel ratio cannot give correct results. Use this function
        instead.

        **See also** **QWindow::devicePixelRatio** ().
        """
        ...

    def scheduleRenderJob(
        self, job: QtCore.QRunnable, schedule: "QQuickWindow.RenderStage"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#scheduleRenderJob

        **[since 5.4] void QQuickWindow::scheduleRenderJob(QRunnable * job ,
        QQuickWindow::RenderStage stage )**

        Schedules **job** to run when the rendering of this window reaches the
        given **stage**.

        This is a convenience to the equivalent signals in **QQuickWindow**  for
        "one shot" tasks.

        The window takes ownership over **job** and will delete it when the job
        is completed.

        If rendering is shut down before **job** has a chance to run, the job
        will be run and then deleted as part of the scene graph cleanup. If the
        window is never shown and no rendering happens before the
        **QQuickWindow**  is destroyed, all pending jobs will be destroyed
        without their run() method being called.

        If the rendering is happening on a different thread, then the job will
        happen on the rendering thread.

        If **stage** is **NoStage** , **job** will be run at the earliest
        opportunity whenever the render thread is not busy rendering a frame. If
        the window is not exposed, and is not renderable, at the time the job is
        either posted or handled, the job is deleted without executing the run()
        method. If a non-threaded renderer is in use, the run() method of the
        job is executed synchronously. When rendering with OpenGL, the OpenGL
        context is changed to the renderer's context before executing any job,
        including **NoStage**  jobs.

        **Note:** This function does not trigger rendering; the jobs targeting
        any other stage than **NoStage**  will be stored run until rendering is
        triggered elsewhere. To force the job to run earlier, call
        **QQuickWindow::update** ();

        This function was introduced in Qt 5.4.

        **See also** **beforeRendering** (), **afterRendering** (),
        **beforeSynchronizing** (), **afterSynchronizing** (), **frameSwapped**
        (), and **sceneGraphInvalidated** ().
        """
        ...

    @staticmethod
    def setDefaultAlphaBuffer(useAlpha: bool) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setDefaultAlphaBuffer

        **[static, since 5.1] void QQuickWindow::setDefaultAlphaBuffer(bool
        useAlpha )**

        **useAlpha** specifies whether to use alpha transparency on newly
        created windows.

        In any application which expects to create translucent windows, it's
        necessary to set this to true before creating the first **QQuickWindow**
        . The default value is false.

        This function was introduced in Qt 5.1.

        **See also** **hasDefaultAlphaBuffer** ().
        """
        ...

    @staticmethod
    def hasDefaultAlphaBuffer() -> bool:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#hasDefaultAlphaBuffer

        **[static, since 5.1] bool QQuickWindow::hasDefaultAlphaBuffer()**

        Returns whether to use alpha transparency on newly created windows.

        This function was introduced in Qt 5.1.

        **See also** **setDefaultAlphaBuffer** ().
        """
        ...

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#closeEvent

        **[override virtual protected] void QQuickWindow::closeEvent(QCloseEvent
        * e )**

        Reimplements: **QWindow::closeEvent** (QCloseEvent *ev).
        """
        ...

    def tabletEvent(self, a0: QtGui.QTabletEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#tabletEvent

        **[override virtual protected] void
        QQuickWindow::tabletEvent(QTabletEvent * event )**

        Reimplements: **QWindow::tabletEvent** (QTabletEvent *ev).
        """
        ...

    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#wheelEvent

        **[override virtual protected] void QQuickWindow::wheelEvent(QWheelEvent
        * event )**

        Reimplements: **QWindow::wheelEvent** (QWheelEvent *ev).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#mouseMoveEvent

        **[override virtual protected] void
        QQuickWindow::mouseMoveEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mouseMoveEvent** (QMouseEvent *ev).
        """
        ...

    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QQuickWindow::mouseDoubleClickEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mouseDoubleClickEvent** (QMouseEvent *ev).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#mouseReleaseEvent

        **[override virtual protected] void
        QQuickWindow::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mouseReleaseEvent** (QMouseEvent *ev).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#mousePressEvent

        **[override virtual protected] void
        QQuickWindow::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mousePressEvent** (QMouseEvent *ev).
        """
        ...

    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#keyReleaseEvent

        **[override virtual protected] void
        QQuickWindow::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QWindow::keyReleaseEvent** (QKeyEvent *ev).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#keyPressEvent

        **[override virtual protected] void
        QQuickWindow::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QWindow::keyPressEvent** (QKeyEvent *ev).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#event

        **[override virtual protected] bool QQuickWindow::event(QEvent * e )**

        Reimplements: **QWindow::event** (QEvent *ev).
        """
        ...

    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#focusOutEvent

        **[override virtual protected] void
        QQuickWindow::focusOutEvent(QFocusEvent * ev )**

        Reimplements: **QWindow::focusOutEvent** (QFocusEvent *ev).
        """
        ...

    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#focusInEvent

        **[override virtual protected] void
        QQuickWindow::focusInEvent(QFocusEvent * ev )**

        Reimplements: **QWindow::focusInEvent** (QFocusEvent *ev).
        """
        ...

    def hideEvent(self, a0: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#hideEvent

        **[override virtual protected] void QQuickWindow::hideEvent(QHideEvent
        *)**

        Reimplements: **QWindow::hideEvent** (QHideEvent *ev).
        """
        ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#showEvent

        **[override virtual protected] void QQuickWindow::showEvent(QShowEvent
        *)**

        Reimplements: **QWindow::showEvent** (QShowEvent *ev).
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#resizeEvent

        **[override virtual protected] void
        QQuickWindow::resizeEvent(QResizeEvent * ev )**

        Reimplements: **QWindow::resizeEvent** (QResizeEvent *ev).
        """
        ...

    def exposeEvent(self, a0: QtGui.QExposeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#exposeEvent

        **[override virtual protected] void
        QQuickWindow::exposeEvent(QExposeEvent *)**

        Reimplements: **QWindow::exposeEvent** (QExposeEvent *ev).
        """
        ...

    def releaseResources(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#releaseResources

        **[slot] void QQuickWindow::releaseResources()**

        This function tries to release redundant resources currently held by the
        QML scene.

        Calling this function requests the scene graph to release cached
        graphics resources, such as graphics pipeline objects or shader
        programs.

        **Note:** The releasing of cached graphics resources is not dependent on
        the hint from **setPersistentGraphics** ().

        Additionally, depending on the render loop in use, this function may
        also result in the scene graph and all rendering resources to be
        released. If this happens, the **sceneGraphInvalidated** () signal will
        be emitted, allowing users to clean up their own graphics resources. The
        **setPersistentGraphics** () and **setPersistentSceneGraph** ()
        functions can be used to prevent this from happening, if handling the
        cleanup is not feasible in the application, at the cost of higher memory
        usage.

        **See also** **sceneGraphInvalidated** (), **setPersistentGraphics** (),
        and **setPersistentSceneGraph** ().
        """
        ...

    def update(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#update

        **[slot] void QQuickWindow::update()**

        Schedules the window to render another frame.

        Calling QQuickWindow::update() differs from **QQuickItem::update** () in
        that it always triggers a repaint, regardless of changes in the
        underlying scene graph or not.
        """
        ...

    def isPersistentSceneGraph(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#isPersistentSceneGraph

        **bool QQuickWindow::isPersistentSceneGraph() const**

        Returns whether the scene graph nodes and resources can be released
        during the lifetime of this **QQuickWindow** .

        **Note:** This is a hint. When and how this happens is implementation
        specific.
        """
        ...

    def setPersistentSceneGraph(self, persistent: bool) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setPersistentSceneGraph

        **void QQuickWindow::setPersistentSceneGraph(bool persistent )**

        Sets whether the scene graph nodes and resources are **persistent**.
        Persistent means the nodes and resources cannot be released. The default
        value is `true`.

        When calling **releaseResources** (), when the window gets hidden (more
        specifically, not renderable), some render loops have the possibility to
        release the scene graph nodes and related graphics resources. This frees
        up memory temporarily, but will also mean the scene graph has to be
        rebuilt when the window renders next time.

        **Note:** The rules for when a window is not renderable are platform and
        window manager specific.

        **Note:** The scene graph nodes and resources are always released when
        the last **QQuickWindow**  is deleted, regardless of this setting.

        **Note:** This is a hint, and is not guaranteed that it is taken into
        account.

        **See also** **isPersistentSceneGraph** (), **setPersistentGraphics**
        (), **sceneGraphInvalidated** (), **sceneGraphInitialized** (), and
        **releaseResources** ().
        """
        ...

    def color(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#color-prop

        **color : QColor**

        This property holds the color used to clear the color buffer at the
        beginning of each frame.

        By default, the clear color is white.

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void **colorChanged** (const QColor &)

        **See also** **setDefaultAlphaBuffer** ().
        """
        ...

    def setColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#color-prop

        **color : QColor**

        This property holds the color used to clear the color buffer at the
        beginning of each frame.

        By default, the clear color is white.

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void **colorChanged** (const QColor &)

        **See also** **setDefaultAlphaBuffer** ().
        """
        ...

    @typing.overload
    def createTextureFromImage(self, image: QtGui.QImage) -> "QSGTexture":
        """
        https://doc.qt.io/qt-6/qquickwindow.html#createTextureFromImage

        **QSGTexture *QQuickWindow::createTextureFromImage(const QImage & image
        , QQuickWindow::CreateTextureOptions options ) const**

        Creates a new **QSGTexture**  from the supplied **image**. If the image
        has an alpha channel, the corresponding texture will have an alpha
        channel.

        The caller of the function is responsible for deleting the returned
        texture. The underlying native texture object is then destroyed together
        with the **QSGTexture** .

        When **options** contains **TextureCanUseAtlas** , the engine may put
        the image into a texture atlas. Textures in an atlas need to rely on
        **QSGTexture::normalizedTextureSubRect** () for their geometry and will
        not support **QSGTexture::Repeat** . Other values from
        **CreateTextureOption**  are ignored.

        When **options** contains **TextureIsOpaque** , the engine will create
        an RGB texture which returns false for **QSGTexture::hasAlphaChannel**
        (). Opaque textures will in most cases be faster to render. When this
        flag is not set, the texture will have an alpha channel based on the
        image's format.

        When **options** contains **TextureHasMipmaps** , the engine will create
        a texture which can use mipmap filtering. Mipmapped textures can not be
        in an atlas.

        When the scene graph uses OpenGL, the returned texture will be using
        `GL_TEXTURE_2D` as texture target and `GL_RGBA` as internal format. With
        other graphics APIs, the texture format is typically `RGBA8`.
        Reimplement **QSGTexture**  to create textures with different
        parameters.

        **Warning:** This function will return 0 if the scene graph has not yet
        been initialized.

        **Warning:** The returned texture is not memory managed by the scene
        graph and must be explicitly deleted by the caller on the rendering
        thread. This is achieved by deleting the texture from a **QSGNode**
        destructor or by using **deleteLater** () in the case where the texture
        already has affinity to the rendering thread.

        This function can be called from any thread.

        **See also** **sceneGraphInitialized** () and **QSGTexture** .
        """
        ...

    @typing.overload
    def createTextureFromImage(
        self, image: QtGui.QImage, options: "QQuickWindow.CreateTextureOption"
    ) -> "QSGTexture":
        """
        https://doc.qt.io/qt-6/qquickwindow.html#createTextureFromImage-1

        **QSGTexture *QQuickWindow::createTextureFromImage(const QImage & image
        ) const**

        This is an overloaded function.
        """
        ...

    def incubationController(self) -> QtQml.QQmlIncubationController:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#incubationController

        **QQmlIncubationController *QQuickWindow::incubationController() const**

        Returns an incubation controller that splices incubation between frames
        for this window. **QQuickView**  automatically installs this controller
        for you, otherwise you will need to install it yourself using
        **QQmlEngine::setIncubationController** ().

        The controller is owned by the window and will be destroyed when the
        window is deleted.
        """
        ...

    def renderTarget(self) -> QQuickRenderTarget:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#renderTarget

        **[since 6.0] QQuickRenderTarget QQuickWindow::renderTarget() const**

        Returns the **QQuickRenderTarget**  passed to **setRenderTarget** (), or
        a default constructed one otherwise

        This function was introduced in Qt 6.0.

        **See also** **setRenderTarget** ().
        """
        ...

    def setRenderTarget(self, target: QQuickRenderTarget) -> None:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#setRenderTarget

        **[since 6.0] void QQuickWindow::setRenderTarget(const
        QQuickRenderTarget & target )**

        Sets the render target for this window to be **target**.

        A **QQuickRenderTarget**  serves as an opaque handle for a renderable
        native object, most commonly a 2D texture, and associated metadata, such
        as the size in pixels.

        A default constructed **QQuickRenderTarget**  means no redirection. A
        valid **target** , created via one of the static **QQuickRenderTarget**
        factory functions, on the other hand, enables redirection of the
        rendering of the Qt Quick scene: it will no longer target the color
        buffers for the surface associated with the window, but rather the
        textures or other graphics objects specified in **target**.

        For example, assuming the scenegraph is using Vulkan to render, one can
        redirect its output into a `VkImage`. For graphics APIs like Vulkan, the
        image layout must be provided as well. **QQuickRenderTarget**  instances
        are implicitly shared and are copyable and can be passed by value. They
        do not own the associated native objects (such as, the VkImage in the
        example), however.

        QQuickRenderTarget rt = QQuickRenderTarget::fromVulkanImage(vulkanImage,
        VK_IMAGE_LAYOUT_PREINITIALIZED, pixelSize);
        quickWindow->setRenderTarget(rt);

        This function is very often used in combination with
        **QQuickRenderControl**  and an invisible **QQuickWindow** , in order to
        render Qt Quick content into a texture, without creating an on-screen
        native window for this **QQuickWindow** .

        When the desired target, or associated data, such as the size, changes,
        call this function with a new **QQuickRenderTarget** . Constructing
        **QQuickRenderTarget**  instances and calling this function is cheap,
        but be aware that setting a new **target** with a different native
        object or other data may lead to potentially expensive initialization
        steps when the scenegraph is about to render the next frame. Therefore
        change the target only when necessary.

        **Note:** This function should not be used when using the `software`
        backend. Instead, use **grabWindow** () to render the content into a
        **QImage** .

        **Note:** The window does not take ownership of any native objects
        referenced in **target**.

        **Note:** It is the caller's responsibility to ensure the native objects
        referred to in **target** are valid for the scenegraph renderer too. For
        instance, with Vulkan, Metal, and Direct3D this implies that the texture
        or image is created on the same graphics device that is used by the
        scenegraph internally. Therefore, when texture objects created on an
        already existing device or context are involved, this function is often
        used in combination with **setGraphicsDevice** ().

        **Note:** With graphics APIs where relevant, the application must pay
        attention to image layout transitions performed by the scenegraph. For
        example, once a VkImage is associated with the scenegraph by calling
        this function, its layout will transition to
        `VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL` when rendering a frame.

        **Warning:** This function can only be called from the thread doing the
        rendering.

        This function was introduced in Qt 6.0.

        **See also** **renderTarget** (), **QQuickRenderControl** ,
        **setGraphicsDevice** (), and **setGraphicsApi** ().
        """
        ...

    def grabWindow(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#grabWindow

        **QImage QQuickWindow::grabWindow()**

        Grabs the contents of the window and returns it as an image.

        It is possible to call the grabWindow() function when the window is not
        visible. This requires that the window is **created**  and has a valid
        size and that no other **QQuickWindow**  instances are rendering in the
        same process.

        **Note:** When using this window in combination with
        **QQuickRenderControl** , the result of this function is an empty image,
        unless the `software` backend is in use. This is because when
        redirecting the output to an application-managed graphics resource (such
        as, a texture) by using **QQuickRenderControl**  and **setRenderTarget**
        (), the application is better suited for managing and executing an
        eventual read back operation, since it is in full control of the
        resource to begin with.

        **Warning:** Calling this function will cause performance problems.

        **Warning:** This function can only be called from the GUI thread.
        """
        ...

    def mouseGrabberItem(self) -> QQuickItem:
        ...

    def focusObject(self) -> QtCore.QObject:
        ...

    def activeFocusItem(self) -> QQuickItem:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#activeFocusItem-prop

        **[read-only] activeFocusItem : QQuickItem* const**

        This property holds the item which currently has active focus or `null`
        if there is no item with active focus.

        **Access functions:**

        QQuickItem * **activeFocusItem** () const

        **Notifier signal:**

        void **activeFocusItemChanged** ()
        """
        ...

    def contentItem(self) -> QQuickItem:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#contentItem-prop

        **[read-only] contentItem : QQuickItem* const**

        This property holds the invisible root item of the scene.

        A **QQuickWindow**  always has a single invisible root item containing
        all of its content. To add items to this window, reparent the items to
        the contentItem or to an existing item in the scene.

        **Access functions:**

        QQuickItem * **contentItem** () const
        """
        ...

    @property
    def activeFocusItemChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def afterAnimating(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#afterAnimating

        **[signal, since 5.3] void QQuickWindow::afterAnimating()**

        This signal is emitted on the GUI thread before requesting the render
        thread to perform the synchronization of the scene graph.

        Unlike the other similar signals, this one is emitted on the GUI thread
        instead of the render thread. It can be used to synchronize external
        animation systems with the QML content. At the same time this means that
        this signal is not suitable for triggering graphics operations.

        This function was introduced in Qt 5.3.
        """
        ...

    @property
    def afterFrameEnd(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#afterFrameEnd

        **[signal, since 6.0] void QQuickWindow::afterFrameEnd()**

        This signal is emitted when the scene graph has submitted a frame. This
        is emitted after all other related signals, such as **afterRendering**
        (). It is the last signal that is emitted by the scene graph rendering
        thread when rendering a frame.

        **Note:** Unlike **frameSwapped** (), this signal is guaranteed to be
        emitted also when the Qt Quick output is redirected via
        **QQuickRenderControl** .

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        This function was introduced in Qt 6.0.

        **See also** **beforeFrameBegin** () and **rendererInterface** ().
        """
        ...

    @property
    def afterRenderPassRecording(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#afterRenderPassRecording

        **[signal, since 5.14] void QQuickWindow::afterRenderPassRecording()**

        This signal is emitted after the scenegraph has recorded the commands
        for its main render pass, but the pass is not yet finalized on the
        command buffer.

        This signal is emitted earlier than **afterRendering** (), and it
        guarantees that not just the frame but also the recording of the
        scenegraph's main render pass is still active. This allows inserting
        commands without having to generate an entire, separate render pass
        (which would typically clear the attached images). The native graphics
        objects can be queried via **QSGRendererInterface** .

        **Note:** Resource updates (uploads, copies) typically cannot be
        enqueued from within a render pass. Therefore, more complex user
        rendering will need to connect to both **beforeRendering** () and this
        signal.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        This function was introduced in Qt 5.14.

        **See also** **rendererInterface** ().
        """
        ...

    @property
    def afterRendering(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#afterRendering

        **[signal] void QQuickWindow::afterRendering()**

        The signal is emitted after scene graph has added its commands to the
        command buffer, which is not yet submitted to the graphics queue. If
        desired, the slot function connected to this signal can query native
        resources, like the command buffer, before via **QSGRendererInterface**
        . Note however that the render pass (or passes) are already recorded at
        this point and it is not possible to add more commands within the
        scenegraph's pass. Instead, use **afterRenderPassRecording** () for
        that. This signal has therefore limited use in Qt 6, unlike in Qt 5.
        Rather, it is the combination of **beforeRendering** () and
        **beforeRenderPassRecording** (), or **beforeRendering** () and
        **afterRenderPassRecording** (), that is typically used to achieve
        under- or overlaying of the custom rendering.

        When using OpenGL, the **QOpenGLContext**  used for rendering by the
        scene graph will be bound at this point.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** When using OpenGL, be aware that setting OpenGL 3.x or 4.x
        specific states and leaving these enabled or set to non-default values
        when returning from the connected slot can interfere with the scene
        graph's rendering.

        **See also** **rendererInterface** (), **Scene Graph - OpenGL Under
        QML** , **Scene Graph - Metal Under QML** , **Scene Graph - Vulkan Under
        QML** , and **Scene Graph - Direct3D 11 Under QML** .
        """
        ...

    @property
    def afterSynchronizing(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#afterSynchronizing

        **[signal, since 5.3] void QQuickWindow::afterSynchronizing()**

        This signal is emitted after the scene graph is synchronized with the
        QML state.

        This signal can be used to do preparation required after calls to
        **QQuickItem::updatePaintNode** (), while the GUI thread is still
        locked.

        When using OpenGL, the **QOpenGLContext**  used for rendering by the
        scene graph will be bound at this point.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** When using OpenGL, be aware that setting OpenGL 3.x or 4.x
        specific states and leaving these enabled or set to non-default values
        when returning from the connected slot can interfere with the scene
        graph's rendering.

        This function was introduced in Qt 5.3.
        """
        ...

    @property
    def beforeFrameBegin(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#beforeFrameBegin

        **[signal, since 6.0] void QQuickWindow::beforeFrameBegin()**

        This signal is emitted before the scene graph starts preparing the
        frame. This precedes signals like **beforeSynchronizing** () or
        **beforeRendering** (). It is the earliest signal that is emitted by the
        scene graph rendering thread when starting to prepare a new frame.

        This signal is relevant for lower level graphics frameworks that need to
        execute certain operations, such as resource cleanup, at a stage where
        Qt Quick has not initiated the recording of a new frame via the
        underlying rendering hardware interface APIs.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        This function was introduced in Qt 6.0.

        **See also** **afterFrameEnd** () and **rendererInterface** ().
        """
        ...

    @property
    def beforeRenderPassRecording(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#beforeRenderPassRecording

        **[signal, since 5.14] void QQuickWindow::beforeRenderPassRecording()**

        This signal is emitted before the scenegraph starts recording commands
        for the main render pass. (Layers have their own passes and are fully
        recorded by the time this signal is emitted.) The render pass is already
        active on the command buffer when the signal is emitted.

        This signal is emitted later than **beforeRendering** () and it
        guarantees that not just the frame, but also the recording of the
        scenegraph's main render pass is active. This allows inserting commands
        without having to generate an entire, separate render pass (which would
        typically clear the attached images). The native graphics objects can be
        queried via **QSGRendererInterface** .

        **Note:** Resource updates (uploads, copies) typically cannot be
        enqueued from within a render pass. Therefore, more complex user
        rendering will need to connect to both **beforeRendering** () and this
        signal.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        This function was introduced in Qt 5.14.

        **See also** **rendererInterface** ().
        """
        ...

    @property
    def beforeRendering(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#beforeRendering

        **[signal] void QQuickWindow::beforeRendering()**

        This signal is emitted after the preparations for the frame have been
        done, meaning there is a command buffer in recording mode, where
        applicable. If desired, the slot function connected to this signal can
        query native resources like the command before via
        **QSGRendererInterface** . Note however that the recording of the main
        render pass is not yet started at this point and it is not possible to
        add commands within that pass. Starting a pass means clearing the color,
        depth, and stencil buffers so it is not possible to achieve an underlay
        type of rendering by just connecting to this signal. Rather, connect to
        **beforeRenderPassRecording** (). However, connecting to this signal is
        still important if the recording of copy type of commands is desired
        since those cannot be enqueued within a render pass.

        When using OpenGL, the **QOpenGLContext**  used for rendering by the
        scene graph will be bound at this point.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** When using OpenGL, be aware that setting OpenGL 3.x or 4.x
        specific states and leaving these enabled or set to non-default values
        when returning from the connected slot can interfere with the scene
        graph's rendering.

        **See also** **rendererInterface** (), **Scene Graph - OpenGL Under
        QML** , **Scene Graph - Metal Under QML** , **Scene Graph - Vulkan Under
        QML** , and **Scene Graph - Direct3D 11 Under QML** .
        """
        ...

    @property
    def beforeSynchronizing(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#beforeSynchronizing

        **[signal] void QQuickWindow::beforeSynchronizing()**

        This signal is emitted before the scene graph is synchronized with the
        QML state.

        Even though the signal is emitted from the scene graph rendering thread,
        the GUI thread is guaranteed to be blocked, like it is in
        **QQuickItem::updatePaintNode** (). Therefore, it is safe to access GUI
        thread thread data in a slot or lambda that is connected with
        **Qt::DirectConnection** .

        This signal can be used to do any preparation required before calls to
        **QQuickItem::updatePaintNode** ().

        When using OpenGL, the **QOpenGLContext**  used for rendering by the
        scene graph will be bound at this point.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** When using OpenGL, be aware that setting OpenGL 3.x or 4.x
        specific states and leaving these enabled or set to non-default values
        when returning from the connected slot can interfere with the scene
        graph's rendering.
        """
        ...

    @property
    def closing(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#closing

        **[signal, since 5.1] void QQuickWindow::closing(QQuickCloseEvent *
        close )**

        This signal is emitted when the window receives the event **close** from
        the windowing system.

        On macOs, Qt will create a menu item `Quit` if there is no menu item
        whose text is "quit" or "exit". This menu item calls the
        `QCoreApplication::quit` signal, not the `QQuickWindow::closing()`
        signal.

        This function was introduced in Qt 5.1.

        **See also** **QMenuBar as a Global Menu Bar** .
        """
        ...

    @property
    def colorChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def frameSwapped(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#frameSwapped

        **[signal] void QQuickWindow::frameSwapped()**

        This signal is emitted when a frame has been queued for presenting. With
        vertical synchronization enabled the signal is emitted at most once per
        vsync interval in a continuously animating scene.

        This signal will be emitted from the scene graph rendering thread.
        """
        ...

    @property
    def sceneGraphAboutToStop(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#sceneGraphAboutToStop

        **[signal, since 5.3] void QQuickWindow::sceneGraphAboutToStop()**

        This signal is emitted on the render thread when the scene graph is
        about to stop rendering. This happens usually because the window has
        been hidden.

        Applications may use this signal to release resources, but should be
        prepared to reinstantiated them again fast. The scene graph and the
        graphics context are not released at this time.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** Make very sure that a signal handler for
        sceneGraphAboutToStop() leaves the graphics context in the same state as
        it was when the signal handler was entered. Failing to do so can result
        in the scene not rendering properly.

        This function was introduced in Qt 5.3.

        **See also** **sceneGraphInvalidated** ().
        """
        ...

    @property
    def sceneGraphError(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#sceneGraphError

        **[signal, since 5.3] void
        QQuickWindow::sceneGraphError(QQuickWindow::SceneGraphError error ,
        const QString & message )**

        This signal is emitted when an **error** occurred during scene graph
        initialization.

        Applications should connect to this signal if they wish to handle
        errors, like graphics context creation failures, in a custom way. When
        no slot is connected to the signal, the behavior will be different:
        Quick will print the **message** , or show a message box, and terminate
        the application.

        This signal will be emitted from the GUI thread.

        This function was introduced in Qt 5.3.
        """
        ...

    @property
    def sceneGraphInitialized(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#sceneGraphInitialized

        **[signal] void QQuickWindow::sceneGraphInitialized()**

        This signal is emitted when the scene graph has been initialized.

        This signal will be emitted from the scene graph rendering thread.
        """
        ...

    @property
    def sceneGraphInvalidated(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qquickwindow.html#sceneGraphInvalidated

        **[signal] void QQuickWindow::sceneGraphInvalidated()**

        This signal is emitted when the scene graph has been invalidated.

        This signal implies that the graphics rendering context used has been
        invalidated and all user resources tied to that context should be
        released.

        When rendering with OpenGL, the **QOpenGLContext**  of this window will
        be bound when this function is called. The only exception is if the
        native OpenGL has been destroyed outside Qt's control, for instance
        through EGL_CONTEXT_LOST.

        This signal will be emitted from the scene graph rendering thread.
        """
        ...
