"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtQuick import *


class QSGFlatColorMaterial(QSGMaterial):
    """
    https://doc.qt.io/qt-6/qsgflatcolormaterial.html

    **Detailed Description**

    **Warning:** This utility class is only functional when running with the
    default backend of the Qt Quick scenegraph.

    The flat color material will fill every pixel in a geometry using a solid
    color. The color can contain transparency.

    The geometry to be rendered with a flat color material requires vertices in
    attribute location 0 in the **QSGGeometry**  object to render correctly. The
    **QSGGeometry::defaultAttributes_Point2D** () returns an attribute set
    compatible with this material.

    The flat color material respects both current opacity and current matrix
    when updating its rendering state.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgflatcolormaterial.html#QSGFlatColorMaterial

        **QSGFlatColorMaterial::QSGFlatColorMaterial()**

        Constructs a new flat color material.

        The default color is white.
        """
        ...

    def compare(self, other: QSGMaterial) -> int:
        ...

    def color(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qsgflatcolormaterial.html#color

        **const QColor &QSGFlatColorMaterial::color() const**

        Returns this flat color material's color.

        The default color is white.

        **See also** **setColor** ().
        """
        ...

    def setColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgflatcolormaterial.html#setColor

        **void QSGFlatColorMaterial::setColor(const QColor & color )**

        Sets this flat color material's color to **color**.

        **See also** **color** ().
        """
        ...

    def createShader(
        self, renderMode: "QSGRendererInterface.RenderMode"
    ) -> "QSGMaterialShader":
        ...

    def type(self) -> "QSGMaterialType":
        ...
