"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt6.QtQuick import *


class QSGGeometryNode(QSGBasicGeometryNode):
    """
    https://doc.qt.io/qt-6/qsggeometrynode.html

    **Detailed Description**

    The QSGGeometryNode consists of geometry and material. The geometry defines
    the mesh, the vertices and their structure, to be drawn. The Material
    defines how the shape is filled.

    The following is a code snippet illustrating how to create a red line using
    a QSGGeometryNode:

    **QSGGeometry**  *geometry = new **QSGGeometry** (**QSGGeometry**
    ::defaultAttributes_Point2D(), 2);
        geometry->setDrawingMode(GL_LINES);
    geometry->setLineWidth(3);
        geometry->vertexDataAsPoint2D()[0].set(0, 0);
    geometry->vertexDataAsPoint2D()[1].set(width(), height());
    **QSGFlatColorMaterial**  *material = new **QSGFlatColorMaterial** ;
    material->setColor(**QColor** (255, 0, 0));

        **QSGGeometryNode**
    *node = new **QSGGeometryNode** ;
        node->setGeometry(geometry);
    node->setFlag(**QSGNode** ::OwnsGeometry);
        node->setMaterial(material);
    node->setFlag(**QSGNode** ::OwnsMaterial);

    A geometry node must have both geometry and a normal material before it is
    added to the scene graph. When the geometry and materials are changed after
    the node has been added to the scene graph, the user should also mark them
    as dirty using **QSGNode::markDirty** ().

    The geometry node supports two types of materials, the **opaqueMaterial**
    and the normal material. The **opaqueMaterial**  is used when the
    accumulated scene graph opacity at the time of rendering is 1. The primary
    use case is to special case opaque rendering to avoid an extra operation in
    the fragment shader can have significant performance impact on embedded
    graphics chips. The opaque material is optional.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **See also** **QSGGeometry**  and **QSGMaterial** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometrynode.html#QSGGeometryNode

        **QSGGeometryNode::QSGGeometryNode()**

        Creates a new geometry node without geometry and material.
        """
        ...

    def opaqueMaterial(self) -> QSGMaterial:
        """
        https://doc.qt.io/qt-6/qsggeometrynode.html#opaqueMaterial

        **QSGMaterial *QSGGeometryNode::opaqueMaterial() const**

        Returns the opaque material of the **QSGGeometryNode** .

        **See also** **setOpaqueMaterial** ().
        """
        ...

    def setOpaqueMaterial(self, material: QSGMaterial) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometrynode.html#setOpaqueMaterial

        **void QSGGeometryNode::setOpaqueMaterial(QSGMaterial * material )**

        Sets the opaque material of this geometry to **material**.

        The opaque material will be preferred by the renderer over the default
        material, as returned by the **material** () function, if it is not null
        and the geometry item has an inherited opacity of 1.

        The opaqueness refers to scene graph opacity, the material is still
        allowed to set **QSGMaterial::Blending**  to true and draw transparent
        pixels.

        If the material is changed without calling setOpaqueMaterial() again,
        the user must also mark the opaque material as dirty using
        **QSGNode::markDirty** ().

        **See also** **opaqueMaterial** ().
        """
        ...

    def material(self) -> QSGMaterial:
        """
        https://doc.qt.io/qt-6/qsggeometrynode.html#material

        **QSGMaterial *QSGGeometryNode::material() const**

        Returns the material of the **QSGGeometryNode** .

        **See also** **setMaterial** ().
        """
        ...

    def setMaterial(self, material: QSGMaterial) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometrynode.html#setMaterial

        **void QSGGeometryNode::setMaterial(QSGMaterial * material )**

        Sets the material of this geometry node to **material**.

        Geometry nodes must have a material before they can be added to the
        scene graph.

        If the material is changed without calling setMaterial() again, the user
        must also mark the material as dirty using **QSGNode::markDirty** ().

        **See also** **material** ().
        """
        ...
