"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtCore
from PyQt6.QtQuick3D import *
import enum


class QQuick3DTextureData(QQuick3DObject):
    """
    https://doc.qt.io/qt-6/qquick3dtexturedata.html

    **Detailed Description**

    The QQuick3DTextureData class can be used to specify custom texture data for
    a **Texture**  in a Qt Quick 3D scene.

    While not strictly required, the typical usage is to inherit from this
    class. The subclass is then exposed to QML by registering it to the type
    system. The **textureData**  property of a **Texture**  can then be set to
    reference an instance of the registered type.

    Example implementation:

    class CustomTextureData : public QQuick3DTextureData
        {
            Q_OBJECT
    ... properties ...

        public:
            CustomTextureData() {
    regenerateTextureData(); }

            void setProperty(...)
            {
    // Change relevant internal data.
                // ...

                //
    Update the texture data
                regenerateTextureData();
    // Finally, trigger an update. This is relevant in case nothing else
    // is changed in the scene; this way we make sure a new frame will
    // be rendered
                update();
            }
        private:
            void
    regenerateTextureData()
            {
                **QByteArray**  textureData;
    textureData = generateTextureData();
    setTextureData(textureData);
                setSize(**QSize** (256, 256));
    setFormat(QQuick3DTextureData::Format::RGBA8)
    setHasTransparency(true);
            }
        };

    This class can then be registered as a QML type and used with **Texture** .

    In Qt 5 type registration happened with **qmlRegisterType** :

    qmlRegisterType<MyCustomTextureData>("Example", 1, 0,
    "MyCustomTextureData");

    In Qt 6 the default approach is to use automatic registration with the help
    of the build system. Instead of calling **qmlRegisterType** , the `.pro`
    file can now contain:

    CONFIG += qmltypes
        QML_IMPORT_NAME = Example
    QML_IMPORT_MAJOR_VERSION = 1

    With CMake, automatic registration is the default behavior, so no special
    settings are needed beyond basic QML module setup:

    qt_add_qml_module(application
            URI Example
            VERSION 1.0
        )

    The class implementation should add **QML_NAMED_ELEMENT** :

    class CustomTextureData : public QQuick3DTextureData
        {
            Q_OBJECT
    QML_NAMED_ELEMENT(MyCustomTextureData)
            ...
        };

    The QML code can then use the custom type:

    import Example 1.0

        Model {
            source: "#Cube"
    materials: [
                DefaultMaterial {
                    diffuseMap:
    diffuseMapCustomTexture
                }
            ]
            Texture {
    id: diffuseMapCustomTexture
                textureData: MyCustomTextureData { }
    }
        }
    """

    class Format(enum.Enum):
        None_: QQuick3DTextureData = ...
        RGBA8: QQuick3DTextureData = ...
        RGBA16F: QQuick3DTextureData = ...
        RGBA32F: QQuick3DTextureData = ...
        RGBE8: QQuick3DTextureData = ...
        R8: QQuick3DTextureData = ...
        R16: QQuick3DTextureData = ...
        R16F: QQuick3DTextureData = ...
        R32F: QQuick3DTextureData = ...
        BC1: QQuick3DTextureData = ...
        BC2: QQuick3DTextureData = ...
        BC3: QQuick3DTextureData = ...
        BC4: QQuick3DTextureData = ...
        BC5: QQuick3DTextureData = ...
        BC6H: QQuick3DTextureData = ...
        BC7: QQuick3DTextureData = ...
        DXT1_RGBA: QQuick3DTextureData = ...
        DXT1_RGB: QQuick3DTextureData = ...
        DXT3_RGBA: QQuick3DTextureData = ...
        DXT5_RGBA: QQuick3DTextureData = ...
        ETC2_RGB8: QQuick3DTextureData = ...
        ETC2_RGB8A1: QQuick3DTextureData = ...
        ETC2_RGBA8: QQuick3DTextureData = ...
        ASTC_4x4: QQuick3DTextureData = ...
        ASTC_5x4: QQuick3DTextureData = ...
        ASTC_5x5: QQuick3DTextureData = ...
        ASTC_6x5: QQuick3DTextureData = ...
        ASTC_6x6: QQuick3DTextureData = ...
        ASTC_8x5: QQuick3DTextureData = ...
        ASTC_8x6: QQuick3DTextureData = ...
        ASTC_8x8: QQuick3DTextureData = ...
        ASTC_10x5: QQuick3DTextureData = ...
        ASTC_10x6: QQuick3DTextureData = ...
        ASTC_10x8: QQuick3DTextureData = ...
        ASTC_10x10: QQuick3DTextureData = ...
        ASTC_12x10: QQuick3DTextureData = ...
        ASTC_12x12: QQuick3DTextureData = ...

    def __init__(self, parent: typing.Optional[QQuick3DObject] = ...) -> None:
        ...

    def setHasTransparency(self, hasTransparency: bool) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#setHasTransparency

        **void QQuick3DTextureData::setHasTransparency(bool hasTransparency )**

        Set **hasTransparency** to true if the texture data has an active alpha
        channel with non-opaque values.

        This is used as an optimization by the engine so that for formats that
        do support an alpha channel do not need to have each value checked for
        non-opaque values.

        **See also** **hasTransparency** ().
        """
        ...

    def hasTransparency(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#hasTransparency

        **bool QQuick3DTextureData::hasTransparency() const**

        Returns `true` if the texture data has transparency.

        The default value is `false`.

        **See also** **setHasTransparency** ().
        """
        ...

    def setFormat(self, format: "QQuick3DTextureData.Format") -> None:
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#setFormat

        **void QQuick3DTextureData::setFormat(QQuick3DTextureData::Format format
        )**

        Sets the **format** of the texture data.

        The default format is /c RGBA8

        **See also** **format** ().
        """
        ...

    def format(self) -> "QQuick3DTextureData.Format":
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#format

        **QQuick3DTextureData::Format QQuick3DTextureData::format() const**

        Returns the format of the texture data.

        **See also** **setFormat** ().
        """
        ...

    def setSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#setSize

        **void QQuick3DTextureData::setSize(const QSize & size )**

        Sets the **size** of the texture data in pixels.

        **See also** **size** ().
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#size

        **QSize QQuick3DTextureData::size() const**

        Returns the size of the texture data in pixels.

        **See also** **setSize** ().
        """
        ...

    def setTextureData(self, data: QtCore.QByteArray) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#setTextureData

        **void QQuick3DTextureData::setTextureData(const QByteArray & data )**

        Sets the texture data. The contents of **data** must respect the
        **size**  and **format**  properties as the backend will try and upload
        and use the data as if it were a texture of size and format, and if
        there is any deviation the result will be somewhere between incorrect
        rendering of the texture, or potentially a crash.

        **See also** **textureData** ().
        """
        ...

    def textureData(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qquick3dtexturedata.html#textureData

        **const QByteArray QQuick3DTextureData::textureData() const**

        Returns the current texture data defined by this item.

        **See also** **setTextureData** ().
        """
        ...
