"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtRemoteObjects import *
import enum


class QRemoteObjectReplica(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qremoteobjectreplica.html

    **Detailed Description**

    A Remote Object Replica is a **QObject**  proxy for another **QObject**
    (called the **Source**  object). Once initialized, a replica can be
    considered a "latent copy" of the **Source**  object. That is, every change
    to a **Q_PROPERTY**  on the **Source** , or signal emitted by the **Source**
    will be updated/emitted by all **Replica**  objects. Latency is introduced
    by process scheduling by any OSes involved and network communication
    latency. As long as the replica has been initialized and the communication
    is not disrupted, receipt and order of changes is guaranteed.

    The **isInitialized**  and **state**  properties (and corresponding
    **initialized** ()/**stateChanged** () signals) allow the state of a
    **Replica**  to be determined.

    While Qt Remote Objects (QtRO) handles the initialization and
    synchronization of **Replica**  objects, there are numerous steps happening
    behind the scenes which can fail and that aren't encountered in single
    process Qt applications. See **Troubleshooting**  for advice on how to
    handle such issues when using a remote objects network.
    """

    class State(enum.Enum):
        Uninitialized: QRemoteObjectReplica = ...
        Default: QRemoteObjectReplica = ...
        Valid: QRemoteObjectReplica = ...
        Suspect: QRemoteObjectReplica = ...
        SignatureMismatch: QRemoteObjectReplica = ...

    def setNode(self, node: "QRemoteObjectNode") -> None:
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#node-prop

        **node : QRemoteObjectNode***

        This property holds a pointer to the node this object was acquired from.

        **Access functions:**

        QRemoteObjectNode * **node** () const
        virtual void **setNode**
        (QRemoteObjectNode * **node** )
        """
        ...

    def node(self) -> "QRemoteObjectNode":
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#node-prop

        **node : QRemoteObjectNode***

        This property holds a pointer to the node this object was acquired from.

        **Access functions:**

        QRemoteObjectNode * **node** () const
        virtual void **setNode**
        (QRemoteObjectNode * **node** )
        """
        ...

    def state(self) -> "QRemoteObjectReplica.State":
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#state

        **QRemoteObjectReplica::State QRemoteObjectReplica::state() const**

        Returns `true` if this replica has been initialized with data from the
        **Source**  object. Returns `false` otherwise.

        **Note:** Getter function for property state.

        **See also** **isInitialized** ().
        """
        ...

    def isInitialized(self) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#isInitialized

        **bool QRemoteObjectReplica::isInitialized() const**

        Returns `true` if this replica has been initialized with data from the
        **Source**  object. Returns `false` otherwise.

        **See also** **state** ().
        """
        ...

    def waitForSource(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#waitForSource

        **bool QRemoteObjectReplica::waitForSource(int timeout = 30000)**

        Blocking call that waits for the replica to become initialized or until
        the **timeout** (in ms) expires. Returns `true` if the replica is
        initialized when the call completes, `false` otherwise.

        If **timeout** is -1, this function will not time out.

        **See also** **isInitialized** () and **initialized** ().
        """
        ...

    def isReplicaValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#isReplicaValid

        **bool QRemoteObjectReplica::isReplicaValid() const**

        Returns `true` if this replica has been initialized and has a valid
        connection with the **node**  hosting the **Source** . Returns `false`
        otherwise.

        **See also** **isInitialized** ().
        """
        ...

    @property
    def initialized(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#initialized

        **[signal] void QRemoteObjectReplica::initialized()**

        This signal is emitted once the replica is initialized. An intialized
        replica has all property values set, but has not yet emitted any
        property change notifications.

        **See also** **isInitialized** () and **stateChanged** ().
        """
        ...

    @property
    def notified(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#notified

        **[signal] void QRemoteObjectReplica::notified()**

        This signal is emitted once the replica is initialized and all property
        change notifications have been emitted.

        It is sometimes useful to respond to property changes as events. For
        example, you might want to display a user notification when a certain
        property change occurs. However, this user notification would then also
        be triggered when a replica first became `QRemoteObjectReplica::Valid`,
        as all property change signals are emitted at that time. This isn't
        always desirable, and `notified` allows the developer to distinguish
        between these two cases.
        """
        ...

    @property
    def stateChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qremoteobjectreplica.html#stateChanged

        **[signal] void
        QRemoteObjectReplica::stateChanged(QRemoteObjectReplica::State state ,
        QRemoteObjectReplica::State oldState )**

        This signal is emitted whenever a replica's state toggles between
        **QRemoteObjectReplica::State** .

        The change in state is represented with **state** and **oldState**.

        **Note:** Notifier signal for property **state** .

        **See also** **state** () and **initialized** ().
        """
        ...
