"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtSensors import *
import enum


class QAccelerometer(QSensor):
    """
    https://doc.qt.io/qt-6/qaccelerometer.html

    **Detailed Description**

    The only behavioural difference is that this class sets the type properly.

    It also supports changing the acceleration mode, which controls whether the
    force of gravity is included in the accelerometer values or not.

    Furthermore, this class features a **reading** () function that returns a
    **QAccelerometerReading**  instead of a **QSensorReading** .

    For details about how the sensor works, see **QAccelerometerReading** .

    **See also** **QAccelerometerReading** .
    """

    class AccelerationMode(enum.Enum):
        Combined: QAccelerometer = ...
        Gravity: QAccelerometer = ...
        User: QAccelerometer = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qaccelerometer.html#QAccelerometer

        **QAccelerometer::QAccelerometer(QObject * parent = nullptr)**

        Construct the sensor as a child of **parent**.
        """
        ...

    def reading(self) -> QAccelerometerReading:
        """
        https://doc.qt.io/qt-6/qaccelerometer.html#reading

        **QAccelerometerReading *QAccelerometer::reading() const**

        Returns the reading class for this sensor.

        **See also** **QSensor::reading** ().
        """
        ...

    def setAccelerationMode(
        self, accelerationMode: "QAccelerometer.AccelerationMode"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccelerometer.html#setAccelerationMode

        **[since 5.1] void
        QAccelerometer::setAccelerationMode(QAccelerometer::AccelerationMode
        accelerationMode )**

        Sets the acceleration mode to **accelerationMode**.

        **Note:** Setter function for property **accelerationMode** .

        This function was introduced in Qt 5.1.

        **See also** **accelerationMode** ().
        """
        ...

    def accelerationMode(self) -> "QAccelerometer.AccelerationMode":
        """
        https://doc.qt.io/qt-6/qaccelerometer.html#accelerationMode-prop

        **[since 5.1] accelerationMode : AccelerationMode**

        This property holds the acceleration mode controls how acceleration
        values are reported.

        The acceleration mode controls how the acceleration sensor reports its
        values. The default mode is **QAccelerometer::Combined** , which means
        the acceleration caused by gravity is included in the reported values.

        Acceleration caused by gravity and acceleration caused by the user
        moving the device are physically impossible to distinguish because of
        general relativity. Most devices use sensor fusion to figure out which
        parts of the acceleration is caused by gravity, for example by using a
        rotation sensor to calculate the gravity direction and assuming a fixed
        magnitude for gravity. Therefore the result is only an approximation and
        may be inaccurate. The **QAccelerometer::Combined**  mode is the most
        accurate one, as it does not involve approximating the gravity.

        Not all backends and devices might support setting the acceleration
        mode. For those cases, the default mode **QAccelerometer::Combined**  is
        used, changing it has no effect.

        This property was introduced in Qt 5.1.

        **Access functions:**

        QAccelerometer::AccelerationMode **accelerationMode** () const
        void
        ****setAccelerationMode** ** (QAccelerometer::AccelerationMode
        **accelerationMode** )

        **Notifier signal:**

        void ****accelerationModeChanged** ** (QAccelerometer::AccelerationMode
        **accelerationMode** )

        **Member Function Documentation**
        """
        ...

    @property
    def accelerationModeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qaccelerometer.html#accelerationModeChanged

        **[signal, since 5.1] void
        QAccelerometer::accelerationModeChanged(QAccelerometer::AccelerationMode
        accelerationMode )**

        Emitted when the **accelerationMode** was changed.

        **Note:** Notifier signal for property **accelerationMode** .

        This function was introduced in Qt 5.1.
        """
        ...
