"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtSql import *


class QSqlRecord(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qsqlrecord.html

    **Detailed Description**

    The QSqlRecord class encapsulates the functionality and characteristics of a
    database record (usually a row in a table or view within the database).
    QSqlRecord supports adding and removing fields as well as setting and
    retrieving field values.

    The values of a record's fields can be set by name or position with
    **setValue** (); if you want to set a field to null use **setNull** (). To
    find the position of a field by name use **indexOf** (), and to find the
    name of a field at a particular position use **fieldName** (). Use **field**
    () to retrieve a **QSqlField**  object for a given field. Use **contains**
    () to see if the record contains a particular field name.

    When queries are generated to be executed on the database only those fields
    for which **isGenerated** () is true are included in the generated SQL.

    A record can have fields added with **append** () or **insert** (), replaced
    with **replace** (), and removed with **remove** (). All the fields can be
    removed with **clear** (). The number of fields is given by **count** ();
    all their values can be cleared (to null) using **clearValues** ().

    **See also** **QSqlField**  and **QSqlQuery::record** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#QSqlRecord

        **QSqlRecord::QSqlRecord()**

        Constructs an empty record.

        **See also** **isEmpty** (), **append** (), and **insert** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QSqlRecord") -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#QSqlRecord-1

        **QSqlRecord::QSqlRecord(const QSqlRecord & other )**

        Constructs a copy of **other**.

        QSqlRecord is **implicitly shared** . This means you can make copies of
        a record in **constant time** .
        """
        ...

    def keyValues(self, keyFields: "QSqlRecord") -> "QSqlRecord":
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#keyValues

        **[since 5.1] QSqlRecord QSqlRecord::keyValues(const QSqlRecord &
        keyFields ) const**

        Returns a record containing the fields represented in **keyFields** set
        to values that match by field name.

        This function was introduced in Qt 5.1.
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#count

        **int QSqlRecord::count() const**

        Returns the number of fields in the record.

        **See also** **isEmpty** ().
        """
        ...

    def clearValues(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#clearValues

        **void QSqlRecord::clearValues()**

        Clears the value of all fields in the record and sets each field to
        null.

        **See also** **setValue** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#clear

        **void QSqlRecord::clear()**

        Removes all the record's fields.

        **See also** **clearValues** () and **isEmpty** ().
        """
        ...

    def contains(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#contains

        **bool QSqlRecord::contains(const QString & name ) const**

        Returns `true` if there is a field in the record called **name** ;
        otherwise returns `false`.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#isEmpty

        **bool QSqlRecord::isEmpty() const**

        Returns `true` if there are no fields in the record; otherwise returns
        `false`.

        **See also** **append** (), **insert** (), and **clear** ().
        """
        ...

    def remove(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#remove

        **void QSqlRecord::remove(int pos )**

        Removes the field at position **pos**. If **pos** is out of range,
        nothing happens.

        **See also** **append** (), **insert** (), and **replace** ().
        """
        ...

    def insert(self, pos: int, field: QSqlField) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#insert

        **void QSqlRecord::insert(int pos , const QSqlField & field )**

        Inserts the field **field** at position **pos** in the record.

        **See also** **append** (), **replace** (), and **remove** ().
        """
        ...

    def replace(self, pos: int, field: QSqlField) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#replace

        **void QSqlRecord::replace(int pos , const QSqlField & field )**

        Replaces the field at position **pos** with the given **field**. If
        **pos** is out of range, nothing happens.

        **See also** **append** (), **insert** (), and **remove** ().
        """
        ...

    def append(self, field: QSqlField) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#append

        **void QSqlRecord::append(const QSqlField & field )**

        Append a copy of field **field** to the end of the record.

        **See also** **insert** (), **replace** (), and **remove** ().
        """
        ...

    @typing.overload
    def setGenerated(self, name: str, generated: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#setGenerated

        **void QSqlRecord::setGenerated(const QString & name , bool generated
        )**

        Sets the generated flag for the field called **name** to **generated**.
        If the field does not exist, nothing happens. Only fields that have
        **generated** set to true are included in the SQL that is generated by
        **QSqlQueryModel**  for example.

        **See also** **isGenerated** ().
        """
        ...

    @typing.overload
    def setGenerated(self, i: int, generated: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#setGenerated-1

        **void QSqlRecord::setGenerated(int index , bool generated )**

        This is an overloaded function.

        Sets the generated flag for the field **index** to **generated**.

        **See also** **isGenerated** ().
        """
        ...

    @typing.overload
    def isGenerated(self, i: int) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#isGenerated

        **bool QSqlRecord::isGenerated(const QString & name ) const**

        Returns `true` if the record has a field called **name** and this field
        is to be generated (the default); otherwise returns `false`.

        **See also** **setGenerated** ().
        """
        ...

    @typing.overload
    def isGenerated(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#isGenerated-1

        **bool QSqlRecord::isGenerated(int index ) const**

        This is an overloaded function.

        Returns `true` if the record has a field at position **index** and this
        field is to be generated (the default); otherwise returns `false`.

        **See also** **setGenerated** ().
        """
        ...

    @typing.overload
    def field(self, i: int) -> QSqlField:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#field

        **QSqlField QSqlRecord::field(int index ) const**

        Returns the field at position **index**. If the **index** is out of
        range, function returns a **default-constructed value** .
        """
        ...

    @typing.overload
    def field(self, name: str) -> QSqlField:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#field-1

        **QSqlField QSqlRecord::field(const QString & name ) const**

        This is an overloaded function.

        Returns the field called **name**.
        """
        ...

    def fieldName(self, i: int) -> str:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#fieldName

        **QString QSqlRecord::fieldName(int index ) const**

        Returns the name of the field at position **index**. If the field does
        not exist, an empty string is returned.

        **See also** **indexOf** ().
        """
        ...

    def indexOf(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#indexOf

        **int QSqlRecord::indexOf(const QString & name ) const**

        Returns the position of the field called **name** within the record, or
        -1 if it cannot be found. Field names are not case-sensitive. If more
        than one field matches, the first one is returned.

        **See also** **fieldName** ().
        """
        ...

    @typing.overload
    def isNull(self, i: int) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#isNull

        **bool QSqlRecord::isNull(const QString & name ) const**

        Returns `true` if the field called **name** is null or if there is no
        field called **name** ; otherwise returns `false`.

        **See also** **setNull** ().
        """
        ...

    @typing.overload
    def isNull(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#isNull-1

        **bool QSqlRecord::isNull(int index ) const**

        This is an overloaded function.

        Returns `true` if the field **index** is null or if there is no field at
        position **index** ; otherwise returns `false`.
        """
        ...

    @typing.overload
    def setNull(self, i: int) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#setNull

        **void QSqlRecord::setNull(int index )**

        Sets the value of field **index** to null. If the field does not exist,
        nothing happens.

        **See also** **isNull** () and **setValue** ().
        """
        ...

    @typing.overload
    def setNull(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#setNull-1

        **void QSqlRecord::setNull(const QString & name )**

        This is an overloaded function.

        Sets the value of the field called **name** to null. If the field does
        not exist, nothing happens.
        """
        ...

    @typing.overload
    def setValue(self, i: int, val: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#setValue

        **void QSqlRecord::setValue(int index , const QVariant & val )**

        Sets the value of the field at position **index** to **val**. If the
        field does not exist, nothing happens.

        **See also** **value** () and **setNull** ().
        """
        ...

    @typing.overload
    def setValue(self, name: str, val: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#setValue-1

        **void QSqlRecord::setValue(const QString & name , const QVariant & val
        )**

        This is an overloaded function.

        Sets the value of the field called **name** to **val**. If the field
        does not exist, nothing happens.
        """
        ...

    @typing.overload
    def value(self, i: int) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#value

        **QVariant QSqlRecord::value(int index ) const**

        Returns the value of the field located at position **index** in the
        record. If **index** is out of bounds, an invalid **QVariant**  is
        returned.

        **See also** **setValue** (), **fieldName** (), and **isNull** ().
        """
        ...

    @typing.overload
    def value(self, name: str) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qsqlrecord.html#value-1

        **QVariant QSqlRecord::value(const QString & name ) const**

        This is an overloaded function.

        Returns the value of the field called **name** in the record. If field
        **name** does not exist an invalid variant is returned.

        **See also** **indexOf** ().
        """
        ...
