"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtSql import *
import enum


class QSqlResult(PyQt6.sip.wrapper):
    """
    https://doc.qt.io/qt-6/qsqlresult.html

    **Detailed Description**

    Normally, you would use **QSqlQuery**  instead of QSqlResult, since
    **QSqlQuery**  provides a generic wrapper for database-specific
    implementations of QSqlResult.

    If you are implementing your own SQL driver (by subclassing **QSqlDriver**
    ), you will need to provide your own QSqlResult subclass that implements all
    the pure virtual functions and other virtual functions that you need.

    **See also** **QSqlDriver** .
    """

    class BindingSyntax(enum.Enum):
        PositionalBinding: QSqlResult = ...
        NamedBinding: QSqlResult = ...

    def __init__(self, db: QSqlDriver) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#QSqlResult

        **[protected] QSqlResult::QSqlResult(const QSqlDriver * db )**

        Creates a QSqlResult using database driver **db**. The object is
        initialized to an inactive state.

        **See also** **isActive** () and **driver** ().
        """
        ...

    def lastInsertId(self) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#lastInsertId

        **[virtual protected] QVariant QSqlResult::lastInsertId() const**

        Returns the object ID of the most recent inserted row if the database
        supports it. An invalid **QVariant**  will be returned if the query did
        not insert any value or if the database does not report the id back. If
        more than one row was touched by the insert, the behavior is undefined.

        Note that for Oracle databases the row's ROWID will be returned, while
        for MySQL databases the row's auto-increment field will be returned.

        **See also** **QSqlDriver::hasFeature** ().
        """
        ...

    def record(self) -> QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#record

        **[virtual protected] QSqlRecord QSqlResult::record() const**

        Returns the current record if the query is active; otherwise returns an
        empty **QSqlRecord** .

        The default implementation always returns an empty **QSqlRecord** .

        **See also** **isActive** ().
        """
        ...

    def numRowsAffected(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#numRowsAffected

        **[pure virtual protected] int QSqlResult::numRowsAffected()**

        Returns the number of rows affected by the last query executed, or -1 if
        it cannot be determined or if the query is a `SELECT` statement.

        **See also** **size** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#size

        **[pure virtual protected] int QSqlResult::size()**

        Returns the size of the `SELECT` result, or -1 if it cannot be
        determined or if the query is not a `SELECT` statement.

        **See also** **numRowsAffected** ().
        """
        ...

    def fetchLast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#fetchLast

        **[pure virtual protected] bool QSqlResult::fetchLast()**

        Positions the result to the last record (last row) in the result.

        This function is only called if the result is in an active state.
        Derived classes must reimplement this function and position the result
        to the last record, and call **setAt** () with an appropriate value.
        Return true to indicate success, or false to signify failure.

        **See also** **fetch** () and **fetchFirst** ().
        """
        ...

    def fetchFirst(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#fetchFirst

        **[pure virtual protected] bool QSqlResult::fetchFirst()**

        Positions the result to the first record (row 0) in the result.

        This function is only called if the result is in an active state.
        Derived classes must reimplement this function and position the result
        to the first record, and call **setAt** () with an appropriate value.
        Return true to indicate success, or false to signify failure.

        **See also** **fetch** () and **fetchLast** ().
        """
        ...

    def fetchPrevious(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#fetchPrevious

        **[virtual protected] bool QSqlResult::fetchPrevious()**

        Positions the result to the previous record (row) in the result.

        This function is only called if the result is in an active state. The
        default implementation calls **fetch** () with the previous index.
        Derived classes can reimplement this function and position the result to
        the next record in some other way, and call **setAt** () with an
        appropriate value. Return true to indicate success, or false to signify
        failure.
        """
        ...

    def fetchNext(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#fetchNext

        **[virtual protected] bool QSqlResult::fetchNext()**

        Positions the result to the next available record (row) in the result.

        This function is only called if the result is in an active state. The
        default implementation calls **fetch** () with the next index. Derived
        classes can reimplement this function and position the result to the
        next record in some other way, and call **setAt** () with an appropriate
        value. Return true to indicate success, or false to signify failure.

        **See also** **fetch** () and **fetchPrevious** ().
        """
        ...

    def fetch(self, i: int) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#fetch

        **[pure virtual protected] bool QSqlResult::fetch(int index )**

        Positions the result to an arbitrary (zero-based) row **index**.

        This function is only called if the result is in an active state.
        Derived classes must reimplement this function and position the result
        to the row **index** , and call **setAt** () with an appropriate value.
        Return true to indicate success, or false to signify failure.

        **See also** **isActive** (), **fetchFirst** (), **fetchLast** (),
        **fetchNext** (), and **fetchPrevious** ().
        """
        ...

    def reset(self, sqlquery: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#reset

        **[pure virtual protected] bool QSqlResult::reset(const QString & query
        )**

        Sets the result to use the SQL statement **query** for subsequent data
        retrieval.

        Derived classes must reimplement this function and apply the **query**
        to the database. This function is only called after the result is set to
        an inactive state and is positioned before the first record of the new
        result. Derived classes should return true if the query was successful
        and ready to be used, or false otherwise.

        **See also** **setQuery** ().
        """
        ...

    def isNull(self, i: int) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#isNull

        **[pure virtual protected] bool QSqlResult::isNull(int index )**

        Returns `true` if the field at position **index** in the current row is
        null; otherwise returns `false`.
        """
        ...

    def data(self, i: int) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#data

        **[pure virtual protected] QVariant QSqlResult::data(int index )**

        Returns the data for field **index** in the current row as a
        **QVariant** . This function is only called if the result is in an
        active state and is positioned on a valid record and **index** is non-
        negative. Derived classes must reimplement this function and return the
        value of field **index** , or QVariant() if it cannot be determined.
        """
        ...

    def bindingSyntax(self) -> "QSqlResult.BindingSyntax":
        """
        https://doc.qt.io/qt-6/qsqlresult.html#bindingSyntax

        **[protected] QSqlResult::BindingSyntax QSqlResult::bindingSyntax()
        const**

        Returns the binding syntax used by prepared queries.
        """
        ...

    def hasOutValues(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#hasOutValues

        **[protected] bool QSqlResult::hasOutValues() const**

        Returns `true` if at least one of the query's bound values is a
        `QSql::Out` or a **QSql::InOut** ; otherwise returns `false`.

        **See also** **bindValueType** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#clear

        **[protected] void QSqlResult::clear()**

        Clears the entire result set and releases any associated resources.
        """
        ...

    def boundValueName(self, pos: int) -> str:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#boundValueName

        **[protected] QString QSqlResult::boundValueName(int index ) const**

        Returns the name of the bound value at position **index** in the current
        record (row).

        **See also** **boundValue** ().
        """
        ...

    def executedQuery(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#executedQuery

        **[protected] QString QSqlResult::executedQuery() const**

        Returns the query that was actually executed. This may differ from the
        query that was passed, for example if bound values were used with a
        prepared query and the underlying database doesn't support prepared
        queries.

        **See also** **exec** () and **setQuery** ().
        """
        ...

    def boundValues(self) -> typing.List[typing.Any]:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#boundValues

        **[protected] QList<QVariant> &QSqlResult::boundValues() const**

        Returns a vector of the result's bound values for the current record
        (row).

        **See also** **boundValueCount** ().
        """
        ...

    def boundValueCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#boundValueCount

        **[protected] int QSqlResult::boundValueCount() const**

        Returns the number of bound values in the result.

        **See also** **boundValues** ().
        """
        ...

    @typing.overload
    def bindValueType(self, placeholder: str) -> "QSql.ParamTypeFlag":
        """
        https://doc.qt.io/qt-6/qsqlresult.html#bindValueType

        **[protected] QSql::ParamType QSqlResult::bindValueType(int index )
        const**

        Returns the parameter type for the value bound at position **index**.

        **See also** **boundValue** ().
        """
        ...

    @typing.overload
    def bindValueType(self, pos: int) -> "QSql.ParamTypeFlag":
        """
        https://doc.qt.io/qt-6/qsqlresult.html#bindValueType-1

        **[protected] QSql::ParamType QSqlResult::bindValueType(const QString &
        placeholder ) const**

        This is an overloaded function.

        Returns the parameter type for the value bound with the given
        **placeholder** name.
        """
        ...

    @typing.overload
    def boundValue(self, placeholder: str) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#boundValue

        **[protected] QVariant QSqlResult::boundValue(int index ) const**

        Returns the value bound at position **index** in the current record
        (row).

        **See also** **bindValue** () and **boundValues** ().
        """
        ...

    @typing.overload
    def boundValue(self, pos: int) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#boundValue-1

        **[protected] QVariant QSqlResult::boundValue(const QString &
        placeholder ) const**

        This is an overloaded function.

        Returns the value bound by the given **placeholder** name in the current
        record (row).

        **See also** **bindValueType** ().
        """
        ...

    def addBindValue(self, val: typing.Any, type: "QSql.ParamTypeFlag") -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#addBindValue

        **[protected] void QSqlResult::addBindValue(const QVariant & val ,
        QSql::ParamType paramType )**

        Binds the value **val** of parameter type **paramType** to the next
        available position in the current record (row).

        **See also** **bindValue** ().
        """
        ...

    @typing.overload
    def bindValue(self, pos: int, val: typing.Any, type: "QSql.ParamTypeFlag") -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#bindValue

        **[virtual protected] void QSqlResult::bindValue(int index , const
        QVariant & val , QSql::ParamType paramType )**

        Binds the value **val** of parameter type **paramType** to position
        **index** in the current record (row).

        **See also** **addBindValue** ().
        """
        ...

    @typing.overload
    def bindValue(
        self, placeholder: str, val: typing.Any, type: "QSql.ParamTypeFlag"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#bindValue-1

        **[virtual protected] void QSqlResult::bindValue(const QString &
        placeholder , const QVariant & val , QSql::ParamType paramType )**

        This is an overloaded function.

        Binds the value **val** of parameter type **paramType** to the
        **placeholder** name in the current record (row).

        **Note:** Binding an undefined placeholder will result in undefined
        behavior.

        **See also** **QSqlQuery::bindValue** ().
        """
        ...

    def savePrepare(self, sqlquery: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#savePrepare

        **[virtual protected] bool QSqlResult::savePrepare(const QString & query
        )**

        Prepares the given **query** , using the underlying database
        functionality where possible. Returns `true` if the query is prepared
        successfully; otherwise returns `false`.

        Note: This method should have been called "safePrepare()".

        **See also** **prepare** ().
        """
        ...

    def prepare(self, query: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#prepare

        **[virtual protected] bool QSqlResult::prepare(const QString & query )**

        Prepares the given **query** for execution; the query will normally use
        placeholders so that it can be executed repeatedly. Returns true if the
        query is prepared successfully; otherwise returns `false`.

        **See also** **exec** ().
        """
        ...

    def exec(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#exec

        **[virtual protected] bool QSqlResult::exec()**

        Executes the query, returning true if successful; otherwise returns
        false.

        **See also** **prepare** ().
        """
        ...

    def setForwardOnly(self, forward: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#setForwardOnly

        **[virtual protected] void QSqlResult::setForwardOnly(bool forward )**

        Sets forward only mode to **forward**. If **forward** is true, only
        **fetchNext** () is allowed for navigating the results. Forward only
        mode needs much less memory since results do not have to be cached. By
        default, this feature is disabled.

        Setting forward only to false is a suggestion to the database engine,
        which has the final say on whether a result set is forward only or
        scrollable. **isForwardOnly** () will always return the correct status
        of the result set.

        **Note:** Calling setForwardOnly after execution of the query will
        result in unexpected results at best, and crashes at worst.

        **Note:** To make sure the forward-only query completed successfully,
        the application should check **lastError** () for an error not only
        after executing the query, but also after navigating the query results.

        **Warning:** PostgreSQL: While navigating the query results in forward-
        only mode, do not execute any other SQL command on the same database
        connection. This will cause the query results to be lost.

        **See also** **isForwardOnly** (), **fetchNext** (), and
        **QSqlQuery::setForwardOnly** ().
        """
        ...

    def setSelect(self, s: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#setSelect

        **[virtual protected] void QSqlResult::setSelect(bool select )**

        This function is provided for derived classes to indicate whether or not
        the current statement is a SQL `SELECT` statement. The **select**
        parameter should be true if the statement is a `SELECT` statement;
        otherwise it should be false.

        **See also** **isSelect** ().
        """
        ...

    def setQuery(self, query: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#setQuery

        **[virtual protected] void QSqlResult::setQuery(const QString & query
        )**

        Sets the current query for the result to **query**. You must call
        **reset** () to execute the query on the database.

        **See also** **reset** () and **lastQuery** ().
        """
        ...

    def setLastError(self, e: QSqlError) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#setLastError

        **[virtual protected] void QSqlResult::setLastError(const QSqlError &
        error )**

        This function is provided for derived classes to set the last error to
        **error**.

        **See also** **lastError** ().
        """
        ...

    def setActive(self, a: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#setActive

        **[virtual protected] void QSqlResult::setActive(bool active )**

        This function is provided for derived classes to set the internal active
        state to **active**.

        **See also** **isActive** ().
        """
        ...

    def setAt(self, at: int) -> None:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#setAt

        **[virtual protected] void QSqlResult::setAt(int index )**

        This function is provided for derived classes to set the internal (zero-
        based) row position to **index**.

        **See also** **at** ().
        """
        ...

    def driver(self) -> QSqlDriver:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#driver

        **[protected] const QSqlDriver *QSqlResult::driver() const**

        Returns the driver associated with the result. This is the object that
        was passed to the constructor.
        """
        ...

    def isForwardOnly(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#isForwardOnly

        **[protected] bool QSqlResult::isForwardOnly() const**

        Returns `true` if you can only scroll forward through the result set;
        otherwise returns `false`.

        **See also** **setForwardOnly** ().
        """
        ...

    def isSelect(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#isSelect

        **[protected] bool QSqlResult::isSelect() const**

        Returns `true` if the current result is from a `SELECT` statement;
        otherwise returns `false`.

        **See also** **setSelect** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#isActive

        **[protected] bool QSqlResult::isActive() const**

        Returns `true` if the result has records to be retrieved; otherwise
        returns `false`.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#isValid

        **[protected] bool QSqlResult::isValid() const**

        Returns `true` if the result is positioned on a valid record (that is,
        the result is not positioned before the first or after the last record);
        otherwise returns `false`.

        **See also** **at** ().
        """
        ...

    def lastError(self) -> QSqlError:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#lastError

        **[protected] QSqlError QSqlResult::lastError() const**

        Returns the last error associated with the result.

        **See also** **setLastError** ().
        """
        ...

    def lastQuery(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#lastQuery

        **[protected] QString QSqlResult::lastQuery() const**

        Returns the current SQL query text, or an empty string if there isn't
        one.

        **See also** **setQuery** ().
        """
        ...

    def at(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#at

        **[protected] int QSqlResult::at() const**

        Returns the current (zero-based) row position of the result. May return
        the special values **QSql::BeforeFirstRow**  or **QSql::AfterLastRow** .

        **See also** **setAt** () and **isValid** ().
        """
        ...

    def handle(self) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qsqlresult.html#handle

        **[virtual] QVariant QSqlResult::handle() const**

        Returns the low-level database handle for this result set wrapped in a
        **QVariant**  or an invalid **QVariant**  if there is no handle.

        **Warning:** Use this with uttermost care and only if you know what
        you're doing.

        **Warning:** The handle returned here can become a stale pointer if the
        result is modified (for example, if you clear it).

        **Warning:** The handle can be NULL if the result was not executed yet.

        **Warning:** PostgreSQL: in forward-only mode, the handle of
        **QSqlResult**  can change after calling **fetch** (), **fetchFirst**
        (), **fetchLast** (), **fetchNext** (), **fetchPrevious** (),
        nextResult().

        The handle returned here is database-dependent, you should query the
        type name of the variant before accessing it.

        This example retrieves the handle for a sqlite result:

        **QSqlDatabase**  db = **QSqlDatabase** ::database("sales");
        **QSqlQuery**  query("SELECT NAME, DOB FROM EMPLOYEES", db);
        **QVariant**  v = query.result()->handle();
            if (v.isValid() &&
        qstrcmp(v.typeName(), "sqlite3_stmt*") == 0) {
                // v.data()
        returns a pointer to the handle
                sqlite3_stmt *handle =
        *static_cast<sqlite3_stmt *\\*>(v.data());
                if (handle) {
        // ...
                }
            }

        This snippet returns the handle for PostgreSQL or MySQL:

        if (qstrcmp(v.typeName(), "PGresult*") == 0) {
                PGresult *handle
        = *static_cast<PGresult *\\*>(v.data());
                if (handle) {
        // ...
                    }
            }

            if (qstrcmp(v.typeName(),
        "MYSQL_STMT*") == 0) {
                MYSQL_STMT *handle =
        *static_cast<MYSQL_STMT *\\*>(v.data());
                if (handle) {
        // ...
                    }
                }

        **See also** **QSqlDriver::handle** ().
        """
        ...
