"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore


class QSignalSpy(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsignalspy.html

    **Detailed Description**

    QSignalSpy can connect to any signal of any object and records its emission.
    QSignalSpy itself is a list of **QVariant**  lists. Each emission of the
    signal will append one item to the list, containing the arguments of the
    signal.

    The following example records all signal emissions for the `clicked()`
    signal of a **QCheckBox** :

    **QCheckBox**  *box = ...;
        **QSignalSpy**  spy(box,
    SIGNAL(clicked(bool)));

        // do something that triggers the signal
    box->animateClick();

        QCOMPARE(spy.count(), 1); // make sure the
    signal was emitted exactly one time
        **QList** <**QVariant** > arguments
    = spy.takeFirst(); // take the first signal
    QVERIFY(arguments.at(0).toBool() == true); // verify the first argument

    `spy.takeFirst()` returns the arguments for the first emitted signal, as a
    list of **QVariant**  objects. The `clicked()` signal has a single bool
    argument, which is stored as the first entry in the list of arguments.

    The example below catches a signal from a custom object:

    **QSignalSpy**  spy(myCustomObject, SIGNAL(mySignal(int,**QString**
    ,double)));

        myCustomObject->doSomething(); // trigger emission of
    the signal

        **QList** <**QVariant** > arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).typeId() == **QMetaType** ::Int);
    QVERIFY(arguments.at(1).typeId() == **QMetaType** ::**QString** );
    QVERIFY(arguments.at(2).typeId() == **QMetaType** ::Double);

    **Note:** Non-standard data types need to be registered, using the
    **qRegisterMetaType** () function, before you can create a QSignalSpy. For
    example:

    **qRegisterMetaType** <SomeStruct>();
        **QSignalSpy**  spy(&model,
    SIGNAL(whatever(SomeStruct)));

    To retrieve the instance, you can use **qvariant_cast** :

    // get the first argument from the first received signal:
        SomeStruct
    result = qvariant_cast<SomeStruct>(spy.at(0).at(0));

    **Verifying Signal Emissions**

    The QSignalSpy class provides an elegant mechanism for capturing the list of
    signals emitted by an object. However, you should verify its validity after
    construction. The constructor does a number of sanity checks, such as
    verifying that the signal to be spied upon actually exists. To make the
    diagnosis of test failures easier, the results of these checks should be
    checked by calling `QVERIFY(spy.isValid())` before proceeding further with a
    test.

    **See also** **QVERIFY** ().
    """

    @typing.overload
    def __init__(self, signal: QtCore.pyqtBoundSignal) -> None:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#QSignalSpy

        **QSignalSpy::QSignalSpy(const QObject * object , const char * signal
        )**

        Constructs a new QSignalSpy that listens for emissions of the **signal**
        from the **QObject**  **object**. If QSignalSpy is not able to listen
        for a valid signal (for example, because **object** is `nullptr` or
        **signal** does not denote a valid signal of **object** ), an
        explanatory warning message will be output using **qWarning** () and
        subsequent calls to `isValid()` will return false.

        Example:

        QSignalSpy spy(myPushButton, SIGNAL(clicked(bool)));
        """
        ...

    @typing.overload
    def __init__(self, obj: QtCore.QObject, signal: QtCore.QMetaMethod) -> None:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#QSignalSpy-1

        **[since 5.4] template <typename PointerToMemberFunction>
        QSignalSpy::QSignalSpy(const QObject * object , PointerToMemberFunction
        signal )**

        Constructs a new QSignalSpy that listens for emissions of the **signal**
        from the **QObject**  **object**. If QSignalSpy is not able to listen
        for a valid signal (for example, because **object** is `nullptr` or
        **signal** does not denote a valid signal of **object** ), an
        explanatory warning message will be output using **qWarning** () and
        subsequent calls to `isValid()` will return false.

        Example:

        **QSignalSpy**  spy(myPushButton, &**QPushButton** ::clicked);

        This function was introduced in Qt 5.4.
        """
        ...

    def __delitem__(self, i: int) -> None:
        ...

    def __setitem__(self, i: int, value: typing.Iterable[typing.Any]) -> None:
        ...

    def __getitem__(self, i: int) -> typing.List[typing.Any]:
        ...

    def __len__(self) -> int:
        ...

    def wait(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#wait

        **[since 5.0] bool QSignalSpy::wait(int timeout = 5000)**

        Starts an event loop that runs until the given signal is received.
        Optionally the event loop can return earlier on a **timeout** (in
        milliseconds).

        Returns `true` if the signal was emitted at least once in **timeout**
        milliseconds, otherwise returns `false`.

        Example:

        QVERIFY(spy.wait(1000));

        This function was introduced in Qt 5.0.
        """
        ...

    def signal(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#signal

        **QByteArray QSignalSpy::signal() const**

        Returns the normalized signal the spy is currently listening to.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#isValid

        **bool QSignalSpy::isValid() const**

        Returns `true` if the signal spy listens to a valid signal, otherwise
        false.
        """
        ...
