"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtWidgets
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtTest import *
import enum


class QTest(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qtest.html

    **Detailed Description**

    See the **Qt Test Overview**  for information about how to write unit tests.
    """

    class KeyAction(enum.Enum):
        Press: QTest = ...
        Release: QTest = ...
        Click: QTest = ...
        Shortcut: QTest = ...

    @typing.overload
    def qWaitForWindowExposed(self, window: QtGui.QWindow, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowExposed

        **[since 5.0] bool QTest::qWaitForWindowExposed(QWindow * window , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **window** is exposed.
        Returns `true` if `window` is exposed within **timeout** milliseconds,
        otherwise returns `false`.

        This is mainly useful for asynchronous systems like X11, where a window
        will be mapped to screen some time after being asked to show itself on
        the screen.

        Note that a window that is mapped to screen may still not be considered
        exposed if the window client area is completely covered by other
        windows, or if the window is otherwise not visible. This function will
        then time out when waiting for such a window.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowActive** () and **QWindow::isExposed** ().
        """
        ...

    @typing.overload
    def qWaitForWindowExposed(
        self, widget: QtWidgets.QWidget, timeout: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowExposed-1

        **[since 5.0] bool QTest::qWaitForWindowExposed(QWidget * widget , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **widget** 's window is
        exposed. Returns `true` if `widget`'s window is exposed within
        **timeout** milliseconds, otherwise returns `false`.

        This is mainly useful for asynchronous systems like X11, where a window
        will be mapped to screen some time after being asked to show itself on
        the screen.

        Note that a window that is mapped to screen may still not be considered
        exposed if the window client area is completely covered by other
        windows, or if the window is otherwise not visible. This function will
        then time out when waiting for such a window.

        A specific configuration where this happens is when using QGLWidget as a
        viewport widget on macOS: The viewport widget gets the expose event, not
        the parent widget.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowActive** ().
        """
        ...

    @typing.overload
    def qWaitForWindowActive(self, window: QtGui.QWindow, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowActive

        **[since 5.0] bool QTest::qWaitForWindowActive(QWindow * window , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **window** is active.

        Returns `true` if `window` is active within **timeout** milliseconds,
        otherwise returns `false`.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowExposed** () and **QWindow::isActive** ().
        """
        ...

    @typing.overload
    def qWaitForWindowActive(
        self, widget: QtWidgets.QWidget, timeout: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowActive-1

        **[since 5.0] bool QTest::qWaitForWindowActive(QWidget * widget , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **widget** 's window is
        active.

        Returns `true` if `widget`'s window is active within **timeout**
        milliseconds, otherwise returns `false`.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowExposed** () and
        **QWidget::isActiveWindow** ().
        """
        ...

    def qWait(self, ms: int) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#qWait

        **void QTest::qWait(int ms )**

        Waits for **ms** milliseconds. While waiting, events will be processed
        and your test will stay responsive to user interface events or network
        communication.

        Example:

        int i = 0;
                while (myNetworkServerNotResponding() && i++ < 50)
        QTest::qWait(250);

        The code above will wait until the network server is responding for a
        maximum of about 12.5 seconds.

        **See also** **QTest::qSleep** () and **QSignalSpy::wait** ().
        """
        ...

    @typing.overload
    def mouseRelease(
        self,
        widget: QtWidgets.QWidget,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseRelease

        **void QTest::mouseRelease(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates releasing a mouse **button** with an optional **modifier** on
        a **widget**. The position of the release is defined by **pos** ; the
        default position is the center of the widget. If **delay** is specified,
        the test will wait for the specified amount of milliseconds before
        releasing the button.

        **See also** **QTest::mousePress** () and **QTest::mouseClick** ().
        """
        ...

    @typing.overload
    def mouseRelease(
        self,
        window: QtGui.QWindow,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseRelease-1

        **[since 5.0] void QTest::mouseRelease(QWindow * window ,
        Qt::MouseButton button , Qt::KeyboardModifiers stateKey =
        Qt::KeyboardModifiers(), QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates releasing a mouse **button** with an optional **stateKey**
        modifier on a **window**. The position of the release is defined by
        **pos** ; the default position is the center of the window. If **delay**
        is specified, the test will wait for the specified amount of
        milliseconds before releasing the button.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mousePress** () and **QTest::mouseClick** ().
        """
        ...

    @typing.overload
    def mousePress(
        self,
        widget: QtWidgets.QWidget,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mousePress

        **void QTest::mousePress(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates pressing a mouse **button** with an optional **modifier** on a
        **widget**. The position is defined by **pos** ; the default position is
        the center of the widget. If **delay** is specified, the test will wait
        for the specified amount of milliseconds before the press.

        **See also** **QTest::mouseRelease** () and **QTest::mouseClick** ().
        """
        ...

    @typing.overload
    def mousePress(
        self,
        window: QtGui.QWindow,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mousePress-1

        **[since 5.0] void QTest::mousePress(QWindow * window , Qt::MouseButton
        button , Qt::KeyboardModifiers stateKey = Qt::KeyboardModifiers(),
        QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates pressing a mouse **button** with an optional **stateKey**
        modifier on a **window**. The position is defined by **pos** ; the
        default position is the center of the window. If **delay** is specified,
        the test will wait for the specified amount of milliseconds before the
        press.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mouseRelease** () and **QTest::mouseClick** ().
        """
        ...

    @typing.overload
    def mouseMove(
        self, widget: QtWidgets.QWidget, pos: QtCore.QPoint = ..., delay: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseMove

        **void QTest::mouseMove(QWidget * widget , QPoint pos = QPoint(), int
        delay = -1)**

        Moves the mouse pointer to a **widget**. If **pos** is not specified,
        the mouse pointer moves to the center of the widget. If a **delay** (in
        milliseconds) is given, the test will wait before moving the mouse
        pointer.
        """
        ...

    @typing.overload
    def mouseMove(
        self, window: QtGui.QWindow, pos: QtCore.QPoint = ..., delay: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseMove-1

        **[since 5.0] void QTest::mouseMove(QWindow * window , QPoint pos =
        QPoint(), int delay = -1)**

        This is an overloaded function.

        Moves the mouse pointer to a **window**. If **pos** is not specified,
        the mouse pointer moves to the center of the window. If a **delay** (in
        milliseconds) is given, the test will wait before moving the mouse
        pointer.

        This function was introduced in Qt 5.0.
        """
        ...

    @typing.overload
    def mouseDClick(
        self,
        widget: QtWidgets.QWidget,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseDClick

        **void QTest::mouseDClick(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates double clicking a mouse **button** with an optional
        **modifier** on a **widget**. The position of the click is defined by
        **pos** ; the default position is the center of the widget. If **delay**
        is specified, the test will wait for the specified amount of
        milliseconds before each press and release.

        **See also** **QTest::mouseClick** ().
        """
        ...

    @typing.overload
    def mouseDClick(
        self,
        window: QtGui.QWindow,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseDClick-1

        **[since 5.0] void QTest::mouseDClick(QWindow * window , Qt::MouseButton
        button , Qt::KeyboardModifiers stateKey = Qt::KeyboardModifiers(),
        QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates double clicking a mouse **button** with an optional
        **stateKey** modifier on a **window**. The position of the click is
        defined by **pos** ; the default position is the center of the window.
        If **delay** is specified, the test will wait for the specified amount
        of milliseconds before each press and release.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mouseClick** ().
        """
        ...

    @typing.overload
    def mouseClick(
        self,
        widget: QtWidgets.QWidget,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseClick

        **void QTest::mouseClick(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates clicking a mouse **button** with an optional **modifier** on a
        **widget**. The position of the click is defined by **pos** ; the
        default position is the center of the widget. If **delay** is specified,
        the test will wait for the specified amount of milliseconds before
        pressing and before releasing the button.

        **See also** **QTest::mousePress** () and **QTest::mouseRelease** ().
        """
        ...

    @typing.overload
    def mouseClick(
        self,
        window: QtGui.QWindow,
        button: QtCore.Qt.MouseButton,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        pos: QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseClick-1

        **[since 5.0] void QTest::mouseClick(QWindow * window , Qt::MouseButton
        button , Qt::KeyboardModifiers stateKey = Qt::KeyboardModifiers(),
        QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates clicking a mouse **button** with an optional **stateKey**
        modifier on a **window**. The position of the click is defined by
        **pos** ; the default position is the center of the window. If **delay**
        is specified, the test will wait for the specified amount of
        milliseconds before pressing and before releasing the button.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mousePress** () and **QTest::mouseRelease** ().
        """
        ...

    @typing.overload
    def sendKeyEvent(
        self,
        action: "QTest.KeyAction",
        widget: QtWidgets.QWidget,
        code: QtCore.Qt.Key,
        ascii: str,
        modifier: QtCore.Qt.KeyboardModifier,
        delay: int = ...,
    ) -> None:
        ...

    @typing.overload
    def sendKeyEvent(
        self,
        action: "QTest.KeyAction",
        widget: QtWidgets.QWidget,
        code: QtCore.Qt.Key,
        text: str,
        modifier: QtCore.Qt.KeyboardModifier,
        delay: int = ...,
    ) -> None:
        ...

    def simulateEvent(
        self,
        widget: QtWidgets.QWidget,
        press: bool,
        code: int,
        modifier: QtCore.Qt.KeyboardModifier,
        text: str,
        repeat: bool,
        delay: int = ...,
    ) -> None:
        ...

    @typing.overload
    def keySequence(
        self,
        widget: QtWidgets.QWidget,
        keySequence: typing.Union[
            QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keySequence

        **[since 5.10] void QTest::keySequence(QWindow * window , const
        QKeySequence & keySequence )**

        This is an overloaded function.

        Simulates typing of **keySequence** into a **window**.

        This function was introduced in Qt 5.10.

        **See also** **QTest::keyClick** () and **QTest::keyClicks** ().
        """
        ...

    @typing.overload
    def keySequence(
        self,
        window: QtGui.QWindow,
        keySequence: typing.Union[
            QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keySequence-1

        **[since 5.10] void QTest::keySequence(QWidget * widget , const
        QKeySequence & keySequence )**

        This is an overloaded function.

        Simulates typing of **keySequence** into a **widget**.

        This function was introduced in Qt 5.10.

        **See also** **QTest::keyClick** () and **QTest::keyClicks** ().
        """
        ...

    @typing.overload
    def keyRelease(
        self,
        widget: QtWidgets.QWidget,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease

        **void QTest::keyRelease(QWidget * widget , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates releasing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        **See also** **QTest::keyPress** () and **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyRelease(
        self,
        widget: QtWidgets.QWidget,
        key: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease-1

        **[since 5.0] void QTest::keyRelease(QWindow * window , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates releasing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyRelease(
        self,
        window: QtGui.QWindow,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease-2

        **[since 5.0] void QTest::keyRelease(QWindow * window , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates releasing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyPress** () and **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyRelease(
        self,
        window: QtGui.QWindow,
        key: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease-3

        **void QTest::keyRelease(QWidget * widget , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates releasing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        **See also** **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyPress(
        self,
        widget: QtWidgets.QWidget,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress

        **void QTest::keyPress(QWidget * widget , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates pressing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyPress(
        self,
        widget: QtWidgets.QWidget,
        key: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress-1

        **[since 5.0] void QTest::keyPress(QWindow * window , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates pressing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyPress(
        self,
        window: QtGui.QWindow,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress-2

        **[since 5.0] void QTest::keyPress(QWindow * window , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates pressing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyPress(
        self,
        window: QtGui.QWindow,
        key: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress-3

        **void QTest::keyPress(QWidget * widget , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates pressing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyEvent(
        self,
        action: "QTest.KeyAction",
        widget: QtWidgets.QWidget,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent

        **void QTest::keyEvent(QTest::KeyAction action , QWidget * widget ,
        Qt::Key key , Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay
        = -1)**

        Sends a Qt key event to **widget** with the given **key** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.
        """
        ...

    @typing.overload
    def keyEvent(
        self,
        action: "QTest.KeyAction",
        widget: QtWidgets.QWidget,
        ascii: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent-1

        **[since 5.0] void QTest::keyEvent(QTest::KeyAction action , QWindow *
        window , char ascii , Qt::KeyboardModifiers modifier = Qt::NoModifier,
        int delay = -1)**

        This is an overloaded function.

        Sends a Qt key event to **window** with the given key **ascii** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.

        This function was introduced in Qt 5.0.
        """
        ...

    @typing.overload
    def keyEvent(
        self,
        action: "QTest.KeyAction",
        window: QtGui.QWindow,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent-2

        **[since 5.0] void QTest::keyEvent(QTest::KeyAction action , QWindow *
        window , Qt::Key key , Qt::KeyboardModifiers modifier = Qt::NoModifier,
        int delay = -1)**

        This is an overloaded function.

        Sends a Qt key event to **window** with the given **key** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.

        This function was introduced in Qt 5.0.
        """
        ...

    @typing.overload
    def keyEvent(
        self,
        action: "QTest.KeyAction",
        window: QtGui.QWindow,
        ascii: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent-3

        **void QTest::keyEvent(QTest::KeyAction action , QWidget * widget , char
        ascii , Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay =
        -1)**

        This is an overloaded function.

        Sends a Qt key event to **widget** with the given key **ascii** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.
        """
        ...

    def keyClicks(
        self,
        widget: QtWidgets.QWidget,
        sequence: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClicks

        **void QTest::keyClicks(QWidget * widget , const QString & sequence ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates clicking a **sequence** of keys on a **widget**. Optionally, a
        keyboard **modifier** can be specified as well as a **delay** (in
        milliseconds) of the test before each key click.

        Example:

        QTest::keyClicks(myWidget, "hello world");

        The example above simulates clicking the sequence of keys representing
        "hello world" on `myWidget` without any keyboard modifiers and without
        delay of the test.

        **See also** **QTest::keyClick** ().
        """
        ...

    @typing.overload
    def keyClick(
        self,
        widget: QtWidgets.QWidget,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick

        **void QTest::keyClick(QWidget * widget , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates clicking of **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Examples:

        QTest::keyClick(myWidget, Qt::Key_Escape);
        QTest::keyClick(myWidget, Qt::Key_Escape, Qt::ShiftModifier, 200);

        The first example above simulates clicking the `escape` key on
        `myWidget` without any keyboard modifiers and without delay. The second
        example simulates clicking `shift-escape` on `myWidget` following a 200
        ms delay of the test.

        **See also** **QTest::keyClicks** ().
        """
        ...

    @typing.overload
    def keyClick(
        self,
        widget: QtWidgets.QWidget,
        key: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick-1

        **[since 5.0] void QTest::keyClick(QWindow * window , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates clicking of **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Examples:

        QTest::keyClick(&myWindow, Qt::Key_Escape);
        QTest::keyClick(&myWindow, Qt::Key_Escape, Qt::ShiftModifier, 200);

        The first example above simulates clicking the `escape` key on
        `myWindow` without any keyboard modifiers and without delay. The second
        example simulates clicking `shift-escape` on `myWindow` following a 200
        ms delay of the test.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyClicks** ().
        """
        ...

    @typing.overload
    def keyClick(
        self,
        window: QtGui.QWindow,
        key: QtCore.Qt.Key,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick-2

        **[since 5.0] void QTest::keyClick(QWindow * window , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates clicking of **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Example:

        **QWidget**  myWindow;
            QTest::keyClick(&myWindow, Qt::Key_Tab);

        The example above simulates clicking `a` on `myWindow` without any
        keyboard modifiers and without delay of the test.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyClicks** ().
        """
        ...

    @typing.overload
    def keyClick(
        self,
        window: QtGui.QWindow,
        key: str,
        modifier: QtCore.Qt.KeyboardModifier = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick-3

        **void QTest::keyClick(QWidget * widget , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates clicking of **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Example:

        QTest::keyClick(myWidget, 'a');

        The example above simulates clicking `a` on `myWidget` without any
        keyboard modifiers and without delay of the test.

        **See also** **QTest::keyClicks** ().
        """
        ...
