"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtNetwork
from PyQt6 import QtCore
from PyQt6.QtWebSockets import *
import enum


class QWebSocketServer(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebsocketserver.html

    **Detailed Description**

    It is modeled after **QTcpServer** , and behaves the same. So, if you know
    how to use **QTcpServer** , you know how to use QWebSocketServer. This class
    makes it possible to accept incoming WebSocket connections. You can specify
    the port or have QWebSocketServer pick one automatically. You can listen on
    a specific address or on all the machine's addresses. Call **listen** () to
    have the server listen for incoming connections.

    The **newConnection** () signal is then emitted each time a client connects
    to the server. Call **nextPendingConnection** () to accept the pending
    connection as a connected **QWebSocket** . The function returns a pointer to
    a **QWebSocket**  in **QAbstractSocket::ConnectedState**  that you can use
    for communicating with the client.

    If an error occurs, **serverError** () returns the type of error, and
    **errorString** () can be called to get a human readable description of what
    happened.

    When listening for connections, the address and port on which the server is
    listening are available as **serverAddress** () and **serverPort** ().

    Calling **close** () makes QWebSocketServer stop listening for incoming
    connections.

    QWebSocketServer currently does not support **WebSocket Extensions**  and
    **WebSocket Subprotocols** .

    **Note:** When working with self-signed certificates, **Firefox bug 594502**
    prevents **Firefox**  to connect to a secure WebSocket server. To work
    around this problem, first browse to the secure WebSocket server using
    HTTPS. FireFox will indicate that the certificate is invalid. From here on,
    the certificate can be added to the exceptions. After this, the secure
    WebSockets connection should work.

    QWebSocketServer only supports version 13 of the WebSocket protocol, as
    outlined in **RFC 6455** .

    There is a default connection handshake timeout of 10 seconds to avoid
    denial of service, which can be customized using **setHandshakeTimeout** ().

    **See also** **WebSocket Server Example**  and **QWebSocket** .
    """

    class SslMode(enum.Enum):
        SecureMode: QWebSocketServer = ...
        NonSecureMode: QWebSocketServer = ...

    def __init__(
        self,
        serverName: str,
        secureMode: "QWebSocketServer.SslMode",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#QWebSocketServer-1

        **QWebSocketServer::QWebSocketServer(const QString & serverName ,
        QWebSocketServer::SslMode secureMode , QObject * parent = nullptr)**

        Constructs a new QWebSocketServer with the given **serverName**. The
        **serverName** will be used in the HTTP handshake phase to identify the
        server. It can be empty, in which case no server name will be sent to
        the client. The **secureMode** parameter indicates whether the server
        operates over wss (**SecureMode** ) or over ws (**NonSecureMode** ).

        **parent** is passed to the **QObject**  constructor.
        """
        ...

    def handshakeTimeoutMS(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#handshakeTimeoutMS

        **[since 5.14] int QWebSocketServer::handshakeTimeoutMS() const**

        Returns the handshake timeout for new connections in milliseconds.

        The default is 10 seconds. If a peer uses more time to complete the
        handshake their connection is closed.

        This function was introduced in Qt 5.14.

        **See also** **setHandshakeTimeout** () and **handshakeTimeout** ().
        """
        ...

    def setHandshakeTimeout(self, msec: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#setHandshakeTimeout

        **[since 5.14] void
        QWebSocketServer::setHandshakeTimeout(std::chrono::milliseconds msec )**

        Sets the handshake timeout for new connections to **msec** milliseconds.

        By default this is set to 10 seconds. If a peer uses more time to
        complete the handshake, their connection is closed. You can pass a
        negative value (e.g. -1) to disable the timeout.

        This function was introduced in Qt 5.14.

        **See also** **handshakeTimeout** () and **handshakeTimeoutMS** ().
        """
        ...

    def handleConnection(self, socket: QtNetwork.QTcpSocket) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#handleConnection

        **[since 5.9] void QWebSocketServer::handleConnection(QTcpSocket *
        socket ) const**

        Upgrades a tcp **socket** to websocket.

        The **QWebSocketServer**  object will take ownership of the socket
        object and delete it when appropriate.

        This function was introduced in Qt 5.9.
        """
        ...

    def serverUrl(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#serverUrl

        **QUrl QWebSocketServer::serverUrl() const**

        Returns a URL clients can use to connect to this server if the server is
        listening for connections. Otherwise an invalid URL is returned.

        **See also** **serverPort** (), **serverAddress** (), and **listen** ().
        """
        ...

    def supportedVersions(self) -> typing.List[QWebSocketProtocol.Version]:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#supportedVersions

        **QList<QWebSocketProtocol::Version>
        QWebSocketServer::supportedVersions() const**

        Returns a list of WebSocket versions that this server is supporting.
        """
        ...

    def sslConfiguration(self) -> QtNetwork.QSslConfiguration:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#sslConfiguration

        **QSslConfiguration QWebSocketServer::sslConfiguration() const**

        Returns the SSL configuration used by the **QWebSocketServer** . If the
        server is not running in secure mode (**QWebSocketServer::SecureMode**
        ), this method returns **QSslConfiguration::defaultConfiguration** ().

        **See also** **setSslConfiguration** (), **SslMode** , and
        **QSslConfiguration::defaultConfiguration** ().
        """
        ...

    def setSslConfiguration(
        self, sslConfiguration: QtNetwork.QSslConfiguration
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#setSslConfiguration

        **void QWebSocketServer::setSslConfiguration(const QSslConfiguration &
        sslConfiguration )**

        Sets the SSL configuration for the **QWebSocketServer**  to
        **sslConfiguration**. This method has no effect if **QWebSocketServer**
        runs in non-secure mode (**QWebSocketServer::NonSecureMode** ).

        **See also** **sslConfiguration** () and **SslMode** .
        """
        ...

    def proxy(self) -> QtNetwork.QNetworkProxy:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#proxy

        **QNetworkProxy QWebSocketServer::proxy() const**

        Returns the network proxy for this server. By default
        **QNetworkProxy::DefaultProxy**  is used.

        **See also** **setProxy** ().
        """
        ...

    def setProxy(self, networkProxy: QtNetwork.QNetworkProxy) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#setProxy

        **void QWebSocketServer::setProxy(const QNetworkProxy & networkProxy )**

        Sets the explicit network proxy for this server to **networkProxy**.

        To disable the use of a proxy, use the **QNetworkProxy::NoProxy**  proxy
        type:

        server->setProxy(**QNetworkProxy** ::NoProxy);

        **See also** **proxy** ().
        """
        ...

    def serverName(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#serverName

        **QString QWebSocketServer::serverName() const**

        Returns the server name that is used during the http handshake phase.

        **See also** **setServerName** ().
        """
        ...

    def setServerName(self, serverName: str) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#setServerName

        **void QWebSocketServer::setServerName(const QString & serverName )**

        Sets the server name that will be used during the HTTP handshake phase
        to the given **serverName**. The **serverName** can be empty, in which
        case an empty server name will be sent to the client. Existing connected
        clients will not be notified of this change, only newly connecting
        clients will see this new name.

        **See also** **serverName** ().
        """
        ...

    def resumeAccepting(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#resumeAccepting

        **void QWebSocketServer::resumeAccepting()**

        Resumes accepting new connections.

        **See also** **pauseAccepting** ().
        """
        ...

    def pauseAccepting(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#pauseAccepting

        **void QWebSocketServer::pauseAccepting()**

        Pauses incoming new connections. Queued connections will remain in
        queue.

        **See also** **resumeAccepting** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#errorString

        **QString QWebSocketServer::errorString() const**

        Returns a human readable description of the last error that occurred. If
        no error occurred, an empty string is returned.

        **See also** **serverError** ().
        """
        ...

    def error(self) -> QWebSocketProtocol.CloseCode:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#error

        **QWebSocketProtocol::CloseCode QWebSocketServer::error() const**

        Returns an error code for the last error that occurred. If no error
        occurred, **QWebSocketProtocol::CloseCodeNormal**  is returned.

        **See also** **errorString** ().
        """
        ...

    def nextPendingConnection(self) -> QWebSocket:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#nextPendingConnection

        **[virtual] QWebSocket *QWebSocketServer::nextPendingConnection()**

        Returns the next pending connection as a connected **QWebSocket**
        object. **QWebSocketServer**  does not take ownership of the returned
        **QWebSocket**  object. It is up to the caller to delete the object
        explicitly when it will no longer be used, otherwise a memory leak will
        occur. nullptr is returned if this function is called when there are no
        pending connections.

        Note: The returned **QWebSocket**  object cannot be used from another
        thread.

        **See also** **hasPendingConnections** ().
        """
        ...

    def hasPendingConnections(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#hasPendingConnections

        **bool QWebSocketServer::hasPendingConnections() const**

        Returns true if the server has pending connections; otherwise returns
        false.

        **See also** **nextPendingConnection** () and
        **setMaxPendingConnections** ().
        """
        ...

    def socketDescriptor(self) -> PyQt6.sip.voidptr:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#socketDescriptor

        **[since 5.3] qintptr QWebSocketServer::socketDescriptor() const**

        Returns the native socket descriptor the server uses to listen for
        incoming instructions, or -1 if the server is not listening. If the
        server is using **QNetworkProxy** , the returned descriptor may not be
        usable with native socket functions.

        This function was introduced in Qt 5.3.

        **See also** **setSocketDescriptor** () and **isListening** ().
        """
        ...

    def setSocketDescriptor(self, socketDescriptor: PyQt6.sip.voidptr) -> bool:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#setSocketDescriptor

        **[since 5.3] bool QWebSocketServer::setSocketDescriptor(qintptr
        socketDescriptor )**

        Sets the socket descriptor this server should use when listening for
        incoming connections to **socketDescriptor**.

        Returns true if the socket is set successfully; otherwise returns false.
        The socket is assumed to be in listening state.

        This function was introduced in Qt 5.3.

        **See also** **socketDescriptor** () and **isListening** ().
        """
        ...

    def secureMode(self) -> "QWebSocketServer.SslMode":
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#secureMode

        **QWebSocketServer::SslMode QWebSocketServer::secureMode() const**

        Returns the secure mode the server is running in.

        **See also** **QWebSocketServer** () and **SslMode** .
        """
        ...

    def serverAddress(self) -> QtNetwork.QHostAddress:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#serverAddress

        **QHostAddress QWebSocketServer::serverAddress() const**

        Returns the server's address if the server is listening for connections;
        otherwise returns **QHostAddress::Null** .

        **See also** **serverPort** () and **listen** ().
        """
        ...

    def serverPort(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#serverPort

        **quint16 QWebSocketServer::serverPort() const**

        Returns the server's port if the server is listening for connections;
        otherwise returns 0.

        **See also** **serverAddress** () and **listen** ().
        """
        ...

    def maxPendingConnections(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#maxPendingConnections

        **int QWebSocketServer::maxPendingConnections() const**

        Returns the maximum number of pending accepted connections. The default
        is 30.

        **See also** **setMaxPendingConnections** () and
        **hasPendingConnections** ().
        """
        ...

    def setMaxPendingConnections(self, numConnections: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#setMaxPendingConnections

        **void QWebSocketServer::setMaxPendingConnections(int numConnections )**

        Sets the maximum number of pending accepted connections to
        **numConnections**. **WebSocketServer**  will accept no more than
        **numConnections** incoming connections before **nextPendingConnection**
        () is called. By default, the limit is 30 pending connections.

        **QWebSocketServer**  will emit the **error** () signal with the
        **QWebSocketProtocol::CloseCodeAbnormalDisconnection**  close code when
        the maximum of connections has been reached. The WebSocket handshake
        will fail and the socket will be closed.

        **See also** **maxPendingConnections** () and **hasPendingConnections**
        ().
        """
        ...

    def isListening(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#isListening

        **bool QWebSocketServer::isListening() const**

        Returns true if the server is currently listening for incoming
        connections; otherwise returns false. If listening fails, **error** ()
        will return the reason.

        **See also** **listen** () and **error** ().
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#close

        **void QWebSocketServer::close()**

        Closes the server. The server will no longer listen for incoming
        connections.
        """
        ...

    def listen(
        self,
        address: typing.Union[
            QtNetwork.QHostAddress, QtNetwork.QHostAddress.SpecialAddress
        ] = ...,
        port: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#listen

        **bool QWebSocketServer::listen(const QHostAddress & address =
        QHostAddress::Any, quint16 port = 0)**

        Tells the server to listen for incoming connections on address
        **address** and port **port**. If **port** is 0, a port is chosen
        automatically. If **address** is **QHostAddress::Any** , the server will
        listen on all network interfaces.

        Returns true on success; otherwise returns false.

        **See also** **isListening** ().
        """
        ...

    @property
    def acceptError(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#acceptError

        **[signal] void
        QWebSocketServer::acceptError(QAbstractSocket::SocketError socketError
        )**

        This signal is emitted when the acceptance of a new connection results
        in an error. The **socketError** parameter describes the type of error
        that occurred.

        **See also** **pauseAccepting** () and **resumeAccepting** ().
        """
        ...

    @property
    def alertReceived(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#alertReceived

        **[signal, since 6.2] void
        QWebSocketServer::alertReceived(QSsl::AlertLevel level , QSsl::AlertType
        type , const QString & description )**

        **QWebSocketServer**  emits this signal if an alert message was received
        from a peer. **level** tells if the alert was fatal or it was a warning.
        **type** is the code explaining why the alert was sent. When a textual
        description of the alert message is available, it is supplied in
        **description**.

        **Note:** The signal is mostly for informational and debugging purposes
        and does not require any handling in the application. If the alert was
        fatal, underlying backend will handle it and close the connection.

        **Note:** Not all backends support this functionality.

        This function was introduced in Qt 6.2.

        **See also** **alertSent** (), **QSsl::AlertLevel** , and
        **QSsl::AlertType** .
        """
        ...

    @property
    def alertSent(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#alertSent

        **[signal, since 6.2] void QWebSocketServer::alertSent(QSsl::AlertLevel
        level , QSsl::AlertType type , const QString & description )**

        **QWebSocketServer**  emits this signal if an alert message was sent to
        a peer. **level** describes if it was a warning or a fatal error.
        **type** gives the code of the alert message. When a textual description
        of the alert message is available, it is supplied in **description**.

        **Note:** This signal is mostly informational and can be used for
        debugging purposes, normally it does not require any actions from the
        application.

        **Note:** Not all backends support this functionality.

        This function was introduced in Qt 6.2.

        **See also** **alertReceived** (), **QSsl::AlertLevel** , and
        **QSsl::AlertType** .
        """
        ...

    @property
    def closed(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#closed

        **[signal] void QWebSocketServer::closed()**

        This signal is emitted when the server closed its connection.

        **See also** **close** ().
        """
        ...

    @property
    def handshakeInterruptedOnError(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#handshakeInterruptedOnError

        **[signal, since 6.2] void
        QWebSocketServer::handshakeInterruptedOnError(const QSslError & error
        )**

        **QWebSocketServer**  emits this signal if a certificate verification
        **error** was found and if early error reporting was enabled in
        **QSslConfiguration** .

        This function was introduced in Qt 6.2.

        **See also** **sslErrors** () and
        **QSslConfiguration::setHandshakeMustInterruptOnError** ().
        """
        ...

    @property
    def newConnection(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#newConnection

        **[signal] void QWebSocketServer::newConnection()**

        This signal is emitted every time a new connection is available.

        **See also** **hasPendingConnections** () and **nextPendingConnection**
        ().
        """
        ...

    @property
    def originAuthenticationRequired(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#originAuthenticationRequire
        d

        **[signal] void QWebSocketServer::originAuthenticationRequired(QWebSocke
        tCorsAuthenticator * authenticator )**

        This signal is emitted when a new connection is requested. The slot
        connected to this signal should indicate whether the origin (which can
        be determined by the origin() call) is allowed in the **authenticator**
        object (by issuing **setAllowed** ()).

        If no slot is connected to this signal, all origins will be accepted by
        default.

        **Note:** It is not possible to use a QueuedConnection to connect to
        this signal, as the connection will always succeed.
        """
        ...

    @property
    def peerVerifyError(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#peerVerifyError

        **[signal] void QWebSocketServer::peerVerifyError(const QSslError &
        error )**

        **QWebSocketServer**  can emit this signal several times during the SSL
        handshake, before encryption has been established, to indicate that an
        error has occurred while establishing the identity of the peer. The
        **error** is usually an indication that **QWebSocketServer**  is unable
        to securely identify the peer.

        This signal provides you with an early indication when something is
        wrong. By connecting to this signal, you can manually choose to tear
        down the connection from inside the connected slot before the handshake
        has completed. If no action is taken, **QWebSocketServer**  will proceed
        to emitting **QWebSocketServer::sslErrors** ().

        **See also** **sslErrors** ().
        """
        ...

    @property
    def preSharedKeyAuthenticationRequired(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#preSharedKeyAuthenticationR
        equired

        **[signal, since 5.8] void QWebSocketServer::preSharedKeyAuthenticationR
        equired(QSslPreSharedKeyAuthenticator * authenticator )**

        **QWebSocketServer**  emits this signal when it negotiates a PSK
        ciphersuite, and therefore a PSK authentication is then required.

        When using PSK, the client must send to the server a valid identity and
        a valid pre shared key, in order for the SSL handshake to continue.
        Applications can provide this information in a slot connected to this
        signal, by filling in the passed **authenticator** object according to
        their needs.

        **Note:** Ignoring this signal, or failing to provide the required
        credentials, will cause the handshake to fail, and therefore the
        connection to be aborted.

        **Note:** The **authenticator** object is owned by the socket and must
        not be deleted by the application.

        This function was introduced in Qt 5.8.

        **See also** **QSslPreSharedKeyAuthenticator**  and
        **QSslSocket::preSharedKeyAuthenticationRequired** ().
        """
        ...

    @property
    def serverError(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#serverError

        **[signal] void
        QWebSocketServer::serverError(QWebSocketProtocol::CloseCode closeCode
        )**

        This signal is emitted when an error occurs during the setup of a
        WebSocket connection. The **closeCode** parameter describes the type of
        error that occurred

        **See also** **errorString** ().
        """
        ...

    @property
    def sslErrors(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qwebsocketserver.html#sslErrors

        **[signal] void QWebSocketServer::sslErrors(const QList<QSslError> &
        errors )**

        **QWebSocketServer**  emits this signal after the SSL handshake to
        indicate that one or more errors have occurred while establishing the
        identity of the peer. The errors are usually an indication that
        **QWebSocketServer**  is unable to securely identify the peer. Unless
        any action is taken, the connection will be dropped after this signal
        has been emitted.

        **errors** contains one or more errors that prevent **QSslSocket**  from
        verifying the identity of the peer.

        **See also** **peerVerifyError** ().
        """
        ...
