"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QAbstractItemView(QAbstractScrollArea):
    """
    https://doc.qt.io/qt-6/qabstractitemview.html

    **Detailed Description**

    QAbstractItemView class is the base class for every standard view that uses
    a **QAbstractItemModel** . QAbstractItemView is an abstract class and cannot
    itself be instantiated. It provides a standard interface for interoperating
    with models through the signals and slots mechanism, enabling subclasses to
    be kept up-to-date with changes to their models. This class provides
    standard support for keyboard and mouse navigation, viewport scrolling, item
    editing, and selections. The keyboard navigation implements this
    functionality:

    KeysFunctionality
    Arrow keysChanges the current item and selects it.
    Ctrl+Arrow keysChanges the current item but does not select it.
    Shift+Arrow keysChanges the current item and selects it. The previously
    selected item(s) is not deselected.
    Ctrl+SpaceToggles selection of the
    current item.
    Tab/BacktabChanges the current item to the next/previous
    item.
    Home/EndSelects the first/last item in the model.
    Page up/Page
    downScrolls the rows shown up/down by the number of visible rows in the
    view.
    Ctrl+ASelects all items in the model.

    Note that the above table assumes that the **selection mode**  allows the
    operations. For instance, you cannot select items if the selection mode is
    **QAbstractItemView::NoSelection** .

    The QAbstractItemView class is one of the **Model/View Classes**  and is
    part of Qt's **model/view framework** .

    The view classes that inherit QAbstractItemView only need to implement their
    own view-specific functionality, such as drawing items, returning the
    geometry of items, finding items, etc.

    QAbstractItemView provides common slots such as **edit** () and
    **setCurrentIndex** (). Many protected slots are also provided, including
    **dataChanged** (), **rowsInserted** (), **rowsAboutToBeRemoved** (),
    **selectionChanged** (), and **currentChanged** ().

    The root item is returned by **rootIndex** (), and the current item by
    **currentIndex** (). To make sure that an item is visible use **scrollTo**
    ().

    Some of QAbstractItemView's functions are concerned with scrolling, for
    example **setHorizontalScrollMode** () and **setVerticalScrollMode** (). To
    set the range of the scroll bars, you can, for example, reimplement the
    view's **resizeEvent** () function:

    void MyView::resizeEvent(**QResizeEvent**  *event) {
    horizontalScrollBar()->setRange(0, realWidth - width());
            ...
        }

    Note that the range is not updated until the widget is shown.

    Several other functions are concerned with selection control; for example
    **setSelectionMode** (), and **setSelectionBehavior** (). This class
    provides a default selection model to work with (**selectionModel** ()), but
    this can be replaced by using **setSelectionModel** () with an instance of
    **QItemSelectionModel** .

    For complete control over the display and editing of items you can specify a
    delegate with **setItemDelegate** ().

    QAbstractItemView provides a lot of protected functions. Some are concerned
    with editing, for example, **edit** (), and **commitData** (), whilst others
    are keyboard and mouse event handlers.

    **Note:** If you inherit QAbstractItemView and intend to update the contents
    of the viewport, you should use viewport->**update** () instead of
    **update** () as all painting operations take place on the viewport.

    **See also** **View Classes** , **Model/View Programming** ,
    **QAbstractItemModel** , and **Chart Example** .
    """

    class DropIndicatorPosition(enum.Enum):
        OnItem: QAbstractItemView = ...
        AboveItem: QAbstractItemView = ...
        BelowItem: QAbstractItemView = ...
        OnViewport: QAbstractItemView = ...

    class State(enum.Enum):
        NoState: QAbstractItemView = ...
        DraggingState: QAbstractItemView = ...
        DragSelectingState: QAbstractItemView = ...
        EditingState: QAbstractItemView = ...
        ExpandingState: QAbstractItemView = ...
        CollapsingState: QAbstractItemView = ...
        AnimatingState: QAbstractItemView = ...

    class CursorAction(enum.Enum):
        MoveUp: QAbstractItemView = ...
        MoveDown: QAbstractItemView = ...
        MoveLeft: QAbstractItemView = ...
        MoveRight: QAbstractItemView = ...
        MoveHome: QAbstractItemView = ...
        MoveEnd: QAbstractItemView = ...
        MovePageUp: QAbstractItemView = ...
        MovePageDown: QAbstractItemView = ...
        MoveNext: QAbstractItemView = ...
        MovePrevious: QAbstractItemView = ...

    class SelectionMode(enum.Enum):
        NoSelection: QAbstractItemView = ...
        SingleSelection: QAbstractItemView = ...
        MultiSelection: QAbstractItemView = ...
        ExtendedSelection: QAbstractItemView = ...
        ContiguousSelection: QAbstractItemView = ...

    class SelectionBehavior(enum.Enum):
        SelectItems: QAbstractItemView = ...
        SelectRows: QAbstractItemView = ...
        SelectColumns: QAbstractItemView = ...

    class ScrollMode(enum.Enum):
        ScrollPerItem: QAbstractItemView = ...
        ScrollPerPixel: QAbstractItemView = ...

    class ScrollHint(enum.Enum):
        EnsureVisible: QAbstractItemView = ...
        PositionAtTop: QAbstractItemView = ...
        PositionAtBottom: QAbstractItemView = ...
        PositionAtCenter: QAbstractItemView = ...

    class EditTrigger(enum.Flag):
        NoEditTriggers: QAbstractItemView = ...
        CurrentChanged: QAbstractItemView = ...
        DoubleClicked: QAbstractItemView = ...
        SelectedClicked: QAbstractItemView = ...
        EditKeyPressed: QAbstractItemView = ...
        AnyKeyPressed: QAbstractItemView = ...
        AllEditTriggers: QAbstractItemView = ...

    class DragDropMode(enum.Enum):
        NoDragDrop: QAbstractItemView = ...
        DragOnly: QAbstractItemView = ...
        DropOnly: QAbstractItemView = ...
        DragDrop: QAbstractItemView = ...
        InternalMove: QAbstractItemView = ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#QAbstractItemView

        **QAbstractItemView::QAbstractItemView(QWidget * parent = nullptr)**

        Constructs an abstract item view with the given **parent**.
        """
        ...

    def initViewItemOption(self, option: "QStyleOptionViewItem") -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#initViewItemOption

        **[virtual protected, since 6.0] void
        QAbstractItemView::initViewItemOption(QStyleOptionViewItem * option )
        const**

        Initialize the **option** structure with the view's palette, font,
        state, alignments etc.

        **Note:** Implementations of this methods should check the **version**
        of the structure received, populate all members the implementation is
        familiar with, and set the version member to the one supported by the
        implementation before returning.

        This function was introduced in Qt 6.0.
        """
        ...

    def isPersistentEditorOpen(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#isPersistentEditorOpen

        **[since 5.10] bool QAbstractItemView::isPersistentEditorOpen(const
        QModelIndex & index ) const**

        Returns whether a persistent editor is open for the item at index
        **index**.

        This function was introduced in Qt 5.10.

        **See also** **openPersistentEditor** () and **closePersistentEditor**
        ().
        """
        ...

    def resetHorizontalScrollMode(self) -> None:
        ...

    def resetVerticalScrollMode(self) -> None:
        ...

    def defaultDropAction(self) -> QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#defaultDropAction-prop

        **defaultDropAction : Qt::DropAction**

        This property holds the drop action that will be used by default in
        QAbstractItemView::drag()

        If the property is not set, the drop action is CopyAction when the
        supported actions support CopyAction.

        **Access functions:**

        Qt::DropAction **defaultDropAction** () const
        void
        **setDefaultDropAction** (Qt::DropAction **dropAction** )

        **See also** **showDropIndicator**  and **dragDropOverwriteMode** .
        """
        ...

    def setDefaultDropAction(self, dropAction: QtCore.Qt.DropAction) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#defaultDropAction-prop

        **defaultDropAction : Qt::DropAction**

        This property holds the drop action that will be used by default in
        QAbstractItemView::drag()

        If the property is not set, the drop action is CopyAction when the
        supported actions support CopyAction.

        **Access functions:**

        Qt::DropAction **defaultDropAction** () const
        void
        **setDefaultDropAction** (Qt::DropAction **dropAction** )

        **See also** **showDropIndicator**  and **dragDropOverwriteMode** .
        """
        ...

    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#eventFilter

        **[override virtual protected] bool
        QAbstractItemView::eventFilter(QObject * object , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def viewportSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#viewportSizeHint

        **[override virtual protected, since 5.2] QSize
        QAbstractItemView::viewportSizeHint() const**

        Reimplements: **QAbstractScrollArea::viewportSizeHint() const** .

        This function was introduced in Qt 5.2.
        """
        ...

    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#inputMethodEvent

        **[override virtual protected] void
        QAbstractItemView::inputMethodEvent(QInputMethodEvent * event )**

        Reimplements: **QWidget::inputMethodEvent** (QInputMethodEvent *event).
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#focusNextPrevChild

        **[override virtual protected] bool
        QAbstractItemView::focusNextPrevChild(bool next )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def autoScrollMargin(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#autoScrollMargin-prop

        **autoScrollMargin : int**

        This property holds the size of the area when auto scrolling is
        triggered

        This property controls the size of the area at the edge of the viewport
        that triggers autoscrolling. The default value is 16 pixels.

        **Access functions:**

        int **autoScrollMargin** () const
        void **setAutoScrollMargin** (int
        **margin** )
        """
        ...

    def setAutoScrollMargin(self, margin: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#autoScrollMargin-prop

        **autoScrollMargin : int**

        This property holds the size of the area when auto scrolling is
        triggered

        This property controls the size of the area at the edge of the viewport
        that triggers autoscrolling. The default value is 16 pixels.

        **Access functions:**

        int **autoScrollMargin** () const
        void **setAutoScrollMargin** (int
        **margin** )
        """
        ...

    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#inputMethodQuery

        **[override virtual] QVariant
        QAbstractItemView::inputMethodQuery(Qt::InputMethodQuery query ) const**

        Reimplements: **QWidget::inputMethodQuery(Qt::InputMethodQuery query)
        const** .
        """
        ...

    def itemDelegateForIndex(self, index: QtCore.QModelIndex) -> QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#itemDelegateForIndex

        **[virtual, since 6.0] QAbstractItemDelegate
        *QAbstractItemView::itemDelegateForIndex(const QModelIndex & index )
        const**

        Returns the item delegate used by this view and model for the given
        **index**.

        This function was introduced in Qt 6.0.

        **See also** **setItemDelegate** (), **setItemDelegateForRow** (), and
        **setItemDelegateForColumn** ().
        """
        ...

    def itemDelegateForColumn(self, column: int) -> QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#itemDelegateForColumn

        **QAbstractItemDelegate *QAbstractItemView::itemDelegateForColumn(int
        column ) const**

        Returns the item delegate used by this view and model for the given
        **column**. You can call **itemDelegate** () to get a pointer to the
        current delegate for a given index.

        **See also** **setItemDelegateForColumn** (), **itemDelegateForRow** (),
        and **itemDelegate** ().
        """
        ...

    def setItemDelegateForColumn(
        self, column: int, delegate: QAbstractItemDelegate
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setItemDelegateForColumn

        **void QAbstractItemView::setItemDelegateForColumn(int column ,
        QAbstractItemDelegate * delegate )**

        Sets the given item **delegate** used by this view and model for the
        given **column**. All items on **column** will be drawn and managed by
        **delegate** instead of using the default delegate (i.e.,
        **itemDelegate** ()).

        Any existing column delegate for **column** will be removed, but not
        deleted. **QAbstractItemView**  does not take ownership of **delegate**.

        **Note:** If a delegate has been assigned to both a row and a column,
        the row delegate will take precedence and manage the intersecting cell
        index.

        **Warning:** You should not share the same instance of a delegate
        between views. Doing so can cause incorrect or unintuitive editing
        behavior since each view connected to a given delegate may receive the
        **closeEditor** () signal, and attempt to access, modify or close an
        editor that has already been closed.

        **See also** **itemDelegateForColumn** (), **setItemDelegateForRow** (),
        and **itemDelegate** ().
        """
        ...

    def itemDelegateForRow(self, row: int) -> QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#itemDelegateForRow

        **QAbstractItemDelegate *QAbstractItemView::itemDelegateForRow(int row )
        const**

        Returns the item delegate used by this view and model for the given
        **row** , or `nullptr` if no delegate has been assigned. You can call
        **itemDelegate** () to get a pointer to the current delegate for a given
        index.

        **See also** **setItemDelegateForRow** (), **itemDelegateForColumn** (),
        and **setItemDelegate** ().
        """
        ...

    def setItemDelegateForRow(self, row: int, delegate: QAbstractItemDelegate) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setItemDelegateForRow

        **void QAbstractItemView::setItemDelegateForRow(int row ,
        QAbstractItemDelegate * delegate )**

        Sets the given item **delegate** used by this view and model for the
        given **row**. All items on **row** will be drawn and managed by
        **delegate** instead of using the default delegate (i.e.,
        **itemDelegate** ()).

        Any existing row delegate for **row** will be removed, but not deleted.
        **QAbstractItemView**  does not take ownership of **delegate**.

        **Note:** If a delegate has been assigned to both a row and a column,
        the row delegate (i.e., this delegate) will take precedence and manage
        the intersecting cell index.

        **Warning:** You should not share the same instance of a delegate
        between views. Doing so can cause incorrect or unintuitive editing
        behavior since each view connected to a given delegate may receive the
        **closeEditor** () signal, and attempt to access, modify or close an
        editor that has already been closed.

        **See also** **itemDelegateForRow** (), **setItemDelegateForColumn** (),
        and **itemDelegate** ().
        """
        ...

    def dragDropMode(self) -> "QAbstractItemView.DragDropMode":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragDropMode-prop

        **dragDropMode : DragDropMode**

        This property holds the drag and drop event the view will act upon

        **Access functions:**

        QAbstractItemView::DragDropMode **dragDropMode** () const
        void
        **setDragDropMode** (QAbstractItemView::DragDropMode **behavior** )

        **See also** **showDropIndicator**  and **dragDropOverwriteMode** .
        """
        ...

    def setDragDropMode(self, behavior: "QAbstractItemView.DragDropMode") -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragDropMode-prop

        **dragDropMode : DragDropMode**

        This property holds the drag and drop event the view will act upon

        **Access functions:**

        QAbstractItemView::DragDropMode **dragDropMode** () const
        void
        **setDragDropMode** (QAbstractItemView::DragDropMode **behavior** )

        **See also** **showDropIndicator**  and **dragDropOverwriteMode** .
        """
        ...

    def dragDropOverwriteMode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragDropOverwriteMode-prop

        **dragDropOverwriteMode : bool**

        This property holds the view's drag and drop behavior

        If its value is `true`, the selected data will overwrite the existing
        item data when dropped, while moving the data will clear the item. If
        its value is `false`, the selected data will be inserted as a new item
        when the data is dropped. When the data is moved, the item is removed as
        well.

        The default value is `false`, as in the **QListView**  and **QTreeView**
        subclasses. In the **QTableView**  subclass, on the other hand, the
        property has been set to `true`.

        Note: This is not intended to prevent overwriting of items. The model's
        implementation of flags() should do that by not returning
        **Qt::ItemIsDropEnabled** .

        **Access functions:**

        bool **dragDropOverwriteMode** () const
        void
        **setDragDropOverwriteMode** (bool **overwrite** )

        **See also** **dragDropMode** .
        """
        ...

    def setDragDropOverwriteMode(self, overwrite: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragDropOverwriteMode-prop

        **dragDropOverwriteMode : bool**

        This property holds the view's drag and drop behavior

        If its value is `true`, the selected data will overwrite the existing
        item data when dropped, while moving the data will clear the item. If
        its value is `false`, the selected data will be inserted as a new item
        when the data is dropped. When the data is moved, the item is removed as
        well.

        The default value is `false`, as in the **QListView**  and **QTreeView**
        subclasses. In the **QTableView**  subclass, on the other hand, the
        property has been set to `true`.

        Note: This is not intended to prevent overwriting of items. The model's
        implementation of flags() should do that by not returning
        **Qt::ItemIsDropEnabled** .

        **Access functions:**

        bool **dragDropOverwriteMode** () const
        void
        **setDragDropOverwriteMode** (bool **overwrite** )

        **See also** **dragDropMode** .
        """
        ...

    def horizontalScrollMode(self) -> "QAbstractItemView.ScrollMode":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#horizontalScrollMode-prop

        **horizontalScrollMode : ScrollMode**

        how the view scrolls its contents in the horizontal direction

        This property controls how the view scroll its contents horizontally.
        Scrolling can be done either per pixel or per item. Its default value
        comes from the style via the **QStyle::SH_ItemView_ScrollMode**  style
        hint.

        **Access functions:**

        QAbstractItemView::ScrollMode **horizontalScrollMode** () const
        void
        **setHorizontalScrollMode** (QAbstractItemView::ScrollMode **mode** )
        void **resetHorizontalScrollMode** ()
        """
        ...

    def setHorizontalScrollMode(self, mode: "QAbstractItemView.ScrollMode") -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#horizontalScrollMode-prop

        **horizontalScrollMode : ScrollMode**

        how the view scrolls its contents in the horizontal direction

        This property controls how the view scroll its contents horizontally.
        Scrolling can be done either per pixel or per item. Its default value
        comes from the style via the **QStyle::SH_ItemView_ScrollMode**  style
        hint.

        **Access functions:**

        QAbstractItemView::ScrollMode **horizontalScrollMode** () const
        void
        **setHorizontalScrollMode** (QAbstractItemView::ScrollMode **mode** )
        void **resetHorizontalScrollMode** ()
        """
        ...

    def verticalScrollMode(self) -> "QAbstractItemView.ScrollMode":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#verticalScrollMode-prop

        **verticalScrollMode : ScrollMode**

        how the view scrolls its contents in the vertical direction

        This property controls how the view scroll its contents vertically.
        Scrolling can be done either per pixel or per item. Its default value
        comes from the style via the **QStyle::SH_ItemView_ScrollMode**  style
        hint.

        **Access functions:**

        QAbstractItemView::ScrollMode **verticalScrollMode** () const
        void
        **setVerticalScrollMode** (QAbstractItemView::ScrollMode **mode** )
        void **resetVerticalScrollMode** ()

        **Member Function Documentation**
        """
        ...

    def setVerticalScrollMode(self, mode: "QAbstractItemView.ScrollMode") -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#verticalScrollMode-prop

        **verticalScrollMode : ScrollMode**

        how the view scrolls its contents in the vertical direction

        This property controls how the view scroll its contents vertically.
        Scrolling can be done either per pixel or per item. Its default value
        comes from the style via the **QStyle::SH_ItemView_ScrollMode**  style
        hint.

        **Access functions:**

        QAbstractItemView::ScrollMode **verticalScrollMode** () const
        void
        **setVerticalScrollMode** (QAbstractItemView::ScrollMode **mode** )
        void **resetVerticalScrollMode** ()

        **Member Function Documentation**
        """
        ...

    def dropIndicatorPosition(self) -> "QAbstractItemView.DropIndicatorPosition":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dropIndicatorPosition

        **[protected] QAbstractItemView::DropIndicatorPosition
        QAbstractItemView::dropIndicatorPosition() const**

        Returns the position of the drop indicator in relation to the closest
        item.
        """
        ...

    def timerEvent(self, e: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#timerEvent

        **[override virtual protected] void
        QAbstractItemView::timerEvent(QTimerEvent * event )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).

        This function is called with the given **event** when a timer event is
        sent to the widget.

        **See also** **QObject::timerEvent** ().
        """
        ...

    def resizeEvent(self, e: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#resizeEvent

        **[override virtual protected] void
        QAbstractItemView::resizeEvent(QResizeEvent * event )**

        Reimplements: **QAbstractScrollArea::resizeEvent** (QResizeEvent
        *event).

        This function is called with the given **event** when a resize event is
        sent to the widget.

        **See also** **QWidget::resizeEvent** ().
        """
        ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#keyPressEvent

        **[override virtual protected] void
        QAbstractItemView::keyPressEvent(QKeyEvent * event )**

        Reimplements: **QAbstractScrollArea::keyPressEvent** (QKeyEvent *e).

        This function is called with the given **event** when a key event is
        sent to the widget. The default implementation handles basic cursor
        movement, e.g. Up, Down, Left, Right, Home, PageUp, and PageDown; the
        **activated** () signal is emitted if the current index is valid and the
        activation key is pressed (e.g. Enter or Return, depending on the
        platform). This function is where editing is initiated by key press,
        e.g. if F2 is pressed.

        **See also** **edit** (), **moveCursor** (), **keyboardSearch** (), and
        **tabKeyNavigation** .
        """
        ...

    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#focusOutEvent

        **[override virtual protected] void
        QAbstractItemView::focusOutEvent(QFocusEvent * event )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).

        This function is called with the given **event** when the widget loses
        the focus. By default, the event is ignored.

        **See also** **clearFocus** () and **focusInEvent** ().
        """
        ...

    def focusInEvent(self, e: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#focusInEvent

        **[override virtual protected] void
        QAbstractItemView::focusInEvent(QFocusEvent * event )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).

        This function is called with the given **event** when the widget obtains
        the focus. By default, the event is ignored.

        **See also** **setFocus** () and **focusOutEvent** ().
        """
        ...

    def dropEvent(self, e: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dropEvent

        **[override virtual protected] void
        QAbstractItemView::dropEvent(QDropEvent * event )**

        Reimplements: **QAbstractScrollArea::dropEvent** (QDropEvent *event).

        This function is called with the given **event** when a drop event
        occurs over the widget. If the model accepts the even position the drop
        event is accepted; otherwise it is ignored.

        **See also** **startDrag** ().
        """
        ...

    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragLeaveEvent

        **[override virtual protected] void
        QAbstractItemView::dragLeaveEvent(QDragLeaveEvent * event )**

        Reimplements: **QAbstractScrollArea::dragLeaveEvent** (QDragLeaveEvent
        *event).

        This function is called when the item being dragged leaves the view. The
        **event** describes the state of the drag and drop operation.
        """
        ...

    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragMoveEvent

        **[override virtual protected] void
        QAbstractItemView::dragMoveEvent(QDragMoveEvent * event )**

        Reimplements: **QAbstractScrollArea::dragMoveEvent** (QDragMoveEvent
        *event).

        This function is called continuously with the given **event** during a
        drag and drop operation over the widget. It can cause the view to scroll
        if, for example, the user drags a selection to view's right or bottom
        edge. In this case, the event will be accepted; otherwise it will be
        ignored.

        **See also** **dropEvent** () and **startDrag** ().
        """
        ...

    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragEnterEvent

        **[override virtual protected] void
        QAbstractItemView::dragEnterEvent(QDragEnterEvent * event )**

        Reimplements: **QAbstractScrollArea::dragEnterEvent** (QDragEnterEvent
        *event).

        This function is called with the given **event** when a drag and drop
        operation enters the widget. If the drag is over a valid dropping place
        (e.g. over an item that accepts drops), the event is accepted; otherwise
        it is ignored.

        **See also** **dropEvent** () and **startDrag** ().
        """
        ...

    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QAbstractItemView::mouseDoubleClickEvent(QMouseEvent * event )**

        Reimplements: **QAbstractScrollArea::mouseDoubleClickEvent**
        (QMouseEvent *e).

        This function is called with the given **event** when a mouse button is
        double clicked inside the widget. If the double-click is on a valid item
        it emits the **doubleClicked** () signal and calls **edit** () on the
        item.
        """
        ...

    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#mouseReleaseEvent

        **[override virtual protected] void
        QAbstractItemView::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QAbstractScrollArea::mouseReleaseEvent** (QMouseEvent
        *e).

        This function is called with the given **event** when a mouse button is
        released, after a mouse press event on the widget. If a user presses the
        mouse inside your widget and then drags the mouse to another location
        before releasing the mouse button, your widget receives the release
        event. The function will emit the **clicked** () signal if an item was
        being pressed.
        """
        ...

    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#mouseMoveEvent

        **[override virtual protected] void
        QAbstractItemView::mouseMoveEvent(QMouseEvent * event )**

        Reimplements: **QAbstractScrollArea::mouseMoveEvent** (QMouseEvent *e).

        This function is called with the given **event** when a mouse move event
        is sent to the widget. If a selection is in progress and new items are
        moved over the selection is extended; if a drag is in progress it is
        continued.
        """
        ...

    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#mousePressEvent

        **[override virtual protected] void
        QAbstractItemView::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QAbstractScrollArea::mousePressEvent** (QMouseEvent *e).

        This function is called with the given **event** when a mouse button is
        pressed while the cursor is inside the widget. If a valid item is
        pressed on it is made into the current item. This function emits the
        **pressed** () signal.
        """
        ...

    def viewportEvent(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#viewportEvent

        **[override virtual protected] bool
        QAbstractItemView::viewportEvent(QEvent * event )**

        Reimplements: **QAbstractScrollArea::viewportEvent** (QEvent *event).

        This function is used to handle tool tips, and What's This? mode, if the
        given **event** is a **QEvent::ToolTip** ,or a **QEvent::WhatsThis** .
        It passes all other events on to its base class viewportEvent() handler.

        Returns `true` if **event** has been recognized and processed;
        otherwise, returns `false`.
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#event

        **[override virtual protected] bool QAbstractItemView::event(QEvent *
        event )**

        Reimplements: **QAbstractScrollArea::event** (QEvent *event).
        """
        ...

    def dirtyRegionOffset(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dirtyRegionOffset

        **[protected] QPoint QAbstractItemView::dirtyRegionOffset() const**

        Returns the offset of the dirty regions in the view.

        If you use **scrollDirtyRegion** () and implement a **paintEvent** () in
        a subclass of **QAbstractItemView** , you should translate the area
        given by the paint event with the offset returned from this function.

        **See also** **scrollDirtyRegion** () and **setDirtyRegion** ().
        """
        ...

    def setDirtyRegion(self, region: QtGui.QRegion) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setDirtyRegion

        **[protected] void QAbstractItemView::setDirtyRegion(const QRegion &
        region )**

        Marks the given **region** as dirty and schedules it to be updated. You
        only need to call this function if you are implementing your own view
        subclass.

        **See also** **scrollDirtyRegion** () and **dirtyRegionOffset** ().
        """
        ...

    def scrollDirtyRegion(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#scrollDirtyRegion

        **[protected] void QAbstractItemView::scrollDirtyRegion(int dx , int dy
        )**

        Prepares the view for scrolling by ( **dx** , **dy** ) pixels by moving
        the dirty regions in the opposite direction. You only need to call this
        function if you are implementing a scrolling viewport in your view
        subclass.

        If you implement **scrollContentsBy** () in a subclass of
        **QAbstractItemView** , call this function before you call
        **QWidget::scroll** () on the viewport. Alternatively, just call
        **update** ().

        **See also** **scrollContentsBy** (), **dirtyRegionOffset** (), and
        **setDirtyRegion** ().
        """
        ...

    def executeDelayedItemsLayout(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#executeDelayedItemsLayout

        **[protected] void QAbstractItemView::executeDelayedItemsLayout()**

        Executes the scheduled layouts without waiting for the event processing
        to begin.

        **See also** **scheduleDelayedItemsLayout** ().
        """
        ...

    def scheduleDelayedItemsLayout(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#scheduleDelayedItemsLayout

        **[protected] void QAbstractItemView::scheduleDelayedItemsLayout()**

        Schedules a layout of the items in the view to be executed when the
        event processing starts.

        Even if scheduleDelayedItemsLayout() is called multiple times before
        events are processed, the view will only do the layout once.

        **See also** **executeDelayedItemsLayout** ().
        """
        ...

    def setState(self, state: "QAbstractItemView.State") -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setState

        **[protected] void QAbstractItemView::setState(QAbstractItemView::State
        state )**

        Sets the item view's state to the given **state**.

        **See also** **state** ().
        """
        ...

    def state(self) -> "QAbstractItemView.State":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#state

        **[protected] QAbstractItemView::State QAbstractItemView::state()
        const**

        Returns the item view's state.

        **See also** **setState** ().
        """
        ...

    def startDrag(self, supportedActions: QtCore.Qt.DropAction) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#startDrag

        **[virtual protected] void QAbstractItemView::startDrag(Qt::DropActions
        supportedActions )**

        Starts a drag by calling drag->exec() using the given
        **supportedActions**.
        """
        ...

    def selectionCommand(
        self, index: QtCore.QModelIndex, event: typing.Optional[QtCore.QEvent] = ...
    ) -> QtCore.QItemSelectionModel.SelectionFlag:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectionCommand

        **[virtual protected] QItemSelectionModel::SelectionFlags
        QAbstractItemView::selectionCommand(const QModelIndex & index , const
        QEvent * event = nullptr) const**

        Returns the SelectionFlags to be used when updating a selection with to
        include the **index** specified. The **event** is a user input event,
        such as a mouse or keyboard event.

        Reimplement this function to define your own selection behavior.

        **See also** **setSelection** ().
        """
        ...

    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectedIndexes

        **[virtual protected] QModelIndexList
        QAbstractItemView::selectedIndexes() const**

        This convenience function returns a list of all selected and non-hidden
        item indexes in the view. The list contains no duplicates, and is not
        sorted.

        **See also** **QItemSelectionModel::selectedIndexes** ().
        """
        ...

    def visualRegionForSelection(
        self, selection: QtCore.QItemSelection
    ) -> QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#visualRegionForSelection

        **[pure virtual protected] QRegion
        QAbstractItemView::visualRegionForSelection(const QItemSelection &
        selection ) const**

        Returns the region from the viewport of the items in the given
        **selection**.

        In the base class this is a pure virtual function.

        **See also** **visualRect** () and **selectedIndexes** ().
        """
        ...

    def setSelection(
        self, rect: QtCore.QRect, command: QtCore.QItemSelectionModel.SelectionFlag
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setSelection

        **[pure virtual protected] void QAbstractItemView::setSelection(const
        QRect & rect , QItemSelectionModel::SelectionFlags flags )**

        Applies the selection **flags** to the items in or touched by the
        rectangle, **rect**.

        When implementing your own itemview setSelection should call
        **selectionModel** ()->select(selection, flags) where selection is
        either an empty **QModelIndex**  or a **QItemSelection**  that contains
        all items that are contained in **rect**.

        **See also** **selectionCommand** () and **selectedIndexes** ().
        """
        ...

    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#isIndexHidden

        **[pure virtual protected] bool QAbstractItemView::isIndexHidden(const
        QModelIndex & index ) const**

        Returns `true` if the item referred to by the given **index** is hidden
        in the view, otherwise returns `false`.

        Hiding is a view specific feature. For example in **TableView**  a
        column can be marked as hidden or a row in the TreeView.

        In the base class this is a pure virtual function.
        """
        ...

    def verticalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#verticalOffset

        **[pure virtual protected] int QAbstractItemView::verticalOffset()
        const**

        Returns the vertical offset of the view.

        In the base class this is a pure virtual function.

        **See also** **horizontalOffset** ().
        """
        ...

    def horizontalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#horizontalOffset

        **[pure virtual protected] int QAbstractItemView::horizontalOffset()
        const**

        Returns the horizontal offset of the view.

        In the base class this is a pure virtual function.

        **See also** **verticalOffset** ().
        """
        ...

    def moveCursor(
        self,
        cursorAction: "QAbstractItemView.CursorAction",
        modifiers: QtCore.Qt.KeyboardModifier,
    ) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#moveCursor

        **[pure virtual protected] QModelIndex
        QAbstractItemView::moveCursor(QAbstractItemView::CursorAction
        cursorAction , Qt::KeyboardModifiers modifiers )**

        Returns a **QModelIndex**  object pointing to the next object in the
        view, based on the given **cursorAction** and keyboard modifiers
        specified by **modifiers**.

        In the base class this is a pure virtual function.
        """
        ...

    def editorDestroyed(self, editor: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#editorDestroyed

        **[virtual protected slot] void
        QAbstractItemView::editorDestroyed(QObject * editor )**

        This function is called when the given **editor** has been destroyed.

        **See also** **closeEditor** ().
        """
        ...

    def commitData(self, editor: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#commitData

        **[virtual protected slot] void QAbstractItemView::commitData(QWidget *
        editor )**

        Commit the data in the **editor** to the model.

        **See also** **closeEditor** ().
        """
        ...

    def closeEditor(
        self, editor: QWidget, hint: QAbstractItemDelegate.EndEditHint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#closeEditor

        **[virtual protected slot] void QAbstractItemView::closeEditor(QWidget *
        editor , QAbstractItemDelegate::EndEditHint hint )**

        Closes the given **editor** , and releases it. The **hint** is used to
        specify how the view should respond to the end of the editing operation.
        For example, the hint may indicate that the next item in the view should
        be opened for editing.

        **See also** **edit** () and **commitData** ().
        """
        ...

    def horizontalScrollbarValueChanged(self, value: int) -> None:
        ...

    def verticalScrollbarValueChanged(self, value: int) -> None:
        ...

    def horizontalScrollbarAction(self, action: int) -> None:
        ...

    def verticalScrollbarAction(self, action: int) -> None:
        ...

    def updateGeometries(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#updateGeometries

        **[virtual protected slot] void QAbstractItemView::updateGeometries()**

        Updates the geometry of the child widgets of the view.
        """
        ...

    def updateEditorGeometries(self) -> None:
        ...

    def updateEditorData(self) -> None:
        ...

    def currentChanged(
        self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#currentChanged

        **[virtual protected slot] void QAbstractItemView::currentChanged(const
        QModelIndex & current , const QModelIndex & previous )**

        This slot is called when a new item becomes the current item. The
        previous current item is specified by the **previous** index, and the
        new item by the **current** index.

        If you want to know about changes to items see the **dataChanged** ()
        signal.
        """
        ...

    def selectionChanged(
        self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectionChanged

        **[virtual protected slot] void
        QAbstractItemView::selectionChanged(const QItemSelection & selected ,
        const QItemSelection & deselected )**

        This slot is called when the selection is changed. The previous
        selection (which may be empty), is specified by **deselected** , and the
        new selection by **selected**.

        **See also** **setSelection** ().
        """
        ...

    def rowsAboutToBeRemoved(
        self, parent: QtCore.QModelIndex, start: int, end: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#rowsAboutToBeRemoved

        **[virtual protected slot] void
        QAbstractItemView::rowsAboutToBeRemoved(const QModelIndex & parent , int
        start , int end )**

        This slot is called when rows are about to be removed. The deleted rows
        are those under the given **parent** from **start** to **end**
        inclusive.

        **See also** **rowsInserted** ().
        """
        ...

    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#rowsInserted

        **[virtual protected slot] void QAbstractItemView::rowsInserted(const
        QModelIndex & parent , int start , int end )**

        This slot is called when rows are inserted. The new rows are those under
        the given **parent** from **start** to **end** inclusive. The base class
        implementation calls fetchMore() on the model to check for more data.

        **See also** **rowsAboutToBeRemoved** ().
        """
        ...

    def dataChanged(
        self,
        topLeft: QtCore.QModelIndex,
        bottomRight: QtCore.QModelIndex,
        roles: typing.Iterable[int] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dataChanged

        **[virtual protected slot] void QAbstractItemView::dataChanged(const
        QModelIndex & topLeft , const QModelIndex & bottomRight , const
        QList<int> & roles = QList<int>())**

        This slot is called when items with the given **roles** are changed in
        the model. The changed items are those from **topLeft** to
        **bottomRight** inclusive. If just one item is changed **topLeft** ==
        **bottomRight**.

        The **roles** which have been changed can either be an empty container
        (meaning everything has changed), or a non-empty container with the
        subset of roles which have changed.

        **Note:** : **Qt::ToolTipRole**  is not honored by dataChanged() in the
        views provided by Qt.
        """
        ...

    @typing.overload
    def update(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#update

        **[slot] void QAbstractItemView::update(const QModelIndex & index )**

        Updates the area occupied by the given **index**.
        """
        ...

    @typing.overload
    def update(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#update

        **[slot] void QAbstractItemView::update(const QModelIndex & index )**

        Updates the area occupied by the given **index**.
        """
        ...

    def scrollToBottom(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#scrollToBottom

        **[slot] void QAbstractItemView::scrollToBottom()**

        Scrolls the view to the bottom.

        **See also** **scrollTo** () and **scrollToTop** ().
        """
        ...

    def scrollToTop(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#scrollToTop

        **[slot] void QAbstractItemView::scrollToTop()**

        Scrolls the view to the top.

        **See also** **scrollTo** () and **scrollToBottom** ().
        """
        ...

    def setCurrentIndex(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setCurrentIndex

        **[slot] void QAbstractItemView::setCurrentIndex(const QModelIndex &
        index )**

        Sets the current item to be the item at **index**.

        Unless the current selection mode is **NoSelection** , the item is also
        selected. Note that this function also updates the starting position for
        any new selections the user performs.

        To set an item as the current item without selecting it, call

        `selectionModel()->setCurrentIndex(index,
        QItemSelectionModel::NoUpdate);`

        **See also** **currentIndex** (), **currentChanged** (), and
        **selectionMode** .
        """
        ...

    def clearSelection(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#clearSelection

        **[slot] void QAbstractItemView::clearSelection()**

        Deselects all selected items. The current index will not be changed.

        **See also** **setSelection** () and **selectAll** ().
        """
        ...

    @typing.overload
    def edit(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#edit

        **[slot] void QAbstractItemView::edit(const QModelIndex & index )**

        Starts editing the item corresponding to the given **index** if it is
        editable.

        Note that this function does not change the current index. Since the
        current index defines the next and previous items to edit, users may
        find that keyboard navigation does not work as expected. To provide
        consistent navigation behavior, call **setCurrentIndex** () before this
        function with the same model index.

        **See also** **QModelIndex::flags** ().
        """
        ...

    @typing.overload
    def edit(
        self,
        index: QtCore.QModelIndex,
        trigger: "QAbstractItemView.EditTrigger",
        event: QtCore.QEvent,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#edit-1

        **[virtual protected] bool QAbstractItemView::edit(const QModelIndex &
        index , QAbstractItemView::EditTrigger trigger , QEvent * event )**

        Starts editing the item at **index** , creating an editor if necessary,
        and returns `true` if the view's **State**  is now **EditingState** ;
        otherwise returns `false`.

        The action that caused the editing process is described by **trigger** ,
        and the associated event is specified by **event**.

        Editing can be forced by specifying the **trigger** to be
        **QAbstractItemView::AllEditTriggers** .

        **See also** **closeEditor** ().
        """
        ...

    def selectAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectAll

        **[virtual slot] void QAbstractItemView::selectAll()**

        Selects all items in the view. This function will use the selection
        behavior set on the view when selecting.

        **See also** **setSelection** (), **selectedIndexes** (), and
        **clearSelection** ().
        """
        ...

    def setRootIndex(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setRootIndex

        **[virtual slot] void QAbstractItemView::setRootIndex(const QModelIndex
        & index )**

        Sets the root item to the item at the given **index**.

        **See also** **rootIndex** ().
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#reset

        **[virtual slot] void QAbstractItemView::reset()**

        Reset the internal state of the view.

        **Warning:** This function will reset open editors, scroll bar
        positions, selections, etc. Existing changes will not be committed. If
        you would like to save your changes when resetting the view, you can
        reimplement this function, commit your changes, and then call the
        superclass' implementation.
        """
        ...

    def indexWidget(self, index: QtCore.QModelIndex) -> QWidget:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#indexWidget

        **QWidget *QAbstractItemView::indexWidget(const QModelIndex & index )
        const**

        Returns the widget for the item at the given **index**.

        **See also** **setIndexWidget** ().
        """
        ...

    def setIndexWidget(self, index: QtCore.QModelIndex, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setIndexWidget

        **void QAbstractItemView::setIndexWidget(const QModelIndex & index ,
        QWidget * widget )**

        Sets the given **widget** on the item at the given **index** , passing
        the ownership of the widget to the viewport.

        If **index** is invalid (e.g., if you pass the root index), this
        function will do nothing.

        The given **widget** 's **autoFillBackground**  property must be set to
        true, otherwise the widget's background will be transparent, showing
        both the model data and the item at the given **index**.

        If index widget A is replaced with index widget B, index widget A will
        be deleted. For example, in the code snippet below, the **QLineEdit**
        object will be deleted.

        setIndexWidget(index, new **QLineEdit** );
            ...
        setIndexWidget(index, new **QTextEdit** );

        This function should only be used to display static content within the
        visible area corresponding to an item of data. If you want to display
        custom dynamic content or implement a custom editor widget, subclass
        **QStyledItemDelegate**  instead.

        **See also** **indexWidget** () and **Delegate Classes** .
        """
        ...

    def closePersistentEditor(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#closePersistentEditor

        **void QAbstractItemView::closePersistentEditor(const QModelIndex &
        index )**

        Closes the persistent editor for the item at the given **index**.

        **See also** **openPersistentEditor** () and **isPersistentEditorOpen**
        ().
        """
        ...

    def openPersistentEditor(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#openPersistentEditor

        **void QAbstractItemView::openPersistentEditor(const QModelIndex & index
        )**

        Opens a persistent editor on the item at the given **index**. If no
        editor exists, the delegate will create a new editor.

        **See also** **closePersistentEditor** () and **isPersistentEditorOpen**
        ().
        """
        ...

    def sizeHintForColumn(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#sizeHintForColumn

        **[virtual] int QAbstractItemView::sizeHintForColumn(int column )
        const**

        Returns the width size hint for the specified **column** or -1 if there
        is no model.

        This function is used in views with a horizontal header to find the size
        hint for a header section based on the contents of the given **column**.

        **See also** **sizeHintForRow** ().
        """
        ...

    def sizeHintForRow(self, row: int) -> int:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#sizeHintForRow

        **[virtual] int QAbstractItemView::sizeHintForRow(int row ) const**

        Returns the height size hint for the specified **row** or -1 if there is
        no model.

        The returned height is calculated using the size hints of the given
        **row** 's items, i.e. the returned value is the maximum height among
        the items. Note that to control the height of a row, you must
        reimplement the **QAbstractItemDelegate::sizeHint** () function.

        This function is used in views with a vertical header to find the size
        hint for a header section based on the contents of the given **row**.

        **See also** **sizeHintForColumn** ().
        """
        ...

    def sizeHintForIndex(self, index: QtCore.QModelIndex) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#sizeHintForIndex

        **QSize QAbstractItemView::sizeHintForIndex(const QModelIndex & index )
        const**

        Returns the size hint for the item with the specified **index** or an
        invalid size for invalid indexes.

        **See also** **sizeHintForRow** () and **sizeHintForColumn** ().
        """
        ...

    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#indexAt

        **[pure virtual] QModelIndex QAbstractItemView::indexAt(const QPoint &
        point ) const**

        Returns the model index of the item at the viewport coordinates
        **point**.

        In the base class this is a pure virtual function.

        **See also** **visualRect** ().
        """
        ...

    def scrollTo(
        self, index: QtCore.QModelIndex, hint: "QAbstractItemView.ScrollHint" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#scrollTo

        **[pure virtual] void QAbstractItemView::scrollTo(const QModelIndex &
        index , QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Scrolls the view if necessary to ensure that the item at **index** is
        visible. The view will try to position the item according to the given
        **hint**.

        In the base class this is a pure virtual function.
        """
        ...

    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#visualRect

        **[pure virtual] QRect QAbstractItemView::visualRect(const QModelIndex &
        index ) const**

        Returns the rectangle on the viewport occupied by the item at **index**.

        If your item is displayed in several areas then visualRect should return
        the primary area that contains index and not the complete area that
        index might encompasses, touch or cause drawing.

        In the base class this is a pure virtual function.

        **See also** **indexAt** () and **visualRegionForSelection** ().
        """
        ...

    def keyboardSearch(self, search: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#keyboardSearch

        **[virtual] void QAbstractItemView::keyboardSearch(const QString &
        search )**

        Moves to and selects the item best matching the string **search**. If no
        item is found nothing happens.

        In the default implementation, the search is reset if **search** is
        empty, or the time interval since the last search has exceeded
        **QApplication::keyboardInputInterval** ().
        """
        ...

    def textElideMode(self) -> QtCore.Qt.TextElideMode:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#textElideMode-prop

        **textElideMode : Qt::TextElideMode**

        This property holds the position of the "..." in elided text.

        The default value for all item views is **Qt::ElideRight** .

        **Access functions:**

        Qt::TextElideMode **textElideMode** () const
        void **setTextElideMode**
        (Qt::TextElideMode **mode** )
        """
        ...

    def setTextElideMode(self, mode: QtCore.Qt.TextElideMode) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#textElideMode-prop

        **textElideMode : Qt::TextElideMode**

        This property holds the position of the "..." in elided text.

        The default value for all item views is **Qt::ElideRight** .

        **Access functions:**

        Qt::TextElideMode **textElideMode** () const
        void **setTextElideMode**
        (Qt::TextElideMode **mode** )
        """
        ...

    def iconSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size of items' icons

        Setting this property when the view is visible will cause the items to
        be laid out again.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **Notifier signal:**

        void **iconSizeChanged** (const QSize & **size** )
        """
        ...

    def setIconSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size of items' icons

        Setting this property when the view is visible will cause the items to
        be laid out again.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **Notifier signal:**

        void **iconSizeChanged** (const QSize & **size** )
        """
        ...

    def alternatingRowColors(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#alternatingRowColors-prop

        **alternatingRowColors : bool**

        This property holds whether to draw the background using alternating
        colors

        If this property is `true`, the item background will be drawn using
        **QPalette::Base**  and **QPalette::AlternateBase** ; otherwise the
        background will be drawn using the **QPalette::Base**  color.

        By default, this property is `false`.

        **Access functions:**

        bool **alternatingRowColors** () const
        void
        **setAlternatingRowColors** (bool **enable** )
        """
        ...

    def setAlternatingRowColors(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#alternatingRowColors-prop

        **alternatingRowColors : bool**

        This property holds whether to draw the background using alternating
        colors

        If this property is `true`, the item background will be drawn using
        **QPalette::Base**  and **QPalette::AlternateBase** ; otherwise the
        background will be drawn using the **QPalette::Base**  color.

        By default, this property is `false`.

        **Access functions:**

        bool **alternatingRowColors** () const
        void
        **setAlternatingRowColors** (bool **enable** )
        """
        ...

    def dragEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragEnabled-prop

        **dragEnabled : bool**

        This property holds whether the view supports dragging of its own items

        **Access functions:**

        bool **dragEnabled** () const
        void **setDragEnabled** (bool **enable**
        )

        **See also** **showDropIndicator** , **DragDropMode** ,
        **dragDropOverwriteMode** , and **acceptDrops** .
        """
        ...

    def setDragEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#dragEnabled-prop

        **dragEnabled : bool**

        This property holds whether the view supports dragging of its own items

        **Access functions:**

        bool **dragEnabled** () const
        void **setDragEnabled** (bool **enable**
        )

        **See also** **showDropIndicator** , **DragDropMode** ,
        **dragDropOverwriteMode** , and **acceptDrops** .
        """
        ...

    def showDropIndicator(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#showDropIndicator-prop

        **showDropIndicator : bool**

        This property holds whether the drop indicator is shown when dragging
        items and dropping.

        **Access functions:**

        bool **showDropIndicator** () const
        void **setDropIndicatorShown**
        (bool **enable** )

        **See also** **dragEnabled** , **DragDropMode** ,
        **dragDropOverwriteMode** , and **acceptDrops** .
        """
        ...

    def setDropIndicatorShown(self, enable: bool) -> None:
        ...

    def tabKeyNavigation(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#tabKeyNavigation-prop

        **tabKeyNavigation : bool**

        This property holds whether item navigation with tab and backtab is
        enabled.

        **Access functions:**

        bool **tabKeyNavigation** () const
        void **setTabKeyNavigation** (bool
        **enable** )
        """
        ...

    def setTabKeyNavigation(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#tabKeyNavigation-prop

        **tabKeyNavigation : bool**

        This property holds whether item navigation with tab and backtab is
        enabled.

        **Access functions:**

        bool **tabKeyNavigation** () const
        void **setTabKeyNavigation** (bool
        **enable** )
        """
        ...

    def hasAutoScroll(self) -> bool:
        ...

    def setAutoScroll(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#autoScroll-prop

        **autoScroll : bool**

        This property holds whether autoscrolling in drag move events is enabled

        If this property is set to true (the default), the **QAbstractItemView**
        automatically scrolls the contents of the view if the user drags within
        16 pixels of the viewport edge. If the current item changes, then the
        view will scroll automatically to ensure that the current item is fully
        visible.

        This property only works if the viewport accepts drops. Autoscroll is
        switched off by setting this property to false.

        **Access functions:**

        bool **hasAutoScroll** () const
        void **setAutoScroll** (bool
        **enable** )
        """
        ...

    def editTriggers(self) -> "QAbstractItemView.EditTrigger":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#editTriggers-prop

        **editTriggers : EditTriggers**

        This property holds which actions will initiate item editing

        This property is a selection of flags defined by **EditTrigger** ,
        combined using the OR operator. The view will only initiate the editing
        of an item if the action performed is set in this property.

        **Access functions:**

        QAbstractItemView::EditTriggers **editTriggers** () const
        void
        **setEditTriggers** (QAbstractItemView::EditTriggers **triggers** )
        """
        ...

    def setEditTriggers(self, triggers: "QAbstractItemView.EditTrigger") -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#editTriggers-prop

        **editTriggers : EditTriggers**

        This property holds which actions will initiate item editing

        This property is a selection of flags defined by **EditTrigger** ,
        combined using the OR operator. The view will only initiate the editing
        of an item if the action performed is set in this property.

        **Access functions:**

        QAbstractItemView::EditTriggers **editTriggers** () const
        void
        **setEditTriggers** (QAbstractItemView::EditTriggers **triggers** )
        """
        ...

    def rootIndex(self) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#rootIndex

        **QModelIndex QAbstractItemView::rootIndex() const**

        Returns the model index of the model's root item. The root item is the
        parent item to the view's toplevel items. The root can be invalid.

        **See also** **setRootIndex** ().
        """
        ...

    def currentIndex(self) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#currentIndex

        **QModelIndex QAbstractItemView::currentIndex() const**

        Returns the model index of the current item.

        **See also** **setCurrentIndex** ().
        """
        ...

    def selectionBehavior(self) -> "QAbstractItemView.SelectionBehavior":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectionBehavior-prop

        **selectionBehavior : SelectionBehavior**

        This property holds which selection behavior the view uses

        This property holds whether selections are done in terms of single
        items, rows or columns.

        **Access functions:**

        QAbstractItemView::SelectionBehavior **selectionBehavior** () const
        void **setSelectionBehavior** (QAbstractItemView::SelectionBehavior
        **behavior** )

        **See also** **SelectionMode**  and **SelectionBehavior** .
        """
        ...

    def setSelectionBehavior(
        self, behavior: "QAbstractItemView.SelectionBehavior"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectionBehavior-prop

        **selectionBehavior : SelectionBehavior**

        This property holds which selection behavior the view uses

        This property holds whether selections are done in terms of single
        items, rows or columns.

        **Access functions:**

        QAbstractItemView::SelectionBehavior **selectionBehavior** () const
        void **setSelectionBehavior** (QAbstractItemView::SelectionBehavior
        **behavior** )

        **See also** **SelectionMode**  and **SelectionBehavior** .
        """
        ...

    def selectionMode(self) -> "QAbstractItemView.SelectionMode":
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectionMode-prop

        **selectionMode : SelectionMode**

        This property holds which selection mode the view operates in

        This property controls whether the user can select one or many items
        and, in many-item selections, whether the selection must be a continuous
        range of items.

        **Access functions:**

        QAbstractItemView::SelectionMode **selectionMode** () const
        void
        **setSelectionMode** (QAbstractItemView::SelectionMode **mode** )

        **See also** **SelectionMode**  and **SelectionBehavior** .
        """
        ...

    def setSelectionMode(self, mode: "QAbstractItemView.SelectionMode") -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectionMode-prop

        **selectionMode : SelectionMode**

        This property holds which selection mode the view operates in

        This property controls whether the user can select one or many items
        and, in many-item selections, whether the selection must be a continuous
        range of items.

        **Access functions:**

        QAbstractItemView::SelectionMode **selectionMode** () const
        void
        **setSelectionMode** (QAbstractItemView::SelectionMode **mode** )

        **See also** **SelectionMode**  and **SelectionBehavior** .
        """
        ...

    def itemDelegate(self) -> QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#itemDelegate

        **QAbstractItemDelegate *QAbstractItemView::itemDelegate() const**

        Returns the item delegate used by this view and model. This is either
        one set with **setItemDelegate** (), or the default one.

        **See also** **setItemDelegate** ().
        """
        ...

    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setItemDelegate

        **void QAbstractItemView::setItemDelegate(QAbstractItemDelegate *
        delegate )**

        Sets the item delegate for this view and its model to **delegate**. This
        is useful if you want complete control over the editing and display of
        items.

        Any existing delegate will be removed, but not deleted.
        **QAbstractItemView**  does not take ownership of **delegate**.

        **Warning:** You should not share the same instance of a delegate
        between views. Doing so can cause incorrect or unintuitive editing
        behavior since each view connected to a given delegate may receive the
        **closeEditor** () signal, and attempt to access, modify or close an
        editor that has already been closed.

        **See also** **itemDelegate** ().
        """
        ...

    def selectionModel(self) -> QtCore.QItemSelectionModel:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#selectionModel

        **QItemSelectionModel *QAbstractItemView::selectionModel() const**

        Returns the current selection model.

        **See also** **setSelectionModel** () and **selectedIndexes** ().
        """
        ...

    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setSelectionModel

        **[virtual] void
        QAbstractItemView::setSelectionModel(QItemSelectionModel *
        selectionModel )**

        Sets the current selection model to the given **selectionModel**.

        Note that, if you call **setModel** () after this function, the given
        **selectionModel** will be replaced by one created by the view.

        **Note:** It is up to the application to delete the old selection model
        if it is no longer needed; i.e., if it is not being used by other views.
        This will happen automatically when its parent object is deleted.
        However, if it does not have a parent, or if the parent is a long-lived
        object, it may be preferable to call its **deleteLater** () function to
        explicitly delete it.

        **See also** **selectionModel** (), **setModel** (), and
        **clearSelection** ().
        """
        ...

    def model(self) -> QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#model

        **QAbstractItemModel *QAbstractItemView::model() const**

        Returns the model that this view is presenting.

        **See also** **setModel** ().
        """
        ...

    def setModel(self, model: QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#setModel

        **[virtual] void QAbstractItemView::setModel(QAbstractItemModel * model
        )**

        Sets the **model** for the view to present.

        This function will create and set a new selection model, replacing any
        model that was previously set with **setSelectionModel** (). However,
        the old selection model will not be deleted as it may be shared between
        several views. We recommend that you delete the old selection model if
        it is no longer required. This is done with the following code:

        **QItemSelectionModel**  *m = view->selectionModel();
        view->setModel(new model);
            delete m;

        If both the old model and the old selection model do not have parents,
        or if their parents are long-lived objects, it may be preferable to call
        their **deleteLater** () functions to explicitly delete them.

        The view **does not** take ownership of the model unless it is the
        model's parent object because the model may be shared between many
        different views.

        **See also** **model** (), **selectionModel** (), and
        **setSelectionModel** ().
        """
        ...

    @property
    def activated(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#activated

        **[signal] void QAbstractItemView::activated(const QModelIndex & index
        )**

        This signal is emitted when the item specified by **index** is activated
        by the user. How to activate items depends on the platform; e.g., by
        single- or double-clicking the item, or by pressing the Return or Enter
        key when the item is current.

        **See also** **clicked** (), **doubleClicked** (), **entered** (), and
        **pressed** ().
        """
        ...

    @property
    def clicked(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#clicked

        **[signal] void QAbstractItemView::clicked(const QModelIndex & index )**

        This signal is emitted when a mouse button is left-clicked. The item the
        mouse was clicked on is specified by **index**. The signal is only
        emitted when the index is valid.

        **See also** **activated** (), **doubleClicked** (), **entered** (), and
        **pressed** ().
        """
        ...

    @property
    def doubleClicked(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#doubleClicked

        **[signal] void QAbstractItemView::doubleClicked(const QModelIndex &
        index )**

        This signal is emitted when a mouse button is double-clicked. The item
        the mouse was double-clicked on is specified by **index**. The signal is
        only emitted when the index is valid.

        **See also** **clicked** () and **activated** ().
        """
        ...

    @property
    def entered(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#entered

        **[signal] void QAbstractItemView::entered(const QModelIndex & index )**

        This signal is emitted when the mouse cursor enters the item specified
        by **index**. Mouse tracking needs to be enabled for this feature to
        work.

        **See also** **viewportEntered** (), **activated** (), **clicked** (),
        **doubleClicked** (), and **pressed** ().
        """
        ...

    @property
    def iconSizeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def pressed(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#pressed

        **[signal] void QAbstractItemView::pressed(const QModelIndex & index )**

        This signal is emitted when a mouse button is pressed. The item the
        mouse was pressed on is specified by **index**. The signal is only
        emitted when the index is valid.

        Use the **QGuiApplication::mouseButtons** () function to get the state
        of the mouse buttons.

        **See also** **activated** (), **clicked** (), **doubleClicked** (), and
        **entered** ().
        """
        ...

    @property
    def viewportEntered(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstractitemview.html#viewportEntered

        **[signal] void QAbstractItemView::viewportEntered()**

        This signal is emitted when the mouse cursor enters the viewport. Mouse
        tracking needs to be enabled for this feature to work.

        **See also** **entered** ().
        """
        ...
