"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QAbstractScrollArea(QFrame):
    """
    https://doc.qt.io/qt-6/qabstractscrollarea.html

    **Detailed Description**

    QAbstractScrollArea is a low-level abstraction of a scrolling area. The area
    provides a central widget called the viewport, in which the contents of the
    area is to be scrolled (i.e, the visible parts of the contents are rendered
    in the viewport).

    Next to the viewport is a vertical scroll bar, and below is a horizontal
    scroll bar. When all of the area contents fits in the viewport, each scroll
    bar can be either visible or hidden depending on the scroll bar's
    **Qt::ScrollBarPolicy** . When a scroll bar is hidden, the viewport expands
    in order to cover all available space. When a scroll bar becomes visible
    again, the viewport shrinks in order to make room for the scroll bar.

    It is possible to reserve a margin area around the viewport, see
    **setViewportMargins** (). The feature is mostly used to place a
    **QHeaderView**  widget above or beside the scrolling area. Subclasses of
    QAbstractScrollArea should implement margins.

    When inheriting QAbstractScrollArea, you need to do the following:

    * Control the scroll bars by setting their range, value, page step, and
    tracking their movements.
      * Draw the contents of the area in the viewport
    according to the values of the scroll bars.
      * Handle events received by
    the viewport in **viewportEvent** () - notably resize events.
      * Use
    `viewport->update()` to update the contents of the viewport instead of
    **update** () as all painting operations take place on the viewport.

    With a scroll bar policy of **Qt::ScrollBarAsNeeded**  (the default),
    QAbstractScrollArea shows scroll bars when they provide a non-zero scrolling
    range, and hides them otherwise.

    The scroll bars and viewport should be updated whenever the viewport
    receives a resize event or the size of the contents changes. The viewport
    also needs to be updated when the scroll bars values change. The initial
    values of the scroll bars are often set when the area receives new contents.

    We give a simple example, in which we have implemented a scroll area that
    can scroll any **QWidget** . We make the widget a child of the viewport;
    this way, we do not have to calculate which part of the widget to draw but
    can simply move the widget with **QWidget::move** (). When the area contents
    or the viewport size changes, we do the following:

    **QSize**  areaSize = viewport()->size();
            **QSize**   widgetSize =
    widget->size();
    verticalScrollBar()->setPageStep(areaSize.height());
    horizontalScrollBar()->setPageStep(areaSize.width());
    verticalScrollBar()->setRange(0, widgetSize.height() - areaSize.height());
    horizontalScrollBar()->setRange(0, widgetSize.width() - areaSize.width());
    updateWidgetPosition();

    When the scroll bars change value, we need to update the widget position,
    i.e., find the part of the widget that is to be drawn in the viewport:

    int hvalue = horizontalScrollBar()->value();
            int vvalue =
    verticalScrollBar()->value();
            **QPoint**  topLeft =
    viewport()->rect().topLeft();

            widget->move(topLeft.x() -
    hvalue, topLeft.y() - vvalue);

    In order to track scroll bar movements, reimplement the virtual function
    **scrollContentsBy** (). In order to fine-tune scrolling behavior, connect
    to a scroll bar's **QAbstractSlider::actionTriggered** () signal and adjust
    the **QAbstractSlider::sliderPosition**  as you wish.

    For convenience, QAbstractScrollArea makes all viewport events available in
    the virtual **viewportEvent** () handler. **QWidget** 's specialized
    handlers are remapped to viewport events in the cases where this makes
    sense. The remapped specialized handlers are: **paintEvent** (),
    **mousePressEvent** (), **mouseReleaseEvent** (), **mouseDoubleClickEvent**
    (), **mouseMoveEvent** (), **wheelEvent** (), **dragEnterEvent** (),
    **dragMoveEvent** (), **dragLeaveEvent** (), **dropEvent** (),
    **contextMenuEvent** (), and **resizeEvent** ().

    **QScrollArea** , which inherits QAbstractScrollArea, provides smooth
    scrolling for any **QWidget**  (i.e., the widget is scrolled pixel by
    pixel). You only need to subclass QAbstractScrollArea if you need more
    specialized behavior. This is, for instance, true if the entire contents of
    the area is not suitable for being drawn on a **QWidget**  or if you do not
    want smooth scrolling.

    **See also** **QScrollArea** .
    """

    class SizeAdjustPolicy(enum.Enum):
        AdjustIgnored: QAbstractScrollArea = ...
        AdjustToContentsOnFirstShow: QAbstractScrollArea = ...
        AdjustToContents: QAbstractScrollArea = ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#QAbstractScrollArea

        **QAbstractScrollArea::QAbstractScrollArea(QWidget * parent = nullptr)**

        Constructs a viewport.

        The **parent** argument is sent to the **QWidget**  constructor.
        """
        ...

    def setSizeAdjustPolicy(
        self, policy: "QAbstractScrollArea.SizeAdjustPolicy"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#sizeAdjustPolicy-prop

        **[since 5.2] sizeAdjustPolicy : SizeAdjustPolicy**

        This property holds the policy describing how the size of the scroll
        area changes when the size of the viewport changes.

        The default policy is **QAbstractScrollArea::AdjustIgnored** . Changing
        this property might actually resize the scrollarea.

        This property was introduced in Qt 5.2.

        **Access functions:**

        QAbstractScrollArea::SizeAdjustPolicy **sizeAdjustPolicy** () const
        void **setSizeAdjustPolicy** (QAbstractScrollArea::SizeAdjustPolicy
        **policy** )
        """
        ...

    def sizeAdjustPolicy(self) -> "QAbstractScrollArea.SizeAdjustPolicy":
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#sizeAdjustPolicy-prop

        **[since 5.2] sizeAdjustPolicy : SizeAdjustPolicy**

        This property holds the policy describing how the size of the scroll
        area changes when the size of the viewport changes.

        The default policy is **QAbstractScrollArea::AdjustIgnored** . Changing
        this property might actually resize the scrollarea.

        This property was introduced in Qt 5.2.

        **Access functions:**

        QAbstractScrollArea::SizeAdjustPolicy **sizeAdjustPolicy** () const
        void **setSizeAdjustPolicy** (QAbstractScrollArea::SizeAdjustPolicy
        **policy** )
        """
        ...

    def setupViewport(self, viewport: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#setupViewport

        **[virtual] void QAbstractScrollArea::setupViewport(QWidget * viewport
        )**

        This slot is called by **QAbstractScrollArea**  after **setViewport** (
        **viewport** ) has been called. Reimplement this function in a subclass
        of **QAbstractScrollArea**  to initialize the new **viewport** before it
        is used.

        **See also** **setViewport** ().
        """
        ...

    def setViewport(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#setViewport

        **void QAbstractScrollArea::setViewport(QWidget * widget )**

        Sets the viewport to be the given **widget**. The
        **QAbstractScrollArea**  will take ownership of the given **widget**.

        If **widget** is `nullptr`, **QAbstractScrollArea**  will assign a new
        **QWidget**  instance for the viewport.

        **See also** **viewport** ().
        """
        ...

    def scrollBarWidgets(
        self, alignment: QtCore.Qt.AlignmentFlag
    ) -> typing.List[QWidget]:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#scrollBarWidgets

        **QWidgetList QAbstractScrollArea::scrollBarWidgets(Qt::Alignment
        alignment )**

        Returns a list of the currently set scroll bar widgets. **alignment**
        can be any combination of the four location flags.

        **See also** **addScrollBarWidget** ().
        """
        ...

    def addScrollBarWidget(
        self, widget: QWidget, alignment: QtCore.Qt.AlignmentFlag
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#addScrollBarWidget

        **void QAbstractScrollArea::addScrollBarWidget(QWidget * widget ,
        Qt::Alignment alignment )**

        Adds **widget** as a scroll bar widget in the location specified by
        **alignment**.

        Scroll bar widgets are shown next to the horizontal or vertical scroll
        bar, and can be placed on either side of it. If you want the scroll bar
        widgets to be always visible, set the scrollBarPolicy for the
        corresponding scroll bar to `AlwaysOn`.

        **alignment** must be one of Qt::Alignleft and **Qt::AlignRight** ,
        which maps to the horizontal scroll bar, or **Qt::AlignTop**  and
        **Qt::AlignBottom** , which maps to the vertical scroll bar.

        A scroll bar widget can be removed by either re-parenting the widget or
        deleting it. It's also possible to hide a widget with **QWidget::hide**
        ()

        The scroll bar widget will be resized to fit the scroll bar geometry for
        the current style. The following describes the case for scroll bar
        widgets on the horizontal scroll bar:

        The height of the widget will be set to match the height of the scroll
        bar. To control the width of the widget, use
        **QWidget::setMinimumWidth**  and **QWidget::setMaximumWidth** , or
        implement **QWidget::sizeHint** () and set a horizontal size policy. If
        you want a square widget, call **QStyle::pixelMetric**
        (**QStyle::PM_ScrollBarExtent** ) and set the width to this value.

        **See also** **scrollBarWidgets** ().
        """
        ...

    def setCornerWidget(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#setCornerWidget

        **void QAbstractScrollArea::setCornerWidget(QWidget * widget )**

        Sets the widget in the corner between the two scroll bars to be
        **widget**.

        You will probably also want to set at least one of the scroll bar modes
        to `AlwaysOn`.

        Passing `nullptr` shows no widget in the corner.

        Any previous corner widget is hidden.

        You may call setCornerWidget() with the same widget at different times.

        All widgets set here will be deleted by the scroll area when it is
        destroyed unless you separately reparent the widget after setting some
        other corner widget (or `nullptr`).

        Any **newly** set widget should have no current parent.

        By default, no corner widget is present.

        **See also** **cornerWidget** (), **horizontalScrollBarPolicy** , and
        **horizontalScrollBarPolicy** .
        """
        ...

    def cornerWidget(self) -> QWidget:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#cornerWidget

        **QWidget *QAbstractScrollArea::cornerWidget() const**

        Returns the widget in the corner between the two scroll bars.

        By default, no corner widget is present.

        **See also** **setCornerWidget** ().
        """
        ...

    def setHorizontalScrollBar(self, scrollbar: "QScrollBar") -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#setHorizontalScrollBar

        **void QAbstractScrollArea::setHorizontalScrollBar(QScrollBar *
        scrollBar )**

        Replaces the existing horizontal scroll bar with **scrollBar** , and
        sets all the former scroll bar's slider properties on the new scroll
        bar. The former scroll bar is then deleted.

        **QAbstractScrollArea**  already provides horizontal and vertical scroll
        bars by default. You can call this function to replace the default
        horizontal scroll bar with your own custom scroll bar.

        **See also** **horizontalScrollBar** () and **setVerticalScrollBar** ().
        """
        ...

    def setVerticalScrollBar(self, scrollbar: "QScrollBar") -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#setVerticalScrollBar

        **void QAbstractScrollArea::setVerticalScrollBar(QScrollBar * scrollBar
        )**

        Replaces the existing vertical scroll bar with **scrollBar** , and sets
        all the former scroll bar's slider properties on the new scroll bar. The
        former scroll bar is then deleted.

        **QAbstractScrollArea**  already provides vertical and horizontal scroll
        bars by default. You can call this function to replace the default
        vertical scroll bar with your own custom scroll bar.

        **See also** **verticalScrollBar** () and **setHorizontalScrollBar** ().
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#scrollContentsBy

        **[virtual protected] void QAbstractScrollArea::scrollContentsBy(int dx
        , int dy )**

        This virtual handler is called when the scroll bars are moved by **dx**
        , **dy** , and consequently the viewport's contents should be scrolled
        accordingly.

        The default implementation simply calls **update** () on the entire
        **viewport** (), subclasses can reimplement this handler for
        optimization purposes, or - like **QScrollArea**  \\- to move a contents
        widget. The parameters **dx** and **dy** are there for convenience, so
        that the class knows how much should be scrolled (useful e.g. when doing
        pixel-shifts). You may just as well ignore these values and scroll
        directly to the position the scroll bars indicate.

        Calling this function in order to scroll programmatically is an error,
        use the scroll bars instead (e.g. by calling **QScrollBar::setValue** ()
        directly).
        """
        ...

    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool:
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#keyPressEvent

        **[override virtual protected] void
        QAbstractScrollArea::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).

        This function is called with key event **e** when key presses occur. It
        handles PageUp, PageDown, Up, Down, Left, and Right, and ignores all
        other key presses.
        """
        ...

    def dropEvent(self, a0: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#dropEvent

        **[override virtual protected] void
        QAbstractScrollArea::dropEvent(QDropEvent * event )**

        Reimplements: **QWidget::dropEvent** (QDropEvent *event).

        This event handler can be reimplemented in a subclass to receive drop
        events (passed in **event** ), for the **viewport** () widget.

        **See also** **QWidget::dropEvent** ().
        """
        ...

    def dragLeaveEvent(self, a0: QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#dragLeaveEvent

        **[override virtual protected] void
        QAbstractScrollArea::dragLeaveEvent(QDragLeaveEvent * event )**

        Reimplements: **QWidget::dragLeaveEvent** (QDragLeaveEvent *event).

        This event handler can be reimplemented in a subclass to receive drag
        leave events (passed in **event** ), for the **viewport** () widget.

        **See also** **QWidget::dragLeaveEvent** ().
        """
        ...

    def dragMoveEvent(self, a0: QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#dragMoveEvent

        **[override virtual protected] void
        QAbstractScrollArea::dragMoveEvent(QDragMoveEvent * event )**

        Reimplements: **QWidget::dragMoveEvent** (QDragMoveEvent *event).

        This event handler can be reimplemented in a subclass to receive drag
        move events (passed in **event** ), for the **viewport** () widget.

        **See also** **QWidget::dragMoveEvent** ().
        """
        ...

    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#dragEnterEvent

        **[override virtual protected] void
        QAbstractScrollArea::dragEnterEvent(QDragEnterEvent * event )**

        Reimplements: **QWidget::dragEnterEvent** (QDragEnterEvent *event).

        This event handler can be reimplemented in a subclass to receive drag
        enter events (passed in **event** ), for the **viewport** () widget.

        **See also** **QWidget::dragEnterEvent** ().
        """
        ...

    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#contextMenuEvent

        **[override virtual protected] void
        QAbstractScrollArea::contextMenuEvent(QContextMenuEvent * e )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).

        This event handler can be reimplemented in a subclass to receive context
        menu events for the **viewport** () widget. The event is passed in
        **e**.

        **See also** **QWidget::contextMenuEvent** ().
        """
        ...

    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#wheelEvent

        **[override virtual protected] void
        QAbstractScrollArea::wheelEvent(QWheelEvent * e )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).

        This event handler can be reimplemented in a subclass to receive wheel
        events for the **viewport** () widget. The event is passed in **e**.

        **See also** **QWidget::wheelEvent** ().
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#mouseMoveEvent

        **[override virtual protected] void
        QAbstractScrollArea::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).

        This event handler can be reimplemented in a subclass to receive mouse
        move events for the **viewport** () widget. The event is passed in
        **e**.

        **See also** **QWidget::mouseMoveEvent** ().
        """
        ...

    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QAbstractScrollArea::mouseDoubleClickEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseDoubleClickEvent** (QMouseEvent *event).

        This event handler can be reimplemented in a subclass to receive mouse
        double click events for the **viewport** () widget. The event is passed
        in **e**.

        **See also** **QWidget::mouseDoubleClickEvent** ().
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#mouseReleaseEvent

        **[override virtual protected] void
        QAbstractScrollArea::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).

        This event handler can be reimplemented in a subclass to receive mouse
        release events for the **viewport** () widget. The event is passed in
        **e**.

        **See also** **QWidget::mouseReleaseEvent** ().
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#mousePressEvent

        **[override virtual protected] void
        QAbstractScrollArea::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).

        This event handler can be reimplemented in a subclass to receive mouse
        press events for the **viewport** () widget. The event is passed in
        **e**.

        The default implementation calls **QWidget::mousePressEvent** () for
        default popup handling.

        **See also** **QWidget::mousePressEvent** ().
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#paintEvent

        **[override virtual protected] void
        QAbstractScrollArea::paintEvent(QPaintEvent * event )**

        Reimplements: **QFrame::paintEvent** (QPaintEvent *).

        This event handler can be reimplemented in a subclass to receive paint
        events (passed in **event** ), for the **viewport** () widget.

        **Note:** If you open a painter, make sure to open it on the
        **viewport** ().

        **See also** **QWidget::paintEvent** ().
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#resizeEvent

        **[override virtual protected] void
        QAbstractScrollArea::resizeEvent(QResizeEvent * event )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).

        This event handler can be reimplemented in a subclass to receive resize
        events (passed in **event** ), for the **viewport** () widget.

        When resizeEvent() is called, the viewport already has its new geometry:
        Its new size is accessible through the **QResizeEvent::size** ()
        function, and the old size through **QResizeEvent::oldSize** ().

        **See also** **QWidget::resizeEvent** ().
        """
        ...

    def viewportEvent(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#viewportEvent

        **[virtual protected] bool QAbstractScrollArea::viewportEvent(QEvent *
        event )**

        The main event handler for the scrolling area (the **viewport** ()
        widget). It handles the **event** specified, and can be called by
        subclasses to provide reasonable default behavior.

        Returns `true` to indicate to the event system that the event has been
        handled, and needs no further processing; otherwise returns `false` to
        indicate that the event should be propagated further.

        You can reimplement this function in a subclass, but we recommend using
        one of the specialized event handlers instead.

        Specialized handlers for viewport events are: **paintEvent** (),
        **mousePressEvent** (), **mouseReleaseEvent** (),
        **mouseDoubleClickEvent** (), **mouseMoveEvent** (), **wheelEvent** (),
        **dragEnterEvent** (), **dragMoveEvent** (), **dragLeaveEvent** (),
        **dropEvent** (), **contextMenuEvent** (), and **resizeEvent** ().
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#event

        **[override virtual protected] bool QAbstractScrollArea::event(QEvent *
        event )**

        Reimplements: **QFrame::event** (QEvent *e).

        This is the main event handler for the **QAbstractScrollArea**  widget (
        **not** the scrolling area **viewport** ()). The specified **event** is
        a general event object that may need to be cast to the appropriate class
        depending on its type.

        **See also** **QEvent::type** ().
        """
        ...

    def viewportSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#viewportSizeHint

        **[virtual protected, since 5.2] QSize
        QAbstractScrollArea::viewportSizeHint() const**

        Returns the recommended size for the viewport. The default
        implementation returns **viewport** ()->**sizeHint** (). Note that the
        size is just the viewport's size, without any scroll bars visible.

        This function was introduced in Qt 5.2.
        """
        ...

    def viewportMargins(self) -> QtCore.QMargins:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#viewportMargins

        **[protected, since 5.5] QMargins QAbstractScrollArea::viewportMargins()
        const**

        Returns the margins around the scrolling area. By default all the
        margins are zero.

        This function was introduced in Qt 5.5.

        **See also** **setViewportMargins** ().
        """
        ...

    @typing.overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#setViewportMargins

        **[protected] void QAbstractScrollArea::setViewportMargins(int left ,
        int top , int right , int bottom )**

        Sets the margins around the scrolling area to **left** , **top** ,
        **right** and **bottom**. This is useful for applications such as
        spreadsheets with "locked" rows and columns. The marginal space is left
        blank; put widgets in the unused area.

        Note that this function is frequently called by **QTreeView**  and
        **QTableView** , so margins must be implemented by
        **QAbstractScrollArea**  subclasses. Also, if the subclasses are to be
        used in item views, they should not call this function.

        By default all margins are zero.

        **See also** **viewportMargins** ().
        """
        ...

    @typing.overload
    def setViewportMargins(self, margins: QtCore.QMargins) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#setViewportMargins-1

        **[protected] void QAbstractScrollArea::setViewportMargins(const
        QMargins & margins )**

        Sets **margins** around the scrolling area. This is useful for
        applications such as spreadsheets with "locked" rows and columns. The
        marginal space is is left blank; put widgets in the unused area.

        By default all margins are zero.

        **See also** **viewportMargins** ().
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#sizeHint

        **[override virtual] QSize QAbstractScrollArea::sizeHint() const**

        Reimplements: **QFrame::sizeHint() const** .

        Returns the sizeHint property of the scroll area. The size is determined
        by using **viewportSizeHint** () plus some extra space for scroll bars,
        if needed.
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#minimumSizeHint

        **[override virtual] QSize QAbstractScrollArea::minimumSizeHint()
        const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def maximumViewportSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#maximumViewportSize

        **QSize QAbstractScrollArea::maximumViewportSize() const**

        Returns the size of the viewport as if the scroll bars had no valid
        scrolling range.
        """
        ...

    def viewport(self) -> QWidget:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#viewport

        **QWidget *QAbstractScrollArea::viewport() const**

        Returns the viewport widget.

        Use the **QScrollArea::widget** () function to retrieve the contents of
        the viewport widget.

        **See also** **setViewport** () and **QScrollArea::widget** ().
        """
        ...

    def horizontalScrollBar(self) -> "QScrollBar":
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#horizontalScrollBar

        **QScrollBar *QAbstractScrollArea::horizontalScrollBar() const**

        Returns the horizontal scroll bar.

        **See also** **setHorizontalScrollBar** (),
        **horizontalScrollBarPolicy** , and **verticalScrollBar** ().
        """
        ...

    def setHorizontalScrollBarPolicy(self, a0: QtCore.Qt.ScrollBarPolicy) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#horizontalScrollBarPolic
        y-prop

        **horizontalScrollBarPolicy : Qt::ScrollBarPolicy**

        This property holds the policy for the horizontal scroll bar

        The default policy is **Qt::ScrollBarAsNeeded** .

        **Access functions:**

        Qt::ScrollBarPolicy **horizontalScrollBarPolicy** () const
        void
        **setHorizontalScrollBarPolicy** (Qt::ScrollBarPolicy)

        **See also** **verticalScrollBarPolicy** .
        """
        ...

    def horizontalScrollBarPolicy(self) -> QtCore.Qt.ScrollBarPolicy:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#horizontalScrollBarPolic
        y-prop

        **horizontalScrollBarPolicy : Qt::ScrollBarPolicy**

        This property holds the policy for the horizontal scroll bar

        The default policy is **Qt::ScrollBarAsNeeded** .

        **Access functions:**

        Qt::ScrollBarPolicy **horizontalScrollBarPolicy** () const
        void
        **setHorizontalScrollBarPolicy** (Qt::ScrollBarPolicy)

        **See also** **verticalScrollBarPolicy** .
        """
        ...

    def verticalScrollBar(self) -> "QScrollBar":
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#verticalScrollBar

        **QScrollBar *QAbstractScrollArea::verticalScrollBar() const**

        Returns the vertical scroll bar.

        **See also** **setVerticalScrollBar** (), **verticalScrollBarPolicy** ,
        and **horizontalScrollBar** ().
        """
        ...

    def setVerticalScrollBarPolicy(self, a0: QtCore.Qt.ScrollBarPolicy) -> None:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#verticalScrollBarPolicy-
        prop

        **verticalScrollBarPolicy : Qt::ScrollBarPolicy**

        This property holds the policy for the vertical scroll bar

        The default policy is **Qt::ScrollBarAsNeeded** .

        **Access functions:**

        Qt::ScrollBarPolicy **verticalScrollBarPolicy** () const
        void
        **setVerticalScrollBarPolicy** (Qt::ScrollBarPolicy)

        **See also** **horizontalScrollBarPolicy** .

        **Member Function Documentation**
        """
        ...

    def verticalScrollBarPolicy(self) -> QtCore.Qt.ScrollBarPolicy:
        """
        https://doc.qt.io/qt-6/qabstractscrollarea.html#verticalScrollBarPolicy-
        prop

        **verticalScrollBarPolicy : Qt::ScrollBarPolicy**

        This property holds the policy for the vertical scroll bar

        The default policy is **Qt::ScrollBarAsNeeded** .

        **Access functions:**

        Qt::ScrollBarPolicy **verticalScrollBarPolicy** () const
        void
        **setVerticalScrollBarPolicy** (Qt::ScrollBarPolicy)

        **See also** **horizontalScrollBarPolicy** .

        **Member Function Documentation**
        """
        ...
