"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QColorDialog(QDialog):
    """
    https://doc.qt.io/qt-6/qcolordialog.html

    **Detailed Description**

    The color dialog's function is to allow users to choose colors. For example,
    you might use this in a drawing program to allow the user to set the brush
    color.

    The static functions provide modal color dialogs.

    The static **getColor** () function shows the dialog, and allows the user to
    specify a color. This function can also be used to let users choose a color
    with a level of transparency: pass the **ShowAlphaChannel**  option as an
    additional argument.

    The user can store **customCount** () different custom colors. The custom
    colors are shared by all color dialogs, and remembered during the execution
    of the program. Use **setCustomColor** () to set the custom colors, and use
    **customColor** () to get them.

    When pressing the "Pick Screen Color" button, the cursor changes to a
    haircross and the colors on the screen are scanned. The user can pick up one
    by clicking the mouse or the Enter button. Pressing Escape restores the last
    color selected before entering this mode.

    The **Standard Dialogs**  example shows how to use QColorDialog as well as
    other built-in Qt dialogs.

    ![A color dialog in the Fusion widget style.](images/fusion-colordialog.png)

    **See also** **QColor** , **QFileDialog** , **QFontDialog** , and **Standard
    Dialogs Example** .
    """

    class ColorDialogOption(enum.Flag):
        ShowAlphaChannel: QColorDialog = ...
        NoButtons: QColorDialog = ...
        DontUseNativeDialog: QColorDialog = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#QColorDialog

        **QColorDialog::QColorDialog(QWidget * parent = nullptr)**

        Constructs a color dialog with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        initial: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int],
        parent: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#QColorDialog-1

        **QColorDialog::QColorDialog(const QColor & initial , QWidget * parent =
        nullptr)**

        Constructs a color dialog with the given **parent** and specified
        **initial** color.
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#setVisible

        **[override virtual] void QColorDialog::setVisible(bool visible )**

        Reimplements: **QDialog::setVisible** (bool visible).

        Changes the visibility of the dialog. If **visible** is true, the dialog
        is shown; otherwise, it is hidden.
        """
        ...

    def options(self) -> "QColorDialog.ColorDialogOption":
        """
        https://doc.qt.io/qt-6/qcolordialog.html#options-prop

        **options : ColorDialogOptions**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        Options should be set before showing the dialog. Setting them while the
        dialog is visible is not guaranteed to have an immediate effect on the
        dialog (depending on the option and on the platform).

        **Access functions:**

        QColorDialog::ColorDialogOptions **options** () const
        void
        **setOptions** (QColorDialog::ColorDialogOptions **options** )

        **See also** **setOption** () and **testOption** ().

        **Member Function Documentation**
        """
        ...

    def setOptions(self, options: "QColorDialog.ColorDialogOption") -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#options-prop

        **options : ColorDialogOptions**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        Options should be set before showing the dialog. Setting them while the
        dialog is visible is not guaranteed to have an immediate effect on the
        dialog (depending on the option and on the platform).

        **Access functions:**

        QColorDialog::ColorDialogOptions **options** () const
        void
        **setOptions** (QColorDialog::ColorDialogOptions **options** )

        **See also** **setOption** () and **testOption** ().

        **Member Function Documentation**
        """
        ...

    def testOption(self, option: "QColorDialog.ColorDialogOption") -> bool:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#testOption

        **bool QColorDialog::testOption(QColorDialog::ColorDialogOption option )
        const**

        Returns `true` if the given **option** is enabled; otherwise, returns
        false.

        **See also** **options**  and **setOption** ().
        """
        ...

    def setOption(
        self, option: "QColorDialog.ColorDialogOption", on: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#setOption

        **void QColorDialog::setOption(QColorDialog::ColorDialogOption option ,
        bool on = true)**

        Sets the given **option** to be enabled if **on** is true; otherwise,
        clears the given **option**.

        **See also** **options**  and **testOption** ().
        """
        ...

    def selectedColor(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#selectedColor

        **QColor QColorDialog::selectedColor() const**

        Returns the color that the user selected by clicking the **OK** or
        equivalent button.

        **Note:** This color is not always the same as the color held by the
        **currentColor**  property since the user can choose different colors
        before finally selecting the one to use.
        """
        ...

    def currentColor(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#currentColor-prop

        **currentColor : QColor**

        This property holds the currently selected color in the dialog

        **Access functions:**

        QColor **currentColor** () const
        void **setCurrentColor** (const
        QColor & **color** )

        **Notifier signal:**

        void ****currentColorChanged** ** (const QColor & **color** )
        """
        ...

    def setCurrentColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#currentColor-prop

        **currentColor : QColor**

        This property holds the currently selected color in the dialog

        **Access functions:**

        QColor **currentColor** () const
        void **setCurrentColor** (const
        QColor & **color** )

        **Notifier signal:**

        void ****currentColorChanged** ** (const QColor & **color** )
        """
        ...

    def done(self, result: int) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#done

        **[override virtual protected] void QColorDialog::done(int result )**

        Reimplements: **QDialog::done** (int r).

        Closes the dialog and sets its result code to **result**. If this dialog
        is shown with **exec** (), done() causes the local event loop to finish,
        and **exec** () to return **result**.

        **See also** **QDialog::done** ().
        """
        ...

    def changeEvent(self, e: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#changeEvent

        **[override virtual protected] void QColorDialog::changeEvent(QEvent * e
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    @typing.overload
    def open(self) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#open

        **void QColorDialog::open(QObject * receiver , const char * member )**

        Opens the dialog and connects its **colorSelected** () signal to the
        slot specified by **receiver** and **member**.

        The signal will be disconnected from the slot when the dialog is closed.
        """
        ...

    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#open

        **void QColorDialog::open(QObject * receiver , const char * member )**

        Opens the dialog and connects its **colorSelected** () signal to the
        slot specified by **receiver** and **member**.

        The signal will be disconnected from the slot when the dialog is closed.
        """
        ...

    @staticmethod
    def setStandardColor(
        index: int, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#setStandardColor

        **[static] void QColorDialog::setStandardColor(int index , QColor color
        )**

        Sets the standard color at **index** to the **QColor**  **color** value.

        **Note:** This function does not apply to the Native Color Dialog on the
        macOS platform. If you still require this function, use the
        **QColorDialog::DontUseNativeDialog**  option.

        **See also** **standardColor** ().
        """
        ...

    @staticmethod
    def standardColor(index: int) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#standardColor

        **[static, since 5.0] QColor QColorDialog::standardColor(int index )**

        Returns the standard color at the given **index** as a **QColor**
        value.

        This function was introduced in Qt 5.0.

        **See also** **setStandardColor** ().
        """
        ...

    @staticmethod
    def setCustomColor(
        index: int, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#setCustomColor

        **[static] void QColorDialog::setCustomColor(int index , QColor color
        )**

        Sets the custom color at **index** to the **QColor**  **color** value.

        **Note:** This function does not apply to the Native Color Dialog on the
        macOS platform. If you still require this function, use the
        **QColorDialog::DontUseNativeDialog**  option.

        **See also** **customColor** ().
        """
        ...

    @staticmethod
    def customColor(index: int) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#customColor

        **[static] QColor QColorDialog::customColor(int index )**

        Returns the custom color at the given **index** as a **QColor**  value.

        **See also** **setCustomColor** ().
        """
        ...

    @staticmethod
    def customCount() -> int:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#customCount

        **[static] int QColorDialog::customCount()**

        Returns the number of custom colors supported by **QColorDialog** . All
        color dialogs share the same custom colors.
        """
        ...

    @staticmethod
    def getColor(
        initial: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int] = ...,
        parent: typing.Optional[QWidget] = ...,
        title: str = ...,
        options: "QColorDialog.ColorDialogOption" = ...,
    ) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#getColor

        **[static] QColor QColorDialog::getColor(const QColor & initial =
        Qt::white, QWidget * parent = nullptr, const QString & title =
        QString(), QColorDialog::ColorDialogOptions options =
        ColorDialogOptions())**

        Pops up a modal color dialog with the given window **title** (or "Select
        Color" if none is specified), lets the user choose a color, and returns
        that color. The color is initially set to **initial**. The dialog is a
        child of **parent**. It returns an invalid (see **QColor::isValid** ())
        color if the user cancels the dialog.

        The **options** argument allows you to customize the dialog.
        """
        ...

    @property
    def colorSelected(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#colorSelected

        **[signal] void QColorDialog::colorSelected(const QColor & color )**

        This signal is emitted just after the user has clicked **OK** to select
        a color to use. The chosen color is specified by **color**.

        **See also** **color**  and **currentColorChanged** ().
        """
        ...

    @property
    def currentColorChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qcolordialog.html#currentColorChanged

        **[signal] void QColorDialog::currentColorChanged(const QColor & color
        )**

        This signal is emitted whenever the current color changes in the dialog.
        The current color is specified by **color**.

        **Note:** Notifier signal for property **currentColor** .

        **See also** **color**  and **colorSelected** ().
        """
        ...
