"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QDataWidgetMapper(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qdatawidgetmapper.html

    **Detailed Description**

    QDataWidgetMapper can be used to create data-aware widgets by mapping them
    to sections of an item model. A section is a column of a model if the
    orientation is horizontal (the default), otherwise a row.

    Every time the current index changes, each widget is updated with data from
    the model via the property specified when its mapping was made. If the user
    edits the contents of a widget, the changes are read using the same property
    and written back to the model. By default, each widget's **user property**
    is used to transfer data between the model and the widget. Since Qt 4.3, an
    additional **addMapping** () function enables a named property to be used
    instead of the default user property.

    It is possible to set an item delegate to support custom widgets. By
    default, a **QItemDelegate**  is used to synchronize the model with the
    widgets.

    Let us assume that we have an item model named `model` with the following
    contents:

    1Qt NorwayOslo
    2Qt AustraliaBrisbane
    3Qt USAPalo Alto
    4Qt ChinaBeijing
    5Qt GermanyBerlin

    The following code will map the columns of the model to widgets called
    `mySpinBox`, `myLineEdit` and `myCountryChooser`:

    **QDataWidgetMapper**  *mapper = new **QDataWidgetMapper** ;
    mapper->setModel(model);
        mapper->addMapping(mySpinBox, 0);
    mapper->addMapping(myLineEdit, 1);
        mapper->addMapping(myCountryChooser,
    2);
        mapper->toFirst();

    After the call to **toFirst** (), `mySpinBox` displays the value `1`,
    `myLineEdit` displays `Qt Norway` and `myCountryChooser` displays `Oslo`.
    The navigational functions **toFirst** (), **toNext** (), **toPrevious** (),
    **toLast** () and **setCurrentIndex** () can be used to navigate in the
    model and update the widgets with contents from the model.

    The **setRootIndex** () function enables a particular item in a model to be
    specified as the root index - children of this item will be mapped to the
    relevant widgets in the user interface.

    QDataWidgetMapper supports two submit policies, `AutoSubmit` and
    `ManualSubmit`. `AutoSubmit` will update the model as soon as the current
    widget loses focus, `ManualSubmit` will not update the model unless
    **submit** () is called. `ManualSubmit` is useful when displaying a dialog
    that lets the user cancel all modifications. Also, other views that display
    the model won't update until the user finishes all their modifications and
    submits.

    Note that QDataWidgetMapper keeps track of external modifications. If the
    contents of the model are updated in another module of the application, the
    widgets are updated as well.

    **See also** **QAbstractItemModel**  and **QAbstractItemDelegate** .
    """

    class SubmitPolicy(enum.Enum):
        AutoSubmit: QDataWidgetMapper = ...
        ManualSubmit: QDataWidgetMapper = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#QDataWidgetMapper

        **QDataWidgetMapper::QDataWidgetMapper(QObject * parent = nullptr)**

        Constructs a new QDataWidgetMapper with parent object **parent**. By
        default, the orientation is horizontal and the submit policy is
        `AutoSubmit`.

        **See also** **setOrientation** () and **setSubmitPolicy** ().
        """
        ...

    def toPrevious(self) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#toPrevious

        **[slot] void QDataWidgetMapper::toPrevious()**

        Populates the widgets with data from the previous row of the model if
        the orientation is horizontal (the default), otherwise with data from
        the previous column.

        Calls **setCurrentIndex** () internally. Does nothing if there is no
        previous row in the model.

        **See also** **toNext** () and **setCurrentIndex** ().
        """
        ...

    def toNext(self) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#toNext

        **[slot] void QDataWidgetMapper::toNext()**

        Populates the widgets with data from the next row of the model if the
        orientation is horizontal (the default), otherwise with data from the
        next column.

        Calls **setCurrentIndex** () internally. Does nothing if there is no
        next row in the model.

        **See also** **toPrevious** () and **setCurrentIndex** ().
        """
        ...

    def toLast(self) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#toLast

        **[slot] void QDataWidgetMapper::toLast()**

        Populates the widgets with data from the last row of the model if the
        orientation is horizontal (the default), otherwise with data from the
        last column.

        Calls **setCurrentIndex** () internally.

        **See also** **toFirst** () and **setCurrentIndex** ().
        """
        ...

    def toFirst(self) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#toFirst

        **[slot] void QDataWidgetMapper::toFirst()**

        Populates the widgets with data from the first row of the model if the
        orientation is horizontal (the default), otherwise with data from the
        first column.

        This is equivalent to calling `setCurrentIndex(0)`.

        **See also** **toLast** () and **setCurrentIndex** ().
        """
        ...

    def submit(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#submit

        **[slot] bool QDataWidgetMapper::submit()**

        Submits all changes from the mapped widgets to the model.

        For every mapped section, the item delegate reads the current value from
        the widget and sets it in the model. Finally, the model's **submit** ()
        method is invoked.

        Returns `true` if all the values were submitted, otherwise false.

        Note: For database models, **QSqlQueryModel::lastError** () can be used
        to retrieve the last error.

        **See also** **revert** () and **setSubmitPolicy** ().
        """
        ...

    def setCurrentModelIndex(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#setCurrentModelIndex

        **[slot] void QDataWidgetMapper::setCurrentModelIndex(const QModelIndex
        & index )**

        Sets the current index to the row of the **index** if the orientation is
        horizontal (the default), otherwise to the column of the **index**.

        Calls **setCurrentIndex** () internally. This convenience slot can be
        connected to the signal **currentRowChanged** () or
        **currentColumnChanged** () of another view's **selection model** .

        The following example illustrates how to update all widgets with new
        data whenever the selection of a **QTableView**  named `myTableView`
        changes:

        **QDataWidgetMapper**  *mapper = new **QDataWidgetMapper** ;
        connect(myTableView->selectionModel(), &**QItemSelectionModel**
        ::currentRowChanged,
                    mapper, &**QDataWidgetMapper**
        ::setCurrentModelIndex);

        **See also** **currentIndex** ().
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#currentIndex-prop

        **currentIndex : int**

        This property holds the current row or column

        The widgets are populated with with data from the row at **index** if
        the orientation is horizontal (the default), otherwise with data from
        the column at **index**.

        **Access functions:**

        int **currentIndex** () const
        virtual void **setCurrentIndex** (int
        **index** )

        **Notifier signal:**

        void ****currentIndexChanged** ** (int **index** )

        **See also** **setCurrentModelIndex** (), **toFirst** (), **toNext** (),
        **toPrevious** (), and **toLast** ().
        """
        ...

    def revert(self) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#revert

        **[slot] void QDataWidgetMapper::revert()**

        Repopulates all widgets with the current data of the model. All
        unsubmitted changes will be lost.

        **See also** **submit** () and **setSubmitPolicy** ().
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#currentIndex-prop

        **currentIndex : int**

        This property holds the current row or column

        The widgets are populated with with data from the row at **index** if
        the orientation is horizontal (the default), otherwise with data from
        the column at **index**.

        **Access functions:**

        int **currentIndex** () const
        virtual void **setCurrentIndex** (int
        **index** )

        **Notifier signal:**

        void ****currentIndexChanged** ** (int **index** )

        **See also** **setCurrentModelIndex** (), **toFirst** (), **toNext** (),
        **toPrevious** (), and **toLast** ().
        """
        ...

    def clearMapping(self) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#clearMapping

        **void QDataWidgetMapper::clearMapping()**

        Clears all mappings.

        **See also** **addMapping** () and **removeMapping** ().
        """
        ...

    def mappedWidgetAt(self, section: int) -> QWidget:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#mappedWidgetAt

        **QWidget *QDataWidgetMapper::mappedWidgetAt(int section ) const**

        Returns the widget that is mapped at **section** , or 0 if no widget is
        mapped at that section.

        **See also** **addMapping** () and **removeMapping** ().
        """
        ...

    def mappedSection(self, widget: QWidget) -> int:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#mappedSection

        **int QDataWidgetMapper::mappedSection(QWidget * widget ) const**

        Returns the section the **widget** is mapped to or -1 if the widget is
        not mapped.

        **See also** **addMapping** () and **removeMapping** ().
        """
        ...

    def mappedPropertyName(self, widget: QWidget) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#mappedPropertyName

        **QByteArray QDataWidgetMapper::mappedPropertyName(QWidget * widget )
        const**

        Returns the name of the property that is used when mapping data to the
        given **widget**.

        **See also** **mappedSection** (), **addMapping** (), and
        **removeMapping** ().
        """
        ...

    def removeMapping(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#removeMapping

        **void QDataWidgetMapper::removeMapping(QWidget * widget )**

        Removes the mapping for the given **widget**.

        **See also** **addMapping** () and **clearMapping** ().
        """
        ...

    @typing.overload
    def addMapping(self, widget: QWidget, section: int) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#addMapping

        **void QDataWidgetMapper::addMapping(QWidget * widget , int section )**

        Adds a mapping between a **widget** and a **section** from the model.
        The **section** is a column in the model if the orientation is
        horizontal (the default), otherwise a row.

        For the following example, we assume a model `myModel` that has two
        columns: the first one contains the names of people in a group, and the
        second column contains their ages. The first column is mapped to the
        **QLineEdit**  `nameLineEdit`, and the second is mapped to the
        **QSpinBox**  `ageSpinBox`:

        **QDataWidgetMapper**  *mapper = new **QDataWidgetMapper** ;
        mapper->setModel(myModel);
            mapper->addMapping(nameLineEdit, 0);
        mapper->addMapping(ageSpinBox, 1);

        **Notes:**

        * If the **widget** is already mapped to a section, the old mapping will
        be replaced by the new one.
          * Only one-to-one mappings between
        sections and widgets are allowed. It is not possible to map a single
        section to multiple widgets, or to map a single widget to multiple
        sections.

        **See also** **removeMapping** (), **mappedSection** (), and
        **clearMapping** ().
        """
        ...

    @typing.overload
    def addMapping(
        self, widget: QWidget, section: int, propertyName: QtCore.QByteArray
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#addMapping-1

        **void QDataWidgetMapper::addMapping(QWidget * widget , int section ,
        const QByteArray & propertyName )**

        Essentially the same as addMapping(), but adds the possibility to
        specify the property to use specifying **propertyName**.

        **See also** **addMapping** ().
        """
        ...

    def submitPolicy(self) -> "QDataWidgetMapper.SubmitPolicy":
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#submitPolicy-prop

        **submitPolicy : SubmitPolicy**

        This property holds the current submit policy

        Changing the current submit policy will revert all widgets to the
        current data from the model.

        **Access functions:**

        QDataWidgetMapper::SubmitPolicy **submitPolicy** () const
        void
        **setSubmitPolicy** (QDataWidgetMapper::SubmitPolicy **policy** )

        **Member Function Documentation**
        """
        ...

    def setSubmitPolicy(self, policy: "QDataWidgetMapper.SubmitPolicy") -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#submitPolicy-prop

        **submitPolicy : SubmitPolicy**

        This property holds the current submit policy

        Changing the current submit policy will revert all widgets to the
        current data from the model.

        **Access functions:**

        QDataWidgetMapper::SubmitPolicy **submitPolicy** () const
        void
        **setSubmitPolicy** (QDataWidgetMapper::SubmitPolicy **policy** )

        **Member Function Documentation**
        """
        ...

    def orientation(self) -> QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#orientation-prop

        **orientation : Qt::Orientation**

        This property holds the orientation of the model

        If the orientation is **Qt::Horizontal**  (the default), a widget is
        mapped to a column of a data model. The widget will be populated with
        the model's data from its mapped column and the row that
        **currentIndex** () points at.

        Use **Qt::Horizontal**  for tabular data that looks like this:

        1Qt NorwayOslo
        2Qt AustraliaBrisbane
        3Qt USASilicon Valley
        4Qt
        ChinaBeijing
        5Qt GermanyBerlin

        If the orientation is set to **Qt::Vertical** , a widget is mapped to a
        row. Calling **setCurrentIndex** () will change the current column. The
        widget will be populates with the model's data from its mapped row and
        the column that **currentIndex** () points at.

        Use **Qt::Vertical**  for tabular data that looks like this:

        12345
        Qt NorwayQt AustraliaQt USAQt ChinaQt Germany
        OsloBrisbaneSilicon ValleyBeijingBerlin

        Changing the orientation clears all existing mappings.

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation**
        (Qt::Orientation **aOrientation** )
        """
        ...

    def setOrientation(self, aOrientation: QtCore.Qt.Orientation) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#orientation-prop

        **orientation : Qt::Orientation**

        This property holds the orientation of the model

        If the orientation is **Qt::Horizontal**  (the default), a widget is
        mapped to a column of a data model. The widget will be populated with
        the model's data from its mapped column and the row that
        **currentIndex** () points at.

        Use **Qt::Horizontal**  for tabular data that looks like this:

        1Qt NorwayOslo
        2Qt AustraliaBrisbane
        3Qt USASilicon Valley
        4Qt
        ChinaBeijing
        5Qt GermanyBerlin

        If the orientation is set to **Qt::Vertical** , a widget is mapped to a
        row. Calling **setCurrentIndex** () will change the current column. The
        widget will be populates with the model's data from its mapped row and
        the column that **currentIndex** () points at.

        Use **Qt::Vertical**  for tabular data that looks like this:

        12345
        Qt NorwayQt AustraliaQt USAQt ChinaQt Germany
        OsloBrisbaneSilicon ValleyBeijingBerlin

        Changing the orientation clears all existing mappings.

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation**
        (Qt::Orientation **aOrientation** )
        """
        ...

    def rootIndex(self) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#rootIndex

        **QModelIndex QDataWidgetMapper::rootIndex() const**

        Returns the current root index.

        **See also** **setRootIndex** ().
        """
        ...

    def setRootIndex(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#setRootIndex

        **void QDataWidgetMapper::setRootIndex(const QModelIndex & index )**

        Sets the root item to **index**. This can be used to display a branch of
        a tree. Pass an invalid model index to display the top-most branch.

        **See also** **rootIndex** ().
        """
        ...

    def itemDelegate(self) -> QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#itemDelegate

        **QAbstractItemDelegate *QDataWidgetMapper::itemDelegate() const**

        Returns the current item delegate.

        **See also** **setItemDelegate** ().
        """
        ...

    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#setItemDelegate

        **void QDataWidgetMapper::setItemDelegate(QAbstractItemDelegate *
        delegate )**

        Sets the item delegate to **delegate**. The delegate will be used to
        write data from the model into the widget and from the widget to the
        model, using **QAbstractItemDelegate::setEditorData** () and
        **QAbstractItemDelegate::setModelData** ().

        Any existing delegate will be removed, but not deleted.
        **QDataWidgetMapper**  does not take ownership of **delegate**.

        The delegate also decides when to apply data and when to change the
        editor, using **QAbstractItemDelegate::commitData** () and
        **QAbstractItemDelegate::closeEditor** ().

        **Warning:** You should not share the same instance of a delegate
        between widget mappers or views. Doing so can cause incorrect or
        unintuitive editing behavior since each view connected to a given
        delegate may receive the **closeEditor** () signal, and attempt to
        access, modify or close an editor that has already been closed.

        **See also** **itemDelegate** ().
        """
        ...

    def model(self) -> QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#model

        **QAbstractItemModel *QDataWidgetMapper::model() const**

        Returns the current model.

        **See also** **setModel** ().
        """
        ...

    def setModel(self, model: QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#setModel

        **void QDataWidgetMapper::setModel(QAbstractItemModel * model )**

        Sets the current model to **model**. If another model was set, all
        mappings to that old model are cleared.

        **See also** **model** ().
        """
        ...

    @property
    def currentIndexChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdatawidgetmapper.html#currentIndexChanged

        **[signal] void QDataWidgetMapper::currentIndexChanged(int index )**

        This signal is emitted after the current index has changed and all
        widgets were populated with new data. **index** is the new current
        index.

        **Note:** Notifier signal for property **currentIndex** .

        **See also** **currentIndex** () and **setCurrentIndex** ().
        """
        ...
