"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
import datetime
from PyQt6.QtWidgets import *
import enum


class QDateTimeEdit(QAbstractSpinBox):
    """
    https://doc.qt.io/qt-6/qdatetimeedit.html

    **Detailed Description**

    ![](images/windows-datetimeedit.png)

    QDateTimeEdit allows the user to edit dates by using the keyboard or the
    arrow keys to increase and decrease date and time values. The arrow keys can
    be used to move from section to section within the QDateTimeEdit box. Dates
    and times appear in accordance with the format set; see **setDisplayFormat**
    ().

    **QDateTimeEdit**  *dateEdit = new **QDateTimeEdit** (**QDate**
    ::currentDate());
        dateEdit->setMinimumDate(**QDate**
    ::currentDate().addDays(-365));
        dateEdit->setMaximumDate(**QDate**
    ::currentDate().addDays(365));
        dateEdit->setDisplayFormat("yyyy.MM.dd");

    Here we've created a new QDateTimeEdit object initialized with today's date,
    and restricted the valid date range to today plus or minus 365 days. We've
    set the order to month, day, year.

    The range of valid values for a QDateTimeEdit is controlled by the
    properties **minimumDateTime** , **maximumDateTime** , and their respective
    date and time components. By default, any date-time from the start of 100 CE
    to the end of 9999 CE is valid.

    **Using a Pop-up Calendar Widget**

    QDateTimeEdit can be configured to allow a **QCalendarWidget**  to be used
    to select dates. This is enabled by setting the **calendarPopup**  property.
    Additionally, you can supply a custom calendar widget for use as the
    calendar pop-up by calling the **setCalendarWidget** () function. The
    existing calendar widget can be retrieved with **calendarWidget** ().

    **Keyboard Tracking**

    When **keyboard tracking**  is enabled (the default), every keystroke of
    editing a field triggers signals for value changes.

    When the allowed **range**  is narrower than some time interval whose end it
    straddles, keyboard tracking prevents the user editing the date or time to
    access the later part of the interval. For example, for a range from
    29.04.2020 to 02.05.2020 and an initial date of 30.04.2020, the user can
    change neither the month (May 30th is outside the range) nor the day (April
    2nd is outside the range).

    When keyboard tracking is disabled, changes are only signalled when focus
    leaves the text field after edits have modified the content. This allows the
    user to edit via an invalid date-time to reach a valid one.

    **See also** **QDateEdit** , **QTimeEdit** , **QDate** , and **QTime** .
    """

    class Section(enum.Flag):
        NoSection: QDateTimeEdit = ...
        AmPmSection: QDateTimeEdit = ...
        MSecSection: QDateTimeEdit = ...
        SecondSection: QDateTimeEdit = ...
        MinuteSection: QDateTimeEdit = ...
        HourSection: QDateTimeEdit = ...
        DaySection: QDateTimeEdit = ...
        MonthSection: QDateTimeEdit = ...
        YearSection: QDateTimeEdit = ...
        TimeSections_Mask: QDateTimeEdit = ...
        DateSections_Mask: QDateTimeEdit = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#QDateTimeEdit

        **QDateTimeEdit::QDateTimeEdit(QWidget * parent = nullptr)**

        Constructs an empty date time editor with a **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        datetime: typing.Union[QtCore.QDateTime, datetime.datetime],
        parent: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#QDateTimeEdit-1

        **QDateTimeEdit::QDateTimeEdit(const QDateTime & datetime , QWidget *
        parent = nullptr)**

        Constructs an empty date time editor with a **parent**. The value is set
        to **datetime**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        d: typing.Union[QtCore.QDate, datetime.date],
        parent: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#QDateTimeEdit-2

        **QDateTimeEdit::QDateTimeEdit(QDate date , QWidget * parent =
        nullptr)**

        Constructs an empty date time editor with a **parent**. The value is set
        to **date**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        t: typing.Union[QtCore.QTime, datetime.time],
        parent: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#QDateTimeEdit-3

        **QDateTimeEdit::QDateTimeEdit(QTime time , QWidget * parent =
        nullptr)**

        Constructs an empty date time editor with a **parent**. The value is set
        to **time**.
        """
        ...

    def setCalendar(self, calendar: QtCore.QCalendar) -> None:
        ...

    def calendar(self) -> QtCore.QCalendar:
        ...

    def setTimeSpec(self, spec: QtCore.Qt.TimeSpec) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#timeSpec-prop

        **timeSpec : Qt::TimeSpec**

        This property holds the current timespec used by the date time edit.

        **Access functions:**

        Qt::TimeSpec **timeSpec** () const
        void **setTimeSpec** (Qt::TimeSpec
        **spec** )

        **Member Function Documentation**
        """
        ...

    def timeSpec(self) -> QtCore.Qt.TimeSpec:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#timeSpec-prop

        **timeSpec : Qt::TimeSpec**

        This property holds the current timespec used by the date time edit.

        **Access functions:**

        Qt::TimeSpec **timeSpec** () const
        void **setTimeSpec** (Qt::TimeSpec
        **spec** )

        **Member Function Documentation**
        """
        ...

    def setCalendarWidget(self, calendarWidget: QCalendarWidget) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#setCalendarWidget

        **void QDateTimeEdit::setCalendarWidget(QCalendarWidget * calendarWidget
        )**

        Sets the given **calendarWidget** as the widget to be used for the
        calendar pop-up. The editor does not automatically take ownership of the
        calendar widget.

        **Note:****calendarPopup**  must be set to true before setting the
        calendar widget.

        **See also** **calendarWidget** () and **calendarPopup** .
        """
        ...

    def calendarWidget(self) -> QCalendarWidget:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#calendarWidget

        **QCalendarWidget *QDateTimeEdit::calendarWidget() const**

        Returns the calendar widget for the editor if **calendarPopup**  is set
        to true and (sections() & **DateSections_Mask** ) != 0.

        This function creates and returns a calendar widget if none has been
        set.

        **See also** **setCalendarWidget** ().
        """
        ...

    def setDateTimeRange(
        self,
        min: typing.Union[QtCore.QDateTime, datetime.datetime],
        max: typing.Union[QtCore.QDateTime, datetime.datetime],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#setDateTimeRange

        **void QDateTimeEdit::setDateTimeRange(const QDateTime & min , const
        QDateTime & max )**

        Set the range of allowed date-times for the date time edit.

        This convenience function sets the **minimumDateTime**  and
        **maximumDateTime**  properties.

        setDateTimeRange(min, max);

        is analogous to:

        setMinimumDateTime(min);
            setMaximumDateTime(max);

        If either **min** or **max** is invalid, this function does nothing. If
        **max** is less than **min** , **min** is used also as **max**.

        If the range is narrower then a time interval whose end it spans, for
        example a week that spans the end of a month, users can only edit the
        date-time to one in the later part of the range if keyboard-tracking is
        disabled.

        **See also** **minimumDateTime** , **maximumDateTime** ,
        **setDateRange** (), **setTimeRange** (), **QDateTime::isValid** (), and
        **Keyboard Tracking** .
        """
        ...

    def setMaximumDateTime(
        self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#maximumDateTime-prop

        **maximumDateTime : QDateTime**

        This property holds the maximum datetime of the date time edit.

        Changing this property implicitly updates the **maximumDate**  and
        **maximumTime**  properties to the date and time parts of this property,
        respectively. When setting this property, the **minimumDateTime**  is
        adjusted, if necessary, to ensure that the range remains valid.
        Otherwise, changing this property preserves the **minimumDateTime**
        property.

        This property can only be set to a valid **QDateTime**  value. The
        latest date-time that setMaximumDateTime() accepts is the end of 9999
        CE. This is the default for this property. This default can be restored
        with clearMaximumDateTime().

        **Access functions:**

        QDateTime **maximumDateTime** () const
        void **setMaximumDateTime**
        (const QDateTime & **dt** )
        void **clearMaximumDateTime** ()

        **See also** **minimumDateTime** , **maximumTime** , **maximumDate** (),
        **setDateTimeRange** (), **QDateTime::isValid** (), and **Keyboard
        Tracking** .
        """
        ...

    def clearMaximumDateTime(self) -> None:
        ...

    def maximumDateTime(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#maximumDateTime-prop

        **maximumDateTime : QDateTime**

        This property holds the maximum datetime of the date time edit.

        Changing this property implicitly updates the **maximumDate**  and
        **maximumTime**  properties to the date and time parts of this property,
        respectively. When setting this property, the **minimumDateTime**  is
        adjusted, if necessary, to ensure that the range remains valid.
        Otherwise, changing this property preserves the **minimumDateTime**
        property.

        This property can only be set to a valid **QDateTime**  value. The
        latest date-time that setMaximumDateTime() accepts is the end of 9999
        CE. This is the default for this property. This default can be restored
        with clearMaximumDateTime().

        **Access functions:**

        QDateTime **maximumDateTime** () const
        void **setMaximumDateTime**
        (const QDateTime & **dt** )
        void **clearMaximumDateTime** ()

        **See also** **minimumDateTime** , **maximumTime** , **maximumDate** (),
        **setDateTimeRange** (), **QDateTime::isValid** (), and **Keyboard
        Tracking** .
        """
        ...

    def setMinimumDateTime(
        self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#minimumDateTime-prop

        **minimumDateTime : QDateTime**

        This property holds the minimum datetime of the date time edit.

        Changing this property implicitly updates the **minimumDate**  and
        **minimumTime**  properties to the date and time parts of this property,
        respectively. When setting this property, the **maximumDateTime**  is
        adjusted, if necessary, to ensure that the range remains valid.
        Otherwise, changing this property preserves the **maximumDateTime**
        property.

        This property can only be set to a valid **QDateTime**  value. The
        earliest date-time that setMinimumDateTime() accepts is the start of 100
        CE. The property's default is the start of September 14, 1752 CE. This
        default can be restored with clearMinimumDateTime().

        **Access functions:**

        QDateTime **minimumDateTime** () const
        void **setMinimumDateTime**
        (const QDateTime & **dt** )
        void **clearMinimumDateTime** ()

        **See also** **maximumDateTime** , **minimumTime** , **minimumDate** ,
        **setDateTimeRange** (), **QDateTime::isValid** (), and **Keyboard
        Tracking** .
        """
        ...

    def clearMinimumDateTime(self) -> None:
        ...

    def minimumDateTime(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#minimumDateTime-prop

        **minimumDateTime : QDateTime**

        This property holds the minimum datetime of the date time edit.

        Changing this property implicitly updates the **minimumDate**  and
        **minimumTime**  properties to the date and time parts of this property,
        respectively. When setting this property, the **maximumDateTime**  is
        adjusted, if necessary, to ensure that the range remains valid.
        Otherwise, changing this property preserves the **maximumDateTime**
        property.

        This property can only be set to a valid **QDateTime**  value. The
        earliest date-time that setMinimumDateTime() accepts is the start of 100
        CE. The property's default is the start of September 14, 1752 CE. This
        default can be restored with clearMinimumDateTime().

        **Access functions:**

        QDateTime **minimumDateTime** () const
        void **setMinimumDateTime**
        (const QDateTime & **dt** )
        void **clearMinimumDateTime** ()

        **See also** **maximumDateTime** , **minimumTime** , **minimumDate** ,
        **setDateTimeRange** (), **QDateTime::isValid** (), and **Keyboard
        Tracking** .
        """
        ...

    def stepEnabled(self) -> QAbstractSpinBox.StepEnabledFlag:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#stepEnabled

        **[override virtual protected] QAbstractSpinBox::StepEnabled
        QDateTimeEdit::stepEnabled() const**

        Reimplements: **QAbstractSpinBox::stepEnabled() const** .
        """
        ...

    def textFromDateTime(
        self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> str:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#textFromDateTime

        **[virtual protected] QString QDateTimeEdit::textFromDateTime(const
        QDateTime & dateTime ) const**

        This virtual function is used by the date time edit whenever it needs to
        display **dateTime**.

        If you reimplement this, you may also need to reimplement **validate**
        ().

        **See also** **dateTimeFromText** () and **validate** ().
        """
        ...

    def dateTimeFromText(self, text: str) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#dateTimeFromText

        **[virtual protected] QDateTime QDateTimeEdit::dateTimeFromText(const
        QString & text ) const**

        Returns an appropriate datetime for the given **text**.

        This virtual function is used by the datetime edit whenever it needs to
        interpret text entered by the user as a value.

        **See also** **textFromDateTime** () and **validate** ().
        """
        ...

    def fixup(self, input: str) -> str:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#fixup

        **[override virtual protected] void QDateTimeEdit::fixup(QString & input
        ) const**

        Reimplements: **QAbstractSpinBox::fixup(QString &input) const** .
        """
        ...

    def validate(
        self, input: str, pos: int
    ) -> typing.Tuple[QtGui.QValidator.State, str, int]:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#validate

        **[override virtual protected] QValidator::State
        QDateTimeEdit::validate(QString & text , int & pos ) const**

        Reimplements: **QAbstractSpinBox::validate(QString &input, int &pos)
        const** .
        """
        ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#paintEvent

        **[override virtual protected] void
        QDateTimeEdit::paintEvent(QPaintEvent * event )**

        Reimplements: **QAbstractSpinBox::paintEvent** (QPaintEvent *event).
        """
        ...

    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#mousePressEvent

        **[override virtual protected] void
        QDateTimeEdit::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QAbstractSpinBox::mousePressEvent** (QMouseEvent
        *event).
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#focusNextPrevChild

        **[override virtual protected] bool
        QDateTimeEdit::focusNextPrevChild(bool next )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def focusInEvent(self, e: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#focusInEvent

        **[override virtual protected] void
        QDateTimeEdit::focusInEvent(QFocusEvent * event )**

        Reimplements: **QAbstractSpinBox::focusInEvent** (QFocusEvent *event).
        """
        ...

    def wheelEvent(self, e: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#wheelEvent

        **[override virtual protected] void
        QDateTimeEdit::wheelEvent(QWheelEvent * event )**

        Reimplements: **QAbstractSpinBox::wheelEvent** (QWheelEvent *event).
        """
        ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#keyPressEvent

        **[override virtual protected] void
        QDateTimeEdit::keyPressEvent(QKeyEvent * event )**

        Reimplements: **QAbstractSpinBox::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionSpinBox") -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#initStyleOption

        **[override virtual protected] void
        QDateTimeEdit::initStyleOption(QStyleOptionSpinBox * option ) const**

        Reimplements: **QAbstractSpinBox::initStyleOption(QStyleOptionSpinBox
        *option) const** .

        Initialize **option** with the values from this QDataTimeEdit. This
        method is useful for subclasses when they need a **QStyleOptionSpinBox**
        , but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def setTime(self, time: typing.Union[QtCore.QTime, datetime.time]) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#time

        **QTime QDateTimeEdit::time() const**

        Returns the time of the date time edit.

        **Note:** Getter function for property time.

        **See also** **setTime** ().
        """
        ...

    def setDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#date

        **QDate QDateTimeEdit::date() const**

        Returns the date of the date time edit.

        **Note:** Getter function for property date.

        **See also** **setDate** ().
        """
        ...

    def setDateTime(
        self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#dateTime-prop

        **dateTime : QDateTime**

        This property holds the **QDateTime**  that is set in the
        **QDateTimeEdit** .

        When setting this property, the new **QDateTime**  is converted to the
        timespec of the **QDateTimeEdit** , which thus remains unchanged.

        By default, this property is set to the start of 2000 CE. It can only be
        set to a valid **QDateTime**  value. If any operation causes this
        property to have an invalid date-time as value, it is reset to the value
        of the **minimumDateTime**  property.

        If the **QDateTimeEdit**  has no date fields, setting this property sets
        the widget's date-range to start and end on the date of the new value of
        this property.

        **Access functions:**

        QDateTime **dateTime** () const
        void **setDateTime** (const QDateTime
        & **dateTime** )

        **Notifier signal:**

        void ****dateTimeChanged** ** (const QDateTime & **datetime** )

        **See also** **date** , **time** , **minimumDateTime** , and
        **maximumDateTime** .
        """
        ...

    def sectionCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#sectionCount-prop

        **[read-only] sectionCount : const int**

        This property holds the number of sections displayed. If the format is
        'yyyy/yy/yyyy', sectionCount returns 3

        **Access functions:**

        int **sectionCount** () const
        """
        ...

    def setCurrentSectionIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#currentSectionIndex-prop

        **currentSectionIndex : int**

        This property holds the current section index of the spinbox.

        If the format is 'yyyy/MM/dd', the displayText is '2001/05/21', and the
        cursorPosition is 5, currentSectionIndex returns 1. If the
        cursorPosition is 3, currentSectionIndex is 0, and so on.

        **Access functions:**

        int **currentSectionIndex** () const
        void **setCurrentSectionIndex**
        (int **index** )

        **See also** **setCurrentSection** () and **currentSection** ().
        """
        ...

    def currentSectionIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#currentSectionIndex-prop

        **currentSectionIndex : int**

        This property holds the current section index of the spinbox.

        If the format is 'yyyy/MM/dd', the displayText is '2001/05/21', and the
        cursorPosition is 5, currentSectionIndex returns 1. If the
        cursorPosition is 3, currentSectionIndex is 0, and so on.

        **Access functions:**

        int **currentSectionIndex** () const
        void **setCurrentSectionIndex**
        (int **index** )

        **See also** **setCurrentSection** () and **currentSection** ().
        """
        ...

    def sectionAt(self, index: int) -> "QDateTimeEdit.Section":
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#sectionAt

        **QDateTimeEdit::Section QDateTimeEdit::sectionAt(int index ) const**

        Returns the Section at **index**.

        If the format is 'yyyy/MM/dd', sectionAt(0) returns **YearSection** ,
        sectionAt(1) returns **MonthSection** , and sectionAt(2) returns
        **YearSection** ,
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#event

        **[override virtual] bool QDateTimeEdit::event(QEvent * event )**

        Reimplements: **QAbstractSpinBox::event** (QEvent *event).
        """
        ...

    def stepBy(self, steps: int) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#stepBy

        **[override virtual] void QDateTimeEdit::stepBy(int steps )**

        Reimplements: **QAbstractSpinBox::stepBy** (int steps).
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#clear

        **[override virtual] void QDateTimeEdit::clear()**

        Reimplements: **QAbstractSpinBox::clear** ().
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#sizeHint

        **[override virtual] QSize QDateTimeEdit::sizeHint() const**

        Reimplements: **QAbstractSpinBox::sizeHint() const** .
        """
        ...

    def setSelectedSection(self, section: "QDateTimeEdit.Section") -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#setSelectedSection

        **void QDateTimeEdit::setSelectedSection(QDateTimeEdit::Section section
        )**

        Selects **section**. If **section** doesn't exist in the currently
        displayed sections, this function does nothing. If **section** is
        **NoSection** , this function will unselect all text in the editor.
        Otherwise, this function will move the cursor and the current section to
        the selected section.

        **See also** **currentSection** ().
        """
        ...

    def setCalendarPopup(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#calendarPopup-prop

        **calendarPopup : bool**

        This property holds the current calendar pop-up show mode.

        The calendar pop-up will be shown upon clicking the arrow button. This
        property is valid only if there is a valid date display format.

        **Access functions:**

        bool **calendarPopup** () const
        void **setCalendarPopup** (bool
        **enable** )

        **See also** **setDisplayFormat** ().
        """
        ...

    def calendarPopup(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#calendarPopup-prop

        **calendarPopup : bool**

        This property holds the current calendar pop-up show mode.

        The calendar pop-up will be shown upon clicking the arrow button. This
        property is valid only if there is a valid date display format.

        **Access functions:**

        bool **calendarPopup** () const
        void **setCalendarPopup** (bool
        **enable** )

        **See also** **setDisplayFormat** ().
        """
        ...

    def setDisplayFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#displayFormat-prop

        **displayFormat : QString**

        This property holds the format used to display the time/date of the date
        time edit.

        This format is described in **QDateTime::toString** () and
        **QDateTime::fromString** ()

        Example format strings (assuming that the date is 2nd of July 1969):

        FormatResult
        dd.MM.yyyy02.07.1969
        MMM d yyJul 2 69
        MMMM d yyJuly 2
        69

        Note that if you specify a two digit year, it will be interpreted to be
        in the century in which the date time edit was initialized. The default
        century is the 21st (2000-2099).

        If you specify an invalid format the format will not be set.

        **Access functions:**

        QString **displayFormat** () const
        void **setDisplayFormat** (const
        QString & **format** )

        **See also** **QDateTime::toString** () and **displayedSections** ().
        """
        ...

    def displayFormat(self) -> str:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#displayFormat-prop

        **displayFormat : QString**

        This property holds the format used to display the time/date of the date
        time edit.

        This format is described in **QDateTime::toString** () and
        **QDateTime::fromString** ()

        Example format strings (assuming that the date is 2nd of July 1969):

        FormatResult
        dd.MM.yyyy02.07.1969
        MMM d yyJul 2 69
        MMMM d yyJuly 2
        69

        Note that if you specify a two digit year, it will be interpreted to be
        in the century in which the date time edit was initialized. The default
        century is the 21st (2000-2099).

        If you specify an invalid format the format will not be set.

        **Access functions:**

        QString **displayFormat** () const
        void **setDisplayFormat** (const
        QString & **format** )

        **See also** **QDateTime::toString** () and **displayedSections** ().
        """
        ...

    def sectionText(self, s: "QDateTimeEdit.Section") -> str:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#sectionText

        **QString QDateTimeEdit::sectionText(QDateTimeEdit::Section section )
        const**

        Returns the text from the given **section**.

        **See also** **currentSection** ().
        """
        ...

    def setCurrentSection(self, section: "QDateTimeEdit.Section") -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#currentSection-prop

        **currentSection : Section**

        This property holds the current section of the spinbox.

        **Access functions:**

        QDateTimeEdit::Section **currentSection** () const
        void
        **setCurrentSection** (QDateTimeEdit::Section **section** )
        """
        ...

    def currentSection(self) -> "QDateTimeEdit.Section":
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#currentSection-prop

        **currentSection : Section**

        This property holds the current section of the spinbox.

        **Access functions:**

        QDateTimeEdit::Section **currentSection** () const
        void
        **setCurrentSection** (QDateTimeEdit::Section **section** )
        """
        ...

    def displayedSections(self) -> "QDateTimeEdit.Section":
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#displayedSections-prop

        **[read-only] displayedSections : const Sections**

        This property holds the currently displayed fields of the date time
        edit.

        Returns a bit set of the displayed sections for this format.

        **Access functions:**

        QDateTimeEdit::Sections **displayedSections** () const

        **See also** **setDisplayFormat** () and **displayFormat** ().
        """
        ...

    def setTimeRange(
        self,
        min: typing.Union[QtCore.QTime, datetime.time],
        max: typing.Union[QtCore.QTime, datetime.time],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#setTimeRange

        **void QDateTimeEdit::setTimeRange(QTime min , QTime max )**

        Set the range of allowed times for the date time edit.

        This convenience function sets the **minimumTime**  and **maximumTime**
        properties.

        Note that these only constrain the date time edit's value on,
        respectively, the **minimumDate**  and **maximumDate** . When these date
        properties do not coincide, times after **max** are allowed on dates
        before **maximumDate**  and times before **min** are allowed on dates
        after **minimumDate** .

        setTimeRange(min, max);

        is analogous to:

        setMinimumTime(min);
            setMaximumTime(max);

        If either **min** or **max** is invalid, this function does nothing.
        This function preserves the **minimumDate**  and **maximumDate**
        properties. If those properties coincide and **max** is less than
        **min** , **min** is used as **max**.

        If the range is narrower then a time interval whose end it spans, for
        example the interval from ten to an hour to ten past the same hour,
        users can only edit the time to one in the later part of the range if
        keyboard-tracking is disabled.

        **See also** **minimumTime** , **maximumTime** , **setDateTimeRange**
        (), **QTime::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def clearMaximumTime(self) -> None:
        ...

    def setMaximumTime(self, max: typing.Union[QtCore.QTime, datetime.time]) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#maximumTime-prop

        **maximumTime : QTime**

        This property holds the maximum time of the date time edit.

        Changing this property updates the time of the **maximumDateTime**
        property while preserving the **minimumDate**  and **maximumDate**
        properties. If those date properties coincide, when setting this
        property, the **minimumTime**  property is adjusted, if necessary, to
        ensure that the range remains valid. Otherwise, changing this property
        preserves the **minimumDateTime**  property.

        This property can be set to any valid **QTime**  value. By default, this
        property contains a time of 23:59:59 and 999 milliseconds. This default
        can be restored with clearMaximumTime().

        **Access functions:**

        QTime **maximumTime** () const
        void **setMaximumTime** (QTime **max**
        )
        void **clearMaximumTime** ()

        **See also** **minimumTime** , **maximumDate** , **maximumDateTime** ,
        **setTimeRange** (), **QTime::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def maximumTime(self) -> QtCore.QTime:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#maximumTime-prop

        **maximumTime : QTime**

        This property holds the maximum time of the date time edit.

        Changing this property updates the time of the **maximumDateTime**
        property while preserving the **minimumDate**  and **maximumDate**
        properties. If those date properties coincide, when setting this
        property, the **minimumTime**  property is adjusted, if necessary, to
        ensure that the range remains valid. Otherwise, changing this property
        preserves the **minimumDateTime**  property.

        This property can be set to any valid **QTime**  value. By default, this
        property contains a time of 23:59:59 and 999 milliseconds. This default
        can be restored with clearMaximumTime().

        **Access functions:**

        QTime **maximumTime** () const
        void **setMaximumTime** (QTime **max**
        )
        void **clearMaximumTime** ()

        **See also** **minimumTime** , **maximumDate** , **maximumDateTime** ,
        **setTimeRange** (), **QTime::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def clearMinimumTime(self) -> None:
        ...

    def setMinimumTime(self, min: typing.Union[QtCore.QTime, datetime.time]) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#minimumTime-prop

        **minimumTime : QTime**

        This property holds the minimum time of the date time edit.

        Changing this property updates the time of the **minimumDateTime**
        property while preserving the **minimumDate**  and **maximumDate**
        properties. If those date properties coincide, when setting this
        property, the **maximumTime**  property is adjusted, if necessary, to
        ensure that the range remains valid. Otherwise, changing this property
        preserves the **maximumDateTime**  property.

        This property can be set to any valid **QTime**  value. By default, this
        property contains a time of 00:00:00 and 0 milliseconds. This default
        can be restored with clearMinimumTime().

        **Access functions:**

        QTime **minimumTime** () const
        void **setMinimumTime** (QTime **min**
        )
        void **clearMinimumTime** ()

        **See also** **maximumTime** , **minimumDate** , **minimumDateTime** ,
        **setTimeRange** (), **QTime::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def minimumTime(self) -> QtCore.QTime:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#minimumTime-prop

        **minimumTime : QTime**

        This property holds the minimum time of the date time edit.

        Changing this property updates the time of the **minimumDateTime**
        property while preserving the **minimumDate**  and **maximumDate**
        properties. If those date properties coincide, when setting this
        property, the **maximumTime**  property is adjusted, if necessary, to
        ensure that the range remains valid. Otherwise, changing this property
        preserves the **maximumDateTime**  property.

        This property can be set to any valid **QTime**  value. By default, this
        property contains a time of 00:00:00 and 0 milliseconds. This default
        can be restored with clearMinimumTime().

        **Access functions:**

        QTime **minimumTime** () const
        void **setMinimumTime** (QTime **min**
        )
        void **clearMinimumTime** ()

        **See also** **maximumTime** , **minimumDate** , **minimumDateTime** ,
        **setTimeRange** (), **QTime::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def setDateRange(
        self,
        min: typing.Union[QtCore.QDate, datetime.date],
        max: typing.Union[QtCore.QDate, datetime.date],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#setDateRange

        **void QDateTimeEdit::setDateRange(QDate min , QDate max )**

        Set the range of allowed dates for the date time edit.

        This convenience function sets the **minimumDate**  and **maximumDate**
        properties.

        setDateRange(min, max);

        is analogous to:

        setMinimumDate(min);
            setMaximumDate(max);

        If either **min** or **max** is invalid, this function does nothing.
        This function preserves the **minimumTime**  property. If **max** is
        less than **min** , the new **maximumDateTime**  property shall be the
        new **minimumDateTime**  property. If **max** is equal to **min** and
        the **maximumTime**  property was less then the **minimumTime**
        property, the **maximumTime**  property is set to the **minimumTime**
        property. Otherwise, this preserves the **maximumTime**  property.

        If the range is narrower then a time interval whose end it spans, for
        example a week that spans the end of a month, users can only edit the
        date to one in the later part of the range if keyboard-tracking is
        disabled.

        **See also** **minimumDate** , **maximumDate** , **setDateTimeRange**
        (), **QDate::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def clearMaximumDate(self) -> None:
        ...

    def setMaximumDate(self, max: typing.Union[QtCore.QDate, datetime.date]) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#maximumDate-prop

        **maximumDate : QDate**

        This property holds the maximum date of the date time edit.

        Changing this property updates the date of the **maximumDateTime**
        property while preserving the **maximumTime**  property. When setting
        this property, the **minimumDate**  is adjusted, if necessary, to ensure
        that the range remains valid. When this happens, the **minimumTime**
        property is also adjusted if it is greater than the **maximumTime**
        property. Otherwise, changes to this property preserve the
        **minimumDateTime**  property.

        This property can only be set to a valid **QDate**  object describing a
        date on which the current **maximumTime**  property makes a valid
        **QDateTime**  object. The latest date that setMaximumDate() accepts is
        the end of 9999 CE. This is the default for this property. This default
        can be restored with **clearMaximumDateTime** ().

        **Access functions:**

        QDate **maximumDate** () const
        void **setMaximumDate** (QDate **max**
        )
        void **clearMaximumDate** ()

        **See also** **minimumDate** , **maximumTime** , **maximumDateTime** ,
        **setDateRange** (), **QDate::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def maximumDate(self) -> QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#maximumDate-prop

        **maximumDate : QDate**

        This property holds the maximum date of the date time edit.

        Changing this property updates the date of the **maximumDateTime**
        property while preserving the **maximumTime**  property. When setting
        this property, the **minimumDate**  is adjusted, if necessary, to ensure
        that the range remains valid. When this happens, the **minimumTime**
        property is also adjusted if it is greater than the **maximumTime**
        property. Otherwise, changes to this property preserve the
        **minimumDateTime**  property.

        This property can only be set to a valid **QDate**  object describing a
        date on which the current **maximumTime**  property makes a valid
        **QDateTime**  object. The latest date that setMaximumDate() accepts is
        the end of 9999 CE. This is the default for this property. This default
        can be restored with **clearMaximumDateTime** ().

        **Access functions:**

        QDate **maximumDate** () const
        void **setMaximumDate** (QDate **max**
        )
        void **clearMaximumDate** ()

        **See also** **minimumDate** , **maximumTime** , **maximumDateTime** ,
        **setDateRange** (), **QDate::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def clearMinimumDate(self) -> None:
        ...

    def setMinimumDate(self, min: typing.Union[QtCore.QDate, datetime.date]) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#minimumDate-prop

        **minimumDate : QDate**

        This property holds the minimum date of the date time edit.

        Changing this property updates the date of the **minimumDateTime**
        property while preserving the **minimumTime**  property. When setting
        this property, the **maximumDate**  is adjusted, if necessary, to ensure
        that the range remains valid. When this happens, the **maximumTime**
        property is also adjusted if it is less than the **minimumTime**
        property. Otherwise, changes to this property preserve the
        **maximumDateTime**  property.

        This property can only be set to a valid **QDate**  object describing a
        date on which the current **minimumTime**  property makes a valid
        **QDateTime**  object. The earliest date that setMinimumDate() accepts
        is the start of 100 CE. The default for this property is September 14,
        1752 CE. This default can be restored with **clearMinimumDateTime** ().

        **Access functions:**

        QDate **minimumDate** () const
        void **setMinimumDate** (QDate **min**
        )
        void **clearMinimumDate** ()

        **See also** **maximumDate** , **minimumTime** , **minimumDateTime** ,
        **setDateRange** (), **QDate::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def minimumDate(self) -> QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#minimumDate-prop

        **minimumDate : QDate**

        This property holds the minimum date of the date time edit.

        Changing this property updates the date of the **minimumDateTime**
        property while preserving the **minimumTime**  property. When setting
        this property, the **maximumDate**  is adjusted, if necessary, to ensure
        that the range remains valid. When this happens, the **maximumTime**
        property is also adjusted if it is less than the **minimumTime**
        property. Otherwise, changes to this property preserve the
        **maximumDateTime**  property.

        This property can only be set to a valid **QDate**  object describing a
        date on which the current **minimumTime**  property makes a valid
        **QDateTime**  object. The earliest date that setMinimumDate() accepts
        is the start of 100 CE. The default for this property is September 14,
        1752 CE. This default can be restored with **clearMinimumDateTime** ().

        **Access functions:**

        QDate **minimumDate** () const
        void **setMinimumDate** (QDate **min**
        )
        void **clearMinimumDate** ()

        **See also** **maximumDate** , **minimumTime** , **minimumDateTime** ,
        **setDateRange** (), **QDate::isValid** (), and **Keyboard Tracking** .
        """
        ...

    def time(self) -> QtCore.QTime:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#time-prop

        **time : QTime**

        This property holds the **QTime**  that is set in the widget.

        By default, this property contains a time of 00:00:00 and 0
        milliseconds.

        **Access functions:**

        QTime ****time** ** () const
        void **setTime** (QTime **time** )

        **Notifier signal:**

        void ****timeChanged** ** (QTime **time** )

        **See also** **date**  and **dateTime** .
        """
        ...

    def date(self) -> QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#date-prop

        **date : QDate**

        This property holds the **QDate**  that is set in the widget.

        By default, this property contains a date that refers to January 1,
        2000.

        **Access functions:**

        QDate ****date** ** () const
        void **setDate** (QDate **date** )

        **Notifier signal:**

        void ****dateChanged** ** (QDate **date** )

        **See also** **time**  and **dateTime** .
        """
        ...

    def dateTime(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#dateTime-prop

        **dateTime : QDateTime**

        This property holds the **QDateTime**  that is set in the
        **QDateTimeEdit** .

        When setting this property, the new **QDateTime**  is converted to the
        timespec of the **QDateTimeEdit** , which thus remains unchanged.

        By default, this property is set to the start of 2000 CE. It can only be
        set to a valid **QDateTime**  value. If any operation causes this
        property to have an invalid date-time as value, it is reset to the value
        of the **minimumDateTime**  property.

        If the **QDateTimeEdit**  has no date fields, setting this property sets
        the widget's date-range to start and end on the date of the new value of
        this property.

        **Access functions:**

        QDateTime **dateTime** () const
        void **setDateTime** (const QDateTime
        & **dateTime** )

        **Notifier signal:**

        void ****dateTimeChanged** ** (const QDateTime & **datetime** )

        **See also** **date** , **time** , **minimumDateTime** , and
        **maximumDateTime** .
        """
        ...

    @property
    def dateChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#dateChanged

        **[signal] void QDateTimeEdit::dateChanged(QDate date )**

        This signal is emitted whenever the date is changed. The new date is
        passed in **date**.

        **Note:** Notifier signal for property **date** .

        **See also** **Keyboard Tracking** .
        """
        ...

    @property
    def dateTimeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#dateTimeChanged

        **[signal] void QDateTimeEdit::dateTimeChanged(const QDateTime &
        datetime )**

        This signal is emitted whenever the date or time is changed. The new
        date and time is passed in **datetime**.

        **Note:** Notifier signal for property **dateTime** .

        **See also** **Keyboard Tracking** .
        """
        ...

    @property
    def timeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdatetimeedit.html#timeChanged

        **[signal] void QDateTimeEdit::timeChanged(QTime time )**

        This signal is emitted whenever the time is changed. The new time is
        passed in **time**.

        **Note:** Notifier signal for property **time** .

        **See also** **Keyboard Tracking** .
        """
        ...
