"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6.QtWidgets import *


class QDoubleSpinBox(QAbstractSpinBox):
    """
    https://doc.qt.io/qt-6/qdoublespinbox.html

    **Detailed Description**

    QDoubleSpinBox allows the user to choose a value by clicking the up and down
    buttons or by pressing Up or Down on the keyboard to increase or decrease
    the value currently displayed. The user can also type the value in manually.
    The spin box supports double values but can be extended to use different
    strings with **validate** (), **textFromValue** () and **valueFromText** ().

    Every time the value changes QDoubleSpinBox emits **valueChanged** () and
    **textChanged** () signals, the former providing a double and the latter a
    **QString** . The **textChanged** () signal provides the value with both
    **prefix** () and **suffix** (). The current value can be fetched with
    **value** () and set with **setValue** ().

    Note: QDoubleSpinBox will round numbers so they can be displayed with the
    current precision. In a QDoubleSpinBox with decimals set to 2, calling
    **setValue** (2.555) will cause **value** () to return 2.56.

    Clicking the up and down buttons or using the keyboard accelerator's Up and
    Down arrows will increase or decrease the current value in steps of size
    **singleStep** (). If you want to change this behavior you can reimplement
    the virtual function **stepBy** (). The minimum and maximum value and the
    step size can be set using one of the constructors, and can be changed later
    with **setMinimum** (), **setMaximum** () and **setSingleStep** (). The
    spinbox has a default precision of 2 decimal places but this can be changed
    using **setDecimals** ().

    Most spin boxes are directional, but QDoubleSpinBox can also operate as a
    circular spin box, i.e. if the range is 0.0-99.9 and the current value is
    99.9, clicking "up" will give 0 if **wrapping** () is set to true. Use
    **setWrapping** () if you want circular behavior.

    The displayed value can be prepended and appended with arbitrary strings
    indicating, for example, currency or the unit of measurement. See
    **setPrefix** () and **setSuffix** (). The text in the spin box is retrieved
    with **text** () (which includes any **prefix** () and **suffix** ()), or
    with **cleanText** () (which has no **prefix** (), no **suffix** () and no
    leading or trailing whitespace).

    It is often desirable to give the user a special (often default) choice in
    addition to the range of numeric values. See **setSpecialValueText** () for
    how to do this with QDoubleSpinBox.

    **Note:** The displayed value of the QDoubleSpinBox is limited to 18
    characters in addition to eventual prefix and suffix content. This
    limitation is used to keep the double spin box usable even with extremely
    large values.

    **See also** **QSpinBox** , **QDateTimeEdit** , **QSlider** , and **Spin
    Boxes Example** .
    """

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#QDoubleSpinBox

        **QDoubleSpinBox::QDoubleSpinBox(QWidget * parent = nullptr)**

        Constructs a spin box with 0.0 as minimum value and 99.99 as maximum
        value, a step value of 1.0 and a precision of 2 decimal places. The
        value is initially set to 0.00. The spin box has the given **parent**.

        **See also** **setMinimum** (), **setMaximum** (), and **setSingleStep**
        ().
        """
        ...

    def setStepType(self, stepType: QAbstractSpinBox.StepType) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#setStepType

        **[since 5.12] void
        QDoubleSpinBox::setStepType(QAbstractSpinBox::StepType stepType )**

        Sets the step type for the spin box to **stepType** , which is single
        step or adaptive decimal step.

        Adaptive decimal step means that the step size will continuously be
        adjusted to one power of ten below the current **value** . So when the
        value is 1100, the step is set to 100, so stepping up once increases it
        to 1200. For 1200 stepping up takes it to 1300. For negative values,
        stepping down from -1100 goes to -1200.

        It also works for any decimal values, 0.041 is increased to 0.042 by
        stepping once.

        Step direction is taken into account to handle edges cases, so that
        stepping down from 100 takes the value to 99 instead of 90. Thus a step
        up followed by a step down -- or vice versa -- always lands on the
        starting value; 99 -> 100 -> 99.

        Setting this will cause the spin box to disregard the value of
        **singleStep** , although it is preserved so that **singleStep**  comes
        into effect if adaptive decimal step is later turned off.

        **Note:** Setter function for property **stepType** .

        This function was introduced in Qt 5.12.

        **See also** **stepType** ().
        """
        ...

    def stepType(self) -> QAbstractSpinBox.StepType:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#stepType-prop

        **stepType : StepType**

        This property holds the step type.

        The step type can be single step or adaptive decimal step.

        **Access functions:**

        QAbstractSpinBox::StepType **stepType** () const
        void
        ****setStepType** ** (QAbstractSpinBox::StepType **stepType** )
        """
        ...

    def setValue(self, val: float) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#value-prop

        **value : double**

        This property holds the value of the spin box

        setValue() will emit **valueChanged** () if the new value is different
        from the old one. The value property has a second notifier signal which
        includes the spin box's prefix and suffix.

        Note: The value will be rounded so it can be displayed with the current
        setting of decimals.

        **Access functions:**

        double **value** () const
        void **setValue** (double **val** )

        **Notifier signal:**

        void ****valueChanged** ** (double **d** )

        **See also** **decimals** .

        **Member Function Documentation**
        """
        ...

    def fixup(self, str: str) -> str:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#fixup

        **[override virtual] void QDoubleSpinBox::fixup(QString & input )
        const**

        Reimplements: **QAbstractSpinBox::fixup(QString &input) const** .
        """
        ...

    def textFromValue(self, v: float) -> str:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#textFromValue

        **[virtual] QString QDoubleSpinBox::textFromValue(double value ) const**

        This virtual function is used by the spin box whenever it needs to
        display the given **value**. The default implementation returns a string
        containing **value** printed using **QWidget::locale** ().toString(
        **value** , **QLatin1Char** ('f'), **decimals** ()) and will remove the
        thousand separator unless **setGroupSeparatorShown** () is set.
        Reimplementations may return anything.

        Note: **QDoubleSpinBox**  does not call this function for
        **specialValueText** () and that neither **prefix** () nor **suffix** ()
        should be included in the return value.

        If you reimplement this, you may also need to reimplement
        **valueFromText** ().

        **See also** **valueFromText** () and **QLocale::groupSeparator** ().
        """
        ...

    def valueFromText(self, text: str) -> float:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#valueFromText

        **[virtual] double QDoubleSpinBox::valueFromText(const QString & text )
        const**

        This virtual function is used by the spin box whenever it needs to
        interpret **text** entered by the user as a value.

        Subclasses that need to display spin box values in a non-numeric way
        need to reimplement this function.

        Note: **QDoubleSpinBox**  handles **specialValueText** () separately;
        this function is only concerned with the other values.

        **See also** **textFromValue** () and **validate** ().
        """
        ...

    def validate(
        self, input: str, pos: int
    ) -> typing.Tuple[QtGui.QValidator.State, str, int]:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#validate

        **[override virtual] QValidator::State QDoubleSpinBox::validate(QString
        & text , int & pos ) const**

        Reimplements: **QAbstractSpinBox::validate(QString &input, int &pos)
        const** .
        """
        ...

    def setDecimals(self, prec: int) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#decimals-prop

        **decimals : int**

        This property holds the precision of the spin box, in decimals

        Sets how many decimals the spinbox will use for displaying and
        interpreting doubles.

        **Warning:** The maximum value for **decimals** is DBL_MAX_10_EXP +
        DBL_DIG (ie. 323) because of the limitations of the double type.

        Note: The maximum, minimum and value might change as a result of
        changing this property.

        **Access functions:**

        int **decimals** () const
        void **setDecimals** (int **prec** )
        """
        ...

    def decimals(self) -> int:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#decimals-prop

        **decimals : int**

        This property holds the precision of the spin box, in decimals

        Sets how many decimals the spinbox will use for displaying and
        interpreting doubles.

        **Warning:** The maximum value for **decimals** is DBL_MAX_10_EXP +
        DBL_DIG (ie. 323) because of the limitations of the double type.

        Note: The maximum, minimum and value might change as a result of
        changing this property.

        **Access functions:**

        int **decimals** () const
        void **setDecimals** (int **prec** )
        """
        ...

    def setRange(self, min: float, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#setRange

        **void QDoubleSpinBox::setRange(double minimum , double maximum )**

        Convenience function to set the **minimum** and **maximum** values with
        a single function call.

        Note: The maximum and minimum values will be rounded to match the
        decimals property.

        setRange(minimum, maximum);

        is equivalent to:

        setMinimum(minimum);
            setMaximum(maximum);

        **See also** **minimum**  and **maximum** .
        """
        ...

    def setMaximum(self, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#maximum-prop

        **maximum : double**

        This property holds the maximum value of the spin box

        When setting this property the **minimum**  is adjusted if necessary, to
        ensure that the range remains valid.

        The default maximum value is 99.99.

        Note: The maximum value will be rounded to match the decimals property.

        **Access functions:**

        double **maximum** () const
        void **setMaximum** (double **max** )

        **See also** **decimals**  and **setRange** ().
        """
        ...

    def maximum(self) -> float:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#maximum-prop

        **maximum : double**

        This property holds the maximum value of the spin box

        When setting this property the **minimum**  is adjusted if necessary, to
        ensure that the range remains valid.

        The default maximum value is 99.99.

        Note: The maximum value will be rounded to match the decimals property.

        **Access functions:**

        double **maximum** () const
        void **setMaximum** (double **max** )

        **See also** **decimals**  and **setRange** ().
        """
        ...

    def setMinimum(self, min: float) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#minimum-prop

        **minimum : double**

        This property holds the minimum value of the spin box

        When setting this property the **maximum**  is adjusted if necessary to
        ensure that the range remains valid.

        The default minimum value is 0.0.

        Note: The minimum value will be rounded to match the decimals property.

        **Access functions:**

        double **minimum** () const
        void **setMinimum** (double **min** )

        **See also** **decimals** , **setRange** (), and **specialValueText** .
        """
        ...

    def minimum(self) -> float:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#minimum-prop

        **minimum : double**

        This property holds the minimum value of the spin box

        When setting this property the **maximum**  is adjusted if necessary to
        ensure that the range remains valid.

        The default minimum value is 0.0.

        Note: The minimum value will be rounded to match the decimals property.

        **Access functions:**

        double **minimum** () const
        void **setMinimum** (double **min** )

        **See also** **decimals** , **setRange** (), and **specialValueText** .
        """
        ...

    def setSingleStep(self, val: float) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#singleStep-prop

        **singleStep : double**

        This property holds the step value

        When the user uses the arrows to change the spin box's value the value
        will be incremented/decremented by the amount of the singleStep. The
        default value is 1.0. Setting a singleStep value of less than 0 does
        nothing.

        **Access functions:**

        double **singleStep** () const
        void **setSingleStep** (double **val**
        )
        """
        ...

    def singleStep(self) -> float:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#singleStep-prop

        **singleStep : double**

        This property holds the step value

        When the user uses the arrows to change the spin box's value the value
        will be incremented/decremented by the amount of the singleStep. The
        default value is 1.0. Setting a singleStep value of less than 0 does
        nothing.

        **Access functions:**

        double **singleStep** () const
        void **setSingleStep** (double **val**
        )
        """
        ...

    def cleanText(self) -> str:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#cleanText-prop

        **[read-only] cleanText : const QString**

        This property holds the text of the spin box excluding any prefix,
        suffix, or leading or trailing whitespace.

        **Access functions:**

        QString **cleanText** () const

        **See also** **text** , **QDoubleSpinBox::prefix** , and
        **QDoubleSpinBox::suffix** .
        """
        ...

    def setSuffix(self, s: str) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#suffix-prop

        **suffix : QString**

        This property holds the suffix of the spin box

        The suffix is appended to the end of the displayed value. Typical use is
        to display a unit of measurement or a currency symbol. For example:

        spinbox->setSuffix(" km");

        To turn off the suffix display, set this property to an empty string.
        The default is no suffix. The suffix is not displayed for the
        **minimum** () if **specialValueText** () is set.

        If no suffix is set, suffix() returns an empty string.

        **Access functions:**

        QString **suffix** () const
        void **setSuffix** (const QString &
        **suffix** )

        **See also** **prefix** (), **setPrefix** (), **specialValueText** (),
        and **setSpecialValueText** ().
        """
        ...

    def suffix(self) -> str:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#suffix-prop

        **suffix : QString**

        This property holds the suffix of the spin box

        The suffix is appended to the end of the displayed value. Typical use is
        to display a unit of measurement or a currency symbol. For example:

        spinbox->setSuffix(" km");

        To turn off the suffix display, set this property to an empty string.
        The default is no suffix. The suffix is not displayed for the
        **minimum** () if **specialValueText** () is set.

        If no suffix is set, suffix() returns an empty string.

        **Access functions:**

        QString **suffix** () const
        void **setSuffix** (const QString &
        **suffix** )

        **See also** **prefix** (), **setPrefix** (), **specialValueText** (),
        and **setSpecialValueText** ().
        """
        ...

    def setPrefix(self, p: str) -> None:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#prefix-prop

        **prefix : QString**

        This property holds the spin box's prefix

        The prefix is prepended to the start of the displayed value. Typical use
        is to display a unit of measurement or a currency symbol. For example:

        spinbox->setPrefix("$");

        To turn off the prefix display, set this property to an empty string.
        The default is no prefix. The prefix is not displayed when **value** ()
        == **minimum** () and **specialValueText** () is set.

        If no prefix is set, prefix() returns an empty string.

        **Access functions:**

        QString **prefix** () const
        void **setPrefix** (const QString &
        **prefix** )

        **See also** **suffix** (), **setSuffix** (), **specialValueText** (),
        and **setSpecialValueText** ().
        """
        ...

    def prefix(self) -> str:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#prefix-prop

        **prefix : QString**

        This property holds the spin box's prefix

        The prefix is prepended to the start of the displayed value. Typical use
        is to display a unit of measurement or a currency symbol. For example:

        spinbox->setPrefix("$");

        To turn off the prefix display, set this property to an empty string.
        The default is no prefix. The prefix is not displayed when **value** ()
        == **minimum** () and **specialValueText** () is set.

        If no prefix is set, prefix() returns an empty string.

        **Access functions:**

        QString **prefix** () const
        void **setPrefix** (const QString &
        **prefix** )

        **See also** **suffix** (), **setSuffix** (), **specialValueText** (),
        and **setSpecialValueText** ().
        """
        ...

    def value(self) -> float:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#value-prop

        **value : double**

        This property holds the value of the spin box

        setValue() will emit **valueChanged** () if the new value is different
        from the old one. The value property has a second notifier signal which
        includes the spin box's prefix and suffix.

        Note: The value will be rounded so it can be displayed with the current
        setting of decimals.

        **Access functions:**

        double **value** () const
        void **setValue** (double **val** )

        **Notifier signal:**

        void ****valueChanged** ** (double **d** )

        **See also** **decimals** .

        **Member Function Documentation**
        """
        ...

    @property
    def textChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#textChanged

        **[signal, since 5.14] void QDoubleSpinBox::textChanged(const QString &
        text )**

        This signal is emitted whenever the spin box's text is changed. The new
        text is passed in **text** with **prefix** () and **suffix** ().

        This function was introduced in Qt 5.14.
        """
        ...

    @property
    def valueChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdoublespinbox.html#valueChanged

        **[signal] void QDoubleSpinBox::valueChanged(double d )**

        This signal is emitted whenever the spin box's value is changed. The new
        value is passed in **d**.

        **Note:** Notifier signal for property **value** .
        """
        ...
