"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QFontComboBox(QComboBox):
    """
    https://doc.qt.io/qt-6/qfontcombobox.html

    **Detailed Description**

    The combobox is populated with an alphabetized list of font family names,
    such as Arial, Helvetica, and Times New Roman. Family names are displayed
    using the actual font when possible. For fonts such as Symbol, where the
    name is not representable in the font itself, a sample of the font is
    displayed next to the family name.

    QFontComboBox is often used in toolbars, in conjunction with a **QComboBox**
    for controlling the font size and two **QToolButton** s for bold and italic.

    When the user selects a new font, the **currentFontChanged** () signal is
    emitted in addition to **currentIndexChanged** ().

    Call **setWritingSystem** () to tell QFontComboBox to show only fonts that
    support a given writing system, and **setFontFilters** () to filter out
    certain types of fonts as e.g. non scalable fonts or monospaced fonts.

    ![Screenshot of QFontComboBox on Windows Vista](images/windowsvista-
    fontcombobox.png)

    **See also** **QComboBox** , **QFont** , **QFontInfo** , **QFontMetrics** ,
    **QFontDatabase** , and **Character Map Example** .
    """

    class FontFilter(enum.Flag):
        AllFonts: QFontComboBox = ...
        ScalableFonts: QFontComboBox = ...
        NonScalableFonts: QFontComboBox = ...
        MonospacedFonts: QFontComboBox = ...
        ProportionalFonts: QFontComboBox = ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#QFontComboBox

        **QFontComboBox::QFontComboBox(QWidget * parent = nullptr)**

        Constructs a font combobox with the given **parent**.
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#event

        **[override virtual protected] bool QFontComboBox::event(QEvent * e )**

        Reimplements: **QComboBox::event** (QEvent *event).
        """
        ...

    def setCurrentFont(self, f: QtGui.QFont) -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#currentFont-prop

        **currentFont : QFont**

        This property holds the currently selected font

        **Access functions:**

        QFont **currentFont** () const
        void **setCurrentFont** (const QFont &
        **f** )

        **Notifier signal:**

        void ****currentFontChanged** ** (const QFont & **font** )

        **See also** **currentIndex**  and **currentText** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#sizeHint

        **[override virtual] QSize QFontComboBox::sizeHint() const**

        Reimplements: **QComboBox::sizeHint() const** .
        """
        ...

    def currentFont(self) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#currentFont-prop

        **currentFont : QFont**

        This property holds the currently selected font

        **Access functions:**

        QFont **currentFont** () const
        void **setCurrentFont** (const QFont &
        **f** )

        **Notifier signal:**

        void ****currentFontChanged** ** (const QFont & **font** )

        **See also** **currentIndex**  and **currentText** .
        """
        ...

    def setFontFilters(self, filters: "QFontComboBox.FontFilter") -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#fontFilters-prop

        **fontFilters : FontFilters**

        This property holds the filter for the combobox

        By default, all fonts are listed.

        **Access functions:**

        QFontComboBox::FontFilters **fontFilters** () const
        void
        **setFontFilters** (QFontComboBox::FontFilters **filters** )

        **See also** **writingSystem** .
        """
        ...

    def writingSystem(self) -> QtGui.QFontDatabase.WritingSystem:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#writingSystem-prop

        **writingSystem : QFontDatabase::WritingSystem**

        This property holds the writing system that serves as a filter for the
        combobox

        If **script** is **QFontDatabase::Any**  (the default), all fonts are
        listed.

        **Access functions:**

        QFontDatabase::WritingSystem **writingSystem** () const
        void
        **setWritingSystem** (QFontDatabase::WritingSystem)

        **See also** **fontFilters** .

        **Member Function Documentation**
        """
        ...

    def setWritingSystem(self, a0: QtGui.QFontDatabase.WritingSystem) -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#writingSystem-prop

        **writingSystem : QFontDatabase::WritingSystem**

        This property holds the writing system that serves as a filter for the
        combobox

        If **script** is **QFontDatabase::Any**  (the default), all fonts are
        listed.

        **Access functions:**

        QFontDatabase::WritingSystem **writingSystem** () const
        void
        **setWritingSystem** (QFontDatabase::WritingSystem)

        **See also** **fontFilters** .

        **Member Function Documentation**
        """
        ...

    def fontFilters(self) -> "QFontComboBox.FontFilter":
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#fontFilters-prop

        **fontFilters : FontFilters**

        This property holds the filter for the combobox

        By default, all fonts are listed.

        **Access functions:**

        QFontComboBox::FontFilters **fontFilters** () const
        void
        **setFontFilters** (QFontComboBox::FontFilters **filters** )

        **See also** **writingSystem** .
        """
        ...

    @property
    def currentFontChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#currentFontChanged

        **[signal] void QFontComboBox::currentFontChanged(const QFont & font )**

        This signal is emitted whenever the current font changes, with the new
        **font**.

        **Note:** Notifier signal for property **currentFont** .

        **See also** **currentFont** .
        """
        ...
