"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QGraphicsItemGroup(QGraphicsItem):
    """
    https://doc.qt.io/qt-6/qgraphicsitemgroup.html

    **Detailed Description**

    A QGraphicsItemGroup is a special type of compound item that treats itself
    and all its children as one item (i.e., all events and geometries for all
    children are merged together). It's common to use item groups in
    presentation tools, when the user wants to group several smaller items into
    one big item in order to simplify moving and copying of items.

    If all you want is to store items inside other items, you can use any
    **QGraphicsItem**  directly by passing a suitable parent to
    **setParentItem** ().

    The **boundingRect** () function of QGraphicsItemGroup returns the bounding
    rectangle of all items in the item group. QGraphicsItemGroup ignores the
    ItemIgnoresTransformations flag on its children (i.e., with respect to the
    geometry of the group item, the children are treated as if they were
    transformable).

    There are two ways to construct an item group. The easiest and most common
    approach is to pass a list of items (e.g., all selected items) to
    **QGraphicsScene::createItemGroup** (), which returns a new
    QGraphicsItemGroup item. The other approach is to manually construct a
    QGraphicsItemGroup item, add it to the scene calling
    **QGraphicsScene::addItem** (), and then add items to the group manually,
    one at a time by calling **addToGroup** (). To dismantle ("ungroup") an item
    group, you can either call **QGraphicsScene::destroyItemGroup** (), or you
    can manually remove all items from the group by calling **removeFromGroup**
    ().

    // Group all selected items together
        **QGraphicsItemGroup**  *group =
    scene->createItemGroup(scene->selecteditems());

        // Destroy the
    group, and delete the group item
        scene->destroyItemGroup(group);

    The operation of adding and removing items preserves the items' scene-
    relative position and transformation, as opposed to calling
    **setParentItem** (), where only the child item's parent-relative position
    and transformation are kept.

    The addtoGroup() function reparents the target item to this item group,
    keeping the item's position and transformation intact relative to the scene.
    Visually, this means that items added via **addToGroup** () will remain
    completely unchanged as a result of this operation, regardless of the item
    or the group's current position or transformation; although the item's
    position and matrix are likely to change.

    The **removeFromGroup** () function has similar semantics to
    **setParentItem** (); it reparents the item to the parent item of the item
    group. As with **addToGroup** (), the item's scene-relative position and
    transformation remain intact.

    **See also** **QGraphicsItem**  and **Graphics View Framework** .
    """

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#QGraphicsItemGroup

        **QGraphicsItemGroup::QGraphicsItemGroup(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsItemGroup. **parent** is passed to
        **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#type

        **[override virtual] int QGraphicsItemGroup::type() const**

        Reimplements: **QGraphicsItem::type() const** .
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsItemGroup::opaqueArea()
        const**

        Reimplements: **QGraphicsItem::opaqueArea() const** .
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#isObscuredBy

        **[override virtual] bool QGraphicsItemGroup::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QGraphicsItem::isObscuredBy(const QGraphicsItem *item)
        const** .
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#paint

        **[override virtual] void QGraphicsItemGroup::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#boundingRect

        **[override virtual] QRectF QGraphicsItemGroup::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .

        Returns the bounding rect of this group item, and all its children.
        """
        ...

    def removeFromGroup(self, item: QGraphicsItem) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#removeFromGroup

        **void QGraphicsItemGroup::removeFromGroup(QGraphicsItem * item )**

        Removes the specified **item** from this group. The item will be
        reparented to this group's parent item, or to 0 if this group has no
        parent. Its position and transformation relative to the scene will stay
        intact.

        **See also** **addToGroup** () and **QGraphicsScene::destroyItemGroup**
        ().
        """
        ...

    def addToGroup(self, item: QGraphicsItem) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemgroup.html#addToGroup

        **void QGraphicsItemGroup::addToGroup(QGraphicsItem * item )**

        Adds the given **item** and item's child items to this item group. The
        item and child items will be reparented to this group, but its position
        and transformation relative to the scene will stay intact.

        **See also** **removeFromGroup** () and
        **QGraphicsScene::createItemGroup** ().
        """
        ...
