"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QGraphicsLayoutItem(PyQt6.sip.wrapper):
    """
    https://doc.qt.io/qt-6/qgraphicslayoutitem.html

    **Detailed Description**

    QGraphicsLayoutItem is an abstract class that defines a set of virtual
    functions describing sizes, size policies, and size hints for any object
    arranged by **QGraphicsLayout** . The API contains functions relevant for
    both the item itself and for the user of the item as most of
    QGraphicsLayoutItem's functions are also part of the subclass' public API.

    In most cases, existing layout-aware classes such as **QGraphicsWidget**
    and **QGraphicsLayout**  already provide the functionality you require.
    However, subclassing these classes will enable you to create both graphical
    elements that work well with layouts (**QGraphicsWidget** ) or custom
    layouts (**QGraphicsLayout** ).

    **Subclassing QGraphicsLayoutItem**

    If you create a subclass of QGraphicsLayoutItem and reimplement its virtual
    functions, you will enable the layout to resize and position your item along
    with other QGraphicsLayoutItems including **QGraphicsWidget**  and
    **QGraphicsLayout** .

    You can start by reimplementing important functions: the protected
    **sizeHint** () function, as well as the public **setGeometry** () function.
    If you want your items to be aware of immediate geometry changes, you can
    also reimplement **updateGeometry** ().

    The geometry, size hint, and size policy affect the item's size and
    position. Calling **setGeometry** () will always resize and reposition the
    item immediately. Normally, this function is called by **QGraphicsLayout**
    after the layout has been activated, but it can also be called by the item's
    user at any time.

    The **sizeHint** () function returns the item' minimum, preferred and
    maximum size hints. You can override these properties by calling
    **setMinimumSize** (), **setPreferredSize** () or **setMaximumSize** (). You
    can also use functions such as **setMinimumWidth** () or
    **setMaximumHeight** () to set only the width or height component if
    desired.

    The **effectiveSizeHint** () function, on the other hand, returns a size
    hint for any given **Qt::SizeHint** , and guarantees that the returned size
    is bound to the minimum and maximum sizes and size hints. You can set the
    item's vertical and horizontal size policy by calling **setSizePolicy** ().
    The **sizePolicy**  property is used by the layout system to describe how
    this item prefers to grow or shrink.

    **Nesting QGraphicsLayoutItems**

    QGraphicsLayoutItems can be nested within other QGraphicsLayoutItems,
    similar to layouts that can contain sublayouts. This is done either by
    passing a QGraphicsLayoutItem pointer to QGraphicsLayoutItem's protected
    constructor, or by calling **setParentLayoutItem** (). The
    **parentLayoutItem** () function returns a pointer to the item's layoutItem
    parent. If the item's parent is `nullptr` or if the parent does not inherit
    from **QGraphicsItem** , the **parentLayoutItem** () function then returns
    `nullptr`. **isLayout** () returns `true` if the QGraphicsLayoutItem
    subclass is itself a layout, or false otherwise.

    Qt uses QGraphicsLayoutItem to provide layout functionality in the
    **Graphics View Framework** , but in the future its use may spread
    throughout Qt itself.

    **See also** **QGraphicsWidget** , **QGraphicsLayout** ,
    **QGraphicsLinearLayout** , and **QGraphicsGridLayout** .
    """

    def __init__(
        self, parent: typing.Optional["QGraphicsLayoutItem"] = ..., isLayout: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#QGraphicsLayoutItem

        **QGraphicsLayoutItem::QGraphicsLayoutItem(QGraphicsLayoutItem * parent
        = nullptr, bool isLayout = false)**

        Constructs the QGraphicsLayoutItem object. **parent** becomes the
        object's parent. If **isLayout** is true the item is a layout, otherwise
        **isLayout** is false.
        """
        ...

    def setOwnedByLayout(self, ownedByLayout: bool) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setOwnedByLayout

        **[protected] void QGraphicsLayoutItem::setOwnedByLayout(bool ownership
        )**

        Sets whether a layout should delete this item in its destructor or not.
        **ownership** must be true to in order for the layout to delete it.

        **See also** **ownedByLayout** ().
        """
        ...

    def setGraphicsItem(self, item: "QGraphicsItem") -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setGraphicsItem

        **[protected] void QGraphicsLayoutItem::setGraphicsItem(QGraphicsItem *
        item )**

        If the **QGraphicsLayoutItem**  represents a **QGraphicsItem** , and it
        wants to take advantage of the automatic reparenting capabilities of
        **QGraphicsLayout**  it should set this value. Note that if you delete
        **item** and not delete the layout item, you are responsible of calling
        setGraphicsItem(`nullptr`) in order to avoid having a dangling pointer.

        **See also** **graphicsItem** ().
        """
        ...

    def sizeHint(
        self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...
    ) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#sizeHint

        **[pure virtual protected] QSizeF
        QGraphicsLayoutItem::sizeHint(Qt::SizeHint which , const QSizeF &
        constraint = QSizeF()) const**

        This pure virtual function returns the size hint for **which** of the
        **QGraphicsLayoutItem** , using the width or height of **constraint** to
        constrain the output.

        Reimplement this function in a subclass of **QGraphicsLayoutItem**  to
        provide the necessary size hints for your items.

        **See also** **effectiveSizeHint** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#isEmpty

        **[virtual, since 6.0] bool QGraphicsLayoutItem::isEmpty() const**

        Returns `true` if this item is empty, i.e whether it has no content and
        should not occupy any space.

        The default implementation returns `true` true if the item has been
        hidden, unless its **size policy**  has retainSizeWhenHidden set to
        `true`

        This function was introduced in Qt 6.0.

        **See also** **sizePolicy** ().
        """
        ...

    def ownedByLayout(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#ownedByLayout

        **bool QGraphicsLayoutItem::ownedByLayout() const**

        Returns whether a layout should delete this item in its destructor. If
        its true, then the layout will delete it. If its false, then it is
        assumed that another object has the ownership of it, and the layout
        won't delete this item.

        If the item inherits both **QGraphicsItem**  and **QGraphicsLayoutItem**
        (such as **QGraphicsWidget**  does) the item is really part of two
        ownership hierarchies. This property informs what the layout should do
        with its child items when it is destructed. In the case of
        **QGraphicsWidget** , it is preferred that when the layout is deleted it
        won't delete its children (since they are also part of the graphics item
        hierarchy).

        By default this value is initialized to false in **QGraphicsLayoutItem**
        , but it is overridden by **QGraphicsLayout**  to return true. This is
        because **QGraphicsLayout**  is not normally part of the
        **QGraphicsItem**  hierarchy, so the parent layout should delete it.
        Subclasses might override this default behaviour by calling
        **setOwnedByLayout** (true).

        **See also** **setOwnedByLayout** ().
        """
        ...

    def graphicsItem(self) -> "QGraphicsItem":
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#graphicsItem

        **QGraphicsItem *QGraphicsLayoutItem::graphicsItem() const**

        Returns the **QGraphicsItem**  that this layout item represents. For
        **QGraphicsWidget**  it will return itself. For custom items it can
        return an aggregated value.

        **See also** **setGraphicsItem** ().
        """
        ...

    def maximumHeight(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#maximumHeight

        **qreal QGraphicsLayoutItem::maximumHeight() const**

        Returns the maximum height.

        **See also** **setMaximumHeight** (), **setMaximumSize** (), and
        **maximumSize** ().
        """
        ...

    def maximumWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#maximumWidth

        **qreal QGraphicsLayoutItem::maximumWidth() const**

        Returns the maximum width.

        **See also** **setMaximumWidth** (), **setMaximumSize** (), and
        **maximumSize** ().
        """
        ...

    def preferredHeight(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#preferredHeight

        **qreal QGraphicsLayoutItem::preferredHeight() const**

        Returns the preferred height.

        **See also** **setPreferredHeight** (), **setPreferredSize** (), and
        **preferredSize** ().
        """
        ...

    def preferredWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#preferredWidth

        **qreal QGraphicsLayoutItem::preferredWidth() const**

        Returns the preferred width.

        **See also** **setPreferredWidth** (), **setPreferredSize** (), and
        **preferredSize** ().
        """
        ...

    def minimumHeight(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#minimumHeight

        **qreal QGraphicsLayoutItem::minimumHeight() const**

        Returns the minimum height.

        **See also** **setMinimumHeight** (), **setMinimumSize** (), and
        **minimumSize** ().
        """
        ...

    def minimumWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#minimumWidth

        **qreal QGraphicsLayoutItem::minimumWidth() const**

        Returns the minimum width.

        **See also** **setMinimumWidth** (), **setMinimumSize** (), and
        **minimumSize** ().
        """
        ...

    def isLayout(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#isLayout

        **bool QGraphicsLayoutItem::isLayout() const**

        Returns `true` if this **QGraphicsLayoutItem**  is a layout (e.g., is
        inherited by an object that arranges other **QGraphicsLayoutItem**
        objects); otherwise returns `false`.

        **See also** **QGraphicsLayout** .
        """
        ...

    def setParentLayoutItem(self, parent: "QGraphicsLayoutItem") -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setParentLayoutItem

        **void QGraphicsLayoutItem::setParentLayoutItem(QGraphicsLayoutItem *
        parent )**

        Sets the parent of this **QGraphicsLayoutItem**  to **parent**.

        **See also** **parentLayoutItem** ().
        """
        ...

    def parentLayoutItem(self) -> "QGraphicsLayoutItem":
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#parentLayoutItem

        **QGraphicsLayoutItem *QGraphicsLayoutItem::parentLayoutItem() const**

        Returns the parent of this **QGraphicsLayoutItem** , or `nullptr` if
        there is no parent, or if the parent does not inherit from
        **QGraphicsLayoutItem**  (**QGraphicsLayoutItem**  is often used through
        multiple inheritance with **QObject** -derived classes).

        **See also** **setParentLayoutItem** ().
        """
        ...

    def updateGeometry(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#updateGeometry

        **[virtual] void QGraphicsLayoutItem::updateGeometry()**

        This virtual function discards any cached size hint information. You
        should always call this function if you change the return value of the
        **sizeHint** () function. Subclasses must always call the base
        implementation when reimplementing this function.

        **See also** **effectiveSizeHint** ().
        """
        ...

    def effectiveSizeHint(
        self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...
    ) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#effectiveSizeHint

        **QSizeF QGraphicsLayoutItem::effectiveSizeHint(Qt::SizeHint which ,
        const QSizeF & constraint = QSizeF()) const**

        Returns the effective size hint for this **QGraphicsLayoutItem** .

        **which** is the size hint in question. **constraint** is an optional
        argument that defines a special constrain when calculating the effective
        size hint. By default, **constraint** is **QSizeF** (-1, -1), which
        means there is no constraint to the size hint.

        If you want to specify the widget's size hint for a given width or
        height, you can provide the fixed dimension in **constraint**. This is
        useful for widgets that can grow only either vertically or horizontally,
        and need to set either their width or their height to a special value.

        For example, a text paragraph item fit into a column width of 200 may
        grow vertically. You can pass **QSizeF** (200, -1) as a constraint to
        get a suitable minimum, preferred and maximum height).

        You can adjust the effective size hint by reimplementing **sizeHint** ()
        in a **QGraphicsLayoutItem**  subclass, or by calling one of the
        following functions: **setMinimumSize** (), **setPreferredSize** , or
        **setMaximumSize** () (or a combination of both).

        This function caches each of the size hints and guarantees that
        **sizeHint** () will be called only once for each value of **which** \\-
        unless **constraint** is not specified and **updateGeometry** () has
        been called.

        **See also** **sizeHint** ().
        """
        ...

    def contentsRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#contentsRect

        **QRectF QGraphicsLayoutItem::contentsRect() const**

        Returns the contents rect in local coordinates.

        The contents rect defines the subrectangle used by an associated layout
        when arranging subitems. This function is a convenience function that
        adjusts the item's **geometry** () by its contents margins. Note that
        **getContentsMargins** () is a virtual function that you can reimplement
        to return the item's contents margins.

        **See also** **getContentsMargins** () and **geometry** ().
        """
        ...

    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#getContentsMargins

        **[virtual] void QGraphicsLayoutItem::getContentsMargins(qreal * left ,
        qreal * top , qreal * right , qreal * bottom ) const**

        This virtual function provides the **left** , **top** , **right** and
        **bottom** contents margins for this **QGraphicsLayoutItem** . The
        default implementation assumes all contents margins are 0. The
        parameters point to values stored in qreals. If any of the pointers is
        `nullptr`, that value will not be updated.

        **See also** **QGraphicsWidget::setContentsMargins** ().
        """
        ...

    def geometry(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#geometry

        **QRectF QGraphicsLayoutItem::geometry() const**

        Returns the item's geometry (e.g., position and size) as a **QRectF** .
        This function is equivalent to **QRectF** (pos(), size()).

        **See also** **setGeometry** ().
        """
        ...

    def setGeometry(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setGeometry

        **[virtual] void QGraphicsLayoutItem::setGeometry(const QRectF & rect
        )**

        This virtual function sets the geometry of the **QGraphicsLayoutItem**
        to **rect** , which is in parent coordinates (e.g., the top-left corner
        of **rect** is equivalent to the item's position in parent coordinates).

        You must reimplement this function in a subclass of
        **QGraphicsLayoutItem**  to receive geometry updates. The layout will
        call this function when it does a rearrangement.

        If **rect** is outside of the bounds of **minimumSize**  and
        **maximumSize** , it will be adjusted to its closest size so that it is
        within the legal bounds.

        **See also** **geometry** ().
        """
        ...

    def setMaximumHeight(self, height: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMaximumHeight

        **void QGraphicsLayoutItem::setMaximumHeight(qreal height )**

        Sets the maximum height to **height**.

        **See also** **maximumHeight** (), **setMaximumSize** (), and
        **maximumSize** ().
        """
        ...

    def setMaximumWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMaximumWidth

        **void QGraphicsLayoutItem::setMaximumWidth(qreal width )**

        Sets the maximum width to **width**.

        **See also** **maximumWidth** (), **setMaximumSize** (), and
        **maximumSize** ().
        """
        ...

    def maximumSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#maximumSize

        **QSizeF QGraphicsLayoutItem::maximumSize() const**

        Returns the maximum size.

        **See also** **setMaximumSize** (), **minimumSize** (),
        **preferredSize** (), **Qt::MaximumSize** , and **sizeHint** ().
        """
        ...

    @typing.overload
    def setMaximumSize(self, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMaximumSize

        **void QGraphicsLayoutItem::setMaximumSize(const QSizeF & size )**

        Sets the maximum size to **size**. This property overrides **sizeHint**
        () for **Qt::MaximumSize**  and ensures that **effectiveSizeHint** ()
        will never return a size larger than **size**. In order to unset the
        maximum size, use an invalid size.

        **See also** **maximumSize** (), **minimumSize** (), **preferredSize**
        (), **Qt::MaximumSize** , and **sizeHint** ().
        """
        ...

    @typing.overload
    def setMaximumSize(self, aw: float, ah: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMaximumSize-1

        **void QGraphicsLayoutItem::setMaximumSize(qreal w , qreal h )**

        This convenience function is equivalent to calling
        setMaximumSize(**QSizeF** ( **w** , **h** )).

        **See also** **maximumSize** (), **setMinimumSize** (),
        **setPreferredSize** (), and **sizeHint** ().
        """
        ...

    def setPreferredHeight(self, height: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setPreferredHeight

        **void QGraphicsLayoutItem::setPreferredHeight(qreal height )**

        Sets the preferred height to **height**.

        **See also** **preferredHeight** (), **preferredWidth** (),
        **setPreferredSize** (), and **preferredSize** ().
        """
        ...

    def setPreferredWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setPreferredWidth

        **void QGraphicsLayoutItem::setPreferredWidth(qreal width )**

        Sets the preferred width to **width**.

        **See also** **preferredWidth** (), **preferredHeight** (),
        **setPreferredSize** (), and **preferredSize** ().
        """
        ...

    def preferredSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#preferredSize

        **QSizeF QGraphicsLayoutItem::preferredSize() const**

        Returns the preferred size.

        **See also** **setPreferredSize** (), **minimumSize** (),
        **maximumSize** (), **Qt::PreferredSize** , and **sizeHint** ().
        """
        ...

    @typing.overload
    def setPreferredSize(self, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setPreferredSize

        **void QGraphicsLayoutItem::setPreferredSize(const QSizeF & size )**

        Sets the preferred size to **size**. This property overrides
        **sizeHint** () for **Qt::PreferredSize**  and provides the default
        value for **effectiveSizeHint** (). In order to unset the preferred
        size, use an invalid size.

        **See also** **preferredSize** (), **minimumSize** (), **maximumSize**
        (), **Qt::PreferredSize** , and **sizeHint** ().
        """
        ...

    @typing.overload
    def setPreferredSize(self, aw: float, ah: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setPreferredSize-1

        **void QGraphicsLayoutItem::setPreferredSize(qreal w , qreal h )**

        This convenience function is equivalent to calling
        setPreferredSize(**QSizeF** ( **w** , **h** )).

        **See also** **preferredSize** (), **setMaximumSize** (),
        **setMinimumSize** (), and **sizeHint** ().
        """
        ...

    def setMinimumHeight(self, height: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMinimumHeight

        **void QGraphicsLayoutItem::setMinimumHeight(qreal height )**

        Sets the minimum height to **height**.

        **See also** **minimumHeight** (), **setMinimumSize** (), and
        **minimumSize** ().
        """
        ...

    def setMinimumWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMinimumWidth

        **void QGraphicsLayoutItem::setMinimumWidth(qreal width )**

        Sets the minimum width to **width**.

        **See also** **minimumWidth** (), **setMinimumSize** (), and
        **minimumSize** ().
        """
        ...

    def minimumSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#minimumSize

        **QSizeF QGraphicsLayoutItem::minimumSize() const**

        Returns the minimum size.

        **See also** **setMinimumSize** (), **preferredSize** (),
        **maximumSize** (), **Qt::MinimumSize** , and **sizeHint** ().
        """
        ...

    @typing.overload
    def setMinimumSize(self, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMinimumSize

        **void QGraphicsLayoutItem::setMinimumSize(const QSizeF & size )**

        Sets the minimum size to **size**. This property overrides **sizeHint**
        () for **Qt::MinimumSize**  and ensures that **effectiveSizeHint** ()
        will never return a size smaller than **size**. In order to unset the
        minimum size, use an invalid size.

        **See also** **minimumSize** (), **maximumSize** (), **preferredSize**
        (), **Qt::MinimumSize** , **sizeHint** (), **setMinimumWidth** (), and
        **setMinimumHeight** ().
        """
        ...

    @typing.overload
    def setMinimumSize(self, aw: float, ah: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setMinimumSize-1

        **void QGraphicsLayoutItem::setMinimumSize(qreal w , qreal h )**

        This convenience function is equivalent to calling
        setMinimumSize(**QSizeF** ( **w** , **h** )).

        **See also** **minimumSize** (), **setMaximumSize** (),
        **setPreferredSize** (), and **sizeHint** ().
        """
        ...

    def sizePolicy(self) -> "QSizePolicy":
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#sizePolicy

        **QSizePolicy QGraphicsLayoutItem::sizePolicy() const**

        Returns the current size policy.

        **See also** **setSizePolicy** () and **QWidget::sizePolicy** ().
        """
        ...

    @typing.overload
    def setSizePolicy(self, policy: "QSizePolicy") -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setSizePolicy

        **void QGraphicsLayoutItem::setSizePolicy(const QSizePolicy & policy )**

        Sets the size policy to **policy**. The size policy describes how the
        item should grow horizontally and vertically when arranged in a layout.

        **QGraphicsLayoutItem** 's default size policy is
        (**QSizePolicy::Fixed** , **QSizePolicy::Fixed** ,
        **QSizePolicy::DefaultType** ), but it is common for subclasses to
        change the default. For example, **QGraphicsWidget**  defaults to
        (**QSizePolicy::Preferred** , **QSizePolicy::Preferred** ,
        **QSizePolicy::DefaultType** ).

        **See also** **sizePolicy** () and **QWidget::sizePolicy** ().
        """
        ...

    @typing.overload
    def setSizePolicy(
        self,
        hPolicy: "QSizePolicy.Policy",
        vPolicy: "QSizePolicy.Policy",
        controlType: "QSizePolicy.ControlType" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslayoutitem.html#setSizePolicy-1

        **void QGraphicsLayoutItem::setSizePolicy(QSizePolicy::Policy hPolicy ,
        QSizePolicy::Policy vPolicy , QSizePolicy::ControlType controlType =
        QSizePolicy::DefaultType)**

        This is an overloaded function.

        This function is equivalent to calling setSizePolicy(**QSizePolicy** (
        **hPolicy** , **vPolicy** , **controlType** )).

        **See also** **sizePolicy** () and **QWidget::sizePolicy** ().
        """
        ...
