"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QGraphicsPathItem(QAbstractGraphicsShapeItem):
    """
    https://doc.qt.io/qt-6/qgraphicspathitem.html

    **Detailed Description**

    To set the item's path, pass a **QPainterPath**  to QGraphicsPathItem's
    constructor, or call the **setPath** () function. The **path** () function
    returns the current path.

    ![](images/graphicsview-pathitem.png)

    QGraphicsPathItem uses the path to provide a reasonable implementation of
    **boundingRect** (), **shape** (), and **contains** (). The **paint** ()
    function draws the path using the item's associated pen and brush, which you
    can set by calling the **setPen** () and **setBrush** () functions.

    **See also** **QGraphicsRectItem** , **QGraphicsEllipseItem** ,
    **QGraphicsPolygonItem** , **QGraphicsTextItem** , **QGraphicsLineItem** ,
    **QGraphicsPixmapItem** , and **Graphics View Framework** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#QGraphicsPathItem

        **QGraphicsPathItem::QGraphicsPathItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsPath. **parent** is passed to
        **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(
        self, path: QtGui.QPainterPath, parent: typing.Optional[QGraphicsItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#QGraphicsPathItem-1

        **QGraphicsPathItem::QGraphicsPathItem(const QPainterPath & path ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsPath item using **path** as the default path.
        **parent** is passed to **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#type

        **[override virtual] int QGraphicsPathItem::type() const**

        Reimplements: **QGraphicsItem::type() const** .
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsPathItem::opaqueArea()
        const**

        Reimplements: **QAbstractGraphicsShapeItem::opaqueArea() const** .
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#isObscuredBy

        **[override virtual] bool QGraphicsPathItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QAbstractGraphicsShapeItem::isObscuredBy(const
        QGraphicsItem *item) const** .
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#paint

        **[override virtual] void QGraphicsPathItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def contains(self, point: QtCore.QPointF) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#contains

        **[override virtual] bool QGraphicsPathItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains(const QPointF &point) const** .
        """
        ...

    def shape(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#shape

        **[override virtual] QPainterPath QGraphicsPathItem::shape() const**

        Reimplements: **QGraphicsItem::shape() const** .
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#boundingRect

        **[override virtual] QRectF QGraphicsPathItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def setPath(self, path: QtGui.QPainterPath) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#setPath

        **void QGraphicsPathItem::setPath(const QPainterPath & path )**

        Sets the item's path to be the given **path**.

        **See also** **path** ().
        """
        ...

    def path(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicspathitem.html#path

        **QPainterPath QGraphicsPathItem::path() const**

        Returns the item's path as a **QPainterPath** . If no item has been set,
        an empty **QPainterPath**  is returned.

        **See also** **setPath** ().
        """
        ...
