"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QGraphicsSceneContextMenuEvent(QGraphicsSceneEvent):
    """
    https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html

    **Detailed Description**

    A **QContextMenuEvent**  received by a **QGraphicsView**  is translated into
    a QGraphicsSceneContextMenuEvent. The **QContextMenuEvent::globalPos** () is
    translated into item, scene, and screen coordinates (**pos** (),
    **scenePos** (), and **screenPos** ()).

    **See also** **QGraphicsSceneMouseEvent** , **QGraphicsSceneWheelEvent** ,
    and **QContextMenuEvent** .
    """

    class Reason(enum.Enum):
        Mouse: QGraphicsSceneContextMenuEvent = ...
        Keyboard: QGraphicsSceneContextMenuEvent = ...
        Other: QGraphicsSceneContextMenuEvent = ...

    def reason(self) -> "QGraphicsSceneContextMenuEvent.Reason":
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#reason

        **QGraphicsSceneContextMenuEvent::Reason
        QGraphicsSceneContextMenuEvent::reason() const**

        Returns the reason for the context menu event.

        **See also** **QGraphicsSceneContextMenuEvent::Reason** .
        """
        ...

    def modifiers(self) -> QtCore.Qt.KeyboardModifier:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneContextMenuEvent::modifiers()
        const**

        Returns the keyboard modifiers in use when the context menu was
        requested.
        """
        ...

    def screenPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#screenPos

        **QPoint QGraphicsSceneContextMenuEvent::screenPos() const**

        Returns the position of the mouse cursor in screen coordinates at the
        moment the context menu was requested.

        **See also** **pos** () and **scenePos** ().
        """
        ...

    def scenePos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#scenePos

        **QPointF QGraphicsSceneContextMenuEvent::scenePos() const**

        Returns the position of the mouse cursor in scene coordinates at the
        moment the context menu was requested.

        **See also** **pos** () and **screenPos** ().
        """
        ...

    def pos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#pos

        **QPointF QGraphicsSceneContextMenuEvent::pos() const**

        Returns the position of the mouse cursor in item coordinates at the
        moment the context menu was requested.

        **See also** **scenePos** () and **screenPos** ().
        """
        ...
