"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QGraphicsSceneWheelEvent(QGraphicsSceneEvent):
    """
    https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html

    **Detailed Description**

    **QWheelEvent** s received by a **QGraphicsView**  are translated into
    QGraphicsSceneWheelEvents; it translates the QWheelEvent::globalPos() into
    item, scene, and screen coordinates (**pos** (), **scenePos** (), and
    **screenPos** ()).

    **See also** **QGraphicsSceneMouseEvent** ,
    **QGraphicsSceneContextMenuEvent** , **QGraphicsSceneHoverEvent** , and
    **QWheelEvent** .
    """

    def isInverted(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#isInverted

        **[since 6.2] bool QGraphicsSceneWheelEvent::isInverted() const**

        Returns whether the delta values delivered with the event are inverted.

        This function was introduced in Qt 6.2.
        """
        ...

    def pixelDelta(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#pixelDelta

        **[since 6.2] QPoint QGraphicsSceneWheelEvent::pixelDelta() const**

        Returns the scrolling distance in pixels on screen. This value is
        provided on platforms that support high-resolution pixel-based delta
        values, such as macOS. The value should be used directly to scroll
        content on screen.

        This function was introduced in Qt 6.2.

        **See also** **QWheelEvent::pixelDelta** .
        """
        ...

    def phase(self) -> QtCore.Qt.ScrollPhase:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#phase

        **[since 6.2] Qt::ScrollPhase QGraphicsSceneWheelEvent::phase() const**

        Returns the scrolling phase of this wheel event.

        This function was introduced in Qt 6.2.

        **See also** **QWheelEvent::phase** .
        """
        ...

    def orientation(self) -> QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#orientation

        **Qt::Orientation QGraphicsSceneWheelEvent::orientation() const**

        Returns the wheel orientation.
        """
        ...

    def delta(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#delta

        **int QGraphicsSceneWheelEvent::delta() const**

        Returns the distance that the wheel is rotated, in eighths (1/8s) of a
        degree. A positive value indicates that the wheel was rotated forwards
        away from the user; a negative value indicates that the wheel was
        rotated backwards toward the user.

        Most mouse types work in steps of 15 degrees, in which case the delta
        value is a multiple of 120 (== 15 * 8).
        """
        ...

    def modifiers(self) -> QtCore.Qt.KeyboardModifier:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneWheelEvent::modifiers() const**

        Returns the keyboard modifiers that were active when the wheel event
        occurred.

        **See also** **buttons** ().
        """
        ...

    def buttons(self) -> QtCore.Qt.MouseButton:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#buttons

        **Qt::MouseButtons QGraphicsSceneWheelEvent::buttons() const**

        Returns the mouse buttons that were pressed when the wheel event
        occurred.

        **See also** **modifiers** ().
        """
        ...

    def screenPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#screenPos

        **QPoint QGraphicsSceneWheelEvent::screenPos() const**

        Returns the position of the cursor in screen coordinates when the wheel
        event occurred.

        **See also** **pos** () and **scenePos** ().
        """
        ...

    def scenePos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#scenePos

        **QPointF QGraphicsSceneWheelEvent::scenePos() const**

        Returns the position of the cursor in scene coordinates when the wheel
        event occurred.

        **See also** **pos** () and **screenPos** ().
        """
        ...

    def pos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenewheelevent.html#pos

        **QPointF QGraphicsSceneWheelEvent::pos() const**

        Returns the position of the cursor in item coordinates when the wheel
        event occurred.

        **See also** **scenePos** () and **screenPos** ().
        """
        ...
