"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QGraphicsSimpleTextItem(QAbstractGraphicsShapeItem):
    """
    https://doc.qt.io/qt-6/qgraphicssimpletextitem.html

    **Detailed Description**

    To set the item's text, you can either pass a **QString**  to
    QGraphicsSimpleTextItem's constructor, or call **setText** () to change the
    text later. To set the text fill color, call **setBrush** ().

    The simple text item can have both a fill and an outline; **setBrush** ()
    will set the text fill (i.e., text color), and **setPen** () sets the pen
    that will be used to draw the text outline. (The latter can be slow,
    especially for complex pens, and items with long text content.) If all you
    want is to draw a simple line of text, you should call **setBrush** () only,
    and leave the pen unset; QGraphicsSimpleTextItem's pen is by default
    **Qt::NoPen** .

    QGraphicsSimpleTextItem uses the text's formatted size and the associated
    font to provide a reasonable implementation of **boundingRect** (),
    **shape** (), and **contains** (). You can set the font by calling
    **setFont** ().

    QGraphicsSimpleText does not display rich text; instead, you can use
    **QGraphicsTextItem** , which provides full text control capabilities.

    ![](images/graphicsview-simpletextitem.png)

    **See also** **QGraphicsTextItem** , **QGraphicsPathItem** ,
    **QGraphicsRectItem** , **QGraphicsEllipseItem** , **QGraphicsPixmapItem** ,
    **QGraphicsPolygonItem** , **QGraphicsLineItem** , and **Graphics View
    Framework** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#QGraphicsSimpleTextI
        tem

        **QGraphicsSimpleTextItem::QGraphicsSimpleTextItem(QGraphicsItem *
        parent = nullptr)**

        Constructs a QGraphicsSimpleTextItem.

        **parent** is passed to **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#QGraphicsSimpleTextI
        tem-1

        **QGraphicsSimpleTextItem::QGraphicsSimpleTextItem(const QString & text
        , QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsSimpleTextItem, using **text** as the default
        plain text.

        **parent** is passed to **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#type

        **[override virtual] int QGraphicsSimpleTextItem::type() const**

        Reimplements: **QGraphicsItem::type() const** .
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsSimpleTextItem::opaqueArea()
        const**

        Reimplements: **QAbstractGraphicsShapeItem::opaqueArea() const** .
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#isObscuredBy

        **[override virtual] bool QGraphicsSimpleTextItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QAbstractGraphicsShapeItem::isObscuredBy(const
        QGraphicsItem *item) const** .
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: QWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#paint

        **[override virtual] void QGraphicsSimpleTextItem::paint(QPainter *
        painter , const QStyleOptionGraphicsItem * option , QWidget * widget )**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def contains(self, point: QtCore.QPointF) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#contains

        **[override virtual] bool QGraphicsSimpleTextItem::contains(const
        QPointF & point ) const**

        Reimplements: **QGraphicsItem::contains(const QPointF &point) const** .
        """
        ...

    def shape(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#shape

        **[override virtual] QPainterPath QGraphicsSimpleTextItem::shape()
        const**

        Reimplements: **QGraphicsItem::shape() const** .
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#boundingRect

        **[override virtual] QRectF QGraphicsSimpleTextItem::boundingRect()
        const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def font(self) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#font

        **QFont QGraphicsSimpleTextItem::font() const**

        Returns the font that is used to draw the item's text.

        **See also** **setFont** ().
        """
        ...

    def setFont(self, font: QtGui.QFont) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#setFont

        **void QGraphicsSimpleTextItem::setFont(const QFont & font )**

        Sets the font that is used to draw the item's text to **font**.

        **See also** **font** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#text

        **QString QGraphicsSimpleTextItem::text() const**

        Returns the item's text.

        **See also** **setText** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssimpletextitem.html#setText

        **void QGraphicsSimpleTextItem::setText(const QString & text )**

        Sets the item's text to **text**. The text will be displayed as plain
        text. Newline characters ('\\n') as well as characters of type
        **QChar::LineSeparator**  will cause item to break the text into
        multiple lines.

        **See also** **text** ().
        """
        ...
