"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QKeySequenceEdit(QWidget):
    """
    https://doc.qt.io/qt-6/qkeysequenceedit.html

    **Detailed Description**

    This widget lets the user choose a **QKeySequence** , which is usually used
    as a shortcut. The recording is initiated when the widget receives the focus
    and ends one second after the user releases the last key.

    **See also** **QKeySequenceEdit::keySequence** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#QKeySequenceEdit

        **QKeySequenceEdit::QKeySequenceEdit(QWidget * parent = nullptr)**

        Constructs a QKeySequenceEdit widget with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        keySequence: typing.Union[
            QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int
        ],
        parent: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#QKeySequenceEdit-1

        **QKeySequenceEdit::QKeySequenceEdit(const QKeySequence & keySequence ,
        QWidget * parent = nullptr)**

        Constructs a QKeySequenceEdit widget with the given **keySequence** and
        **parent**.
        """
        ...

    def timerEvent(self, a0: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#timerEvent

        **[override virtual protected] void
        QKeySequenceEdit::timerEvent(QTimerEvent * e )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keyReleaseEvent

        **[override virtual protected] void
        QKeySequenceEdit::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keyPressEvent

        **[override virtual protected] void
        QKeySequenceEdit::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#event

        **[override virtual protected] bool QKeySequenceEdit::event(QEvent * e
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#clear

        **[slot] void QKeySequenceEdit::clear()**

        Clears the current key sequence.
        """
        ...

    def setKeySequence(
        self,
        keySequence: typing.Union[
            QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keySequence-prop

        **keySequence : QKeySequence**

        This property contains the currently chosen key sequence.

        The shortcut can be changed by the user or via setter function.

        **Access functions:**

        QKeySequence **keySequence** () const
        void **setKeySequence** (const
        QKeySequence & **keySequence** )

        **Notifier signal:**

        void **keySequenceChanged** (const QKeySequence & **keySequence** )

        **Member Function Documentation**
        """
        ...

    def keySequence(self) -> QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keySequence-prop

        **keySequence : QKeySequence**

        This property contains the currently chosen key sequence.

        The shortcut can be changed by the user or via setter function.

        **Access functions:**

        QKeySequence **keySequence** () const
        void **setKeySequence** (const
        QKeySequence & **keySequence** )

        **Notifier signal:**

        void **keySequenceChanged** (const QKeySequence & **keySequence** )

        **Member Function Documentation**
        """
        ...

    @property
    def editingFinished(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#editingFinished

        **[signal] void QKeySequenceEdit::editingFinished()**

        This signal is emitted when the user finishes entering the shortcut.

        **Note:** there is a one second delay before releasing the last key and
        emitting this signal.
        """
        ...

    @property
    def keySequenceChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...
