"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QListWidget(QListView):
    """
    https://doc.qt.io/qt-6/qlistwidget.html

    **Detailed Description**

    ![](images/windows-listview.png)

    QListWidget is a convenience class that provides a list view similar to the
    one supplied by **QListView** , but with a classic item-based interface for
    adding and removing items. QListWidget uses an internal model to manage each
    **QListWidgetItem**  in the list.

    For a more flexible list view widget, use the **QListView**  class with a
    standard model.

    List widgets are constructed in the same way as other widgets:

    QListWidget *listWidget = new QListWidget(this);

    The **selectionMode** () of a list widget determines how many of the items
    in the list can be selected at the same time, and whether complex selections
    of items can be created. This can be set with the **setSelectionMode** ()
    function.

    There are two ways to add items to the list: they can be constructed with
    the list widget as their parent widget, or they can be constructed with no
    parent widget and added to the list later. If a list widget already exists
    when the items are constructed, the first method is easier to use:

    new **QListWidgetItem** (tr("Oak"), listWidget);
            new
    **QListWidgetItem** (tr("Fir"), listWidget);
            new **QListWidgetItem**
    (tr("Pine"), listWidget);

    If you need to insert a new item into the list at a particular position,
    then it should be constructed without a parent widget. The **insertItem** ()
    function should then be used to place it within the list. The list widget
    will take ownership of the item.

    **QListWidgetItem**  *newItem = new **QListWidgetItem** ;
    newItem->setText(itemText);
            listWidget->insertItem(row, newItem);

    For multiple items, **insertItems** () can be used instead. The number of
    items in the list is found with the **count** () function. To remove items
    from the list, use **takeItem** ().

    The current item in the list can be found with **currentItem** (), and
    changed with **setCurrentItem** (). The user can also change the current
    item by navigating with the keyboard or clicking on a different item. When
    the current item changes, the **currentItemChanged** () signal is emitted
    with the new current item and the item that was previously current.

    **See also** **QListWidgetItem** , **QListView** , **QTreeView** ,
    **Model/View Programming** , and **Tab Dialog Example** .
    """

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#QListWidget

        **QListWidget::QListWidget(QWidget * parent = nullptr)**

        Constructs an empty QListWidget with the given **parent**.
        """
        ...

    def isPersistentEditorOpen(self, item: QListWidgetItem) -> bool:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#isPersistentEditorOpen

        **[since 5.10] bool QListWidget::isPersistentEditorOpen(QListWidgetItem
        * item ) const**

        Returns whether a persistent editor is open for item **item**.

        This function was introduced in Qt 5.10.

        **See also** **openPersistentEditor** () and **closePersistentEditor**
        ().
        """
        ...

    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#setSelectionModel

        **[override virtual] void
        QListWidget::setSelectionModel(QItemSelectionModel * selectionModel )**

        Reimplements: **QAbstractItemView::setSelectionModel**
        (QItemSelectionModel *selectionModel).
        """
        ...

    def removeItemWidget(self, aItem: QListWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#removeItemWidget

        **void QListWidget::removeItemWidget(QListWidgetItem * item )**

        Removes the widget set on the given **item**.

        To remove an item (row) from the list entirely, either delete the item
        or use **takeItem** ().

        **See also** **itemWidget** () and **setItemWidget** ().
        """
        ...

    def isSortingEnabled(self) -> bool:
        ...

    def setSortingEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#sortingEnabled-prop

        **sortingEnabled : bool**

        This property holds whether sorting is enabled

        If this property is `true`, sorting is enabled for the list; if the
        property is false, sorting is not enabled.

        The default value is false.

        **Access functions:**

        bool **isSortingEnabled** () const
        void **setSortingEnabled** (bool
        **enable** )

        **Member Function Documentation**
        """
        ...

    def itemFromIndex(self, index: QtCore.QModelIndex) -> QListWidgetItem:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemFromIndex

        **QListWidgetItem *QListWidget::itemFromIndex(const QModelIndex & index
        ) const**

        Returns a pointer to the **QListWidgetItem**  associated with the given
        **index**.
        """
        ...

    def indexFromItem(self, item: QListWidgetItem) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#indexFromItem

        **QModelIndex QListWidget::indexFromItem(const QListWidgetItem * item )
        const**

        Returns the **QModelIndex**  associated with the given **item**.

        **Note:** In Qt versions prior to 5.10, this function took a non-`const`
        **item**.
        """
        ...

    def items(self, data: QtCore.QMimeData) -> typing.List[QListWidgetItem]:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#items

        **QList<QListWidgetItem *> QListWidget::items(const QMimeData * data )
        const**

        Returns a list of pointers to the items contained in the **data**
        object. If the object was not created by a **QListWidget**  in the same
        process, the list is empty.
        """
        ...

    def dropEvent(self, event: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#dropEvent

        **[override virtual protected] void QListWidget::dropEvent(QDropEvent *
        event )**

        Reimplements: **QListView::dropEvent** (QDropEvent *event).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#event

        **[override virtual protected] bool QListWidget::event(QEvent * e )**

        Reimplements: **QListView::event** (QEvent *e).
        """
        ...

    def supportedDropActions(self) -> QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#supportedDropActions

        **[virtual protected] Qt::DropActions
        QListWidget::supportedDropActions() const**

        Returns the drop actions supported by this view.

        **See also** **Qt::DropActions** .
        """
        ...

    def dropMimeData(
        self, index: int, data: QtCore.QMimeData, action: QtCore.Qt.DropAction
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#dropMimeData

        **[virtual protected] bool QListWidget::dropMimeData(int index , const
        QMimeData * data , Qt::DropAction action )**

        Handles **data** supplied by an external drag and drop operation that
        ended with the given **action** in the given **index**. Returns `true`
        if **data** and **action** can be handled by the model; otherwise
        returns `false`.

        **See also** **supportedDropActions** ().
        """
        ...

    def mimeData(self, items: typing.Iterable[QListWidgetItem]) -> QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#mimeData

        **[virtual protected] QMimeData *QListWidget::mimeData(const
        QList<QListWidgetItem *> & items ) const**

        Returns an object that contains a serialized description of the
        specified **items**. The format used to describe the items is obtained
        from the **mimeTypes** () function.

        If the list of items is empty, `nullptr` is returned instead of a
        serialized empty list.
        """
        ...

    def mimeTypes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#mimeTypes

        **[virtual protected] QStringList QListWidget::mimeTypes() const**

        Returns a list of MIME types that can be used to describe a list of
        listwidget items.

        **See also** **mimeData** ().
        """
        ...

    def scrollToItem(
        self, item: QListWidgetItem, hint: QAbstractItemView.ScrollHint = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#scrollToItem

        **[slot] void QListWidget::scrollToItem(const QListWidgetItem * item ,
        QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Scrolls the view if necessary to ensure that the **item** is visible.

        **hint** specifies where the **item** should be located after the
        operation.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#clear

        **[slot] void QListWidget::clear()**

        Removes all items and selections in the view.

        **Warning:** All items will be permanently deleted.
        """
        ...

    def findItems(
        self, text: str, flags: QtCore.Qt.MatchFlag
    ) -> typing.List[QListWidgetItem]:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#findItems

        **QList<QListWidgetItem *> QListWidget::findItems(const QString & text ,
        Qt::MatchFlags flags ) const**

        Finds items with the text that matches the string **text** using the
        given **flags**.
        """
        ...

    def selectedItems(self) -> typing.List[QListWidgetItem]:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#selectedItems

        **QList<QListWidgetItem *> QListWidget::selectedItems() const**

        Returns a list of all selected items in the list widget.
        """
        ...

    def closePersistentEditor(self, item: QListWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#closePersistentEditor

        **void QListWidget::closePersistentEditor(QListWidgetItem * item )**

        Closes the persistent editor for the given **item**.

        **See also** **openPersistentEditor** () and **isPersistentEditorOpen**
        ().
        """
        ...

    def openPersistentEditor(self, item: QListWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#openPersistentEditor

        **void QListWidget::openPersistentEditor(QListWidgetItem * item )**

        Opens an editor for the given **item**. The editor remains open after
        editing.

        **See also** **closePersistentEditor** () and **isPersistentEditorOpen**
        ().
        """
        ...

    def editItem(self, item: QListWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#editItem

        **void QListWidget::editItem(QListWidgetItem * item )**

        Starts editing the **item** if it is editable.
        """
        ...

    def sortItems(self, order: QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#sortItems

        **void QListWidget::sortItems(Qt::SortOrder order =
        Qt::AscendingOrder)**

        Sorts all the items in the list widget according to the specified
        **order**.
        """
        ...

    def visualItemRect(self, item: QListWidgetItem) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#visualItemRect

        **QRect QListWidget::visualItemRect(const QListWidgetItem * item )
        const**

        Returns the rectangle on the viewport occupied by the item at **item**.
        """
        ...

    def setItemWidget(self, item: QListWidgetItem, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#setItemWidget

        **void QListWidget::setItemWidget(QListWidgetItem * item , QWidget *
        widget )**

        Sets the **widget** to be displayed in the given **item**.

        This function should only be used to display static content in the place
        of a list widget item. If you want to display custom dynamic content or
        implement a custom editor widget, use **QListView**  and subclass
        **QStyledItemDelegate**  instead.

        **See also** **itemWidget** (), **removeItemWidget** (), and **Delegate
        Classes** .
        """
        ...

    def itemWidget(self, item: QListWidgetItem) -> QWidget:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemWidget

        **QWidget *QListWidget::itemWidget(QListWidgetItem * item ) const**

        Returns the widget displayed in the given **item**.

        **See also** **setItemWidget** () and **removeItemWidget** ().
        """
        ...

    @typing.overload
    def itemAt(self, p: QtCore.QPoint) -> QListWidgetItem:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemAt

        **QListWidgetItem *QListWidget::itemAt(const QPoint & p ) const**

        Returns a pointer to the item at the coordinates **p**. The coordinates
        are relative to the list widget's **viewport** ().
        """
        ...

    @typing.overload
    def itemAt(self, ax: int, ay: int) -> QListWidgetItem:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemAt-1

        **QListWidgetItem *QListWidget::itemAt(int x , int y ) const**

        This is an overloaded function.

        Returns a pointer to the item at the coordinates ( **x** , **y** ). The
        coordinates are relative to the list widget's **viewport** ().
        """
        ...

    @typing.overload
    def setCurrentRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#setCurrentRow-1

        **void QListWidget::setCurrentRow(int row ,
        QItemSelectionModel::SelectionFlags command )**

        Sets the current row to be the given **row** , using the given
        **command** ,

        **Note:** Setter function for property **currentRow** .
        """
        ...

    @typing.overload
    def setCurrentRow(
        self, row: int, command: QtCore.QItemSelectionModel.SelectionFlag
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#currentRow-prop

        **currentRow : int**

        This property holds the row of the current item.

        Depending on the current selection mode, the row may also be selected.

        **Access functions:**

        int **currentRow** () const
        void **setCurrentRow** (int **row** )
        void ****setCurrentRow** ** (int **row** ,
        QItemSelectionModel::SelectionFlags **command** )

        **Notifier signal:**

        void ****currentRowChanged** ** (int **currentRow** )
        """
        ...

    def currentRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#currentRow-prop

        **currentRow : int**

        This property holds the row of the current item.

        Depending on the current selection mode, the row may also be selected.

        **Access functions:**

        int **currentRow** () const
        void **setCurrentRow** (int **row** )
        void ****setCurrentRow** ** (int **row** ,
        QItemSelectionModel::SelectionFlags **command** )

        **Notifier signal:**

        void ****currentRowChanged** ** (int **currentRow** )
        """
        ...

    @typing.overload
    def setCurrentItem(self, item: QListWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#setCurrentItem

        **void QListWidget::setCurrentItem(QListWidgetItem * item )**

        Sets the current item to **item**.

        Unless the selection mode is **NoSelection** , the item is also
        selected.

        **See also** **currentItem** ().
        """
        ...

    @typing.overload
    def setCurrentItem(
        self, item: QListWidgetItem, command: QtCore.QItemSelectionModel.SelectionFlag
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#setCurrentItem-1

        **void QListWidget::setCurrentItem(QListWidgetItem * item ,
        QItemSelectionModel::SelectionFlags command )**

        Set the current item to **item** , using the given **command**.
        """
        ...

    def currentItem(self) -> QListWidgetItem:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#currentItem

        **QListWidgetItem *QListWidget::currentItem() const**

        Returns the current item.

        **See also** **setCurrentItem** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#count-prop

        **[read-only] count : const int**

        This property holds the number of items in the list including any hidden
        items.

        **Access functions:**

        int **count** () const
        """
        ...

    def takeItem(self, row: int) -> QListWidgetItem:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#takeItem

        **QListWidgetItem *QListWidget::takeItem(int row )**

        Removes and returns the item from the given **row** in the list widget;
        otherwise returns `nullptr`.

        Items removed from a list widget will not be managed by Qt, and will
        need to be deleted manually.

        **See also** **insertItem** () and **addItem** ().
        """
        ...

    def addItems(self, labels: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#addItems

        **void QListWidget::addItems(const QStringList & labels )**

        Inserts items with the text **labels** at the end of the list widget.

        **See also** **insertItems** ().
        """
        ...

    @typing.overload
    def addItem(self, aitem: QListWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#addItem

        **void QListWidget::addItem(const QString & label )**

        Inserts an item with the text **label** at the end of the list widget.
        """
        ...

    @typing.overload
    def addItem(self, label: str) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#addItem-1

        **void QListWidget::addItem(QListWidgetItem * item )**

        Inserts the **item** at the end of the list widget.

        **Warning:** A **QListWidgetItem**  can only be added to a
        **QListWidget**  once. Adding the same **QListWidgetItem**  multiple
        times to a **QListWidget**  will result in undefined behavior.

        **See also** **insertItem** ().
        """
        ...

    def insertItems(self, row: int, labels: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#insertItems

        **void QListWidget::insertItems(int row , const QStringList & labels )**

        Inserts items from the list of **labels** into the list, starting at the
        given **row**.

        **See also** **insertItem** () and **addItem** ().
        """
        ...

    @typing.overload
    def insertItem(self, row: int, item: QListWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#insertItem

        **void QListWidget::insertItem(int row , QListWidgetItem * item )**

        Inserts the **item** at the position in the list given by **row**.

        **See also** **addItem** ().
        """
        ...

    @typing.overload
    def insertItem(self, row: int, label: str) -> None:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#insertItem-1

        **void QListWidget::insertItem(int row , const QString & label )**

        Inserts an item with the text **label** in the list widget at the
        position given by **row**.

        **See also** **addItem** ().
        """
        ...

    def row(self, item: QListWidgetItem) -> int:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#row

        **int QListWidget::row(const QListWidgetItem * item ) const**

        Returns the row containing the given **item**.

        **See also** **item** ().
        """
        ...

    def item(self, row: int) -> QListWidgetItem:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#item

        **QListWidgetItem *QListWidget::item(int row ) const**

        Returns the item that occupies the given **row** in the list if one has
        been set; otherwise returns `nullptr`.

        **See also** **row** ().
        """
        ...

    @property
    def currentItemChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#currentItemChanged

        **[signal] void QListWidget::currentItemChanged(QListWidgetItem *
        current , QListWidgetItem * previous )**

        This signal is emitted whenever the current item changes.

        **previous** is the item that previously had the focus; **current** is
        the new current item.
        """
        ...

    @property
    def currentRowChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#currentRowChanged

        **[signal] void QListWidget::currentRowChanged(int currentRow )**

        This signal is emitted whenever the current item changes.

        **currentRow** is the row of the current item. If there is no current
        item, the **currentRow** is -1.

        **Note:** Notifier signal for property **currentRow** .
        """
        ...

    @property
    def currentTextChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#currentTextChanged

        **[signal] void QListWidget::currentTextChanged(const QString &
        currentText )**

        This signal is emitted whenever the current item changes.

        **currentText** is the text data in the current item. If there is no
        current item, the **currentText** is invalid.
        """
        ...

    @property
    def itemActivated(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemActivated

        **[signal] void QListWidget::itemActivated(QListWidgetItem * item )**

        This signal is emitted when the **item** is activated. The **item** is
        activated when the user clicks or double clicks on it, depending on the
        system configuration. It is also activated when the user presses the
        activation key (on Windows and X11 this is the **Return** key, on Mac OS
        X it is **Command+O** ).
        """
        ...

    @property
    def itemChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemChanged

        **[signal] void QListWidget::itemChanged(QListWidgetItem * item )**

        This signal is emitted whenever the data of **item** has changed.
        """
        ...

    @property
    def itemClicked(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemClicked

        **[signal] void QListWidget::itemClicked(QListWidgetItem * item )**

        This signal is emitted with the specified **item** when a mouse button
        is clicked on an item in the widget.

        **See also** **itemPressed** () and **itemDoubleClicked** ().
        """
        ...

    @property
    def itemDoubleClicked(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemDoubleClicked

        **[signal] void QListWidget::itemDoubleClicked(QListWidgetItem * item
        )**

        This signal is emitted with the specified **item** when a mouse button
        is double clicked on an item in the widget.

        **See also** **itemClicked** () and **itemPressed** ().
        """
        ...

    @property
    def itemEntered(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemEntered

        **[signal] void QListWidget::itemEntered(QListWidgetItem * item )**

        This signal is emitted when the mouse cursor enters an item. The
        **item** is the item entered. This signal is only emitted when
        mouseTracking is turned on, or when a mouse button is pressed while
        moving into an item.

        **See also** **QWidget::setMouseTracking** ().
        """
        ...

    @property
    def itemPressed(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemPressed

        **[signal] void QListWidget::itemPressed(QListWidgetItem * item )**

        This signal is emitted with the specified **item** when a mouse button
        is pressed on an item in the widget.

        **See also** **itemClicked** () and **itemDoubleClicked** ().
        """
        ...

    @property
    def itemSelectionChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qlistwidget.html#itemSelectionChanged

        **[signal] void QListWidget::itemSelectionChanged()**

        This signal is emitted whenever the selection changes.

        **See also** **selectedItems** (), **QListWidgetItem::isSelected** (),
        and **currentItemChanged** ().
        """
        ...
