"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QMessageBox(QDialog):
    """
    https://doc.qt.io/qt-6/qmessagebox.html

    **Detailed Description**

    A message box displays a primary **text**  to alert the user to a situation,
    an **informative text**  to further explain the alert or to ask the user a
    question, and an optional **detailed text**  to provide even more data if
    the user requests it. A message box can also display an **icon**  and
    **standard buttons**  for accepting a user response.

    Two APIs for using QMessageBox are provided, the property-based API, and the
    static functions. Calling one of the static functions is the simpler
    approach, but it is less flexible than using the property-based API, and the
    result is less informative. Using the property-based API is recommended.

    **The Property-based API**

    To use the property-based API, construct an instance of QMessageBox, set the
    desired properties, and call **exec** () to show the message. The simplest
    configuration is to set only the **message text**  property.

    **QMessageBox**  msgBox;
        msgBox.setText("The document has been
    modified.");
        msgBox.exec();

    The user must click the **OK** button to dismiss the message box. The rest
    of the GUI is blocked until the message box is dismissed.

    ![](images/msgbox1.png)

    A better approach than just alerting the user to an event is to also ask the
    user what to do about it. Store the question in the **informative text**
    property, and set the **standard buttons**  property to the set of buttons
    you want as the set of user responses. The buttons are specified by
    combining values from **StandardButtons**  using the bitwise OR operator.
    The display order for the buttons is platform-dependent. For example, on
    Windows, **Save** is displayed to the left of **Cancel** , whereas on Mac
    OS, the order is reversed.

    Mark one of your standard buttons to be your **default button** .

    **QMessageBox**  msgBox;
        msgBox.setText("The document has been
    modified.");
        msgBox.setInformativeText("Do you want to save your
    changes?");
        msgBox.setStandardButtons(**QMessageBox** ::Save |
    **QMessageBox** ::Discard | **QMessageBox** ::Cancel);
    msgBox.setDefaultButton(**QMessageBox** ::Save);
        int ret =
    msgBox.exec();

    This is the approach recommended in the **macOS Guidelines** . Similar
    guidelines apply for the other platforms, but note the different ways the
    **informative text**  is handled for different platforms.

    ![](images/msgbox2.png)

    The **exec** () slot returns the **StandardButtons**  value of the button
    that was clicked.

    switch (ret) {
          case **QMessageBox** ::Save:
              // Save was
    clicked
              break;
          case **QMessageBox** ::Discard:
              //
    Don't Save was clicked
              break;
          case **QMessageBox** ::Cancel:
    // Cancel was clicked
              break;
          default:
              // should
    never be reached
              break;
        }

    To give the user more information to help him answer the question, set the
    **detailed text**  property. If the **detailed text**  property is set, the
    **Show Details...** button will be shown.

    ![](images/msgbox3.png)

    Clicking the **Show Details...** button displays the detailed text.

    ![](images/msgbox4.png)

    **Rich Text and the Text Format Property**

    The **detailed text**  property is always interpreted as plain text. The
    **main text**  and **informative text**  properties can be either plain text
    or rich text. These strings are interpreted according to the setting of the
    **text format**  property. The default setting is **auto-text** .

    Note that for some plain text strings containing XML meta-characters, the
    auto-text **rich text detection test**  may fail causing your plain text
    string to be interpreted incorrectly as rich text. In these rare cases, use
    **Qt::convertFromPlainText** () to convert your plain text string to a
    visually equivalent rich text string, or set the **text format**  property
    explicitly with **setTextFormat** ().

    **Severity Levels and the Icon and Pixmap Properties**

    QMessageBox supports four predefined message severity levels, or message
    types, which really only differ in the predefined icon they each show.
    Specify one of the four predefined message types by setting the **icon**
    property to one of the **predefined icons** . The following rules are
    guidelines:

    ![](images/qmessagebox-quest.png)

    **Question** For asking a question during
    normal operations.

    ![](images/qmessagebox-info.png)

    **Information**
    For reporting information about normal operations.
    ![](images/qmessagebox-warn.png)

    **Warning** For reporting non-critical
    errors.

    ![](images/qmessagebox-crit.png)

    **Critical** For reporting
    critical errors.

    **Predefined icons**  are not defined by QMessageBox, but provided by the
    style. The default value is **No Icon** . The message boxes are otherwise
    the same for all cases. When using a standard icon, use the one recommended
    in the table, or use the one recommended by the style guidelines for your
    platform. If none of the standard icons is right for your message box, you
    can use a custom icon by setting the **icon pixmap**  property instead of
    setting the **icon**  property.

    In summary, to set an icon, use **either** **setIcon** () for one of the
    standard icons, **or** **setIconPixmap** () for a custom icon.

    **The Static Functions API**

    Building message boxes with the static functions API, although convenient,
    is less flexible than using the property-based API, because the static
    function signatures lack parameters for setting the **informative text**
    and **detailed text**  properties. One work-around for this has been to use
    the `title` parameter as the message box main text and the `text` parameter
    as the message box informative text. Because this has the obvious drawback
    of making a less readable message box, platform guidelines do not recommend
    it. The **Microsoft Windows User Interface Guidelines** recommend using the
    **application name**  as the **window's title** , which means that if you
    have an informative text in addition to your main text, you must concatenate
    it to the `text` parameter.

    Note that the static function signatures have changed with respect to their
    button parameters, which are now used to set the **standard buttons**  and
    the **default button** .

    Static functions are available for creating **information** (), **question**
    (), **warning** (), and **critical** () message boxes.

    int ret = **QMessageBox** ::warning(this, tr("My Application"),
    tr("The document has been modified.\\n"
    "Do you want to save your changes?"),
    **QMessageBox** ::Save | **QMessageBox** ::Discard
    | **QMessageBox** ::Cancel,
    **QMessageBox** ::Save);

    The **Standard Dialogs**  example shows how to use QMessageBox and the other
    built-in Qt dialogs.

    **Advanced Usage**

    If the **standard buttons**  are not flexible enough for your message box,
    you can use the **addButton** () overload that takes a text and a
    **ButtonRole**  to add custom buttons. The **ButtonRole**  is used by
    QMessageBox to determine the ordering of the buttons on screen (which varies
    according to the platform). You can test the value of **clickedButton** ()
    after calling **exec** (). For example,

    **QMessageBox**  msgBox;
        **QPushButton**  *connectButton =
    msgBox.addButton(tr("Connect"), **QMessageBox** ::ActionRole);
    **QPushButton**  *abortButton = msgBox.addButton(**QMessageBox** ::Abort);
    msgBox.exec();

        if (msgBox.clickedButton() == connectButton) {
    // connect
        } else if (msgBox.clickedButton() == abortButton) {
    // abort
        }

    **Default and Escape Keys**

    The default button (i.e., the button activated when **Enter** is pressed)
    can be specified using **setDefaultButton** (). If a default button is not
    specified, QMessageBox tries to find one based on the **button roles**  of
    the buttons used in the message box.

    The escape button (the button activated when **Esc** is pressed) can be
    specified using **setEscapeButton** (). If an escape button is not
    specified, QMessageBox tries to find one using these rules:

    1. If there is only one button, it is the button activated when **Esc** is
    pressed.
      2. If there is a **Cancel**  button, it is the button activated
    when **Esc** is pressed.
      3. If there is exactly one button having either
    **the Reject role**  or the **the No role** , it is the button activated
    when **Esc** is pressed.

    When an escape button can't be determined using these rules, pressing
    **Esc** has no effect.

    **See also** **QDialogButtonBox** , **GUI Design Handbook: Message Box** ,
    **Standard Dialogs Example** , and **Qt Widgets - Application Example** .
    """

    class StandardButton(enum.IntFlag):
        NoButton: QMessageBox = ...
        Ok: QMessageBox = ...
        Save: QMessageBox = ...
        SaveAll: QMessageBox = ...
        Open: QMessageBox = ...
        Yes: QMessageBox = ...
        YesToAll: QMessageBox = ...
        No: QMessageBox = ...
        NoToAll: QMessageBox = ...
        Abort: QMessageBox = ...
        Retry: QMessageBox = ...
        Ignore: QMessageBox = ...
        Close: QMessageBox = ...
        Cancel: QMessageBox = ...
        Discard: QMessageBox = ...
        Help: QMessageBox = ...
        Apply: QMessageBox = ...
        Reset: QMessageBox = ...
        RestoreDefaults: QMessageBox = ...
        FirstButton: QMessageBox = ...
        LastButton: QMessageBox = ...
        YesAll: QMessageBox = ...
        NoAll: QMessageBox = ...
        Default: QMessageBox = ...
        Escape: QMessageBox = ...
        FlagMask: QMessageBox = ...
        ButtonMask: QMessageBox = ...

    class Icon(enum.Enum):
        NoIcon: QMessageBox = ...
        Information: QMessageBox = ...
        Warning: QMessageBox = ...
        Critical: QMessageBox = ...
        Question: QMessageBox = ...

    class ButtonRole(enum.Enum):
        InvalidRole: QMessageBox = ...
        AcceptRole: QMessageBox = ...
        RejectRole: QMessageBox = ...
        DestructiveRole: QMessageBox = ...
        ActionRole: QMessageBox = ...
        HelpRole: QMessageBox = ...
        YesRole: QMessageBox = ...
        NoRole: QMessageBox = ...
        ResetRole: QMessageBox = ...
        ApplyRole: QMessageBox = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#QMessageBox

        **QMessageBox::QMessageBox(QWidget * parent = nullptr)**

        Constructs a message box with no text and no buttons. **parent** is
        passed to the **QDialog**  constructor.

        On macOS, if you want your message box to appear as a **Qt::Sheet**  of
        its **parent** , set the message box's **window modality**  to
        **Qt::WindowModal**  or use **open** (). Otherwise, the message box will
        be a standard dialog.
        """
        ...

    @typing.overload
    def __init__(
        self,
        icon: "QMessageBox.Icon",
        title: str,
        text: str,
        buttons: "QMessageBox.StandardButton" = ...,
        parent: typing.Optional[QWidget] = ...,
        flags: QtCore.Qt.WindowType = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#QMessageBox-1

        **QMessageBox::QMessageBox(QMessageBox::Icon icon , const QString &
        title , const QString & text , QMessageBox::StandardButtons buttons =
        NoButton, QWidget * parent = nullptr, Qt::WindowFlags f = Qt::Dialog |
        Qt::MSWindowsFixedSizeDialogHint)**

        Constructs a message box with the given **icon** , **title** , **text**
        , and standard **buttons**. Standard or custom buttons can be added at
        any time using **addButton** (). The **parent** and **f** arguments are
        passed to the **QDialog**  constructor.

        The message box is an **application modal**  dialog box.

        On macOS, if **parent** is not `nullptr` and you want your message box
        to appear as a **Qt::Sheet**  of that parent, set the message box's
        **window modality**  to **Qt::WindowModal**  (default). Otherwise, the
        message box will be a standard dialog.

        **See also** **setWindowTitle** (), **setText** (), **setIcon** (), and
        **setStandardButtons** ().
        """
        ...

    def checkBox(self) -> QCheckBox:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#checkBox

        **[since 5.2] QCheckBox *QMessageBox::checkBox() const**

        Returns the checkbox shown on the dialog. This is `nullptr` if no
        checkbox is set.

        This function was introduced in Qt 5.2.

        **See also** **setCheckBox** ().
        """
        ...

    def setCheckBox(self, cb: QCheckBox) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#setCheckBox

        **[since 5.2] void QMessageBox::setCheckBox(QCheckBox * cb )**

        Sets the checkbox **cb** on the message dialog. The message box takes
        ownership of the checkbox. The argument **cb** can be `nullptr` to
        remove an existing checkbox from the message box.

        This function was introduced in Qt 5.2.

        **See also** **checkBox** ().
        """
        ...

    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlag:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#textInteractionFlags-prop

        **[since 5.1] textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the label of the message box should interact with user
        input.

        The default value depends on the style.

        This property was introduced in Qt 5.1.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )

        **See also** **QStyle::SH_MessageBox_TextInteractionFlags** .

        **Member Function Documentation**
        """
        ...

    def setTextInteractionFlags(self, flags: QtCore.Qt.TextInteractionFlag) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#textInteractionFlags-prop

        **[since 5.1] textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the label of the message box should interact with user
        input.

        The default value depends on the style.

        This property was introduced in Qt 5.1.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )

        **See also** **QStyle::SH_MessageBox_TextInteractionFlags** .

        **Member Function Documentation**
        """
        ...

    def buttonRole(self, button: QAbstractButton) -> "QMessageBox.ButtonRole":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#buttonRole

        **QMessageBox::ButtonRole QMessageBox::buttonRole(QAbstractButton *
        button ) const**

        Returns the button role for the specified **button**. This function
        returns **InvalidRole**  if **button** is `nullptr` or has not been
        added to the message box.

        **See also** **buttons** () and **addButton** ().
        """
        ...

    def buttons(self) -> typing.List[QAbstractButton]:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#buttons

        **QList<QAbstractButton *> QMessageBox::buttons() const**

        Returns a list of all the buttons that have been added to the message
        box.

        **See also** **buttonRole** (), **addButton** (), and **removeButton**
        ().
        """
        ...

    @typing.overload
    def open(self) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#open

        **void QMessageBox::open(QObject * receiver , const char * member )**

        Opens the dialog and connects its **finished** () or **buttonClicked**
        () signal to the slot specified by **receiver** and **member**. If the
        slot in **member** has a pointer for its first parameter the connection
        is to **buttonClicked** (), otherwise the connection is to **finished**
        ().

        The signal will be disconnected from the slot when the dialog is closed.
        """
        ...

    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#open

        **void QMessageBox::open(QObject * receiver , const char * member )**

        Opens the dialog and connects its **finished** () or **buttonClicked**
        () signal to the slot specified by **receiver** and **member**. If the
        slot in **member** has a pointer for its first parameter the connection
        is to **buttonClicked** (), otherwise the connection is to **finished**
        ().

        The signal will be disconnected from the slot when the dialog is closed.
        """
        ...

    def setWindowModality(self, windowModality: QtCore.Qt.WindowModality) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#setWindowModality

        **void QMessageBox::setWindowModality(Qt::WindowModality windowModality
        )**

        This function shadows **QWidget::setWindowModality** ().

        Sets the modality of the message box to **windowModality**.

        On macOS, if the modality is set to **Qt::WindowModal**  and the message
        box has a parent, then the message box will be a **Qt::Sheet** ,
        otherwise the message box will be a standard dialog.
        """
        ...

    def setWindowTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#setWindowTitle

        **void QMessageBox::setWindowTitle(const QString & title )**

        This function shadows **QWidget::setWindowTitle** ().

        Sets the title of the message box to **title**. On macOS, the window
        title is ignored (as required by the macOS Guidelines).
        """
        ...

    def setDetailedText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#detailedText-prop

        **detailedText : QString**

        This property holds the text to be displayed in the details area.

        The text will be interpreted as a plain text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **detailedText** () const
        void **setDetailedText** (const
        QString & **text** )

        **See also** **QMessageBox::text**  and **QMessageBox::informativeText**
        .
        """
        ...

    def detailedText(self) -> str:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#detailedText-prop

        **detailedText : QString**

        This property holds the text to be displayed in the details area.

        The text will be interpreted as a plain text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **detailedText** () const
        void **setDetailedText** (const
        QString & **text** )

        **See also** **QMessageBox::text**  and **QMessageBox::informativeText**
        .
        """
        ...

    def setInformativeText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#informativeText-prop

        **informativeText : QString**

        This property holds the informative text that provides a fuller
        description for the message

        Infromative text can be used to expand upon the **text** () to give more
        information to the user. On the Mac, this text appears in small system
        font below the **text** (). On other platforms, it is simply appended to
        the existing text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **informativeText** () const
        void **setInformativeText**
        (const QString & **text** )

        **See also** **QMessageBox::text**  and **QMessageBox::detailedText** .
        """
        ...

    def informativeText(self) -> str:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#informativeText-prop

        **informativeText : QString**

        This property holds the informative text that provides a fuller
        description for the message

        Infromative text can be used to expand upon the **text** () to give more
        information to the user. On the Mac, this text appears in small system
        font below the **text** (). On other platforms, it is simply appended to
        the existing text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **informativeText** () const
        void **setInformativeText**
        (const QString & **text** )

        **See also** **QMessageBox::text**  and **QMessageBox::detailedText** .
        """
        ...

    def clickedButton(self) -> QAbstractButton:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#clickedButton

        **QAbstractButton *QMessageBox::clickedButton() const**

        Returns the button that was clicked by the user, or `nullptr` if the
        user hit the **Esc** key and no **escape button**  was set.

        If **exec** () hasn't been called yet, returns nullptr.

        Example:

        **QMessageBox**  messageBox(this);
            **QAbstractButton**
        *disconnectButton =
                  messageBox.addButton(tr("Disconnect"),
        **QMessageBox** ::ActionRole);
            ...
            messageBox.exec();
            if
        (messageBox.clickedButton() == disconnectButton) {
                ...
            }

        **See also** **standardButton** () and **button** ().
        """
        ...

    @typing.overload
    def setEscapeButton(self, button: QAbstractButton) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#setEscapeButton

        **void QMessageBox::setEscapeButton(QAbstractButton * button )**

        Sets the button that gets activated when the **Escape** key is pressed
        to **button**.

        **See also** **escapeButton** (), **addButton** (), and
        **clickedButton** ().
        """
        ...

    @typing.overload
    def setEscapeButton(self, button: "QMessageBox.StandardButton") -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#setEscapeButton-1

        **void QMessageBox::setEscapeButton(QMessageBox::StandardButton button
        )**

        Sets the buttons that gets activated when the **Escape** key is pressed
        to **button**.

        **See also** **addButton** () and **clickedButton** ().
        """
        ...

    def escapeButton(self) -> QAbstractButton:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#escapeButton

        **QAbstractButton *QMessageBox::escapeButton() const**

        Returns the button that is activated when escape is pressed.

        By default, **QMessageBox**  attempts to automatically detect an escape
        button as follows:

        1. If there is only one button, it is made the escape button.
          2. If
        there is a **Cancel**  button, it is made the escape button.
          3. On
        macOS only, if there is exactly one button with the role
        **QMessageBox::RejectRole** , it is made the escape button.

        When an escape button could not be automatically detected, pressing
        **Esc** has no effect.

        **See also** **setEscapeButton** () and **addButton** ().
        """
        ...

    @typing.overload
    def setDefaultButton(self, button: QPushButton) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#setDefaultButton

        **void QMessageBox::setDefaultButton(QPushButton * button )**

        Sets the message box's **default button**  to **button**.

        **See also** **defaultButton** (), **addButton** (), and
        **QPushButton::setDefault** ().
        """
        ...

    @typing.overload
    def setDefaultButton(self, button: "QMessageBox.StandardButton") -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#setDefaultButton-1

        **void QMessageBox::setDefaultButton(QMessageBox::StandardButton button
        )**

        Sets the message box's **default button**  to **button**.

        **See also** **addButton** () and **QPushButton::setDefault** ().
        """
        ...

    def defaultButton(self) -> QPushButton:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#defaultButton

        **QPushButton *QMessageBox::defaultButton() const**

        Returns the button that should be the message box's **default button** .
        Returns nullptr if no default button was set.

        **See also** **setDefaultButton** (), **addButton** (), and
        **QPushButton::setDefault** ().
        """
        ...

    def button(self, which: "QMessageBox.StandardButton") -> QAbstractButton:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#button

        **QAbstractButton *QMessageBox::button(QMessageBox::StandardButton which
        ) const**

        Returns a pointer corresponding to the standard button **which** , or
        `nullptr` if the standard button doesn't exist in this message box.

        **See also** **standardButtons**  and **standardButton** ().
        """
        ...

    def standardButton(self, button: QAbstractButton) -> "QMessageBox.StandardButton":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#standardButton

        **QMessageBox::StandardButton
        QMessageBox::standardButton(QAbstractButton * button ) const**

        Returns the standard button enum value corresponding to the given
        **button** , or **NoButton**  if the given **button** isn't a standard
        button.

        **See also** **button** () and **standardButtons** ().
        """
        ...

    def standardButtons(self) -> "QMessageBox.StandardButton":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#standardButtons-prop

        **standardButtons : StandardButtons**

        collection of standard buttons in the message box

        This property controls which standard buttons are used by the message
        box.

        By default, this property contains no standard buttons.

        **Access functions:**

        QMessageBox::StandardButtons **standardButtons** () const
        void
        **setStandardButtons** (QMessageBox::StandardButtons **buttons** )

        **See also** **addButton** ().
        """
        ...

    def setStandardButtons(self, buttons: "QMessageBox.StandardButton") -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#standardButtons-prop

        **standardButtons : StandardButtons**

        collection of standard buttons in the message box

        This property controls which standard buttons are used by the message
        box.

        By default, this property contains no standard buttons.

        **Access functions:**

        QMessageBox::StandardButtons **standardButtons** () const
        void
        **setStandardButtons** (QMessageBox::StandardButtons **buttons** )

        **See also** **addButton** ().
        """
        ...

    def removeButton(self, button: QAbstractButton) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#removeButton

        **void QMessageBox::removeButton(QAbstractButton * button )**

        Removes **button** from the button box without deleting it.

        **See also** **addButton** () and **setStandardButtons** ().
        """
        ...

    @typing.overload
    def addButton(
        self, button: QAbstractButton, role: "QMessageBox.ButtonRole"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#addButton

        **void QMessageBox::addButton(QAbstractButton * button ,
        QMessageBox::ButtonRole role )**

        Adds the given **button** to the message box with the specified
        **role**.

        **See also** **removeButton** (), **button** (), and
        **setStandardButtons** ().
        """
        ...

    @typing.overload
    def addButton(self, text: str, role: "QMessageBox.ButtonRole") -> QPushButton:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#addButton-1

        **QPushButton *QMessageBox::addButton(const QString & text ,
        QMessageBox::ButtonRole role )**

        This is an overloaded function.

        Creates a button with the given **text** , adds it to the message box
        for the specified **role** , and returns it.
        """
        ...

    @typing.overload
    def addButton(self, button: "QMessageBox.StandardButton") -> QPushButton:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#addButton-2

        **QPushButton *QMessageBox::addButton(QMessageBox::StandardButton button
        )**

        This is an overloaded function.

        Adds a standard **button** to the message box if it is valid to do so,
        and returns the push button.

        **See also** **setStandardButtons** ().
        """
        ...

    def changeEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#changeEvent

        **[override virtual protected] void QMessageBox::changeEvent(QEvent * ev
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#keyPressEvent

        **[override virtual protected] void QMessageBox::keyPressEvent(QKeyEvent
        * e )**

        Reimplements: **QDialog::keyPressEvent** (QKeyEvent *e).
        """
        ...

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#closeEvent

        **[override virtual protected] void QMessageBox::closeEvent(QCloseEvent
        * e )**

        Reimplements: **QDialog::closeEvent** (QCloseEvent *e).
        """
        ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#showEvent

        **[override virtual protected] void QMessageBox::showEvent(QShowEvent *
        e )**

        Reimplements: **QDialog::showEvent** (QShowEvent *event).
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#resizeEvent

        **[override virtual protected] void
        QMessageBox::resizeEvent(QResizeEvent * event )**

        Reimplements: **QDialog::resizeEvent** (QResizeEvent *).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#event

        **[override virtual protected] bool QMessageBox::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    @staticmethod
    def standardIcon(icon: "QMessageBox.Icon") -> QtGui.QPixmap:
        ...

    @staticmethod
    def aboutQt(parent: QWidget, title: str = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#aboutQt

        **[static] void QMessageBox::aboutQt(QWidget * parent , const QString &
        title = QString())**

        Displays a simple message box about Qt, with the given **title** and
        centered over **parent** (if **parent** is not `nullptr`). The message
        includes the version number of Qt being used by the application.

        This is useful for inclusion in the **Help** menu of an application, as
        shown in the **Menus**  example.

        **QApplication**  provides this functionality as a slot.

        On macOS, the about box is popped up as a modeless window; on other
        platforms, it is currently application modal.

        **See also** **QApplication::aboutQt** ().
        """
        ...

    @staticmethod
    def about(parent: QWidget, caption: str, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#about

        **[static] void QMessageBox::about(QWidget * parent , const QString &
        title , const QString & text )**

        Displays a simple about box with title **title** and text **text**. The
        about box's parent is **parent**.

        about() looks for a suitable icon in four locations:

        1. It prefers **parent->icon** () if that exists.
          2. If not, it tries
        the top-level widget containing **parent**.
          3. If that fails, it tries
        the **active window.**
          4. As a last resort it uses the Information
        icon.

        The about box has a single button labelled "OK". On macOS, the about box
        is popped up as a modeless window; on other platforms, it is currently
        application modal.

        **See also** **QWidget::windowIcon** () and
        **QApplication::activeWindow** ().
        """
        ...

    @staticmethod
    def critical(
        parent: QWidget,
        title: str,
        text: str,
        buttons: "QMessageBox.StandardButton" = ...,
        defaultButton: "QMessageBox.StandardButton" = ...,
    ) -> "QMessageBox.StandardButton":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#critical

        **[static] QMessageBox::StandardButton QMessageBox::critical(QWidget *
        parent , const QString & title , const QString & text ,
        QMessageBox::StandardButtons buttons = Ok, QMessageBox::StandardButton
        defaultButton = NoButton)**

        Opens a critical message box with the given **title** and **text** in
        front of the specified **parent** widget.

        The standard **buttons** are added to the message box. **defaultButton**
        specifies the button used when **Enter** is pressed. **defaultButton**
        must refer to a button that was given in **buttons**. If
        **defaultButton** is **QMessageBox::NoButton** , **QMessageBox**
        chooses a suitable default automatically.

        Returns the identity of the standard button that was clicked. If **Esc**
        was pressed instead, the **escape button**  is returned.

        The message box is an **application modal**  dialog box.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QMessageBox**  constructors.

        **See also** **question** (), **warning** (), and **information** ().
        """
        ...

    @staticmethod
    def warning(
        parent: QWidget,
        title: str,
        text: str,
        buttons: "QMessageBox.StandardButton" = ...,
        defaultButton: "QMessageBox.StandardButton" = ...,
    ) -> "QMessageBox.StandardButton":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#warning

        **[static] QMessageBox::StandardButton QMessageBox::warning(QWidget *
        parent , const QString & title , const QString & text ,
        QMessageBox::StandardButtons buttons = Ok, QMessageBox::StandardButton
        defaultButton = NoButton)**

        Opens a warning message box with the given **title** and **text** in
        front of the specified **parent** widget.

        The standard **buttons** are added to the message box. **defaultButton**
        specifies the button used when **Enter** is pressed. **defaultButton**
        must refer to a button that was given in **buttons**. If
        **defaultButton** is **QMessageBox::NoButton** , **QMessageBox**
        chooses a suitable default automatically.

        Returns the identity of the standard button that was clicked. If **Esc**
        was pressed instead, the **escape button**  is returned.

        The message box is an **application modal**  dialog box.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QMessageBox**  constructors.

        **See also** **question** (), **information** (), and **critical** ().
        """
        ...

    @staticmethod
    def question(
        parent: QWidget,
        title: str,
        text: str,
        buttons: "QMessageBox.StandardButton" = ...,
        defaultButton: "QMessageBox.StandardButton" = ...,
    ) -> "QMessageBox.StandardButton":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#question

        **[static] QMessageBox::StandardButton QMessageBox::question(QWidget *
        parent , const QString & title , const QString & text ,
        QMessageBox::StandardButtons buttons = StandardButtons(Yes | No),
        QMessageBox::StandardButton defaultButton = NoButton)**

        Opens a question message box with the given **title** and **text** in
        front of the specified **parent** widget.

        The standard **buttons** are added to the message box. **defaultButton**
        specifies the button used when **Enter** is pressed. **defaultButton**
        must refer to a button that was given in **buttons**. If
        **defaultButton** is **QMessageBox::NoButton** , **QMessageBox**
        chooses a suitable default automatically.

        Returns the identity of the standard button that was clicked. If **Esc**
        was pressed instead, the **escape button**  is returned.

        The message box is an **application modal**  dialog box.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QMessageBox**  constructors.

        **See also** **information** (), **warning** (), and **critical** ().
        """
        ...

    @staticmethod
    def information(
        parent: QWidget,
        title: str,
        text: str,
        buttons: "QMessageBox.StandardButton" = ...,
        defaultButton: "QMessageBox.StandardButton" = ...,
    ) -> "QMessageBox.StandardButton":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#information

        **[static] QMessageBox::StandardButton QMessageBox::information(QWidget
        * parent , const QString & title , const QString & text ,
        QMessageBox::StandardButtons buttons = Ok, QMessageBox::StandardButton
        defaultButton = NoButton)**

        Opens an information message box with the given **title** and **text**
        in front of the specified **parent** widget.

        The standard **buttons** are added to the message box. **defaultButton**
        specifies the button used when **Enter** is pressed. **defaultButton**
        must refer to a button that was given in **buttons**. If
        **defaultButton** is **QMessageBox::NoButton** , **QMessageBox**
        chooses a suitable default automatically.

        Returns the identity of the standard button that was clicked. If **Esc**
        was pressed instead, the **escape button**  is returned.

        The message box is an **application modal**  dialog box.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QMessageBox**  constructors.

        **See also** **question** (), **warning** (), and **critical** ().
        """
        ...

    def setTextFormat(self, a0: QtCore.Qt.TextFormat) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#textFormat-prop

        **textFormat : Qt::TextFormat**

        This property holds the format of the text displayed by the message box

        The current text format used by the message box. See the
        **Qt::TextFormat**  enum for an explanation of the possible options.

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **textFormat** () const
        void **setTextFormat**
        (Qt::TextFormat **format** )

        **See also** **setText** ().
        """
        ...

    def textFormat(self) -> QtCore.Qt.TextFormat:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#textFormat-prop

        **textFormat : Qt::TextFormat**

        This property holds the format of the text displayed by the message box

        The current text format used by the message box. See the
        **Qt::TextFormat**  enum for an explanation of the possible options.

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **textFormat** () const
        void **setTextFormat**
        (Qt::TextFormat **format** )

        **See also** **setText** ().
        """
        ...

    def setIconPixmap(self, a0: QtGui.QPixmap) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#iconPixmap-prop

        **iconPixmap : QPixmap**

        This property holds the current icon

        The icon currently used by the message box. Note that it's often hard to
        draw one pixmap that looks appropriate in all GUI styles; you may want
        to supply a different pixmap for each platform.

        By default, this property is undefined.

        **Access functions:**

        QPixmap **iconPixmap** () const
        void **setIconPixmap** (const QPixmap
        & **pixmap** )

        **See also** **icon** .
        """
        ...

    def iconPixmap(self) -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#iconPixmap-prop

        **iconPixmap : QPixmap**

        This property holds the current icon

        The icon currently used by the message box. Note that it's often hard to
        draw one pixmap that looks appropriate in all GUI styles; you may want
        to supply a different pixmap for each platform.

        By default, this property is undefined.

        **Access functions:**

        QPixmap **iconPixmap** () const
        void **setIconPixmap** (const QPixmap
        & **pixmap** )

        **See also** **icon** .
        """
        ...

    def setIcon(self, a0: "QMessageBox.Icon") -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#icon-prop

        **icon : Icon**

        This property holds the message box's icon

        The icon of the message box can be specified with one of the values:

        * **QMessageBox::NoIcon**
          * **QMessageBox::Question**
          *
        **QMessageBox::Information**
          * **QMessageBox::Warning**
          *
        **QMessageBox::Critical**

        The default is **QMessageBox::NoIcon** .

        The pixmap used to display the actual icon depends on the current **GUI
        style** . You can also set a custom pixmap for the icon by setting the
        **icon pixmap**  property.

        **Access functions:**

        QMessageBox::Icon **icon** () const
        void **setIcon**
        (QMessageBox::Icon)

        **See also** **iconPixmap** .
        """
        ...

    def icon(self) -> "QMessageBox.Icon":
        """
        https://doc.qt.io/qt-6/qmessagebox.html#icon-prop

        **icon : Icon**

        This property holds the message box's icon

        The icon of the message box can be specified with one of the values:

        * **QMessageBox::NoIcon**
          * **QMessageBox::Question**
          *
        **QMessageBox::Information**
          * **QMessageBox::Warning**
          *
        **QMessageBox::Critical**

        The default is **QMessageBox::NoIcon** .

        The pixmap used to display the actual icon depends on the current **GUI
        style** . You can also set a custom pixmap for the icon by setting the
        **icon pixmap**  property.

        **Access functions:**

        QMessageBox::Icon **icon** () const
        void **setIcon**
        (QMessageBox::Icon)

        **See also** **iconPixmap** .
        """
        ...

    def setText(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#text-prop

        **text : QString**

        This property holds the message box text to be displayed.

        The text will be interpreted either as a plain text or as rich text,
        depending on the text format setting (**QMessageBox::textFormat** ). The
        default setting is **Qt::AutoText** , i.e., the message box will try to
        auto-detect the format of the text.

        The default value of this property is an empty string.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **See also** **textFormat** , **QMessageBox::informativeText** , and
        **QMessageBox::detailedText** .
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#text-prop

        **text : QString**

        This property holds the message box text to be displayed.

        The text will be interpreted either as a plain text or as rich text,
        depending on the text format setting (**QMessageBox::textFormat** ). The
        default setting is **Qt::AutoText** , i.e., the message box will try to
        auto-detect the format of the text.

        The default value of this property is an empty string.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **See also** **textFormat** , **QMessageBox::informativeText** , and
        **QMessageBox::detailedText** .
        """
        ...

    @property
    def buttonClicked(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qmessagebox.html#buttonClicked

        **[signal] void QMessageBox::buttonClicked(QAbstractButton * button )**

        This signal is emitted whenever a button is clicked inside the
        **QMessageBox** . The button that was clicked in returned in **button**.
        """
        ...
