"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QPlainTextEdit(QAbstractScrollArea):
    """
    https://doc.qt.io/qt-6/qplaintextedit.html

    **Detailed Description**

    **Introduction and Concepts**

    QPlainTextEdit is an advanced viewer/editor supporting plain text. It is
    optimized to handle large documents and to respond quickly to user input.

    QPlainText uses very much the same technology and concepts as **QTextEdit**
    , but is optimized for plain text handling.

    QPlainTextEdit works on paragraphs and characters. A paragraph is a
    formatted string which is word-wrapped to fit into the width of the widget.
    By default when reading plain text, one newline signifies a paragraph. A
    document consists of zero or more paragraphs. Paragraphs are separated by
    hard line breaks. Each character within a paragraph has its own attributes,
    for example, font and color.

    The shape of the mouse cursor on a QPlainTextEdit is **Qt::IBeamCursor**  by
    default. It can be changed through the **viewport** ()'s cursor property.

    **Using QPlainTextEdit as a Display Widget**

    The text is set or replaced using **setPlainText** () which deletes the
    existing text and replaces it with the text passed to **setPlainText** ().

    Text can be inserted using the **QTextCursor**  class or using the
    convenience functions **insertPlainText** (), **appendPlainText** () or
    **paste** ().

    By default, the text edit wraps words at whitespace to fit within the text
    edit widget. The **setLineWrapMode** () function is used to specify the kind
    of line wrap you want, **WidgetWidth**  or **NoWrap**  if you don't want any
    wrapping. If you use word wrap to the widget's width **WidgetWidth** , you
    can specify whether to break on whitespace or anywhere with
    **setWordWrapMode** ().

    The **find** () function can be used to find and select a given string
    within the text.

    If you want to limit the total number of paragraphs in a QPlainTextEdit, as
    it is for example useful in a log viewer, then you can use the
    **maximumBlockCount**  property. The combination of **setMaximumBlockCount**
    () and **appendPlainText** () turns QPlainTextEdit into an efficient viewer
    for log text. The scrolling can be reduced with the **centerOnScroll** ()
    property, making the log viewer even faster. Text can be formatted in a
    limited way, either using a syntax highlighter (see below), or by appending
    html-formatted text with **appendHtml** (). While QPlainTextEdit does not
    support complex rich text rendering with tables and floats, it does support
    limited paragraph-based formatting that you may need in a log viewer.

    **Read-only Key Bindings**

    When QPlainTextEdit is used read-only the key bindings are limited to
    navigation, and text may only be selected with the mouse:

    KeypressesAction
    **Qt::UpArrow** Moves one line up.
    **Qt::DownArrow**
    Moves one line down.
    **Qt::LeftArrow** Moves one character to the left.
    **Qt::RightArrow** Moves one character to the right.
    PageUpMoves one
    (viewport) page up.
    PageDownMoves one (viewport) page down.
    HomeMoves to
    the beginning of the text.
    EndMoves to the end of the text.
    Alt+WheelScrolls the page horizontally (the Wheel is the mouse wheel).
    Ctrl+WheelZooms the text.
    Ctrl+ASelects all text.

    **Using QPlainTextEdit as an Editor**

    All the information about using QPlainTextEdit as a display widget also
    applies here.

    Selection of text is handled by the **QTextCursor**  class, which provides
    functionality for creating selections, retrieving the text contents or
    deleting selections. You can retrieve the object that corresponds with the
    user-visible cursor using the **textCursor** () method. If you want to set a
    selection in QPlainTextEdit just create one on a **QTextCursor**  object and
    then make that cursor the visible cursor using **setCursor** (). The
    selection can be copied to the clipboard with **copy** (), or cut to the
    clipboard with **cut** (). The entire text can be selected using
    **selectAll** ().

    QPlainTextEdit holds a **QTextDocument**  object which can be retrieved
    using the **document** () method. You can also set your own document object
    using **setDocument** (). **QTextDocument**  emits a **textChanged** ()
    signal if the text changes and it also provides a isModified() function
    which will return true if the text has been modified since it was either
    loaded or since the last call to setModified with false as argument. In
    addition it provides methods for undo and redo.

    **Syntax Highlighting**

    Just like **QTextEdit** , QPlainTextEdit works together with
    **QSyntaxHighlighter** .

    **Editing Key Bindings**

    The list of key bindings which are implemented for editing:

    KeypressesAction
    BackspaceDeletes the character to the left of the cursor.
    DeleteDeletes the character to the right of the cursor.
    Ctrl+CCopy the
    selected text to the clipboard.
    Ctrl+InsertCopy the selected text to the
    clipboard.
    Ctrl+KDeletes to the end of the line.
    Ctrl+VPastes the
    clipboard text into text edit.
    Shift+InsertPastes the clipboard text into
    text edit.
    Ctrl+XDeletes the selected text and copies it to the clipboard.
    Shift+DeleteDeletes the selected text and copies it to the clipboard.
    Ctrl+ZUndoes the last operation.
    Ctrl+YRedoes the last operation.
    LeftArrowMoves the cursor one character to the left.
    Ctrl+LeftArrowMoves
    the cursor one word to the left.
    RightArrowMoves the cursor one character
    to the right.
    Ctrl+RightArrowMoves the cursor one word to the right.
    UpArrowMoves the cursor one line up.
    Ctrl+UpArrowMoves the cursor one word
    up.
    DownArrowMoves the cursor one line down.
    Ctrl+Down ArrowMoves the
    cursor one word down.
    PageUpMoves the cursor one page up.
    PageDownMoves
    the cursor one page down.
    HomeMoves the cursor to the beginning of the
    line.
    Ctrl+HomeMoves the cursor to the beginning of the text.
    EndMoves
    the cursor to the end of the line.
    Ctrl+EndMoves the cursor to the end of
    the text.
    Alt+WheelScrolls the page horizontally (the Wheel is the mouse
    wheel).
    Ctrl+WheelZooms the text.

    To select (mark) text hold down the Shift key whilst pressing one of the
    movement keystrokes, for example, **Shift+Right Arrow** will select the
    character to the right, and **Shift+Ctrl+Right Arrow** will select the word
    to the right, etc.

    **Differences to QTextEdit**

    QPlainTextEdit is a thin class, implemented by using most of the technology
    that is behind **QTextEdit**  and **QTextDocument** . Its performance
    benefits over **QTextEdit**  stem mostly from using a different and
    simplified text layout called **QPlainTextDocumentLayout**  on the text
    document (see **QTextDocument::setDocumentLayout** ()). The plain text
    document layout does not support tables nor embedded frames, and **replaces
    a pixel-exact height calculation with a line-by-line respectively paragraph-
    by-paragraph scrolling approach**. This makes it possible to handle
    significantly larger documents, and still resize the editor with line wrap
    enabled in real time. It also makes for a fast log viewer (see
    **setMaximumBlockCount** ()).

    **See also** **QTextDocument** , **QTextCursor** , **Qt Widgets -
    Application Example** , **Code Editor Example** , **Syntax Highlighter
    Example** , and **Rich Text Processing** .
    """

    class LineWrapMode(enum.Enum):
        NoWrap: QPlainTextEdit = ...
        WidgetWidth: QPlainTextEdit = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#QPlainTextEdit

        **QPlainTextEdit::QPlainTextEdit(QWidget * parent = nullptr)**

        Constructs an empty QPlainTextEdit with parent **parent**.
        """
        ...

    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#QPlainTextEdit-1

        **QPlainTextEdit::QPlainTextEdit(const QString & text , QWidget * parent
        = nullptr)**

        Constructs a QPlainTextEdit with parent **parent**. The text edit will
        display the plain text **text**.
        """
        ...

    def setTabStopDistance(self, distance: float) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#tabStopDistance-prop

        **[since 5.10] tabStopDistance : qreal**

        This property holds the tab stop distance in pixels

        By default, this property contains a value of 80 pixels.

        Do not set a value less than the **horizontalAdvance** () of the
        **QChar::VisualTabCharacter**  character, otherwise the tab-character
        will be drawn incompletely.

        This property was introduced in Qt 5.10.

        **Access functions:**

        qreal **tabStopDistance** () const
        void **setTabStopDistance** (qreal
        **distance** )

        **See also** **QTextOption::ShowTabsAndSpaces**  and
        **QTextDocument::defaultTextOption** .
        """
        ...

    def tabStopDistance(self) -> float:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#tabStopDistance-prop

        **[since 5.10] tabStopDistance : qreal**

        This property holds the tab stop distance in pixels

        By default, this property contains a value of 80 pixels.

        Do not set a value less than the **horizontalAdvance** () of the
        **QChar::VisualTabCharacter**  character, otherwise the tab-character
        will be drawn incompletely.

        This property was introduced in Qt 5.10.

        **Access functions:**

        qreal **tabStopDistance** () const
        void **setTabStopDistance** (qreal
        **distance** )

        **See also** **QTextOption::ShowTabsAndSpaces**  and
        **QTextDocument::defaultTextOption** .
        """
        ...

    def placeholderText(self) -> str:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#placeholderText-prop

        **[since 5.3] placeholderText : QString**

        This property holds the editor placeholder text

        Setting this property makes the editor display a grayed-out placeholder
        text as long as the **document** () is empty.

        By default, this property contains an empty string.

        This property was introduced in Qt 5.3.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )

        **See also** **document** ().
        """
        ...

    def setPlaceholderText(self, placeholderText: str) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#placeholderText-prop

        **[since 5.3] placeholderText : QString**

        This property holds the editor placeholder text

        Setting this property makes the editor display a grayed-out placeholder
        text as long as the **document** () is empty.

        By default, this property contains an empty string.

        This property was introduced in Qt 5.3.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )

        **See also** **document** ().
        """
        ...

    def zoomOut(self, range: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#zoomOut

        **[slot] void QPlainTextEdit::zoomOut(int range = 1)**

        Zooms out on the text by making the base font size **range** points
        smaller and recalculating all font sizes to be the new size. This does
        not change the size of any images.

        **See also** **zoomIn** ().
        """
        ...

    def zoomIn(self, range: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#zoomIn

        **[slot] void QPlainTextEdit::zoomIn(int range = 1)**

        Zooms in on the text by making the base font size **range** points
        larger and recalculating all font sizes to be the new size. This does
        not change the size of any images.

        **See also** **zoomOut** ().
        """
        ...

    def anchorAt(self, pos: QtCore.QPoint) -> str:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#anchorAt

        **QString QPlainTextEdit::anchorAt(const QPoint & pos ) const**

        Returns the reference of the anchor at position **pos** , or an empty
        string if no anchor exists at that point.
        """
        ...

    def getPaintContext(self) -> QtGui.QAbstractTextDocumentLayout.PaintContext:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#getPaintContext

        **[protected] QAbstractTextDocumentLayout::PaintContext
        QPlainTextEdit::getPaintContext() const**

        Returns the paint context for the **viewport** (), useful only when
        reimplementing **paintEvent** ().
        """
        ...

    def blockBoundingGeometry(self, block: QtGui.QTextBlock) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#blockBoundingGeometry

        **[protected] QRectF QPlainTextEdit::blockBoundingGeometry(const
        QTextBlock & block ) const**

        Returns the bounding rectangle of the text **block** in content
        coordinates. Translate the rectangle with the **contentOffset** () to
        get visual coordinates on the viewport.

        **See also** **firstVisibleBlock** () and **blockBoundingRect** ().
        """
        ...

    def blockBoundingRect(self, block: QtGui.QTextBlock) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#blockBoundingRect

        **[protected] QRectF QPlainTextEdit::blockBoundingRect(const QTextBlock
        & block ) const**

        Returns the bounding rectangle of the text **block** in the block's own
        coordinates.

        **See also** **blockBoundingGeometry** ().
        """
        ...

    def contentOffset(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#contentOffset

        **[protected] QPointF QPlainTextEdit::contentOffset() const**

        Returns the content's origin in viewport coordinates.

        The origin of the content of a plain text edit is always the top left
        corner of the first visible text block. The content offset is different
        from (0,0) when the text has been scrolled horizontally, or when the
        first visible block has been scrolled partially off the screen, i.e. the
        visible text does not start with the first line of the first visible
        block, or when the first visible block is the very first block and the
        editor displays a margin.

        **See also** **firstVisibleBlock** (), **horizontalScrollBar** (), and
        **verticalScrollBar** ().
        """
        ...

    def firstVisibleBlock(self) -> QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#firstVisibleBlock

        **[protected] QTextBlock QPlainTextEdit::firstVisibleBlock() const**

        Returns the first visible block.

        **See also** **blockBoundingRect** ().
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#scrollContentsBy

        **[override virtual protected] void QPlainTextEdit::scrollContentsBy(int
        dx , int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).
        """
        ...

    def insertFromMimeData(self, source: QtCore.QMimeData) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#insertFromMimeData

        **[virtual protected] void QPlainTextEdit::insertFromMimeData(const
        QMimeData * source )**

        This function inserts the contents of the MIME data object, specified by
        **source** , into the text edit at the current cursor position. It is
        called whenever text is inserted as the result of a clipboard paste
        operation, or when the text edit accepts data from a drag and drop
        operation.
        """
        ...

    def canInsertFromMimeData(self, source: QtCore.QMimeData) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#canInsertFromMimeData

        **[virtual protected] bool QPlainTextEdit::canInsertFromMimeData(const
        QMimeData * source ) const**

        This function returns `true` if the contents of the MIME data object,
        specified by **source** , can be decoded and inserted into the document.
        It is called for example when during a drag operation the mouse enters
        this widget and it is necessary to determine whether it is possible to
        accept the drag.
        """
        ...

    def createMimeDataFromSelection(self) -> QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#createMimeDataFromSelection

        **[virtual protected] QMimeData
        *QPlainTextEdit::createMimeDataFromSelection() const**

        This function returns a new MIME data object to represent the contents
        of the text edit's current selection. It is called when the selection
        needs to be encapsulated into a new **QMimeData**  object; for example,
        when a drag and drop operation is started, or when data is copied to the
        clipboard.

        If you reimplement this function, note that the ownership of the
        returned **QMimeData**  object is passed to the caller. The selection
        can be retrieved by using the **textCursor** () function.
        """
        ...

    @typing.overload
    def inputMethodQuery(self, property: QtCore.Qt.InputMethodQuery) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#inputMethodQuery

        **[override virtual] QVariant
        QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery property ) const**

        Reimplements: **QWidget::inputMethodQuery(Qt::InputMethodQuery query)
        const** .
        """
        ...

    @typing.overload
    def inputMethodQuery(
        self, query: QtCore.Qt.InputMethodQuery, argument: typing.Any
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#inputMethodQuery

        **[override virtual] QVariant
        QPlainTextEdit::inputMethodQuery(Qt::InputMethodQuery property ) const**

        Reimplements: **QWidget::inputMethodQuery(Qt::InputMethodQuery query)
        const** .
        """
        ...

    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#inputMethodEvent

        **[override virtual protected] void
        QPlainTextEdit::inputMethodEvent(QInputMethodEvent * e )**

        Reimplements: **QWidget::inputMethodEvent** (QInputMethodEvent *event).
        """
        ...

    def wheelEvent(self, e: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#wheelEvent

        **[override virtual protected] void
        QPlainTextEdit::wheelEvent(QWheelEvent * e )**

        Reimplements: **QAbstractScrollArea::wheelEvent** (QWheelEvent *e).
        """
        ...

    def changeEvent(self, e: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#changeEvent

        **[override virtual protected] void QPlainTextEdit::changeEvent(QEvent *
        e )**

        Reimplements: **QFrame::changeEvent** (QEvent *ev).
        """
        ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#showEvent

        **[override virtual protected] void QPlainTextEdit::showEvent(QShowEvent
        *)**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#focusOutEvent

        **[override virtual protected] void
        QPlainTextEdit::focusOutEvent(QFocusEvent * e )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusInEvent(self, e: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#focusInEvent

        **[override virtual protected] void
        QPlainTextEdit::focusInEvent(QFocusEvent * e )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def dropEvent(self, e: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#dropEvent

        **[override virtual protected] void QPlainTextEdit::dropEvent(QDropEvent
        * e )**

        Reimplements: **QAbstractScrollArea::dropEvent** (QDropEvent *event).
        """
        ...

    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#dragMoveEvent

        **[override virtual protected] void
        QPlainTextEdit::dragMoveEvent(QDragMoveEvent * e )**

        Reimplements: **QAbstractScrollArea::dragMoveEvent** (QDragMoveEvent
        *event).
        """
        ...

    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#dragLeaveEvent

        **[override virtual protected] void
        QPlainTextEdit::dragLeaveEvent(QDragLeaveEvent * e )**

        Reimplements: **QAbstractScrollArea::dragLeaveEvent** (QDragLeaveEvent
        *event).
        """
        ...

    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#dragEnterEvent

        **[override virtual protected] void
        QPlainTextEdit::dragEnterEvent(QDragEnterEvent * e )**

        Reimplements: **QAbstractScrollArea::dragEnterEvent** (QDragEnterEvent
        *event).
        """
        ...

    def contextMenuEvent(self, e: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#contextMenuEvent

        **[override virtual protected] void
        QPlainTextEdit::contextMenuEvent(QContextMenuEvent * event )**

        Reimplements: **QAbstractScrollArea::contextMenuEvent**
        (QContextMenuEvent *e).

        Shows the standard context menu created with
        **createStandardContextMenu** ().

        If you do not want the text edit to have a context menu, you can set its
        **contextMenuPolicy**  to **Qt::NoContextMenu** . If you want to
        customize the context menu, reimplement this function. If you want to
        extend the standard context menu, reimplement this function, call
        **createStandardContextMenu** () and extend the menu returned.

        Information about the event is passed in the **event** object.

        void MyQPlainTextEdit::contextMenuEvent(**QContextMenuEvent**  *event)
        {
                **QMenu**  *menu = createStandardContextMenu();
        menu->addAction(tr("My Menu Item"));
                //...
        menu->exec(event->globalPos());
                delete menu;
            }
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#focusNextPrevChild

        **[override virtual protected] bool
        QPlainTextEdit::focusNextPrevChild(bool next )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QPlainTextEdit::mouseDoubleClickEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mouseDoubleClickEvent**
        (QMouseEvent *e).
        """
        ...

    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#mouseReleaseEvent

        **[override virtual protected] void
        QPlainTextEdit::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mouseReleaseEvent** (QMouseEvent
        *e).
        """
        ...

    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#mouseMoveEvent

        **[override virtual protected] void
        QPlainTextEdit::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mouseMoveEvent** (QMouseEvent *e).
        """
        ...

    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#mousePressEvent

        **[override virtual protected] void
        QPlainTextEdit::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mousePressEvent** (QMouseEvent *e).
        """
        ...

    def paintEvent(self, e: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#paintEvent

        **[override virtual protected] void
        QPlainTextEdit::paintEvent(QPaintEvent * e )**

        Reimplements: **QAbstractScrollArea::paintEvent** (QPaintEvent *event).
        """
        ...

    def resizeEvent(self, e: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#resizeEvent

        **[override virtual protected] void
        QPlainTextEdit::resizeEvent(QResizeEvent * e )**

        Reimplements: **QAbstractScrollArea::resizeEvent** (QResizeEvent
        *event).
        """
        ...

    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#keyReleaseEvent

        **[override virtual protected] void
        QPlainTextEdit::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#keyPressEvent

        **[override virtual protected] void
        QPlainTextEdit::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QAbstractScrollArea::keyPressEvent** (QKeyEvent *e).
        """
        ...

    def timerEvent(self, e: QtCore.QTimerEvent) -> None:
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        ...

    def centerCursor(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#centerCursor

        **[slot] void QPlainTextEdit::centerCursor()**

        Scrolls the document in order to center the cursor vertically.

        **See also** **ensureCursorVisible** () and **centerOnScroll** .
        """
        ...

    def appendHtml(self, html: str) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#appendHtml

        **[slot] void QPlainTextEdit::appendHtml(const QString & html )**

        Appends a new paragraph with **html** to the end of the text edit.

        **appendPlainText** ()
        """
        ...

    def appendPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#appendPlainText

        **[slot] void QPlainTextEdit::appendPlainText(const QString & text )**

        Appends a new paragraph with **text** to the end of the text edit.

        **See also** **appendHtml** ().
        """
        ...

    def insertPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#insertPlainText

        **[slot] void QPlainTextEdit::insertPlainText(const QString & text )**

        Convenience slot that inserts **text** at the current cursor position.

        It is equivalent to

        edit->textCursor().insertText(text);
        """
        ...

    def selectAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#selectAll

        **[slot] void QPlainTextEdit::selectAll()**

        Selects all text.

        **See also** **copy** (), **cut** (), and **textCursor** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#clear

        **[slot] void QPlainTextEdit::clear()**

        Deletes all the text in the text edit.

        Notes:

        * The undo/redo history is also cleared.
          * **currentCharFormat** () is
        reset, unless **textCursor** () is already at the beginning of the
        document.

        **See also** **cut** () and **setPlainText** ().
        """
        ...

    def redo(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#redo

        **[slot] void QPlainTextEdit::redo()**

        Redoes the last operation.

        If there is no operation to redo, i.e. there is no redo step in the
        undo/redo history, nothing happens.

        **See also** **undo** ().
        """
        ...

    def undo(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#undo

        **[slot] void QPlainTextEdit::undo()**

        Undoes the last operation.

        If there is no operation to undo, i.e. there is no undo step in the
        undo/redo history, nothing happens.

        **See also** **redo** ().
        """
        ...

    def paste(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#paste

        **[slot] void QPlainTextEdit::paste()**

        Pastes the text from the clipboard into the text edit at the current
        cursor position.

        If there is no text in the clipboard nothing happens.

        To change the behavior of this function, i.e. to modify what
        **QPlainTextEdit**  can paste and how it is being pasted, reimplement
        the virtual **canInsertFromMimeData** () and **insertFromMimeData** ()
        functions.

        **See also** **cut** () and **copy** ().
        """
        ...

    def copy(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#copy

        **[slot] void QPlainTextEdit::copy()**

        Copies any selected text to the clipboard.

        **See also** **copyAvailable** ().
        """
        ...

    def cut(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#cut

        **[slot] void QPlainTextEdit::cut()**

        Copies the selected text to the clipboard and deletes it from the text
        edit.

        If there is no selected text nothing happens.

        **See also** **copy** () and **paste** ().
        """
        ...

    def setPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#setPlainText

        **[slot] void QPlainTextEdit::setPlainText(const QString & text )**

        Changes the text of the text edit to the string **text**. Any previous
        text is removed.

        **text** is interpreted as plain text.

        Notes:

        * The undo/redo history is also cleared.
          * **currentCharFormat** () is
        reset, unless **textCursor** () is already at the beginning of the
        document.

        **Note:** Setter function for property **plainText** .

        **See also** **toPlainText** ().
        """
        ...

    def blockCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#blockCount-prop

        **[read-only] blockCount : const int**

        This property holds the number of text blocks in the document.

        By default, in an empty document, this property contains a value of 1.

        **Access functions:**

        int **blockCount** () const
        """
        ...

    def print(self, printer: QtGui.QPagedPaintDevice) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#print

        **void QPlainTextEdit::print(QPagedPaintDevice * printer ) const**

        Convenience function to print the text edit's document to the given
        **printer**. This is equivalent to calling the print method on the
        document directly except that this function also supports
        QPrinter::Selection as print range.

        **See also** **QTextDocument::print** ().
        """
        ...

    def canPaste(self) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#canPaste

        **bool QPlainTextEdit::canPaste() const**

        Returns whether text can be pasted from the clipboard into the textedit.
        """
        ...

    def moveCursor(
        self,
        operation: QtGui.QTextCursor.MoveOperation,
        mode: QtGui.QTextCursor.MoveMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#moveCursor

        **void QPlainTextEdit::moveCursor(QTextCursor::MoveOperation operation ,
        QTextCursor::MoveMode mode = QTextCursor::MoveAnchor)**

        Moves the cursor by performing the given **operation**.

        If **mode** is **QTextCursor::KeepAnchor** , the cursor selects the text
        it moves over. This is the same effect that the user achieves when they
        hold down the Shift key and move the cursor with the cursor keys.

        **See also** **QTextCursor::movePosition** ().
        """
        ...

    def extraSelections(self) -> typing.List["QTextEdit.ExtraSelection"]:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#extraSelections

        **QList<QTextEdit::ExtraSelection> QPlainTextEdit::extraSelections()
        const**

        Returns previously set extra selections.

        **See also** **setExtraSelections** ().
        """
        ...

    def setExtraSelections(
        self, selections: typing.Iterable["QTextEdit.ExtraSelection"]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#setExtraSelections

        **void QPlainTextEdit::setExtraSelections(const
        QList<QTextEdit::ExtraSelection> & selections )**

        This function allows temporarily marking certain regions in the document
        with a given color, specified as **selections**. This can be useful for
        example in a programming editor to mark a whole line of text with a
        given background color to indicate the existence of a breakpoint.

        **See also** **QTextEdit::ExtraSelection**  and **extraSelections** ().
        """
        ...

    def setCursorWidth(self, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#cursorWidth-prop

        **cursorWidth : int**

        This property specifies the width of the cursor in pixels. The default
        value is 1.

        **Access functions:**

        int **cursorWidth** () const
        void **setCursorWidth** (int **width** )
        """
        ...

    def cursorWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#cursorWidth-prop

        **cursorWidth : int**

        This property specifies the width of the cursor in pixels. The default
        value is 1.

        **Access functions:**

        int **cursorWidth** () const
        void **setCursorWidth** (int **width** )
        """
        ...

    def setOverwriteMode(self, overwrite: bool) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#overwriteMode-prop

        **overwriteMode : bool**

        This property holds whether text entered by the user will overwrite
        existing text

        As with many text editors, the plain text editor widget can be
        configured to insert or overwrite existing text with new text entered by
        the user.

        If this property is `true`, existing text is overwritten, character-for-
        character by new text; otherwise, text is inserted at the cursor
        position, displacing existing text.

        By default, this property is `false` (new text does not overwrite
        existing text).

        **Access functions:**

        bool **overwriteMode** () const
        void **setOverwriteMode** (bool
        **overwrite** )
        """
        ...

    def overwriteMode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#overwriteMode-prop

        **overwriteMode : bool**

        This property holds whether text entered by the user will overwrite
        existing text

        As with many text editors, the plain text editor widget can be
        configured to insert or overwrite existing text with new text entered by
        the user.

        If this property is `true`, existing text is overwritten, character-for-
        character by new text; otherwise, text is inserted at the cursor
        position, displacing existing text.

        By default, this property is `false` (new text does not overwrite
        existing text).

        **Access functions:**

        bool **overwriteMode** () const
        void **setOverwriteMode** (bool
        **overwrite** )
        """
        ...

    @typing.overload
    def cursorRect(self, cursor: QtGui.QTextCursor) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#cursorRect

        **QRect QPlainTextEdit::cursorRect(const QTextCursor & cursor ) const**

        returns a rectangle (in viewport coordinates) that includes the
        **cursor**.
        """
        ...

    @typing.overload
    def cursorRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#cursorRect-1

        **QRect QPlainTextEdit::cursorRect() const**

        returns a rectangle (in viewport coordinates) that includes the cursor
        of the text edit.
        """
        ...

    def cursorForPosition(self, pos: QtCore.QPoint) -> QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#cursorForPosition

        **QTextCursor QPlainTextEdit::cursorForPosition(const QPoint & pos )
        const**

        returns a **QTextCursor**  at position **pos** (in viewport
        coordinates).
        """
        ...

    @typing.overload
    def createStandardContextMenu(self) -> QMenu:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#createStandardContextMenu

        **QMenu *QPlainTextEdit::createStandardContextMenu()**

        This function creates the standard context menu which is shown when the
        user clicks on the text edit with the right mouse button. It is called
        from the default **contextMenuEvent** () handler. The popup menu's
        ownership is transferred to the caller.

        We recommend that you use the createStandardContextMenu(**QPoint** )
        version instead which will enable the actions that are sensitive to
        where the user clicked.
        """
        ...

    @typing.overload
    def createStandardContextMenu(self, position: QtCore.QPoint) -> QMenu:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#createStandardContextMenu-1

        **[since 5.5] QMenu *QPlainTextEdit::createStandardContextMenu(const
        QPoint & position )**

        This function creates the standard context menu which is shown when the
        user clicks on the text edit with the right mouse button. It is called
        from the default **contextMenuEvent** () handler and it takes the
        **position** in document coordinates where the mouse click was. This can
        enable actions that are sensitive to the position where the user
        clicked. The popup menu's ownership is transferred to the caller.

        This function was introduced in Qt 5.5.
        """
        ...

    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#loadResource

        **[virtual] QVariant QPlainTextEdit::loadResource(int type , const QUrl
        & name )**

        Loads the resource specified by the given **type** and **name**.

        This function is an extension of **QTextDocument::loadResource** ().

        **See also** **QTextDocument::loadResource** ().
        """
        ...

    def ensureCursorVisible(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#ensureCursorVisible

        **void QPlainTextEdit::ensureCursorVisible()**

        Ensures that the cursor is visible by scrolling the text edit if
        necessary.

        **See also** **centerCursor** () and **centerOnScroll** .
        """
        ...

    def toPlainText(self) -> str:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#toPlainText

        **QString QPlainTextEdit::toPlainText() const**

        Returns the text of the text edit as plain text.

        **Note:** Getter function for property **plainText** .

        **See also** **QPlainTextEdit::setPlainText** ().
        """
        ...

    @typing.overload
    def find(self, exp: str, options: QtGui.QTextDocument.FindFlag = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#find

        **bool QPlainTextEdit::find(const QString & exp ,
        QTextDocument::FindFlags options = QTextDocument::FindFlags())**

        Finds the next occurrence of the string, **exp** , using the given
        **options**. Returns `true` if **exp** was found and changes the cursor
        to select the match; otherwise returns `false`.
        """
        ...

    @typing.overload
    def find(
        self,
        exp: QtCore.QRegularExpression,
        options: QtGui.QTextDocument.FindFlag = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#find-1

        **[since 5.13] bool QPlainTextEdit::find(const QRegularExpression & exp
        , QTextDocument::FindFlags options = QTextDocument::FindFlags())**

        This is an overloaded function.

        Finds the next occurrence, matching the regular expression, **exp** ,
        using the given **options**. The **QTextDocument::FindCaseSensitively**
        option is ignored for this overload, use
        **QRegularExpression::CaseInsensitiveOption**  instead.

        Returns `true` if a match was found and changes the cursor to select the
        match; otherwise returns `false`.

        This function was introduced in Qt 5.13.
        """
        ...

    def centerOnScroll(self) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#centerOnScroll-prop

        **centerOnScroll : bool**

        This property holds whether the cursor should be centered on screen

        If set to true, the plain text edit scrolls the document vertically to
        make the cursor visible at the center of the viewport. This also allows
        the text edit to scroll below the end of the document. Otherwise, if set
        to false, the plain text edit scrolls the smallest amount possible to
        ensure the cursor is visible. The same algorithm is applied to any new
        line appended through **appendPlainText** ().

        The default is false.

        **Access functions:**

        bool **centerOnScroll** () const
        void **setCenterOnScroll** (bool
        **enabled** )

        **See also** **centerCursor** () and **ensureCursorVisible** ().
        """
        ...

    def setCenterOnScroll(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#centerOnScroll-prop

        **centerOnScroll : bool**

        This property holds whether the cursor should be centered on screen

        If set to true, the plain text edit scrolls the document vertically to
        make the cursor visible at the center of the viewport. This also allows
        the text edit to scroll below the end of the document. Otherwise, if set
        to false, the plain text edit scrolls the smallest amount possible to
        ensure the cursor is visible. The same algorithm is applied to any new
        line appended through **appendPlainText** ().

        The default is false.

        **Access functions:**

        bool **centerOnScroll** () const
        void **setCenterOnScroll** (bool
        **enabled** )

        **See also** **centerCursor** () and **ensureCursorVisible** ().
        """
        ...

    def backgroundVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#backgroundVisible-prop

        **backgroundVisible : bool**

        This property holds whether the palette background is visible outside
        the document area

        If set to true, the plain text edit paints the palette background on the
        viewport area not covered by the text document. Otherwise, if set to
        false, it won't. The feature makes it possible for the user to visually
        distinguish between the area of the document, painted with the base
        color of the palette, and the empty area not covered by any document.

        The default is false.

        **Access functions:**

        bool **backgroundVisible** () const
        void **setBackgroundVisible**
        (bool **visible** )
        """
        ...

    def setBackgroundVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#backgroundVisible-prop

        **backgroundVisible : bool**

        This property holds whether the palette background is visible outside
        the document area

        If set to true, the plain text edit paints the palette background on the
        viewport area not covered by the text document. Otherwise, if set to
        false, it won't. The feature makes it possible for the user to visually
        distinguish between the area of the document, painted with the base
        color of the palette, and the empty area not covered by any document.

        The default is false.

        **Access functions:**

        bool **backgroundVisible** () const
        void **setBackgroundVisible**
        (bool **visible** )
        """
        ...

    def setWordWrapMode(self, policy: QtGui.QTextOption.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#wordWrapMode-prop

        **wordWrapMode : QTextOption::WrapMode**

        This property holds the mode **QPlainTextEdit**  will use when wrapping
        text by words

        By default, this property is set to
        **QTextOption::WrapAtWordBoundaryOrAnywhere** .

        **Access functions:**

        QTextOption::WrapMode **wordWrapMode** () const
        void
        **setWordWrapMode** (QTextOption::WrapMode **policy** )

        **See also** **QTextOption::WrapMode** .

        **Member Function Documentation**
        """
        ...

    def wordWrapMode(self) -> QtGui.QTextOption.WrapMode:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#wordWrapMode-prop

        **wordWrapMode : QTextOption::WrapMode**

        This property holds the mode **QPlainTextEdit**  will use when wrapping
        text by words

        By default, this property is set to
        **QTextOption::WrapAtWordBoundaryOrAnywhere** .

        **Access functions:**

        QTextOption::WrapMode **wordWrapMode** () const
        void
        **setWordWrapMode** (QTextOption::WrapMode **policy** )

        **See also** **QTextOption::WrapMode** .

        **Member Function Documentation**
        """
        ...

    def setLineWrapMode(self, mode: "QPlainTextEdit.LineWrapMode") -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#lineWrapMode-prop

        **lineWrapMode : LineWrapMode**

        This property holds the line wrap mode

        The default mode is **WidgetWidth**  which causes words to be wrapped at
        the right edge of the text edit. Wrapping occurs at whitespace, keeping
        whole words intact. If you want wrapping to occur within words use
        **setWordWrapMode** ().

        **Access functions:**

        QPlainTextEdit::LineWrapMode **lineWrapMode** () const
        void
        **setLineWrapMode** (QPlainTextEdit::LineWrapMode **mode** )
        """
        ...

    def lineWrapMode(self) -> "QPlainTextEdit.LineWrapMode":
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#lineWrapMode-prop

        **lineWrapMode : LineWrapMode**

        This property holds the line wrap mode

        The default mode is **WidgetWidth**  which causes words to be wrapped at
        the right edge of the text edit. Wrapping occurs at whitespace, keeping
        whole words intact. If you want wrapping to occur within words use
        **setWordWrapMode** ().

        **Access functions:**

        QPlainTextEdit::LineWrapMode **lineWrapMode** () const
        void
        **setLineWrapMode** (QPlainTextEdit::LineWrapMode **mode** )
        """
        ...

    def maximumBlockCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#maximumBlockCount-prop

        **maximumBlockCount : int**

        This property holds the limit for blocks in the document.

        Specifies the maximum number of blocks the document may have. If there
        are more blocks in the document that specified with this property blocks
        are removed from the beginning of the document.

        A negative or zero value specifies that the document may contain an
        unlimited amount of blocks.

        The default value is 0.

        Note that setting this property will apply the limit immediately to the
        document contents. Setting this property also disables the undo redo
        history.

        **Access functions:**

        int **maximumBlockCount** () const
        void **setMaximumBlockCount** (int
        **maximum** )
        """
        ...

    def setMaximumBlockCount(self, maximum: int) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#maximumBlockCount-prop

        **maximumBlockCount : int**

        This property holds the limit for blocks in the document.

        Specifies the maximum number of blocks the document may have. If there
        are more blocks in the document that specified with this property blocks
        are removed from the beginning of the document.

        A negative or zero value specifies that the document may contain an
        unlimited amount of blocks.

        The default value is 0.

        Note that setting this property will apply the limit immediately to the
        document contents. Setting this property also disables the undo redo
        history.

        **Access functions:**

        int **maximumBlockCount** () const
        void **setMaximumBlockCount** (int
        **maximum** )
        """
        ...

    def setUndoRedoEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#undoRedoEnabled-prop

        **undoRedoEnabled : bool**

        This property holds whether undo and redo are enabled

        Users are only able to undo or redo actions if this property is true,
        and if there is an action that can be undone (or redone).

        By default, this property is `true`.

        **Access functions:**

        bool **isUndoRedoEnabled** () const
        void **setUndoRedoEnabled** (bool
        **enable** )
        """
        ...

    def isUndoRedoEnabled(self) -> bool:
        ...

    def documentTitle(self) -> str:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#documentTitle-prop

        **documentTitle : QString**

        This property holds the title of the document parsed from the text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **documentTitle** () const
        void **setDocumentTitle** (const
        QString & **title** )
        """
        ...

    def setDocumentTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#documentTitle-prop

        **documentTitle : QString**

        This property holds the title of the document parsed from the text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **documentTitle** () const
        void **setDocumentTitle** (const
        QString & **title** )
        """
        ...

    def setTabChangesFocus(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#tabChangesFocus-prop

        **tabChangesFocus : bool**

        This property holds whether **Tab** changes focus or is accepted as
        input

        In some occasions text edits should not allow the user to input
        tabulators or change indentation using the **Tab** key, as this breaks
        the focus chain. The default is false.

        **Access functions:**

        bool **tabChangesFocus** () const
        void **setTabChangesFocus** (bool
        **b** )
        """
        ...

    def tabChangesFocus(self) -> bool:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#tabChangesFocus-prop

        **tabChangesFocus : bool**

        This property holds whether **Tab** changes focus or is accepted as
        input

        In some occasions text edits should not allow the user to input
        tabulators or change indentation using the **Tab** key, as this breaks
        the focus chain. The default is false.

        **Access functions:**

        bool **tabChangesFocus** () const
        void **setTabChangesFocus** (bool
        **b** )
        """
        ...

    def currentCharFormat(self) -> QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#currentCharFormat

        **QTextCharFormat QPlainTextEdit::currentCharFormat() const**

        Returns the char format that is used when inserting new text.

        **See also** **setCurrentCharFormat** ().
        """
        ...

    def setCurrentCharFormat(self, format: QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#setCurrentCharFormat

        **void QPlainTextEdit::setCurrentCharFormat(const QTextCharFormat &
        format )**

        Sets the char format that is be used when inserting new text to
        **format** by calling **QTextCursor::setCharFormat** () on the editor's
        cursor. If the editor has a selection then the char format is directly
        applied to the selection.

        **See also** **currentCharFormat** ().
        """
        ...

    def mergeCurrentCharFormat(self, modifier: QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#mergeCurrentCharFormat

        **void QPlainTextEdit::mergeCurrentCharFormat(const QTextCharFormat &
        modifier )**

        Merges the properties specified in **modifier** into the current
        character format by calling **QTextCursor::mergeCharFormat**  on the
        editor's cursor. If the editor has a selection then the properties of
        **modifier** are directly applied to the selection.

        **See also** **QTextCursor::mergeCharFormat** ().
        """
        ...

    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlag:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#textInteractionFlags-prop

        **textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the label should interact with user input if it displays
        text.

        If the flags contain either **Qt::LinksAccessibleByKeyboard**  or
        **Qt::TextSelectableByKeyboard**  then the focus policy is also
        automatically set to **Qt::ClickFocus** .

        The default value depends on whether the **QPlainTextEdit**  is read-
        only or editable.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )
        """
        ...

    def setTextInteractionFlags(self, flags: QtCore.Qt.TextInteractionFlag) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#textInteractionFlags-prop

        **textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the label should interact with user input if it displays
        text.

        If the flags contain either **Qt::LinksAccessibleByKeyboard**  or
        **Qt::TextSelectableByKeyboard**  then the focus policy is also
        automatically set to **Qt::ClickFocus** .

        The default value depends on whether the **QPlainTextEdit**  is read-
        only or editable.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )
        """
        ...

    def setReadOnly(self, ro: bool) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#readOnly-prop

        **readOnly : bool**

        This property holds whether the text edit is read-only

        In a read-only text edit the user can only navigate through the text and
        select text; modifying the text is not possible.

        This property's default is false.

        **Access functions:**

        bool **isReadOnly** () const
        void **setReadOnly** (bool **ro** )
        """
        ...

    def isReadOnly(self) -> bool:
        ...

    def textCursor(self) -> QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#textCursor

        **QTextCursor QPlainTextEdit::textCursor() const**

        Returns a copy of the **QTextCursor**  that represents the currently
        visible cursor. Note that changes on the returned cursor do not affect
        **QPlainTextEdit** 's cursor; use **setTextCursor** () to update the
        visible cursor.

        **See also** **setTextCursor** ().
        """
        ...

    def setTextCursor(self, cursor: QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#setTextCursor

        **void QPlainTextEdit::setTextCursor(const QTextCursor & cursor )**

        Sets the visible **cursor**.

        **See also** **textCursor** ().
        """
        ...

    def document(self) -> QtGui.QTextDocument:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#document

        **QTextDocument *QPlainTextEdit::document() const**

        Returns a pointer to the underlying document.

        **See also** **setDocument** ().
        """
        ...

    def setDocument(self, document: QtGui.QTextDocument) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#setDocument

        **void QPlainTextEdit::setDocument(QTextDocument * document )**

        Makes **document** the new document of the text editor.

        The parent **QObject**  of the provided document remains the owner of
        the object. If the current document is a child of the text editor, then
        it is deleted.

        The document must have a document layout that inherits
        **QPlainTextDocumentLayout**  (see **QTextDocument::setDocumentLayout**
        ()).

        **See also** **document** ().
        """
        ...

    @property
    def blockCountChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#blockCountChanged

        **[signal] void QPlainTextEdit::blockCountChanged(int newBlockCount )**

        This signal is emitted whenever the block count changes. The new block
        count is passed in **newBlockCount**.
        """
        ...

    @property
    def copyAvailable(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#copyAvailable

        **[signal] void QPlainTextEdit::copyAvailable(bool yes )**

        This signal is emitted when text is selected or de-selected in the text
        edit.

        When text is selected this signal will be emitted with **yes** set to
        true. If no text has been selected or if the selected text is de-
        selected this signal is emitted with **yes** set to false.

        If **yes** is true then **copy** () can be used to copy the selection to
        the clipboard. If **yes** is false then **copy** () does nothing.

        **See also** **selectionChanged** ().
        """
        ...

    @property
    def cursorPositionChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#cursorPositionChanged

        **[signal] void QPlainTextEdit::cursorPositionChanged()**

        This signal is emitted whenever the position of the cursor changed.
        """
        ...

    @property
    def modificationChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#modificationChanged

        **[signal] void QPlainTextEdit::modificationChanged(bool changed )**

        This signal is emitted whenever the content of the document changes in a
        way that affects the modification state. If **changed** is true, the
        document has been modified; otherwise it is false.

        For example, calling setModified(false) on a document and then inserting
        text causes the signal to get emitted. If you undo that operation,
        causing the document to return to its original unmodified state, the
        signal will get emitted again.
        """
        ...

    @property
    def redoAvailable(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#redoAvailable

        **[signal] void QPlainTextEdit::redoAvailable(bool available )**

        This signal is emitted whenever redo operations become available (
        **available** is true) or unavailable ( **available** is false).
        """
        ...

    @property
    def selectionChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#selectionChanged

        **[signal] void QPlainTextEdit::selectionChanged()**

        This signal is emitted whenever the selection changes.

        **See also** **copyAvailable** ().
        """
        ...

    @property
    def textChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#textChanged

        **[signal] void QPlainTextEdit::textChanged()**

        This signal is emitted whenever the document's content changes; for
        example, when text is inserted or deleted, or when formatting is
        applied.

        **Note:** Notifier signal for property **plainText** .
        """
        ...

    @property
    def undoAvailable(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#undoAvailable

        **[signal] void QPlainTextEdit::undoAvailable(bool available )**

        This signal is emitted whenever undo operations become available (
        **available** is true) or unavailable ( **available** is false).
        """
        ...

    @property
    def updateRequest(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qplaintextedit.html#updateRequest

        **[signal] void QPlainTextEdit::updateRequest(const QRect & rect , int
        dy )**

        This signal is emitted when the text document needs an update of the
        specified **rect**. If the text is scrolled, **rect** will cover the
        entire viewport area. If the text is scrolled vertically, **dy** carries
        the amount of pixels the viewport was scrolled.

        The purpose of the signal is to support extra widgets in plain text edit
        subclasses that e.g. show line numbers, breakpoints, or other extra
        information.
        """
        ...
