"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtWidgets import *
import enum


class QScrollerProperties(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qscrollerproperties.html

    **Detailed Description**

    The QScrollerProperties class stores the parameters used by **QScroller** .

    The default settings are platform dependent so that Qt emulates the platform
    behaviour for kinetic scrolling.

    As a convention the QScrollerProperties are in physical units (meter,
    seconds) and are converted by **QScroller**  using the current DPI.

    **See also** **QScroller** .
    """

    class ScrollMetric(enum.Enum):
        MousePressEventDelay: QScrollerProperties = ...
        DragStartDistance: QScrollerProperties = ...
        DragVelocitySmoothingFactor: QScrollerProperties = ...
        AxisLockThreshold: QScrollerProperties = ...
        ScrollingCurve: QScrollerProperties = ...
        DecelerationFactor: QScrollerProperties = ...
        MinimumVelocity: QScrollerProperties = ...
        MaximumVelocity: QScrollerProperties = ...
        MaximumClickThroughVelocity: QScrollerProperties = ...
        AcceleratingFlickMaximumTime: QScrollerProperties = ...
        AcceleratingFlickSpeedupFactor: QScrollerProperties = ...
        SnapPositionRatio: QScrollerProperties = ...
        SnapTime: QScrollerProperties = ...
        OvershootDragResistanceFactor: QScrollerProperties = ...
        OvershootDragDistanceFactor: QScrollerProperties = ...
        OvershootScrollDistanceFactor: QScrollerProperties = ...
        OvershootScrollTime: QScrollerProperties = ...
        HorizontalOvershootPolicy: QScrollerProperties = ...
        VerticalOvershootPolicy: QScrollerProperties = ...
        FrameRate: QScrollerProperties = ...
        ScrollMetricCount: QScrollerProperties = ...

    class FrameRates(enum.Enum):
        Standard: QScrollerProperties = ...
        Fps60: QScrollerProperties = ...
        Fps30: QScrollerProperties = ...
        Fps20: QScrollerProperties = ...

    class OvershootPolicy(enum.Enum):
        OvershootWhenScrollable: QScrollerProperties = ...
        OvershootAlwaysOff: QScrollerProperties = ...
        OvershootAlwaysOn: QScrollerProperties = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#QScrollerProperties

        **QScrollerProperties::QScrollerProperties()**

        Constructs new scroller properties.
        """
        ...

    @typing.overload
    def __init__(self, sp: "QScrollerProperties") -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#QScrollerProperties-1

        **QScrollerProperties::QScrollerProperties(const QScrollerProperties &
        sp )**

        Constructs a copy of **sp**.
        """
        ...

    def setScrollMetric(
        self, metric: "QScrollerProperties.ScrollMetric", value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#setScrollMetric

        **void
        QScrollerProperties::setScrollMetric(QScrollerProperties::ScrollMetric
        metric , const QVariant & value )**

        Set a specific value of the **metric** ScrollerMetric to **value**.

        **See also** **scrollMetric** () and **ScrollMetric** .
        """
        ...

    def scrollMetric(self, metric: "QScrollerProperties.ScrollMetric") -> typing.Any:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#scrollMetric

        **QVariant
        QScrollerProperties::scrollMetric(QScrollerProperties::ScrollMetric
        metric ) const**

        Query the **metric** value of the scroller properties.

        **See also** **setScrollMetric** () and **ScrollMetric** .
        """
        ...

    @staticmethod
    def unsetDefaultScrollerProperties() -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#unsetDefaultScrollerProp
        erties

        **[static] void QScrollerProperties::unsetDefaultScrollerProperties()**

        Sets the scroller properties returned by the default constructor back to
        the platform default properties.

        **See also** **setDefaultScrollerProperties** ().
        """
        ...

    @staticmethod
    def setDefaultScrollerProperties(sp: "QScrollerProperties") -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#setDefaultScrollerProper
        ties

        **[static] void QScrollerProperties::setDefaultScrollerProperties(const
        QScrollerProperties & sp )**

        Sets the scroller properties for all new **QScrollerProperties**
        objects to **sp**.

        Use this function to override the platform default properties returned
        by the default constructor. If you only want to change the scroller
        properties of a single scroller, use
        **QScroller::setScrollerProperties** ()

        **Note:** Calling this function will not change the content of already
        existing **QScrollerProperties**  objects.

        **See also** **unsetDefaultScrollerProperties** ().
        """
        ...
