"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QStackedWidget(QFrame):
    """
    https://doc.qt.io/qt-6/qstackedwidget.html

    **Detailed Description**

    QStackedWidget can be used to create a user interface similar to the one
    provided by **QTabWidget** . It is a convenience layout widget built on top
    of the **QStackedLayout**  class.

    Like **QStackedLayout** , QStackedWidget can be constructed and populated
    with a number of child widgets ("pages"):

    **QWidget**  *firstPageWidget = new **QWidget** ;
            **QWidget**
    *secondPageWidget = new **QWidget** ;
            **QWidget**  *thirdPageWidget
    = new **QWidget** ;

            **QStackedWidget**  *stackedWidget = new
    **QStackedWidget** ;
            stackedWidget->addWidget(firstPageWidget);
    stackedWidget->addWidget(secondPageWidget);
    stackedWidget->addWidget(thirdPageWidget);

            **QVBoxLayout**
    *layout = new **QVBoxLayout** ;
            layout->addWidget(stackedWidget);
    setLayout(layout);

    QStackedWidget provides no intrinsic means for the user to switch page. This
    is typically done through a **QComboBox**  or a **QListWidget**  that stores
    the titles of the QStackedWidget's pages. For example:

    **QComboBox**  *pageComboBox = new **QComboBox** ;
    pageComboBox->addItem(tr("Page 1"));
            pageComboBox->addItem(tr("Page
    2"));
            pageComboBox->addItem(tr("Page 3"));
    connect(pageComboBox, &**QComboBox** ::activated,
    stackedWidget, &**QStackedWidget** ::setCurrentIndex);

    When populating a stacked widget, the widgets are added to an internal list.
    The **indexOf** () function returns the index of a widget in that list. The
    widgets can either be added to the end of the list using the **addWidget**
    () function, or inserted at a given index using the **insertWidget** ()
    function. The **removeWidget** () function removes a widget from the stacked
    widget. The number of widgets contained in the stacked widget can be
    obtained using the **count** () function.

    The **widget** () function returns the widget at a given index position. The
    index of the widget that is shown on screen is given by **currentIndex** ()
    and can be changed using **setCurrentIndex** (). In a similar manner, the
    currently shown widget can be retrieved using the **currentWidget** ()
    function, and altered using the **setCurrentWidget** () function.

    Whenever the current widget in the stacked widget changes or a widget is
    removed from the stacked widget, the **currentChanged** () and
    **widgetRemoved** () signals are emitted respectively.

    **See also** **QStackedLayout**  and **QTabWidget** .
    """

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#QStackedWidget

        **QStackedWidget::QStackedWidget(QWidget * parent = nullptr)**

        Constructs a QStackedWidget with the given **parent**.

        **See also** **addWidget** () and **insertWidget** ().
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#event

        **[override virtual protected] bool QStackedWidget::event(QEvent * e )**

        Reimplements: **QFrame::event** (QEvent *e).
        """
        ...

    def setCurrentWidget(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#setCurrentWidget

        **[slot] void QStackedWidget::setCurrentWidget(QWidget * widget )**

        Sets the current widget to be the specified **widget**. The new current
        widget must already be contained in this stacked widget.

        **See also** **currentWidget** () and **setCurrentIndex** ().
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index position of the widget that is visible

        The current index is -1 if there is no current widget.

        By default, this property contains a value of -1 because the stack is
        initially empty.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )

        **See also** **currentWidget** () and **indexOf** ().

        **Member Function Documentation**
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#count-prop

        **[read-only] count : const int**

        This property holds the number of widgets contained by this stacked
        widget

        By default, this property contains a value of 0.

        **Access functions:**

        int **count** () const

        **See also** **currentIndex** () and **widget** ().
        """
        ...

    def widget(self, a0: int) -> QWidget:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#widget

        **QWidget *QStackedWidget::widget(int index ) const**

        Returns the widget at the given **index** , or `nullptr` if there is no
        such widget.

        **See also** **currentWidget** () and **indexOf** ().
        """
        ...

    def indexOf(self, a0: QWidget) -> int:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#indexOf

        **int QStackedWidget::indexOf(const QWidget * widget ) const**

        Returns the index of the given **widget** , or -1 if the given
        **widget** is not a child of the **QStackedWidget** .

        **See also** **currentIndex** () and **widget** ().
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index position of the widget that is visible

        The current index is -1 if there is no current widget.

        By default, this property contains a value of -1 because the stack is
        initially empty.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )

        **See also** **currentWidget** () and **indexOf** ().

        **Member Function Documentation**
        """
        ...

    def currentWidget(self) -> QWidget:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#currentWidget

        **QWidget *QStackedWidget::currentWidget() const**

        Returns the current widget, or `nullptr` if there are no child widgets.

        **See also** **currentIndex** () and **setCurrentWidget** ().
        """
        ...

    def removeWidget(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#removeWidget

        **void QStackedWidget::removeWidget(QWidget * widget )**

        Removes **widget** from the **QStackedWidget** . i.e., **widget** is
        **not** deleted but simply removed from the stacked layout, causing it
        to be hidden.

        **Note:** Parent object and parent widget of **widget** will remain the
        **QStackedWidget** . If the application wants to reuse the removed
        **widget** , then it is recommended to re-parent it.

        **See also** **addWidget** (), **insertWidget** (), and
        **currentWidget** ().
        """
        ...

    def insertWidget(self, index: int, w: QWidget) -> int:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#insertWidget

        **int QStackedWidget::insertWidget(int index , QWidget * widget )**

        Inserts the given **widget** at the given **index** in the
        **QStackedWidget** . Ownership of **widget** is passed on to the
        **QStackedWidget** . If **index** is out of range, the **widget** is
        appended (in which case it is the actual index of the **widget** that is
        returned).

        If the **QStackedWidget**  was empty before this function is called, the
        given **widget** becomes the current widget.

        Inserting a new widget at an index less than or equal to the current
        index will increment the current index, but keep the current widget.

        **See also** **addWidget** (), **removeWidget** (), and
        **setCurrentWidget** ().
        """
        ...

    def addWidget(self, w: QWidget) -> int:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#addWidget

        **int QStackedWidget::addWidget(QWidget * widget )**

        Appends the given **widget** to the **QStackedWidget**  and returns the
        index position. Ownership of **widget** is passed on to the
        **QStackedWidget** .

        If the **QStackedWidget**  is empty before this function is called,
        **widget** becomes the current widget.

        **See also** **insertWidget** (), **removeWidget** (), and
        **setCurrentWidget** ().
        """
        ...

    @property
    def currentChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#currentChanged

        **[signal] void QStackedWidget::currentChanged(int index )**

        This signal is emitted whenever the current widget changes.

        The parameter holds the **index** of the new current widget, or -1 if
        there isn't a new one (for example, if there are no widgets in the
        **QStackedWidget** ).

        **Note:** Notifier signal for property **currentIndex** .

        **See also** **currentWidget** () and **setCurrentWidget** ().
        """
        ...

    @property
    def widgetRemoved(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qstackedwidget.html#widgetRemoved

        **[signal] void QStackedWidget::widgetRemoved(int index )**

        This signal is emitted whenever a widget is removed. The widget's
        **index** is passed as parameter.

        **See also** **removeWidget** ().
        """
        ...
