"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QStyleOptionMenuItem(QStyleOption):
    """
    https://doc.qt.io/qt-6/qstyleoptionmenuitem.html

    **Detailed Description**

    QStyleOptionMenuItem contains all the information that **QStyle**  functions
    need to draw the menu items from **QMenu** . It is also used for drawing
    other menu-related widgets.

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    makes the structures straightforward to use and emphasizes that these are
    simply parameters used by the style functions.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyleOption** .
    """

    class CheckType(enum.Enum):
        NotCheckable: QStyleOptionMenuItem = ...
        Exclusive: QStyleOptionMenuItem = ...
        NonExclusive: QStyleOptionMenuItem = ...

    class MenuItemType(enum.Enum):
        Normal: QStyleOptionMenuItem = ...
        DefaultItem: QStyleOptionMenuItem = ...
        Separator: QStyleOptionMenuItem = ...
        SubMenu: QStyleOptionMenuItem = ...
        Scroller: QStyleOptionMenuItem = ...
        TearOff: QStyleOptionMenuItem = ...
        Margin: QStyleOptionMenuItem = ...
        EmptyArea: QStyleOptionMenuItem = ...

    class StyleOptionVersion(enum.Enum):
        Version: QStyleOptionMenuItem = ...

    class StyleOptionType(enum.Enum):
        Type: QStyleOptionMenuItem = ...

    checkType = ...
    checked: bool = ...
    font: QtGui = ...
    icon: QtGui = ...
    maxIconWidth: int = ...
    menuHasCheckableItems: bool = ...
    menuItemType = ...
    menuRect: QtCore = ...
    reservedShortcutWidth: int = ...
    text: str = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionmenuitem.html#QStyleOptionMenuItem

        **QStyleOptionMenuItem::QStyleOptionMenuItem()**

        Constructs a QStyleOptionMenuItem, initializing the members variables to
        their default values.
        """
        ...

    @typing.overload
    def __init__(self, other: "QStyleOptionMenuItem") -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionmenuitem.html#QStyleOptionMenuItem-1

        **QStyleOptionMenuItem::QStyleOptionMenuItem(const QStyleOptionMenuItem
        & other )**

        Constructs a copy of the **other** style option.
        """
        ...
