"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QStylePainter(QtGui.QPainter):
    """
    https://doc.qt.io/qt-6/qstylepainter.html

    **Detailed Description**

    QStylePainter extends **QPainter**  with a set of high-level `draw...()`
    functions implemented on top of **QStyle** 's API. The advantage of using
    QStylePainter is that the parameter lists get considerably shorter. Whereas
    a **QStyle**  object must be able to draw on any widget using any painter
    (because the application normally has one **QStyle**  object shared by all
    widget), a QStylePainter is initialized with a widget, eliminating the need
    to specify the **QWidget** , the **QPainter** , and the **QStyle**  for
    every function call.

    Example using **QStyle**  directly:

    void MyWidget::paintEvent(**QPaintEvent**  * /* event */)
        {
    **QPainter**  painter(this);

            **QStyleOptionFocusRect**  option;
    option.initFrom(this);
            option.backgroundColor =
    palette().color(**QPalette** ::Background);
    style()->drawPrimitive(**QStyle** ::PE_FrameFocusRect, &option, &painter,
    this);
        }

    Example using QStylePainter:

    void MyWidget::paintEvent(**QPaintEvent**  * /* event */)
        {
    **QStylePainter**  painter(this);

            **QStyleOptionFocusRect**
    option;
            option.initFrom(this);
            option.backgroundColor =
    palette().color(**QPalette** ::Background);
    painter.drawPrimitive(**QStyle** ::PE_FrameFocusRect, option);
        }

    **See also** **QStyle**  and **QStyleOption** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#QStylePainter

        **QStylePainter::QStylePainter()**

        Constructs a QStylePainter.
        """
        ...

    @typing.overload
    def __init__(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#QStylePainter-1

        **QStylePainter::QStylePainter(QWidget * widget )**

        Construct a QStylePainter using widget **widget** for its paint device.
        """
        ...

    @typing.overload
    def __init__(self, pd: QtGui.QPaintDevice, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#QStylePainter-2

        **QStylePainter::QStylePainter(QPaintDevice * pd , QWidget * widget )**

        Construct a QStylePainter using **pd** for its paint device, and
        attributes from **widget**.
        """
        ...

    def drawItemPixmap(
        self, r: QtCore.QRect, flags: int, pixmap: QtGui.QPixmap
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#drawItemPixmap

        **void QStylePainter::drawItemPixmap(const QRect & rect , int flags ,
        const QPixmap & pixmap )**

        Draws the **pixmap** in rectangle **rect**. The pixmap is aligned
        according to **flags**.

        **See also** **QStyle::drawItemPixmap** () and **Qt::Alignment** .
        """
        ...

    def drawItemText(
        self,
        rect: QtCore.QRect,
        flags: int,
        pal: QtGui.QPalette,
        enabled: bool,
        text: str,
        textRole: QtGui.QPalette.ColorRole = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#drawItemText

        **void QStylePainter::drawItemText(const QRect & rect , int flags ,
        const QPalette & pal , bool enabled , const QString & text ,
        QPalette::ColorRole textRole = QPalette::NoRole)**

        Draws the **text** in rectangle **rect** and palette **pal**. The text
        is aligned and wrapped according to **flags**.

        The pen color is specified with **textRole**. The **enabled** bool
        indicates whether or not the item is enabled; when reimplementing this
        bool should influence how the item is drawn.

        **See also** **QStyle::drawItemText** () and **Qt::Alignment** .
        """
        ...

    def drawComplexControl(
        self, cc: QStyle.ComplexControl, opt: QStyleOptionComplex
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#drawComplexControl

        **void QStylePainter::drawComplexControl(QStyle::ComplexControl cc ,
        const QStyleOptionComplex & option )**

        Use the widget's style to draw a complex control **cc** specified by the
        **QStyleOptionComplex**  **option**.

        **See also** **QStyle::drawComplexControl** ().
        """
        ...

    def drawControl(self, ce: QStyle.ControlElement, opt: QStyleOption) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#drawControl

        **void QStylePainter::drawControl(QStyle::ControlElement ce , const
        QStyleOption & option )**

        Use the widget's style to draw a control element **ce** specified by
        **QStyleOption**  **option**.

        **See also** **QStyle::drawControl** ().
        """
        ...

    def drawPrimitive(self, pe: QStyle.PrimitiveElement, opt: QStyleOption) -> None:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#drawPrimitive

        **void QStylePainter::drawPrimitive(QStyle::PrimitiveElement pe , const
        QStyleOption & option )**

        Use the widget's style to draw a primitive element **pe** specified by
        **QStyleOption**  **option**.

        **See also** **QStyle::drawPrimitive** ().
        """
        ...

    def style(self) -> QStyle:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#style

        **QStyle *QStylePainter::style() const**

        Return the current style used by the **QStylePainter** .
        """
        ...

    @typing.overload
    def begin(self, w: QWidget) -> bool:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#begin

        **bool QStylePainter::begin(QWidget * widget )**

        Begin painting operations on the specified **widget**. Returns `true` if
        the painter is ready to use; otherwise returns `false`.

        This is automatically called by the constructor that takes a **QWidget**
        .
        """
        ...

    @typing.overload
    def begin(self, pd: QtGui.QPaintDevice, w: QWidget) -> bool:
        """
        https://doc.qt.io/qt-6/qstylepainter.html#begin-1

        **bool QStylePainter::begin(QPaintDevice * pd , QWidget * widget )**

        This is an overloaded function.

        Begin painting operations on paint device **pd** as if it was
        **widget**.

        This is automatically called by the constructor that takes a
        **QPaintDevice**  and a **QWidget** .
        """
        ...
