"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QSystemTrayIcon(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsystemtrayicon.html

    **Detailed Description**

    Modern operating systems usually provide a special area on the desktop,
    called the **system tray** or **notification area** , where long-running
    applications can display icons and short messages.

    ![The system tray on Windows XP.](images/system-tray.png)

    The QSystemTrayIcon class can be used on the following platforms:

    * All supported versions of Windows.
      * All window managers and independent
    tray implementations for X11 that implement the
    **http://standards.freedesktop.org/systemtray-spec/systemtray-spec-0.2.html
    freedesktop.org**  XEmbed system tray specification.
      * All X11 desktop
    environments that implement the D-Bus <http://www.freedesktop.org/wiki/Speci
    fications/StatusNotifierItem/StatusNotifierItem> specification, including
    recent versions of KDE and Unity.
      * All supported versions of macOS.

    To check whether a system tray is present on the user's desktop, call the
    **QSystemTrayIcon::isSystemTrayAvailable** () static function.

    To add a system tray entry, create a QSystemTrayIcon object, call
    **setContextMenu** () to provide a context menu for the icon, and call
    **show** () to make it visible in the system tray. Status notification
    messages ("balloon messages") can be displayed at any time using
    **showMessage** ().

    If the system tray is unavailable when a system tray icon is constructed,
    but becomes available later, QSystemTrayIcon will automatically add an entry
    for the application in the system tray if the icon is **visible** .

    The **activated** () signal is emitted when the user activates the icon.

    Only on X11, when a tooltip is requested, the QSystemTrayIcon receives a
    **QHelpEvent**  of type **QEvent::ToolTip** . Additionally, the
    QSystemTrayIcon receives wheel events of type **QEvent::Wheel** . These are
    not supported on any other platform.

    **See also** **QDesktopServices** , **Desktop Integration** , and **System
    Tray Icon Example** .
    """

    class MessageIcon(enum.Enum):
        NoIcon: QSystemTrayIcon = ...
        Information: QSystemTrayIcon = ...
        Warning: QSystemTrayIcon = ...
        Critical: QSystemTrayIcon = ...

    class ActivationReason(enum.Enum):
        Unknown: QSystemTrayIcon = ...
        Context: QSystemTrayIcon = ...
        DoubleClick: QSystemTrayIcon = ...
        Trigger: QSystemTrayIcon = ...
        MiddleClick: QSystemTrayIcon = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#QSystemTrayIcon

        **QSystemTrayIcon::QSystemTrayIcon(QObject * parent = nullptr)**

        Constructs a QSystemTrayIcon object with the given **parent**.

        The icon is initially invisible.

        **See also** **visible** .
        """
        ...

    @typing.overload
    def __init__(
        self, icon: QtGui.QIcon, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#QSystemTrayIcon-1

        **QSystemTrayIcon::QSystemTrayIcon(const QIcon & icon , QObject * parent
        = nullptr)**

        Constructs a QSystemTrayIcon object with the given **icon** and
        **parent**.

        The icon is initially invisible.

        **See also** **visible** .
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#event

        **[override virtual protected] bool QSystemTrayIcon::event(QEvent * e
        )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def show(self) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#show

        **[slot] void QSystemTrayIcon::show()**

        Shows the icon in the system tray.

        **See also** **hide** () and **visible** .
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#visible-prop

        **visible : bool**

        This property holds whether the system tray entry is visible

        Setting this property to true or calling **show** () makes the system
        tray icon visible; setting this property to false or calling **hide** ()
        hides it.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** )

        **Member Function Documentation**
        """
        ...

    def hide(self) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#hide

        **[slot] void QSystemTrayIcon::hide()**

        Hides the system tray entry.

        **See also** **show** () and **visible** .
        """
        ...

    def isVisible(self) -> bool:
        ...

    @typing.overload
    def showMessage(
        self,
        title: str,
        msg: str,
        icon: "QSystemTrayIcon.MessageIcon" = ...,
        msecs: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#showMessage

        **[slot] void QSystemTrayIcon::showMessage(const QString & title , const
        QString & message , QSystemTrayIcon::MessageIcon icon =
        QSystemTrayIcon::Information, int millisecondsTimeoutHint = 10000)**

        Shows a balloon message for the entry with the given **title** ,
        **message** and **icon** for the time specified in
        **millisecondsTimeoutHint**. **title** and **message** must be plain
        text strings.

        Message can be clicked by the user; the **messageClicked** () signal
        will emitted when this occurs.

        Note that display of messages are dependent on the system configuration
        and user preferences, and that messages may not appear at all. Hence, it
        should not be relied upon as the sole means for providing critical
        information.

        On Windows, the **millisecondsTimeoutHint** is usually ignored by the
        system when the application has focus.

        Has been turned into a slot in Qt 5.2.

        **See also** **show** () and **supportsMessages** ().
        """
        ...

    @typing.overload
    def showMessage(
        self, title: str, msg: str, icon: QtGui.QIcon, msecs: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#showMessage-1

        **[slot, since 5.9] void QSystemTrayIcon::showMessage(const QString &
        title , const QString & message , const QIcon & icon , int
        millisecondsTimeoutHint = 10000)**

        This function overloads showMessage().

        Shows a balloon message for the entry with the given **title** ,
        **message** , and custom icon **icon** for the time specified in
        **millisecondsTimeoutHint**.

        This function was introduced in Qt 5.9.
        """
        ...

    @staticmethod
    def supportsMessages() -> bool:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#supportsMessages

        **[static] bool QSystemTrayIcon::supportsMessages()**

        Returns `true` if the system tray supports balloon messages; otherwise
        returns `false`.

        **See also** **showMessage** ().
        """
        ...

    @staticmethod
    def isSystemTrayAvailable() -> bool:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#isSystemTrayAvailable

        **[static] bool QSystemTrayIcon::isSystemTrayAvailable()**

        Returns `true` if the system tray is available; otherwise returns
        `false`.

        If the system tray is currently unavailable but becomes available later,
        **QSystemTrayIcon**  will automatically add an entry in the system tray
        if it is **visible** .
        """
        ...

    def setToolTip(self, tip: str) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#toolTip-prop

        **toolTip : QString**

        This property holds the tooltip for the system tray entry

        On some systems, the tooltip's length is limited. The tooltip will be
        truncated if necessary.

        **Access functions:**

        QString **toolTip** () const
        void **setToolTip** (const QString &
        **tip** )
        """
        ...

    def toolTip(self) -> str:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#toolTip-prop

        **toolTip : QString**

        This property holds the tooltip for the system tray entry

        On some systems, the tooltip's length is limited. The tooltip will be
        truncated if necessary.

        **Access functions:**

        QString **toolTip** () const
        void **setToolTip** (const QString &
        **tip** )
        """
        ...

    def setIcon(self, icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#icon-prop

        **icon : QIcon**

        This property holds the system tray icon

        On Windows, the system tray icon size is 16x16; on X11, the preferred
        size is 22x22. The icon will be scaled to the appropriate size as
        necessary.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def icon(self) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#icon-prop

        **icon : QIcon**

        This property holds the system tray icon

        On Windows, the system tray icon size is 16x16; on X11, the preferred
        size is 22x22. The icon will be scaled to the appropriate size as
        necessary.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def geometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#geometry

        **QRect QSystemTrayIcon::geometry() const**

        Returns the geometry of the system tray icon in screen coordinates.

        **See also** **visible** .
        """
        ...

    def contextMenu(self) -> QMenu:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#contextMenu

        **QMenu *QSystemTrayIcon::contextMenu() const**

        Returns the current context menu for the system tray entry.

        **See also** **setContextMenu** ().
        """
        ...

    def setContextMenu(self, menu: QMenu) -> None:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#setContextMenu

        **void QSystemTrayIcon::setContextMenu(QMenu * menu )**

        Sets the specified **menu** to be the context menu for the system tray
        icon.

        The menu will pop up when the user requests the context menu for the
        system tray icon by clicking the mouse button.

        On macOS, this is currently converted to a NSMenu, so the aboutToHide()
        signal is not emitted.

        **Note:** The system tray icon does not take ownership of the menu. You
        must ensure that it is deleted at the appropriate time by, for example,
        creating the menu with a suitable parent object.

        **See also** **contextMenu** ().
        """
        ...

    @property
    def activated(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#activated

        **[signal] void
        QSystemTrayIcon::activated(QSystemTrayIcon::ActivationReason reason )**

        This signal is emitted when the user activates the system tray icon.
        **reason** specifies the reason for activation.
        **QSystemTrayIcon::ActivationReason**  enumerates the various reasons.

        **See also** **QSystemTrayIcon::ActivationReason** .
        """
        ...

    @property
    def messageClicked(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qsystemtrayicon.html#messageClicked

        **[signal] void QSystemTrayIcon::messageClicked()**

        This signal is emitted when the message displayed using **showMessage**
        () was clicked by the user.

        **Note:** We follow Microsoft Windows behavior, so the signal is also
        emitted when the user clicks on a tray icon with a balloon message
        displayed.

        **See also** **activated** ().
        """
        ...
