"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *


class QToolBar(QWidget):
    """
    https://doc.qt.io/qt-6/qtoolbar.html

    **Detailed Description**

    Toolbar buttons are added by adding **actions** , using **addAction** () or
    **insertAction** (). Groups of buttons can be separated using
    **addSeparator** () or **insertSeparator** (). If a toolbar button is not
    appropriate, a widget can be inserted instead using **addWidget** () or
    **insertWidget** (). Examples of suitable widgets are **QSpinBox** ,
    **QDoubleSpinBox** , and **QComboBox** . When a toolbar button is pressed,
    it emits the **actionTriggered** () signal.

    A toolbar can be fixed in place in a particular area (e.g., at the top of
    the window), or it can be movable between toolbar areas; see **setMovable**
    (), **isMovable** (), **allowedAreas** () and **isAreaAllowed** ().

    When a toolbar is resized in such a way that it is too small to show all the
    items it contains, an extension button will appear as the last item in the
    toolbar. Pressing the extension button will pop up a menu containing the
    items that do not currently fit in the toolbar.

    When a QToolBar is not a child of a **QMainWindow** , it loses the ability
    to populate the extension pop up with widgets added to the toolbar using
    **addWidget** (). Please use widget actions created by inheriting
    **QWidgetAction**  and implementing **QWidgetAction::createWidget** ()
    instead.

    **See also** **QToolButton** , **QMenu** , **QAction** , and **Qt Widgets -
    Application Example** .
    """

    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#QToolBar

        **QToolBar::QToolBar(const QString & title , QWidget * parent =
        nullptr)**

        Constructs a QToolBar with the given **parent**.

        The given window **title** identifies the toolbar and is shown in the
        context menu provided by **QMainWindow** .

        **See also** **setWindowTitle** ().
        """
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#QToolBar-1

        **QToolBar::QToolBar(QWidget * parent = nullptr)**

        Constructs a QToolBar with the given **parent**.
        """
        ...

    def isFloating(self) -> bool:
        ...

    def setFloatable(self, floatable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#floatable-prop

        **floatable : bool**

        This property holds whether the toolbar can be dragged and dropped as an
        independent window.

        The default is true.

        **Access functions:**

        bool **isFloatable** () const
        void **setFloatable** (bool
        **floatable** )
        """
        ...

    def isFloatable(self) -> bool:
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#event

        **[override virtual protected] bool QToolBar::event(QEvent * event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#paintEvent

        **[override virtual protected] void QToolBar::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def changeEvent(self, event: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#changeEvent

        **[override virtual protected] void QToolBar::changeEvent(QEvent * event
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def actionEvent(self, event: QtGui.QActionEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionEvent

        **[override virtual protected] void QToolBar::actionEvent(QActionEvent *
        event )**

        Reimplements: **QWidget::actionEvent** (QActionEvent *event).
        """
        ...

    def initStyleOption(self, option: QStyleOptionToolBar) -> None:
        ...

    def setToolButtonStyle(self, toolButtonStyle: QtCore.Qt.ToolButtonStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        This property holds the style of toolbar buttons

        This property defines the style of all tool buttons that are added as
        **QAction** s. Note that if you add a **QToolButton**  with the
        **addWidget** () method, it will not get this button style.

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        The default is **Qt::ToolButtonIconOnly** .

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **toolButtonStyle** )

        **Notifier signal:**

        void ****toolButtonStyleChanged** ** (Qt::ToolButtonStyle
        **toolButtonStyle** )

        **Member Function Documentation**
        """
        ...

    def setIconSize(self, iconSize: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#iconSize-prop

        **iconSize : QSize**

        size of icons in the toolbar.

        The default size is determined by the application's style and is derived
        from the **QStyle::PM_ToolBarIconSize**  pixel metric. It is the maximum
        size an icon can have. Icons of smaller size will not be scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **iconSize** )

        **Notifier signal:**

        void ****iconSizeChanged** ** (const QSize & **iconSize** )
        """
        ...

    def widgetForAction(self, action: QtGui.QAction) -> QWidget:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#widgetForAction

        **QWidget *QToolBar::widgetForAction(QAction * action ) const**

        Returns the widget associated with the specified **action**.

        **See also** **addWidget** ().
        """
        ...

    def toolButtonStyle(self) -> QtCore.Qt.ToolButtonStyle:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        This property holds the style of toolbar buttons

        This property defines the style of all tool buttons that are added as
        **QAction** s. Note that if you add a **QToolButton**  with the
        **addWidget** () method, it will not get this button style.

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        The default is **Qt::ToolButtonIconOnly** .

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **toolButtonStyle** )

        **Notifier signal:**

        void ****toolButtonStyleChanged** ** (Qt::ToolButtonStyle
        **toolButtonStyle** )

        **Member Function Documentation**
        """
        ...

    def iconSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#iconSize-prop

        **iconSize : QSize**

        size of icons in the toolbar.

        The default size is determined by the application's style and is derived
        from the **QStyle::PM_ToolBarIconSize**  pixel metric. It is the maximum
        size an icon can have. Icons of smaller size will not be scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **iconSize** )

        **Notifier signal:**

        void ****iconSizeChanged** ** (const QSize & **iconSize** )
        """
        ...

    def toggleViewAction(self) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toggleViewAction

        **QAction *QToolBar::toggleViewAction() const**

        Returns a checkable action that can be used to show or hide this
        toolbar.

        The action's text is set to the toolbar's window title.

        **See also** **QAction::text**  and **QWidget::windowTitle** .
        """
        ...

    @typing.overload
    def actionAt(self, p: QtCore.QPoint) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionAt

        **QAction *QToolBar::actionAt(const QPoint & p ) const**

        Returns the action at point **p**. This function returns zero if no
        action was found.

        **See also** **QWidget::childAt** ().
        """
        ...

    @typing.overload
    def actionAt(self, ax: int, ay: int) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionAt-1

        **QAction *QToolBar::actionAt(int x , int y ) const**

        This is an overloaded function.

        Returns the action at the point **x** , **y**. This function returns
        zero if no action was found.
        """
        ...

    def actionGeometry(self, action: QtGui.QAction) -> QtCore.QRect:
        ...

    def insertWidget(self, before: QtGui.QAction, widget: QWidget) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#insertWidget

        **QAction *QToolBar::insertWidget(QAction * before , QWidget * widget
        )**

        Inserts the given **widget** in front of the toolbar item associated
        with the **before** action.

        Note: You should use **QAction::setVisible** () to change the visibility
        of the widget. Using **QWidget::setVisible** (), **QWidget::show** ()
        and **QWidget::hide** () does not work.

        **See also** **addWidget** ().
        """
        ...

    def addWidget(self, widget: QWidget) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addWidget

        **QAction *QToolBar::addWidget(QWidget * widget )**

        Adds the given **widget** to the toolbar as the toolbar's last item.

        The toolbar takes ownership of **widget**.

        If you add a **QToolButton**  with this method, the toolbar's
        **Qt::ToolButtonStyle**  will not be respected.

        **Note:** You should use **QAction::setVisible** () to change the
        visibility of the widget. Using **QWidget::setVisible** (),
        **QWidget::show** () and **QWidget::hide** () does not work.

        **See also** **insertWidget** ().
        """
        ...

    def insertSeparator(self, before: QtGui.QAction) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#insertSeparator

        **QAction *QToolBar::insertSeparator(QAction * before )**

        Inserts a separator into the toolbar in front of the toolbar item
        associated with the **before** action.

        **See also** **addSeparator** ().
        """
        ...

    def addSeparator(self) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addSeparator

        **QAction *QToolBar::addSeparator()**

        Adds a separator to the end of the toolbar.

        **See also** **insertSeparator** ().
        """
        ...

    @typing.overload
    def addAction(self, a0: QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction

        **QAction *QToolBar::addAction(const QString & text )**

        Creates a new action with the given **text**. This action is added to
        the end of the toolbar.
        """
        ...

    @typing.overload
    def addAction(self, text: str) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-1

        **QAction *QToolBar::addAction(const QIcon & icon , const QString & text
        )**

        This is an overloaded function.

        Creates a new action with the given **icon** and **text**. This action
        is added to the end of the toolbar.
        """
        ...

    @typing.overload
    def addAction(self, icon: QtGui.QIcon, text: str) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-2

        **QAction *QToolBar::addAction(const QString & text , const QObject *
        receiver , const char * member )**

        This is an overloaded function.

        Creates a new action with the given **text**. This action is added to
        the end of the toolbar. The action's **triggered** () signal is
        connected to **member** in **receiver**.
        """
        ...

    @typing.overload
    def addAction(self, text: str, slot: PYQT_SLOT) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-3

        **QAction *QToolBar::addAction(const QIcon & icon , const QString & text
        , const QObject * receiver , const char * member )**

        This is an overloaded function.

        Creates a new action with the given **icon** and **text**. This action
        is added to the end of the toolbar. The action's **triggered** () signal
        is connected to **member** in **receiver**.
        """
        ...

    @typing.overload
    def addAction(self, icon: QtGui.QIcon, text: str, slot: PYQT_SLOT) -> QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-4

        **[since 5.6] template <typename Functor> QAction
        *QToolBar::addAction(const QString & text , Functor functor )**

        This is an overloaded function.

        Creates a new action with the given **text**. This action is added to
        the end of the toolbar. The action's **triggered** () signal is
        connected to the **functor**.

        This function was introduced in Qt 5.6.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#clear

        **void QToolBar::clear()**

        Removes all actions from the toolbar.

        **See also** **removeAction** ().
        """
        ...

    def orientation(self) -> QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#orientation-prop

        **orientation : Qt::Orientation**

        orientation of the toolbar

        The default is **Qt::Horizontal** .

        This function should not be used when the toolbar is managed by
        **QMainWindow** . You can use **QMainWindow::addToolBar** () or
        **QMainWindow::insertToolBar** () if you wish to move a toolbar that is
        already added to a main window to another **Qt::ToolBarArea** .

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation**
        (Qt::Orientation **orientation** )

        **Notifier signal:**

        void ****orientationChanged** ** (Qt::Orientation **orientation** )
        """
        ...

    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#orientation-prop

        **orientation : Qt::Orientation**

        orientation of the toolbar

        The default is **Qt::Horizontal** .

        This function should not be used when the toolbar is managed by
        **QMainWindow** . You can use **QMainWindow::addToolBar** () or
        **QMainWindow::insertToolBar** () if you wish to move a toolbar that is
        already added to a main window to another **Qt::ToolBarArea** .

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation**
        (Qt::Orientation **orientation** )

        **Notifier signal:**

        void ****orientationChanged** ** (Qt::Orientation **orientation** )
        """
        ...

    def isAreaAllowed(self, area: QtCore.Qt.ToolBarArea) -> bool:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#isAreaAllowed

        **bool QToolBar::isAreaAllowed(Qt::ToolBarArea area ) const**

        Returns `true` if this toolbar is dockable in the given **area** ;
        otherwise returns `false`.
        """
        ...

    def allowedAreas(self) -> QtCore.Qt.ToolBarArea:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#allowedAreas-prop

        **allowedAreas : Qt::ToolBarAreas**

        areas where the toolbar may be placed

        The default is **Qt::AllToolBarAreas** .

        This property only makes sense if the toolbar is in a **QMainWindow** .

        **Access functions:**

        Qt::ToolBarAreas **allowedAreas** () const
        void **setAllowedAreas**
        (Qt::ToolBarAreas **areas** )

        **Notifier signal:**

        void ****allowedAreasChanged** ** (Qt::ToolBarAreas **allowedAreas** )

        **See also** **movable** .
        """
        ...

    def setAllowedAreas(self, areas: QtCore.Qt.ToolBarArea) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#allowedAreas-prop

        **allowedAreas : Qt::ToolBarAreas**

        areas where the toolbar may be placed

        The default is **Qt::AllToolBarAreas** .

        This property only makes sense if the toolbar is in a **QMainWindow** .

        **Access functions:**

        Qt::ToolBarAreas **allowedAreas** () const
        void **setAllowedAreas**
        (Qt::ToolBarAreas **areas** )

        **Notifier signal:**

        void ****allowedAreasChanged** ** (Qt::ToolBarAreas **allowedAreas** )

        **See also** **movable** .
        """
        ...

    def isMovable(self) -> bool:
        ...

    def setMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#movable-prop

        **movable : bool**

        This property holds whether the user can move the toolbar within the
        toolbar area, or between toolbar areas.

        By default, this property is `true`.

        This property only makes sense if the toolbar is in a **QMainWindow** .

        **Access functions:**

        bool **isMovable** () const
        void **setMovable** (bool **movable** )

        **Notifier signal:**

        void ****movableChanged** ** (bool **movable** )

        **See also** **allowedAreas** .
        """
        ...

    @property
    def actionTriggered(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionTriggered

        **[signal] void QToolBar::actionTriggered(QAction * action )**

        This signal is emitted when an action in this toolbar is triggered. This
        happens when the action's tool button is pressed, or when the action is
        triggered in some other way outside the toolbar. The parameter holds the
        triggered **action**.
        """
        ...

    @property
    def allowedAreasChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#allowedAreasChanged

        **[signal] void QToolBar::allowedAreasChanged(Qt::ToolBarAreas
        allowedAreas )**

        This signal is emitted when the collection of allowed areas for the
        toolbar is changed. The new areas in which the toolbar can be positioned
        are specified by **allowedAreas**.

        **Note:** Notifier signal for property **allowedAreas** .

        **See also** **allowedAreas** .
        """
        ...

    @property
    def iconSizeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#iconSizeChanged

        **[signal] void QToolBar::iconSizeChanged(const QSize & iconSize )**

        This signal is emitted when the icon size is changed. The **iconSize**
        parameter holds the toolbar's new icon size.

        **Note:** Notifier signal for property **iconSize** .

        **See also** **iconSize**  and **QMainWindow::iconSize** .
        """
        ...

    @property
    def movableChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#movableChanged

        **[signal] void QToolBar::movableChanged(bool movable )**

        This signal is emitted when the toolbar becomes movable or fixed. If the
        toolbar can be moved, **movable** is true; otherwise it is false.

        **Note:** Notifier signal for property **movable** .

        **See also** **movable** .
        """
        ...

    @property
    def orientationChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#orientationChanged

        **[signal] void QToolBar::orientationChanged(Qt::Orientation orientation
        )**

        This signal is emitted when the orientation of the toolbar changes. The
        **orientation** parameter holds the toolbar's new orientation.

        **Note:** Notifier signal for property **orientation** .

        **See also** **orientation** .
        """
        ...

    @property
    def toolButtonStyleChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toolButtonStyleChanged

        **[signal] void QToolBar::toolButtonStyleChanged(Qt::ToolButtonStyle
        toolButtonStyle )**

        This signal is emitted when the tool button style is changed. The
        **toolButtonStyle** parameter holds the toolbar's new tool button style.

        **Note:** Notifier signal for property **toolButtonStyle** .

        **See also** **toolButtonStyle**  and **QMainWindow::toolButtonStyle** .
        """
        ...

    @property
    def topLevelChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#topLevelChanged

        **[signal] void QToolBar::topLevelChanged(bool topLevel )**

        This signal is emitted when the **floating**  property changes. The
        **topLevel** parameter is true if the toolbar is now floating; otherwise
        it is false.

        **See also** **isWindow** ().
        """
        ...

    @property
    def visibilityChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#visibilityChanged

        **[signal] void QToolBar::visibilityChanged(bool visible )**

        This signal is emitted when the toolbar becomes **visible** (or
        invisible). This happens when the widget is hidden or shown.
        """
        ...
