"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtWidgets import *
import enum


class QTreeWidgetItem(PyQt6.sip.wrapper):
    """
    https://doc.qt.io/qt-6/qtreewidgetitem.html

    **Detailed Description**

    Tree widget items are used to hold rows of information for tree widgets.
    Rows usually contain several columns of data, each of which can contain a
    text label and an icon.

    The QTreeWidgetItem class is a convenience class that replaces the
    QListViewItem class in Qt 3. It provides an item for use with the
    **QTreeWidget**  class.

    Items are usually constructed with a parent that is either a **QTreeWidget**
    (for top-level items) or a QTreeWidgetItem (for items on lower levels of the
    tree). For example, the following code constructs a top-level item to
    represent cities of the world, and adds a entry for Oslo as a child item:

    **QTreeWidgetItem**  *cities = new **QTreeWidgetItem** (treeWidget);
    cities->setText(0, tr("Cities"));
            **QTreeWidgetItem**  *osloItem =
    new **QTreeWidgetItem** (cities);
            osloItem->setText(0, tr("Oslo"));
    osloItem->setText(1, tr("Yes"));

    Items can be added in a particular order by specifying the item they follow
    when they are constructed:

    **QTreeWidgetItem**  *planets = new **QTreeWidgetItem** (treeWidget,
    cities);
            planets->setText(0, tr("Planets"));

    Each column in an item can have its own background brush which is set with
    the **setBackground** () function. The current background brush can be found
    with **background** (). The text label for each column can be rendered with
    its own font and brush. These are specified with the **setFont** () and
    **setForeground** () functions, and read with **font** () and **foreground**
    ().

    The main difference between top-level items and those in lower levels of the
    tree is that a top-level item has no **parent** (). This information can be
    used to tell the difference between items, and is useful to know when
    inserting and removing items from the tree. Children of an item can be
    removed with **takeChild** () and inserted at a given index in the list of
    children with the **insertChild** () function.

    By default, items are enabled, selectable, checkable, and can be the source
    of a drag and drop operation. Each item's flags can be changed by calling
    **setFlags** () with the appropriate value (see **Qt::ItemFlags** ).
    Checkable items can be checked and unchecked with the **setCheckState** ()
    function. The corresponding **checkState** () function indicates whether the
    item is currently checked.

    **Subclassing**

    When subclassing QTreeWidgetItem to provide custom items, it is possible to
    define new types for them so that they can be distinguished from standard
    items. The constructors for subclasses that require this feature need to
    call the base class constructor with a new type value equal to or greater
    than **UserType** .

    **See also** **QTreeWidget** , **QTreeWidgetItemIterator** , **Model/View
    Programming** , **QListWidgetItem** , and **QTableWidgetItem** .
    """

    class ChildIndicatorPolicy(enum.Enum):
        ShowIndicator: QTreeWidgetItem = ...
        DontShowIndicator: QTreeWidgetItem = ...
        DontShowIndicatorWhenChildless: QTreeWidgetItem = ...

    class ItemType(enum.IntEnum):
        Type: QTreeWidgetItem = ...
        UserType: QTreeWidgetItem = ...

    @typing.overload
    def __init__(
        self, parent: "QTreeWidgetItem", after: "QTreeWidgetItem", type: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem

        **QTreeWidgetItem::QTreeWidgetItem(int type = Type)**

        Constructs a tree widget item of the specified **type**. The item must
        be inserted into a tree widget.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(
        self, parent: "QTreeWidgetItem", strings: typing.Iterable[str], type: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-1

        **QTreeWidgetItem::QTreeWidgetItem(const QStringList & strings , int
        type = Type)**

        Constructs a tree widget item of the specified **type**. The item must
        be inserted into a tree widget. The given list of **strings** will be
        set as the item text for each column in the item.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(self, parent: "QTreeWidgetItem", type: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-2

        **QTreeWidgetItem::QTreeWidgetItem(QTreeWidget * parent , int type =
        Type)**

        Constructs a tree widget item of the specified **type** and appends it
        to the items in the given **parent**.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(
        self, parent: "QTreeWidget", after: "QTreeWidgetItem", type: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-3

        **QTreeWidgetItem::QTreeWidgetItem(QTreeWidget * parent , const
        QStringList & strings , int type = Type)**

        Constructs a tree widget item of the specified **type** and appends it
        to the items in the given **parent**. The given list of **strings** will
        be set as the item text for each column in the item.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(
        self, parent: "QTreeWidget", strings: typing.Iterable[str], type: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-4

        **QTreeWidgetItem::QTreeWidgetItem(QTreeWidget * parent ,
        QTreeWidgetItem * preceding , int type = Type)**

        Constructs a tree widget item of the specified **type** and inserts it
        into the given **parent** after the **preceding** item.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(self, parent: "QTreeWidget", type: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-5

        **QTreeWidgetItem::QTreeWidgetItem(QTreeWidgetItem * parent , int type =
        Type)**

        Constructs a tree widget item and append it to the given **parent**.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(self, strings: typing.Iterable[str], type: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-6

        **QTreeWidgetItem::QTreeWidgetItem(QTreeWidgetItem * parent , const
        QStringList & strings , int type = Type)**

        Constructs a tree widget item and append it to the given **parent**. The
        given list of **strings** will be set as the item text for each column
        in the item.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(self, type: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-7

        **QTreeWidgetItem::QTreeWidgetItem(QTreeWidgetItem * parent ,
        QTreeWidgetItem * preceding , int type = Type)**

        Constructs a tree widget item of the specified **type** that is inserted
        into the **parent** after the **preceding** child item.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QTreeWidgetItem") -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#QTreeWidgetItem-8

        **QTreeWidgetItem::QTreeWidgetItem(const QTreeWidgetItem & other )**

        Constructs a copy of **other**. Note that **type** () and **treeWidget**
        () are not copied.

        This function is useful when reimplementing **clone** ().

        **See also** **data** () and **flags** ().
        """
        ...

    def emitDataChanged(self) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#emitDataChanged

        **[protected] void QTreeWidgetItem::emitDataChanged()**

        Causes the model associated with this item to emit a **dataChanged** ()
        signal for this item.

        You normally only need to call this function if you have subclassed
        **QTreeWidgetItem**  and reimplemented **data** () and/or **setData**
        ().

        **See also** **setData** ().
        """
        ...

    def isDisabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#isDisabled

        **bool QTreeWidgetItem::isDisabled() const**

        Returns `true` if the item is disabled; otherwise returns `false`.

        **See also** **setFlags** ().
        """
        ...

    def setDisabled(self, disabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setDisabled

        **void QTreeWidgetItem::setDisabled(bool disabled )**

        Disables the item if **disabled** is true; otherwise enables the item.

        **See also** **isDisabled** () and **setFlags** ().
        """
        ...

    def isFirstColumnSpanned(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#isFirstColumnSpanned

        **bool QTreeWidgetItem::isFirstColumnSpanned() const**

        Returns `true` if the item is spanning all the columns in a row;
        otherwise returns `false`.

        **See also** **setFirstColumnSpanned** ().
        """
        ...

    def setFirstColumnSpanned(self, aspan: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setFirstColumnSpanned

        **void QTreeWidgetItem::setFirstColumnSpanned(bool span )**

        Sets the first section to span all columns if **span** is true;
        otherwise all item sections are shown.

        **See also** **isFirstColumnSpanned** ().
        """
        ...

    def removeChild(self, child: "QTreeWidgetItem") -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#removeChild

        **void QTreeWidgetItem::removeChild(QTreeWidgetItem * child )**

        Removes the given item indicated by **child**. The removed item will not
        be deleted.
        """
        ...

    def childIndicatorPolicy(self) -> "QTreeWidgetItem.ChildIndicatorPolicy":
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#childIndicatorPolicy

        **QTreeWidgetItem::ChildIndicatorPolicy
        QTreeWidgetItem::childIndicatorPolicy() const**

        Returns the item indicator policy. This policy decides when the tree
        branch expand/collapse indicator is shown.

        **See also** **setChildIndicatorPolicy** ().
        """
        ...

    def setChildIndicatorPolicy(
        self, policy: "QTreeWidgetItem.ChildIndicatorPolicy"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setChildIndicatorPolicy

        **void QTreeWidgetItem::setChildIndicatorPolicy(QTreeWidgetItem::ChildIn
        dicatorPolicy policy )**

        Sets the item indicator **policy**. This policy decides when the tree
        branch expand/collapse indicator is shown. The default value is
        **DontShowIndicatorWhenChildless** .

        **See also** **childIndicatorPolicy** ().
        """
        ...

    def isExpanded(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#isExpanded

        **bool QTreeWidgetItem::isExpanded() const**

        Returns `true` if the item is expanded, otherwise returns `false`.

        **See also** **setExpanded** ().
        """
        ...

    def setExpanded(self, aexpand: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setExpanded

        **void QTreeWidgetItem::setExpanded(bool expand )**

        Expands the item if **expand** is true, otherwise collapses the item.

        **Warning:** The **QTreeWidgetItem**  must be added to the
        **QTreeWidget**  before calling this function.

        **See also** **isExpanded** ().
        """
        ...

    def isHidden(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#isHidden

        **bool QTreeWidgetItem::isHidden() const**

        Returns `true` if the item is hidden, otherwise returns `false`.

        **See also** **setHidden** ().
        """
        ...

    def setHidden(self, ahide: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setHidden

        **void QTreeWidgetItem::setHidden(bool hide )**

        Hides the item if **hide** is true, otherwise shows the item.

        **Note:** A call to this function has no effect if the item is not
        currently in a view. In particular, calling `setHidden(true)` on an item
        and only then adding it to a view will result in a visible item.

        **See also** **isHidden** ().
        """
        ...

    def isSelected(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#isSelected

        **bool QTreeWidgetItem::isSelected() const**

        Returns `true` if the item is selected, otherwise returns `false`.

        **See also** **setSelected** ().
        """
        ...

    def setSelected(self, aselect: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setSelected

        **void QTreeWidgetItem::setSelected(bool select )**

        Sets the selected state of the item to **select**.

        **See also** **isSelected** ().
        """
        ...

    def sortChildren(self, column: int, order: QtCore.Qt.SortOrder) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#sortChildren

        **void QTreeWidgetItem::sortChildren(int column , Qt::SortOrder order
        )**

        Sorts the children of the item using the given **order** , by the values
        in the given **column**.

        **Note:** This function does nothing if the item is not associated with
        a **QTreeWidget** .
        """
        ...

    def setForeground(
        self,
        column: int,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, int, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setForeground

        **void QTreeWidgetItem::setForeground(int column , const QBrush & brush
        )**

        Sets the foreground brush of the label in the given **column** to the
        specified **brush**.

        **See also** **foreground** () and **setBackground** ().
        """
        ...

    def foreground(self, column: int) -> QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#foreground

        **QBrush QTreeWidgetItem::foreground(int column ) const**

        Returns the brush used to render the foreground (e.g. text) of the
        specified **column**. Setting a default-constructed brush will let the
        view use the default color from the style.

        **See also** **setForeground** () and **background** ().
        """
        ...

    def setBackground(
        self,
        column: int,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, int, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setBackground

        **void QTreeWidgetItem::setBackground(int column , const QBrush & brush
        )**

        Sets the background brush of the label in the given **column** to the
        specified **brush**. Setting a default-constructed brush will let the
        view use the default color from the style.

        **Note:** If **Qt Style Sheets**  are used on the same widget as
        setBackground(), style sheets will take precedence if the settings
        conflict.

        **See also** **background** () and **setForeground** ().
        """
        ...

    def background(self, column: int) -> QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#background

        **QBrush QTreeWidgetItem::background(int column ) const**

        Returns the brush used to render the background of the specified
        **column**.

        **See also** **setBackground** () and **foreground** ().
        """
        ...

    def takeChildren(self) -> typing.List["QTreeWidgetItem"]:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#takeChildren

        **QList<QTreeWidgetItem *> QTreeWidgetItem::takeChildren()**

        Removes the list of children and returns it, otherwise returns an empty
        list.
        """
        ...

    def insertChildren(
        self, index: int, children: typing.Iterable["QTreeWidgetItem"]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#insertChildren

        **void QTreeWidgetItem::insertChildren(int index , const
        QList<QTreeWidgetItem *> & children )**

        Inserts the given list of **children** into the list of the item
        children at **index** .

        Children that have already been inserted somewhere else won't be
        inserted.
        """
        ...

    def addChildren(self, children: typing.Iterable["QTreeWidgetItem"]) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#addChildren

        **void QTreeWidgetItem::addChildren(const QList<QTreeWidgetItem *> &
        children )**

        Appends the given list of **children** to the item.

        **See also** **insertChildren** () and **takeChildren** ().
        """
        ...

    def setSizeHint(self, column: int, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setSizeHint

        **void QTreeWidgetItem::setSizeHint(int column , const QSize & size )**

        Sets the size hint for the tree item in the given **column** to be
        **size**. If no size hint is set or **size** is invalid, the item
        delegate will compute the size hint based on the item data.

        **See also** **sizeHint** ().
        """
        ...

    def sizeHint(self, column: int) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#sizeHint

        **QSize QTreeWidgetItem::sizeHint(int column ) const**

        Returns the size hint set for the tree item in the given **column** (see
        **QSize** ).

        **See also** **setSizeHint** ().
        """
        ...

    def indexOfChild(self, achild: "QTreeWidgetItem") -> int:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#indexOfChild

        **int QTreeWidgetItem::indexOfChild(QTreeWidgetItem * child ) const**

        Returns the index of the given **child** in the item's list of children.
        """
        ...

    def setFont(self, column: int, afont: QtGui.QFont) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setFont

        **void QTreeWidgetItem::setFont(int column , const QFont & font )**

        Sets the font used to display the text in the given **column** to the
        given **font**.

        **See also** **font** (), **setText** (), and **setForeground** ().
        """
        ...

    def setWhatsThis(self, column: int, awhatsThis: str) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setWhatsThis

        **void QTreeWidgetItem::setWhatsThis(int column , const QString &
        whatsThis )**

        Sets the "What's This?" help for the given **column** to **whatsThis**.

        **See also** **whatsThis** (), **setStatusTip** (), and **setToolTip**
        ().
        """
        ...

    def setToolTip(self, column: int, atoolTip: str) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setToolTip

        **void QTreeWidgetItem::setToolTip(int column , const QString & toolTip
        )**

        Sets the tooltip for the given **column** to **toolTip**.

        **See also** **toolTip** (), **setStatusTip** (), and **setWhatsThis**
        ().
        """
        ...

    def setStatusTip(self, column: int, astatusTip: str) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setStatusTip

        **void QTreeWidgetItem::setStatusTip(int column , const QString &
        statusTip )**

        Sets the status tip for the given **column** to the given **statusTip**.
        **QTreeWidget**  mouse tracking needs to be enabled for this feature to
        work.

        **See also** **statusTip** (), **setToolTip** (), and **setWhatsThis**
        ().
        """
        ...

    def setIcon(self, column: int, aicon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setIcon

        **void QTreeWidgetItem::setIcon(int column , const QIcon & icon )**

        Sets the icon to be displayed in the given **column** to **icon**.

        **See also** **icon** (), **setText** (), and **iconSize** .
        """
        ...

    def setText(self, column: int, atext: str) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setText

        **void QTreeWidgetItem::setText(int column , const QString & text )**

        Sets the text to be displayed in the given **column** to the given
        **text**.

        **See also** **text** (), **setFont** (), and **setForeground** ().
        """
        ...

    def setFlags(self, aflags: QtCore.Qt.ItemFlag) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setFlags

        **void QTreeWidgetItem::setFlags(Qt::ItemFlags flags )**

        Sets the flags for the item to the given **flags**. These determine
        whether the item can be selected or modified. This is often used to
        disable an item.

        **See also** **flags** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#type

        **int QTreeWidgetItem::type() const**

        Returns the type passed to the **QTreeWidgetItem**  constructor.
        """
        ...

    def takeChild(self, index: int) -> "QTreeWidgetItem":
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#takeChild

        **QTreeWidgetItem *QTreeWidgetItem::takeChild(int index )**

        Removes the item at **index** and returns it, otherwise return 0.
        """
        ...

    def insertChild(self, index: int, child: "QTreeWidgetItem") -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#insertChild

        **void QTreeWidgetItem::insertChild(int index , QTreeWidgetItem * child
        )**

        Inserts the **child** item at **index** in the list of children.

        If the child has already been inserted somewhere else it won't be
        inserted again.
        """
        ...

    def addChild(self, child: "QTreeWidgetItem") -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#addChild

        **void QTreeWidgetItem::addChild(QTreeWidgetItem * child )**

        Appends the **child** item to the list of children.

        **See also** **insertChild** () and **takeChild** ().
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#columnCount

        **int QTreeWidgetItem::columnCount() const**

        Returns the number of columns in the item.
        """
        ...

    def childCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#childCount

        **int QTreeWidgetItem::childCount() const**

        Returns the number of child items.
        """
        ...

    def child(self, index: int) -> "QTreeWidgetItem":
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#child

        **QTreeWidgetItem *QTreeWidgetItem::child(int index ) const**

        Returns the item at the given **index** in the list of the item's
        children.

        **See also** **parent** ().
        """
        ...

    def parent(self) -> "QTreeWidgetItem":
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#parent

        **QTreeWidgetItem *QTreeWidgetItem::parent() const**

        Returns the item's parent.

        **See also** **child** ().
        """
        ...

    def write(self, out: QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#write

        **[virtual] void QTreeWidgetItem::write(QDataStream & out ) const**

        Writes the item to stream **out**. This only writes data from one single
        item.

        **See also** **read** ().
        """
        ...

    def read(self, in_: QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#read

        **[virtual] void QTreeWidgetItem::read(QDataStream & in )**

        Reads the item from stream **in**. This only reads data into a single
        item.

        **See also** **write** ().
        """
        ...

    def setData(self, column: int, role: int, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setData

        **[virtual] void QTreeWidgetItem::setData(int column , int role , const
        QVariant & value )**

        Sets the value for the item's **column** and **role** to the given
        **value**.

        The **role** describes the type of data specified by **value** , and is
        defined by the **Qt::ItemDataRole**  enum.

        **Note:** The default implementation treats **Qt::EditRole**  and
        **Qt::DisplayRole**  as referring to the same data.

        **See also** **data** ().
        """
        ...

    def data(self, column: int, role: int) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#data

        **[virtual] QVariant QTreeWidgetItem::data(int column , int role )
        const**

        Returns the value for the item's **column** and **role**.

        **See also** **setData** ().
        """
        ...

    def setCheckState(self, column: int, state: QtCore.Qt.CheckState) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setCheckState

        **void QTreeWidgetItem::setCheckState(int column , Qt::CheckState state
        )**

        Sets the item in the given **column** check state to be **state**.

        **See also** **checkState** ().
        """
        ...

    def checkState(self, column: int) -> QtCore.Qt.CheckState:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#checkState

        **Qt::CheckState QTreeWidgetItem::checkState(int column ) const**

        Returns the check state of the label in the given **column**.

        **See also** **setCheckState** () and **Qt::CheckState** .
        """
        ...

    def setTextAlignment(self, column: int, alignment: int) -> None:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#setTextAlignment

        **void QTreeWidgetItem::setTextAlignment(int column , int alignment )**

        Sets the text alignment for the label in the given **column** to the
        **alignment** specified (see **Qt::AlignmentFlag** ).

        **See also** **textAlignment** ().
        """
        ...

    def textAlignment(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#textAlignment

        **int QTreeWidgetItem::textAlignment(int column ) const**

        Returns the text alignment for the label in the given **column** (see
        **Qt::AlignmentFlag** ).

        **See also** **setTextAlignment** ().
        """
        ...

    def font(self, column: int) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#font

        **QFont QTreeWidgetItem::font(int column ) const**

        Returns the font used to render the text in the specified **column**.

        **See also** **setFont** ().
        """
        ...

    def whatsThis(self, column: int) -> str:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#whatsThis

        **QString QTreeWidgetItem::whatsThis(int column ) const**

        Returns the "What's This?" help for the contents of the given
        **column**.

        **See also** **setWhatsThis** ().
        """
        ...

    def toolTip(self, column: int) -> str:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#toolTip

        **QString QTreeWidgetItem::toolTip(int column ) const**

        Returns the tool tip for the given **column**.

        **See also** **setToolTip** ().
        """
        ...

    def statusTip(self, column: int) -> str:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#statusTip

        **QString QTreeWidgetItem::statusTip(int column ) const**

        Returns the status tip for the contents of the given **column**.

        **See also** **setStatusTip** ().
        """
        ...

    def icon(self, column: int) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#icon

        **QIcon QTreeWidgetItem::icon(int column ) const**

        Returns the icon that is displayed in the specified **column**.

        **See also** **setIcon** () and **iconSize** .
        """
        ...

    def text(self, column: int) -> str:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#text

        **QString QTreeWidgetItem::text(int column ) const**

        Returns the text in the specified **column**.

        **See also** **setText** ().
        """
        ...

    def flags(self) -> QtCore.Qt.ItemFlag:
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#flags

        **Qt::ItemFlags QTreeWidgetItem::flags() const**

        Returns the flags used to describe the item. These determine whether the
        item can be checked, edited, and selected.

        The default value for flags is **Qt::ItemIsSelectable**  |
        **Qt::ItemIsUserCheckable**  | **Qt::ItemIsEnabled**  |
        **Qt::ItemIsDragEnabled**  | **Qt::ItemIsDropEnabled** .

        **See also** **setFlags** ().
        """
        ...

    def treeWidget(self) -> "QTreeWidget":
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#treeWidget

        **QTreeWidget *QTreeWidgetItem::treeWidget() const**

        Returns the tree widget that contains the item.
        """
        ...

    def clone(self) -> "QTreeWidgetItem":
        """
        https://doc.qt.io/qt-6/qtreewidgetitem.html#clone

        **[virtual] QTreeWidgetItem *QTreeWidgetItem::clone() const**

        Creates a deep copy of the item and of its children.
        """
        ...
